/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The scaling configuration for an Aurora Serverless v2 DB cluster.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora
 * Serverless v2</a> in the <i>Amazon Aurora User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerlessV2ScalingConfigurationInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerlessV2ScalingConfigurationInfo.Builder, ServerlessV2ScalingConfigurationInfo> {
    private static final SdkField<Double> MIN_CAPACITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinCapacity").getter(getter(ServerlessV2ScalingConfigurationInfo::minCapacity))
            .setter(setter(Builder::minCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()).build();

    private static final SdkField<Double> MAX_CAPACITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaxCapacity").getter(getter(ServerlessV2ScalingConfigurationInfo::maxCapacity))
            .setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<Integer> SECONDS_UNTIL_AUTO_PAUSE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SecondsUntilAutoPause").getter(getter(ServerlessV2ScalingConfigurationInfo::secondsUntilAutoPause))
            .setter(setter(Builder::secondsUntilAutoPause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondsUntilAutoPause").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CAPACITY_FIELD,
            MAX_CAPACITY_FIELD, SECONDS_UNTIL_AUTO_PAUSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double minCapacity;

    private final Double maxCapacity;

    private final Integer secondsUntilAutoPause;

    private ServerlessV2ScalingConfigurationInfo(BuilderImpl builder) {
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.secondsUntilAutoPause = builder.secondsUntilAutoPause;
    }

    /**
     * <p>
     * The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can
     * specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. For Aurora versions that support the
     * Aurora Serverless v2 auto-pause feature, the smallest value that you can use is 0. For versions that don't
     * support Aurora Serverless v2 auto-pause, the smallest value that you can use is 0.5.
     * </p>
     * 
     * @return The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster.
     *         You can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. For Aurora versions
     *         that support the Aurora Serverless v2 auto-pause feature, the smallest value that you can use is 0. For
     *         versions that don't support Aurora Serverless v2 auto-pause, the smallest value that you can use is 0.5.
     */
    public final Double minCapacity() {
        return minCapacity;
    }

    /**
     * <p>
     * The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can
     * specify ACU values in half-step increments, such as 32, 32.5, 33, and so on. The largest value that you can use
     * is 256 for recent Aurora versions, or 128 for older versions.
     * </p>
     * 
     * @return The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster.
     *         You can specify ACU values in half-step increments, such as 32, 32.5, 33, and so on. The largest value
     *         that you can use is 256 for recent Aurora versions, or 128 for older versions.
     */
    public final Double maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * The number of seconds an Aurora Serverless v2 DB instance must be idle before Aurora attempts to automatically
     * pause it. This property is only shown when the minimum capacity for the cluster is set to 0 ACUs. Changing the
     * minimum capacity to a nonzero value removes this property. If you later change the minimum capacity back to 0
     * ACUs, this property is reset to its default value unless you specify it again.
     * </p>
     * <p>
     * This value ranges between 300 seconds (five minutes) and 86,400 seconds (one day). The default is 300 seconds.
     * </p>
     * 
     * @return The number of seconds an Aurora Serverless v2 DB instance must be idle before Aurora attempts to
     *         automatically pause it. This property is only shown when the minimum capacity for the cluster is set to 0
     *         ACUs. Changing the minimum capacity to a nonzero value removes this property. If you later change the
     *         minimum capacity back to 0 ACUs, this property is reset to its default value unless you specify it again.
     *         </p>
     *         <p>
     *         This value ranges between 300 seconds (five minutes) and 86,400 seconds (one day). The default is 300
     *         seconds.
     */
    public final Integer secondsUntilAutoPause() {
        return secondsUntilAutoPause;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(secondsUntilAutoPause());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerlessV2ScalingConfigurationInfo)) {
            return false;
        }
        ServerlessV2ScalingConfigurationInfo other = (ServerlessV2ScalingConfigurationInfo) obj;
        return Objects.equals(minCapacity(), other.minCapacity()) && Objects.equals(maxCapacity(), other.maxCapacity())
                && Objects.equals(secondsUntilAutoPause(), other.secondsUntilAutoPause());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerlessV2ScalingConfigurationInfo").add("MinCapacity", minCapacity())
                .add("MaxCapacity", maxCapacity()).add("SecondsUntilAutoPause", secondsUntilAutoPause()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinCapacity":
            return Optional.ofNullable(clazz.cast(minCapacity()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "SecondsUntilAutoPause":
            return Optional.ofNullable(clazz.cast(secondsUntilAutoPause()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MinCapacity", MIN_CAPACITY_FIELD);
        map.put("MaxCapacity", MAX_CAPACITY_FIELD);
        map.put("SecondsUntilAutoPause", SECONDS_UNTIL_AUTO_PAUSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerlessV2ScalingConfigurationInfo, T> g) {
        return obj -> g.apply((ServerlessV2ScalingConfigurationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerlessV2ScalingConfigurationInfo> {
        /**
         * <p>
         * The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You
         * can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. For Aurora versions that
         * support the Aurora Serverless v2 auto-pause feature, the smallest value that you can use is 0. For versions
         * that don't support Aurora Serverless v2 auto-pause, the smallest value that you can use is 0.5.
         * </p>
         * 
         * @param minCapacity
         *        The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2
         *        cluster. You can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. For Aurora
         *        versions that support the Aurora Serverless v2 auto-pause feature, the smallest value that you can use
         *        is 0. For versions that don't support Aurora Serverless v2 auto-pause, the smallest value that you can
         *        use is 0.5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minCapacity(Double minCapacity);

        /**
         * <p>
         * The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You
         * can specify ACU values in half-step increments, such as 32, 32.5, 33, and so on. The largest value that you
         * can use is 256 for recent Aurora versions, or 128 for older versions.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2
         *        cluster. You can specify ACU values in half-step increments, such as 32, 32.5, 33, and so on. The
         *        largest value that you can use is 256 for recent Aurora versions, or 128 for older versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Double maxCapacity);

        /**
         * <p>
         * The number of seconds an Aurora Serverless v2 DB instance must be idle before Aurora attempts to
         * automatically pause it. This property is only shown when the minimum capacity for the cluster is set to 0
         * ACUs. Changing the minimum capacity to a nonzero value removes this property. If you later change the minimum
         * capacity back to 0 ACUs, this property is reset to its default value unless you specify it again.
         * </p>
         * <p>
         * This value ranges between 300 seconds (five minutes) and 86,400 seconds (one day). The default is 300
         * seconds.
         * </p>
         * 
         * @param secondsUntilAutoPause
         *        The number of seconds an Aurora Serverless v2 DB instance must be idle before Aurora attempts to
         *        automatically pause it. This property is only shown when the minimum capacity for the cluster is set
         *        to 0 ACUs. Changing the minimum capacity to a nonzero value removes this property. If you later change
         *        the minimum capacity back to 0 ACUs, this property is reset to its default value unless you specify it
         *        again. </p>
         *        <p>
         *        This value ranges between 300 seconds (five minutes) and 86,400 seconds (one day). The default is 300
         *        seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondsUntilAutoPause(Integer secondsUntilAutoPause);
    }

    static final class BuilderImpl implements Builder {
        private Double minCapacity;

        private Double maxCapacity;

        private Integer secondsUntilAutoPause;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerlessV2ScalingConfigurationInfo model) {
            minCapacity(model.minCapacity);
            maxCapacity(model.maxCapacity);
            secondsUntilAutoPause(model.secondsUntilAutoPause);
        }

        public final Double getMinCapacity() {
            return minCapacity;
        }

        public final void setMinCapacity(Double minCapacity) {
            this.minCapacity = minCapacity;
        }

        @Override
        public final Builder minCapacity(Double minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final Double getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final Integer getSecondsUntilAutoPause() {
            return secondsUntilAutoPause;
        }

        public final void setSecondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
        }

        @Override
        public final Builder secondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
            return this;
        }

        @Override
        public ServerlessV2ScalingConfigurationInfo build() {
            return new ServerlessV2ScalingConfigurationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
