/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.GlobalClusterMemberSynchronizationStatus;
import software.amazon.awssdk.services.rds.model.ReadersArnListCopier;
import software.amazon.awssdk.services.rds.model.WriteForwardingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalClusterMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlobalClusterMember> {
    private static final SdkField<String> DB_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterArn").getter(GlobalClusterMember.getter(GlobalClusterMember::dbClusterArn)).setter(GlobalClusterMember.setter(Builder::dbClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterArn").build()}).build();
    private static final SdkField<List<String>> READERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Readers").getter(GlobalClusterMember.getter(GlobalClusterMember::readers)).setter(GlobalClusterMember.setter(Builder::readers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Readers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_WRITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsWriter").getter(GlobalClusterMember.getter(GlobalClusterMember::isWriter)).setter(GlobalClusterMember.setter(Builder::isWriter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsWriter").build()}).build();
    private static final SdkField<String> GLOBAL_WRITE_FORWARDING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalWriteForwardingStatus").getter(GlobalClusterMember.getter(GlobalClusterMember::globalWriteForwardingStatusAsString)).setter(GlobalClusterMember.setter(Builder::globalWriteForwardingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalWriteForwardingStatus").build()}).build();
    private static final SdkField<String> SYNCHRONIZATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SynchronizationStatus").getter(GlobalClusterMember.getter(GlobalClusterMember::synchronizationStatusAsString)).setter(GlobalClusterMember.setter(Builder::synchronizationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SynchronizationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_ARN_FIELD, READERS_FIELD, IS_WRITER_FIELD, GLOBAL_WRITE_FORWARDING_STATUS_FIELD, SYNCHRONIZATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GlobalClusterMember.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dbClusterArn;
    private final List<String> readers;
    private final Boolean isWriter;
    private final String globalWriteForwardingStatus;
    private final String synchronizationStatus;

    private GlobalClusterMember(BuilderImpl builder) {
        this.dbClusterArn = builder.dbClusterArn;
        this.readers = builder.readers;
        this.isWriter = builder.isWriter;
        this.globalWriteForwardingStatus = builder.globalWriteForwardingStatus;
        this.synchronizationStatus = builder.synchronizationStatus;
    }

    public final String dbClusterArn() {
        return this.dbClusterArn;
    }

    public final boolean hasReaders() {
        return this.readers != null && !(this.readers instanceof SdkAutoConstructList);
    }

    public final List<String> readers() {
        return this.readers;
    }

    public final Boolean isWriter() {
        return this.isWriter;
    }

    public final WriteForwardingStatus globalWriteForwardingStatus() {
        return WriteForwardingStatus.fromValue(this.globalWriteForwardingStatus);
    }

    public final String globalWriteForwardingStatusAsString() {
        return this.globalWriteForwardingStatus;
    }

    public final GlobalClusterMemberSynchronizationStatus synchronizationStatus() {
        return GlobalClusterMemberSynchronizationStatus.fromValue(this.synchronizationStatus);
    }

    public final String synchronizationStatusAsString() {
        return this.synchronizationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReaders() ? this.readers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isWriter());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalWriteForwardingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.synchronizationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalClusterMember)) {
            return false;
        }
        GlobalClusterMember other = (GlobalClusterMember)obj;
        return Objects.equals(this.dbClusterArn(), other.dbClusterArn()) && this.hasReaders() == other.hasReaders() && Objects.equals(this.readers(), other.readers()) && Objects.equals(this.isWriter(), other.isWriter()) && Objects.equals(this.globalWriteForwardingStatusAsString(), other.globalWriteForwardingStatusAsString()) && Objects.equals(this.synchronizationStatusAsString(), other.synchronizationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GlobalClusterMember").add("DBClusterArn", (Object)this.dbClusterArn()).add("Readers", this.hasReaders() ? this.readers() : null).add("IsWriter", (Object)this.isWriter()).add("GlobalWriteForwardingStatus", (Object)this.globalWriteForwardingStatusAsString()).add("SynchronizationStatus", (Object)this.synchronizationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterArn": {
                return Optional.ofNullable(clazz.cast(this.dbClusterArn()));
            }
            case "Readers": {
                return Optional.ofNullable(clazz.cast(this.readers()));
            }
            case "IsWriter": {
                return Optional.ofNullable(clazz.cast(this.isWriter()));
            }
            case "GlobalWriteForwardingStatus": {
                return Optional.ofNullable(clazz.cast(this.globalWriteForwardingStatusAsString()));
            }
            case "SynchronizationStatus": {
                return Optional.ofNullable(clazz.cast(this.synchronizationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DBClusterArn", DB_CLUSTER_ARN_FIELD);
        map.put("Readers", READERS_FIELD);
        map.put("IsWriter", IS_WRITER_FIELD);
        map.put("GlobalWriteForwardingStatus", GLOBAL_WRITE_FORWARDING_STATUS_FIELD);
        map.put("SynchronizationStatus", SYNCHRONIZATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlobalClusterMember, T> g) {
        return obj -> g.apply((GlobalClusterMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbClusterArn;
        private List<String> readers = DefaultSdkAutoConstructList.getInstance();
        private Boolean isWriter;
        private String globalWriteForwardingStatus;
        private String synchronizationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalClusterMember model) {
            this.dbClusterArn(model.dbClusterArn);
            this.readers(model.readers);
            this.isWriter(model.isWriter);
            this.globalWriteForwardingStatus(model.globalWriteForwardingStatus);
            this.synchronizationStatus(model.synchronizationStatus);
        }

        public final String getDbClusterArn() {
            return this.dbClusterArn;
        }

        public final void setDbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
        }

        @Override
        public final Builder dbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
            return this;
        }

        public final Collection<String> getReaders() {
            if (this.readers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.readers;
        }

        public final void setReaders(Collection<String> readers) {
            this.readers = ReadersArnListCopier.copy(readers);
        }

        @Override
        public final Builder readers(Collection<String> readers) {
            this.readers = ReadersArnListCopier.copy(readers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readers(String ... readers) {
            this.readers(Arrays.asList(readers));
            return this;
        }

        public final Boolean getIsWriter() {
            return this.isWriter;
        }

        public final void setIsWriter(Boolean isWriter) {
            this.isWriter = isWriter;
        }

        @Override
        public final Builder isWriter(Boolean isWriter) {
            this.isWriter = isWriter;
            return this;
        }

        public final String getGlobalWriteForwardingStatus() {
            return this.globalWriteForwardingStatus;
        }

        public final void setGlobalWriteForwardingStatus(String globalWriteForwardingStatus) {
            this.globalWriteForwardingStatus = globalWriteForwardingStatus;
        }

        @Override
        public final Builder globalWriteForwardingStatus(String globalWriteForwardingStatus) {
            this.globalWriteForwardingStatus = globalWriteForwardingStatus;
            return this;
        }

        @Override
        public final Builder globalWriteForwardingStatus(WriteForwardingStatus globalWriteForwardingStatus) {
            this.globalWriteForwardingStatus(globalWriteForwardingStatus == null ? null : globalWriteForwardingStatus.toString());
            return this;
        }

        public final String getSynchronizationStatus() {
            return this.synchronizationStatus;
        }

        public final void setSynchronizationStatus(String synchronizationStatus) {
            this.synchronizationStatus = synchronizationStatus;
        }

        @Override
        public final Builder synchronizationStatus(String synchronizationStatus) {
            this.synchronizationStatus = synchronizationStatus;
            return this;
        }

        @Override
        public final Builder synchronizationStatus(GlobalClusterMemberSynchronizationStatus synchronizationStatus) {
            this.synchronizationStatus(synchronizationStatus == null ? null : synchronizationStatus.toString());
            return this;
        }

        public GlobalClusterMember build() {
            return new GlobalClusterMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlobalClusterMember> {
        public Builder dbClusterArn(String var1);

        public Builder readers(Collection<String> var1);

        public Builder readers(String ... var1);

        public Builder isWriter(Boolean var1);

        public Builder globalWriteForwardingStatus(String var1);

        public Builder globalWriteForwardingStatus(WriteForwardingStatus var1);

        public Builder synchronizationStatus(String var1);

        public Builder synchronizationStatus(GlobalClusterMemberSynchronizationStatus var1);
    }
}

