/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGlobalClusterRequest extends RdsRequest implements
        ToCopyableBuilder<CreateGlobalClusterRequest.Builder, CreateGlobalClusterRequest> {
    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalClusterIdentifier").getter(getter(CreateGlobalClusterRequest::globalClusterIdentifier))
            .setter(setter(Builder::globalClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterIdentifier").build())
            .build();

    private static final SdkField<String> SOURCE_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceDBClusterIdentifier").getter(getter(CreateGlobalClusterRequest::sourceDBClusterIdentifier))
            .setter(setter(Builder::sourceDBClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBClusterIdentifier").build())
            .build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(CreateGlobalClusterRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(CreateGlobalClusterRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> ENGINE_LIFECYCLE_SUPPORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineLifecycleSupport").getter(getter(CreateGlobalClusterRequest::engineLifecycleSupport))
            .setter(setter(Builder::engineLifecycleSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineLifecycleSupport").build())
            .build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(CreateGlobalClusterRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(CreateGlobalClusterRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEncrypted").getter(getter(CreateGlobalClusterRequest::storageEncrypted))
            .setter(setter(Builder::storageEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateGlobalClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_CLUSTER_IDENTIFIER_FIELD, SOURCE_DB_CLUSTER_IDENTIFIER_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD,
            ENGINE_LIFECYCLE_SUPPORT_FIELD, DELETION_PROTECTION_FIELD, DATABASE_NAME_FIELD, STORAGE_ENCRYPTED_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String globalClusterIdentifier;

    private final String sourceDBClusterIdentifier;

    private final String engine;

    private final String engineVersion;

    private final String engineLifecycleSupport;

    private final Boolean deletionProtection;

    private final String databaseName;

    private final Boolean storageEncrypted;

    private final List<Tag> tags;

    private CreateGlobalClusterRequest(BuilderImpl builder) {
        super(builder);
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.sourceDBClusterIdentifier = builder.sourceDBClusterIdentifier;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.engineLifecycleSupport = builder.engineLifecycleSupport;
        this.deletionProtection = builder.deletionProtection;
        this.databaseName = builder.databaseName;
        this.storageEncrypted = builder.storageEncrypted;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The cluster identifier for this global database cluster. This parameter is stored as a lowercase string.
     * </p>
     * 
     * @return The cluster identifier for this global database cluster. This parameter is stored as a lowercase string.
     */
    public final String globalClusterIdentifier() {
        return globalClusterIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) to use as the primary cluster of the global database.
     * </p>
     * <p>
     * If you provide a value for this parameter, don't specify values for the following settings because Amazon Aurora
     * uses the values from the specified source DB cluster:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DatabaseName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Engine</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EngineVersion</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StorageEncrypted</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) to use as the primary cluster of the global database.</p>
     *         <p>
     *         If you provide a value for this parameter, don't specify values for the following settings because Amazon
     *         Aurora uses the values from the specified source DB cluster:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DatabaseName</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Engine</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EngineVersion</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>StorageEncrypted</code>
     *         </p>
     *         </li>
     */
    public final String sourceDBClusterIdentifier() {
        return sourceDBClusterIdentifier;
    }

    /**
     * <p>
     * The database engine to use for this global database cluster.
     * </p>
     * <p>
     * Valid Values: <code>aurora-mysql | aurora-postgresql</code>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses the
     * engine of the source DB cluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The database engine to use for this global database cluster.</p>
     *         <p>
     *         Valid Values: <code>aurora-mysql | aurora-postgresql</code>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora
     *         uses the engine of the source DB cluster.
     *         </p>
     *         </li>
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The engine version to use for this global database cluster.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses the
     * engine version of the source DB cluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The engine version to use for this global database cluster.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora
     *         uses the engine version of the source DB cluster.
     *         </p>
     *         </li>
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The life cycle type for this global database cluster.
     * </p>
     * <note>
     * <p>
     * By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your global cluster
     * into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by
     * setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case, creating the global
     * cluster will fail if the DB major version is past its end of standard support date.
     * </p>
     * </note>
     * <p>
     * This setting only applies to Aurora PostgreSQL-based global databases.
     * </p>
     * <p>
     * You can use this setting to enroll your global cluster into Amazon RDS Extended Support. With RDS Extended
     * Support, you can run the selected major engine version on your global cluster past the end of standard support
     * for that engine version. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Using Amazon RDS
     * Extended Support</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
     * </p>
     * <p>
     * Default: <code>open-source-rds-extended-support</code>
     * </p>
     * 
     * @return The life cycle type for this global database cluster.</p> <note>
     *         <p>
     *         By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your global
     *         cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for
     *         Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this
     *         case, creating the global cluster will fail if the DB major version is past its end of standard support
     *         date.
     *         </p>
     *         </note>
     *         <p>
     *         This setting only applies to Aurora PostgreSQL-based global databases.
     *         </p>
     *         <p>
     *         You can use this setting to enroll your global cluster into Amazon RDS Extended Support. With RDS
     *         Extended Support, you can run the selected major engine version on your global cluster past the end of
     *         standard support for that engine version. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Using Amazon
     *         RDS Extended Support</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <p>
     *         Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
     *         </p>
     *         <p>
     *         Default: <code>open-source-rds-extended-support</code>
     */
    public final String engineLifecycleSupport() {
        return engineLifecycleSupport;
    }

    /**
     * <p>
     * Specifies whether to enable deletion protection for the new global database cluster. The global database can't be
     * deleted when deletion protection is enabled.
     * </p>
     * 
     * @return Specifies whether to enable deletion protection for the new global database cluster. The global database
     *         can't be deleted when deletion protection is enabled.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * The name for your database of up to 64 alphanumeric characters. If you don't specify a name, Amazon Aurora
     * doesn't create a database in the global database cluster.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses the
     * database name from the source DB cluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name for your database of up to 64 alphanumeric characters. If you don't specify a name, Amazon
     *         Aurora doesn't create a database in the global database cluster.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora
     *         uses the database name from the source DB cluster.
     *         </p>
     *         </li>
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * Specifies whether to enable storage encryption for the new global database cluster.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses the
     * setting from the source DB cluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether to enable storage encryption for the new global database cluster.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora
     *         uses the setting from the source DB cluster.
     *         </p>
     *         </li>
     */
    public final Boolean storageEncrypted() {
        return storageEncrypted;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to assign to the global cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to assign to the global cluster.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDBClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(engineLifecycleSupport());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlobalClusterRequest)) {
            return false;
        }
        CreateGlobalClusterRequest other = (CreateGlobalClusterRequest) obj;
        return Objects.equals(globalClusterIdentifier(), other.globalClusterIdentifier())
                && Objects.equals(sourceDBClusterIdentifier(), other.sourceDBClusterIdentifier())
                && Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(engineLifecycleSupport(), other.engineLifecycleSupport())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(storageEncrypted(), other.storageEncrypted()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGlobalClusterRequest").add("GlobalClusterIdentifier", globalClusterIdentifier())
                .add("SourceDBClusterIdentifier", sourceDBClusterIdentifier()).add("Engine", engine())
                .add("EngineVersion", engineVersion()).add("EngineLifecycleSupport", engineLifecycleSupport())
                .add("DeletionProtection", deletionProtection()).add("DatabaseName", databaseName())
                .add("StorageEncrypted", storageEncrypted()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalClusterIdentifier":
            return Optional.ofNullable(clazz.cast(globalClusterIdentifier()));
        case "SourceDBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(sourceDBClusterIdentifier()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "EngineLifecycleSupport":
            return Optional.ofNullable(clazz.cast(engineLifecycleSupport()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "StorageEncrypted":
            return Optional.ofNullable(clazz.cast(storageEncrypted()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GlobalClusterIdentifier", GLOBAL_CLUSTER_IDENTIFIER_FIELD);
        map.put("SourceDBClusterIdentifier", SOURCE_DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("EngineLifecycleSupport", ENGINE_LIFECYCLE_SUPPORT_FIELD);
        map.put("DeletionProtection", DELETION_PROTECTION_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("StorageEncrypted", STORAGE_ENCRYPTED_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGlobalClusterRequest, T> g) {
        return obj -> g.apply((CreateGlobalClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGlobalClusterRequest> {
        /**
         * <p>
         * The cluster identifier for this global database cluster. This parameter is stored as a lowercase string.
         * </p>
         * 
         * @param globalClusterIdentifier
         *        The cluster identifier for this global database cluster. This parameter is stored as a lowercase
         *        string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalClusterIdentifier(String globalClusterIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) to use as the primary cluster of the global database.
         * </p>
         * <p>
         * If you provide a value for this parameter, don't specify values for the following settings because Amazon
         * Aurora uses the values from the specified source DB cluster:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DatabaseName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Engine</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EngineVersion</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>StorageEncrypted</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceDBClusterIdentifier
         *        The Amazon Resource Name (ARN) to use as the primary cluster of the global database.</p>
         *        <p>
         *        If you provide a value for this parameter, don't specify values for the following settings because
         *        Amazon Aurora uses the values from the specified source DB cluster:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DatabaseName</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Engine</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EngineVersion</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>StorageEncrypted</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier);

        /**
         * <p>
         * The database engine to use for this global database cluster.
         * </p>
         * <p>
         * Valid Values: <code>aurora-mysql | aurora-postgresql</code>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses
         * the engine of the source DB cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param engine
         *        The database engine to use for this global database cluster.</p>
         *        <p>
         *        Valid Values: <code>aurora-mysql | aurora-postgresql</code>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora
         *        uses the engine of the source DB cluster.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The engine version to use for this global database cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses
         * the engine version of the source DB cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param engineVersion
         *        The engine version to use for this global database cluster.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora
         *        uses the engine version of the source DB cluster.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The life cycle type for this global database cluster.
         * </p>
         * <note>
         * <p>
         * By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your global
         * cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended
         * Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case,
         * creating the global cluster will fail if the DB major version is past its end of standard support date.
         * </p>
         * </note>
         * <p>
         * This setting only applies to Aurora PostgreSQL-based global databases.
         * </p>
         * <p>
         * You can use this setting to enroll your global cluster into Amazon RDS Extended Support. With RDS Extended
         * Support, you can run the selected major engine version on your global cluster past the end of standard
         * support for that engine version. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Using Amazon RDS
         * Extended Support</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
         * </p>
         * <p>
         * Default: <code>open-source-rds-extended-support</code>
         * </p>
         * 
         * @param engineLifecycleSupport
         *        The life cycle type for this global database cluster.</p> <note>
         *        <p>
         *        By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your
         *        global cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges
         *        for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>.
         *        In this case, creating the global cluster will fail if the DB major version is past its end of
         *        standard support date.
         *        </p>
         *        </note>
         *        <p>
         *        This setting only applies to Aurora PostgreSQL-based global databases.
         *        </p>
         *        <p>
         *        You can use this setting to enroll your global cluster into Amazon RDS Extended Support. With RDS
         *        Extended Support, you can run the selected major engine version on your global cluster past the end of
         *        standard support for that engine version. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Using Amazon
         *        RDS Extended Support</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Valid Values:
         *        <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
         *        </p>
         *        <p>
         *        Default: <code>open-source-rds-extended-support</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineLifecycleSupport(String engineLifecycleSupport);

        /**
         * <p>
         * Specifies whether to enable deletion protection for the new global database cluster. The global database
         * can't be deleted when deletion protection is enabled.
         * </p>
         * 
         * @param deletionProtection
         *        Specifies whether to enable deletion protection for the new global database cluster. The global
         *        database can't be deleted when deletion protection is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * The name for your database of up to 64 alphanumeric characters. If you don't specify a name, Amazon Aurora
         * doesn't create a database in the global database cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses
         * the database name from the source DB cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param databaseName
         *        The name for your database of up to 64 alphanumeric characters. If you don't specify a name, Amazon
         *        Aurora doesn't create a database in the global database cluster.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora
         *        uses the database name from the source DB cluster.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * Specifies whether to enable storage encryption for the new global database cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses
         * the setting from the source DB cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param storageEncrypted
         *        Specifies whether to enable storage encryption for the new global database cluster.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora
         *        uses the setting from the source DB cluster.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEncrypted(Boolean storageEncrypted);

        /**
         * <p>
         * Tags to assign to the global cluster.
         * </p>
         * 
         * @param tags
         *        Tags to assign to the global cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags to assign to the global cluster.
         * </p>
         * 
         * @param tags
         *        Tags to assign to the global cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags to assign to the global cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String globalClusterIdentifier;

        private String sourceDBClusterIdentifier;

        private String engine;

        private String engineVersion;

        private String engineLifecycleSupport;

        private Boolean deletionProtection;

        private String databaseName;

        private Boolean storageEncrypted;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlobalClusterRequest model) {
            super(model);
            globalClusterIdentifier(model.globalClusterIdentifier);
            sourceDBClusterIdentifier(model.sourceDBClusterIdentifier);
            engine(model.engine);
            engineVersion(model.engineVersion);
            engineLifecycleSupport(model.engineLifecycleSupport);
            deletionProtection(model.deletionProtection);
            databaseName(model.databaseName);
            storageEncrypted(model.storageEncrypted);
            tags(model.tags);
        }

        public final String getGlobalClusterIdentifier() {
            return globalClusterIdentifier;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        @Override
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final String getSourceDBClusterIdentifier() {
            return sourceDBClusterIdentifier;
        }

        public final void setSourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
        }

        @Override
        public final Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getEngineLifecycleSupport() {
            return engineLifecycleSupport;
        }

        public final void setEngineLifecycleSupport(String engineLifecycleSupport) {
            this.engineLifecycleSupport = engineLifecycleSupport;
        }

        @Override
        public final Builder engineLifecycleSupport(String engineLifecycleSupport) {
            this.engineLifecycleSupport = engineLifecycleSupport;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGlobalClusterRequest build() {
            return new CreateGlobalClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
