/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDbShardGroupRequest extends RdsRequest implements
        ToCopyableBuilder<CreateDbShardGroupRequest.Builder, CreateDbShardGroupRequest> {
    private static final SdkField<String> DB_SHARD_GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBShardGroupIdentifier").getter(getter(CreateDbShardGroupRequest::dbShardGroupIdentifier))
            .setter(setter(Builder::dbShardGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBShardGroupIdentifier").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(CreateDbShardGroupRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<Integer> COMPUTE_REDUNDANCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ComputeRedundancy").getter(getter(CreateDbShardGroupRequest::computeRedundancy))
            .setter(setter(Builder::computeRedundancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeRedundancy").build()).build();

    private static final SdkField<Double> MAX_ACU_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("MaxACU")
            .getter(getter(CreateDbShardGroupRequest::maxACU)).setter(setter(Builder::maxACU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxACU").build()).build();

    private static final SdkField<Double> MIN_ACU_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("MinACU")
            .getter(getter(CreateDbShardGroupRequest::minACU)).setter(setter(Builder::minACU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinACU").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(CreateDbShardGroupRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDbShardGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DB_SHARD_GROUP_IDENTIFIER_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, COMPUTE_REDUNDANCY_FIELD, MAX_ACU_FIELD, MIN_ACU_FIELD,
            PUBLICLY_ACCESSIBLE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbShardGroupIdentifier;

    private final String dbClusterIdentifier;

    private final Integer computeRedundancy;

    private final Double maxACU;

    private final Double minACU;

    private final Boolean publiclyAccessible;

    private final List<Tag> tags;

    private CreateDbShardGroupRequest(BuilderImpl builder) {
        super(builder);
        this.dbShardGroupIdentifier = builder.dbShardGroupIdentifier;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.computeRedundancy = builder.computeRedundancy;
        this.maxACU = builder.maxACU;
        this.minACU = builder.minACU;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the DB shard group.
     * </p>
     * 
     * @return The name of the DB shard group.
     */
    public final String dbShardGroupIdentifier() {
        return dbShardGroupIdentifier;
    }

    /**
     * <p>
     * The name of the primary DB cluster for the DB shard group.
     * </p>
     * 
     * @return The name of the primary DB cluster for the DB shard group.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * 0 - Creates a DB shard group without a standby DB shard group. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * 1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).
     * </p>
     * </li>
     * <li>
     * <p>
     * 2 - Creates a DB shard group with two standby DB shard groups in two different AZs.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         0 - Creates a DB shard group without a standby DB shard group. This is the default value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2 - Creates a DB shard group with two standby DB shard groups in two different AZs.
     *         </p>
     *         </li>
     */
    public final Integer computeRedundancy() {
        return computeRedundancy;
    }

    /**
     * <p>
     * The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
     * </p>
     * 
     * @return The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
     */
    public final Double maxACU() {
        return maxACU;
    }

    /**
     * <p>
     * The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
     * </p>
     * 
     * @return The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
     */
    public final Double minACU() {
        return minACU;
    }

    /**
     * <p>
     * Specifies whether the DB shard group is publicly accessible.
     * </p>
     * <p>
     * When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP
     * address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from
     * outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group
     * it uses. That public access is not permitted if the security group assigned to the DB shard group doesn't permit
     * it.
     * </p>
     * <p>
     * When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves
     * to a private IP address.
     * </p>
     * <p>
     * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     * </p>
     * <p>
     * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the
     * following applies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB shard group is
     * private.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the default VPC in the target Region has an internet gateway attached to it, the DB shard group is public.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
     * following applies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB shard group is
     * private.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the subnets are part of a VPC that has an internet gateway attached to it, the DB shard group is public.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether the DB shard group is publicly accessible.</p>
     *         <p>
     *         When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the
     *         private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the
     *         public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately
     *         controlled by the security group it uses. That public access is not permitted if the security group
     *         assigned to the DB shard group doesn't permit it.
     *         </p>
     *         <p>
     *         When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that
     *         resolves to a private IP address.
     *         </p>
     *         <p>
     *         Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     *         </p>
     *         <p>
     *         If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified,
     *         the following applies:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB shard
     *         group is private.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the default VPC in the target Region has an internet gateway attached to it, the DB shard group is
     *         public.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
     *         following applies:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB shard group
     *         is private.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the subnets are part of a VPC that has an internet gateway attached to it, the DB shard group is
     *         public.
     *         </p>
     *         </li>
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbShardGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(computeRedundancy());
        hashCode = 31 * hashCode + Objects.hashCode(maxACU());
        hashCode = 31 * hashCode + Objects.hashCode(minACU());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbShardGroupRequest)) {
            return false;
        }
        CreateDbShardGroupRequest other = (CreateDbShardGroupRequest) obj;
        return Objects.equals(dbShardGroupIdentifier(), other.dbShardGroupIdentifier())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(computeRedundancy(), other.computeRedundancy()) && Objects.equals(maxACU(), other.maxACU())
                && Objects.equals(minACU(), other.minACU()) && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDbShardGroupRequest").add("DBShardGroupIdentifier", dbShardGroupIdentifier())
                .add("DBClusterIdentifier", dbClusterIdentifier()).add("ComputeRedundancy", computeRedundancy())
                .add("MaxACU", maxACU()).add("MinACU", minACU()).add("PubliclyAccessible", publiclyAccessible())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBShardGroupIdentifier":
            return Optional.ofNullable(clazz.cast(dbShardGroupIdentifier()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "ComputeRedundancy":
            return Optional.ofNullable(clazz.cast(computeRedundancy()));
        case "MaxACU":
            return Optional.ofNullable(clazz.cast(maxACU()));
        case "MinACU":
            return Optional.ofNullable(clazz.cast(minACU()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBShardGroupIdentifier", DB_SHARD_GROUP_IDENTIFIER_FIELD);
        map.put("DBClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("ComputeRedundancy", COMPUTE_REDUNDANCY_FIELD);
        map.put("MaxACU", MAX_ACU_FIELD);
        map.put("MinACU", MIN_ACU_FIELD);
        map.put("PubliclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDbShardGroupRequest, T> g) {
        return obj -> g.apply((CreateDbShardGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDbShardGroupRequest> {
        /**
         * <p>
         * The name of the DB shard group.
         * </p>
         * 
         * @param dbShardGroupIdentifier
         *        The name of the DB shard group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbShardGroupIdentifier(String dbShardGroupIdentifier);

        /**
         * <p>
         * The name of the primary DB cluster for the DB shard group.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The name of the primary DB cluster for the DB shard group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * 0 - Creates a DB shard group without a standby DB shard group. This is the default value.
         * </p>
         * </li>
         * <li>
         * <p>
         * 1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).
         * </p>
         * </li>
         * <li>
         * <p>
         * 2 - Creates a DB shard group with two standby DB shard groups in two different AZs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param computeRedundancy
         *        Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        0 - Creates a DB shard group without a standby DB shard group. This is the default value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2 - Creates a DB shard group with two standby DB shard groups in two different AZs.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeRedundancy(Integer computeRedundancy);

        /**
         * <p>
         * The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
         * </p>
         * 
         * @param maxACU
         *        The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxACU(Double maxACU);

        /**
         * <p>
         * The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
         * </p>
         * 
         * @param minACU
         *        The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minACU(Double minACU);

        /**
         * <p>
         * Specifies whether the DB shard group is publicly accessible.
         * </p>
         * <p>
         * When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private
         * IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address
         * from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the
         * security group it uses. That public access is not permitted if the security group assigned to the DB shard
         * group doesn't permit it.
         * </p>
         * <p>
         * When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that
         * resolves to a private IP address.
         * </p>
         * <p>
         * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         * </p>
         * <p>
         * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the
         * following applies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB shard group
         * is private.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the default VPC in the target Region has an internet gateway attached to it, the DB shard group is public.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
         * following applies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB shard group is
         * private.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the subnets are part of a VPC that has an internet gateway attached to it, the DB shard group is public.
         * </p>
         * </li>
         * </ul>
         * 
         * @param publiclyAccessible
         *        Specifies whether the DB shard group is publicly accessible.</p>
         *        <p>
         *        When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the
         *        private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the
         *        public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately
         *        controlled by the security group it uses. That public access is not permitted if the security group
         *        assigned to the DB shard group doesn't permit it.
         *        </p>
         *        <p>
         *        When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name
         *        that resolves to a private IP address.
         *        </p>
         *        <p>
         *        Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         *        </p>
         *        <p>
         *        If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't
         *        specified, the following applies:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB shard
         *        group is private.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the default VPC in the target Region has an internet gateway attached to it, the DB shard group is
         *        public.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified,
         *        the following applies:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB shard
         *        group is private.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the subnets are part of a VPC that has an internet gateway attached to it, the DB shard group is
         *        public.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbShardGroupIdentifier;

        private String dbClusterIdentifier;

        private Integer computeRedundancy;

        private Double maxACU;

        private Double minACU;

        private Boolean publiclyAccessible;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbShardGroupRequest model) {
            super(model);
            dbShardGroupIdentifier(model.dbShardGroupIdentifier);
            dbClusterIdentifier(model.dbClusterIdentifier);
            computeRedundancy(model.computeRedundancy);
            maxACU(model.maxACU);
            minACU(model.minACU);
            publiclyAccessible(model.publiclyAccessible);
            tags(model.tags);
        }

        public final String getDbShardGroupIdentifier() {
            return dbShardGroupIdentifier;
        }

        public final void setDbShardGroupIdentifier(String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
        }

        @Override
        public final Builder dbShardGroupIdentifier(String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final Integer getComputeRedundancy() {
            return computeRedundancy;
        }

        public final void setComputeRedundancy(Integer computeRedundancy) {
            this.computeRedundancy = computeRedundancy;
        }

        @Override
        public final Builder computeRedundancy(Integer computeRedundancy) {
            this.computeRedundancy = computeRedundancy;
            return this;
        }

        public final Double getMaxACU() {
            return maxACU;
        }

        public final void setMaxACU(Double maxACU) {
            this.maxACU = maxACU;
        }

        @Override
        public final Builder maxACU(Double maxACU) {
            this.maxACU = maxACU;
            return this;
        }

        public final Double getMinACU() {
            return minACU;
        }

        public final void setMinACU(Double minACU) {
            this.minACU = minACU;
        }

        @Override
        public final Builder minACU(Double minACU) {
            this.minACU = minACU;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbShardGroupRequest build() {
            return new CreateDbShardGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
