/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbSnapshotTenantDatabasesResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeDbSnapshotTenantDatabasesResponse.Builder, DescribeDbSnapshotTenantDatabasesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbSnapshotTenantDatabasesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<DBSnapshotTenantDatabase>> DB_SNAPSHOT_TENANT_DATABASES_FIELD = SdkField
            .<List<DBSnapshotTenantDatabase>> builder(MarshallingType.LIST)
            .memberName("DBSnapshotTenantDatabases")
            .getter(getter(DescribeDbSnapshotTenantDatabasesResponse::dbSnapshotTenantDatabases))
            .setter(setter(Builder::dbSnapshotTenantDatabases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotTenantDatabases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBSnapshotTenantDatabase")
                            .memberFieldInfo(
                                    SdkField.<DBSnapshotTenantDatabase> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBSnapshotTenantDatabase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBSnapshotTenantDatabase").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            DB_SNAPSHOT_TENANT_DATABASES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final List<DBSnapshotTenantDatabase> dbSnapshotTenantDatabases;

    private DescribeDbSnapshotTenantDatabasesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbSnapshotTenantDatabases = builder.dbSnapshotTenantDatabases;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the DBSnapshotTenantDatabases property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDbSnapshotTenantDatabases() {
        return dbSnapshotTenantDatabases != null && !(dbSnapshotTenantDatabases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DB snapshot tenant databases.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbSnapshotTenantDatabases} method.
     * </p>
     * 
     * @return A list of DB snapshot tenant databases.
     */
    public final List<DBSnapshotTenantDatabase> dbSnapshotTenantDatabases() {
        return dbSnapshotTenantDatabases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbSnapshotTenantDatabases() ? dbSnapshotTenantDatabases() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbSnapshotTenantDatabasesResponse)) {
            return false;
        }
        DescribeDbSnapshotTenantDatabasesResponse other = (DescribeDbSnapshotTenantDatabasesResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasDbSnapshotTenantDatabases() == other.hasDbSnapshotTenantDatabases()
                && Objects.equals(dbSnapshotTenantDatabases(), other.dbSnapshotTenantDatabases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbSnapshotTenantDatabasesResponse").add("Marker", marker())
                .add("DBSnapshotTenantDatabases", hasDbSnapshotTenantDatabases() ? dbSnapshotTenantDatabases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "DBSnapshotTenantDatabases":
            return Optional.ofNullable(clazz.cast(dbSnapshotTenantDatabases()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("DBSnapshotTenantDatabases", DB_SNAPSHOT_TENANT_DATABASES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbSnapshotTenantDatabasesResponse, T> g) {
        return obj -> g.apply((DescribeDbSnapshotTenantDatabasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDbSnapshotTenantDatabasesResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of DB snapshot tenant databases.
         * </p>
         * 
         * @param dbSnapshotTenantDatabases
         *        A list of DB snapshot tenant databases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSnapshotTenantDatabases(Collection<DBSnapshotTenantDatabase> dbSnapshotTenantDatabases);

        /**
         * <p>
         * A list of DB snapshot tenant databases.
         * </p>
         * 
         * @param dbSnapshotTenantDatabases
         *        A list of DB snapshot tenant databases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSnapshotTenantDatabases(DBSnapshotTenantDatabase... dbSnapshotTenantDatabases);

        /**
         * <p>
         * A list of DB snapshot tenant databases.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.DBSnapshotTenantDatabase.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.rds.model.DBSnapshotTenantDatabase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.DBSnapshotTenantDatabase.Builder#build()} is called
         * immediately and its result is passed to {@link #dbSnapshotTenantDatabases(List<DBSnapshotTenantDatabase>)}.
         * 
         * @param dbSnapshotTenantDatabases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.DBSnapshotTenantDatabase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbSnapshotTenantDatabases(java.util.Collection<DBSnapshotTenantDatabase>)
         */
        Builder dbSnapshotTenantDatabases(Consumer<DBSnapshotTenantDatabase.Builder>... dbSnapshotTenantDatabases);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String marker;

        private List<DBSnapshotTenantDatabase> dbSnapshotTenantDatabases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbSnapshotTenantDatabasesResponse model) {
            super(model);
            marker(model.marker);
            dbSnapshotTenantDatabases(model.dbSnapshotTenantDatabases);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<DBSnapshotTenantDatabase.Builder> getDbSnapshotTenantDatabases() {
            List<DBSnapshotTenantDatabase.Builder> result = DBSnapshotTenantDatabasesListCopier
                    .copyToBuilder(this.dbSnapshotTenantDatabases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbSnapshotTenantDatabases(Collection<DBSnapshotTenantDatabase.BuilderImpl> dbSnapshotTenantDatabases) {
            this.dbSnapshotTenantDatabases = DBSnapshotTenantDatabasesListCopier.copyFromBuilder(dbSnapshotTenantDatabases);
        }

        @Override
        public final Builder dbSnapshotTenantDatabases(Collection<DBSnapshotTenantDatabase> dbSnapshotTenantDatabases) {
            this.dbSnapshotTenantDatabases = DBSnapshotTenantDatabasesListCopier.copy(dbSnapshotTenantDatabases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSnapshotTenantDatabases(DBSnapshotTenantDatabase... dbSnapshotTenantDatabases) {
            dbSnapshotTenantDatabases(Arrays.asList(dbSnapshotTenantDatabases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSnapshotTenantDatabases(Consumer<DBSnapshotTenantDatabase.Builder>... dbSnapshotTenantDatabases) {
            dbSnapshotTenantDatabases(Stream.of(dbSnapshotTenantDatabases)
                    .map(c -> DBSnapshotTenantDatabase.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDbSnapshotTenantDatabasesResponse build() {
            return new DescribeDbSnapshotTenantDatabasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
