/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The minimum DB engine version required for each corresponding allowed value for an option setting.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MinimumEngineVersionPerAllowedValue implements SdkPojo, Serializable,
        ToCopyableBuilder<MinimumEngineVersionPerAllowedValue.Builder, MinimumEngineVersionPerAllowedValue> {
    private static final SdkField<String> ALLOWED_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AllowedValue").getter(getter(MinimumEngineVersionPerAllowedValue::allowedValue))
            .setter(setter(Builder::allowedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValue").build()).build();

    private static final SdkField<String> MINIMUM_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MinimumEngineVersion").getter(getter(MinimumEngineVersionPerAllowedValue::minimumEngineVersion))
            .setter(setter(Builder::minimumEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumEngineVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_VALUE_FIELD,
            MINIMUM_ENGINE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String allowedValue;

    private final String minimumEngineVersion;

    private MinimumEngineVersionPerAllowedValue(BuilderImpl builder) {
        this.allowedValue = builder.allowedValue;
        this.minimumEngineVersion = builder.minimumEngineVersion;
    }

    /**
     * <p>
     * The allowed value for an option setting.
     * </p>
     * 
     * @return The allowed value for an option setting.
     */
    public final String allowedValue() {
        return allowedValue;
    }

    /**
     * <p>
     * The minimum DB engine version required for the allowed value.
     * </p>
     * 
     * @return The minimum DB engine version required for the allowed value.
     */
    public final String minimumEngineVersion() {
        return minimumEngineVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowedValue());
        hashCode = 31 * hashCode + Objects.hashCode(minimumEngineVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MinimumEngineVersionPerAllowedValue)) {
            return false;
        }
        MinimumEngineVersionPerAllowedValue other = (MinimumEngineVersionPerAllowedValue) obj;
        return Objects.equals(allowedValue(), other.allowedValue())
                && Objects.equals(minimumEngineVersion(), other.minimumEngineVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MinimumEngineVersionPerAllowedValue").add("AllowedValue", allowedValue())
                .add("MinimumEngineVersion", minimumEngineVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowedValue":
            return Optional.ofNullable(clazz.cast(allowedValue()));
        case "MinimumEngineVersion":
            return Optional.ofNullable(clazz.cast(minimumEngineVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllowedValue", ALLOWED_VALUE_FIELD);
        map.put("MinimumEngineVersion", MINIMUM_ENGINE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MinimumEngineVersionPerAllowedValue, T> g) {
        return obj -> g.apply((MinimumEngineVersionPerAllowedValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MinimumEngineVersionPerAllowedValue> {
        /**
         * <p>
         * The allowed value for an option setting.
         * </p>
         * 
         * @param allowedValue
         *        The allowed value for an option setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValue(String allowedValue);

        /**
         * <p>
         * The minimum DB engine version required for the allowed value.
         * </p>
         * 
         * @param minimumEngineVersion
         *        The minimum DB engine version required for the allowed value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumEngineVersion(String minimumEngineVersion);
    }

    static final class BuilderImpl implements Builder {
        private String allowedValue;

        private String minimumEngineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(MinimumEngineVersionPerAllowedValue model) {
            allowedValue(model.allowedValue);
            minimumEngineVersion(model.minimumEngineVersion);
        }

        public final String getAllowedValue() {
            return allowedValue;
        }

        public final void setAllowedValue(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        @Override
        public final Builder allowedValue(String allowedValue) {
            this.allowedValue = allowedValue;
            return this;
        }

        public final String getMinimumEngineVersion() {
            return minimumEngineVersion;
        }

        public final void setMinimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
        }

        @Override
        public final Builder minimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
            return this;
        }

        @Override
        public MinimumEngineVersionPerAllowedValue build() {
            return new MinimumEngineVersionPerAllowedValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
