/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used as a response element in the operation <code>DescribeDBMajorEngineVersions</code>.
 * </p>
 * <p>
 * You can use the information that this data type returns to plan for upgrades.
 * </p>
 * <p>
 * This data type only returns information for the open source engines Amazon RDS for MariaDB, Amazon RDS for MySQL,
 * Amazon RDS for PostgreSQL, Aurora MySQL, and Aurora PostgreSQL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SupportedEngineLifecycle implements SdkPojo, Serializable,
        ToCopyableBuilder<SupportedEngineLifecycle.Builder, SupportedEngineLifecycle> {
    private static final SdkField<String> LIFECYCLE_SUPPORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LifecycleSupportName").getter(getter(SupportedEngineLifecycle::lifecycleSupportNameAsString))
            .setter(setter(Builder::lifecycleSupportName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleSupportName").build())
            .build();

    private static final SdkField<Instant> LIFECYCLE_SUPPORT_START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("LifecycleSupportStartDate")
            .getter(getter(SupportedEngineLifecycle::lifecycleSupportStartDate))
            .setter(setter(Builder::lifecycleSupportStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleSupportStartDate").build())
            .build();

    private static final SdkField<Instant> LIFECYCLE_SUPPORT_END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LifecycleSupportEndDate").getter(getter(SupportedEngineLifecycle::lifecycleSupportEndDate))
            .setter(setter(Builder::lifecycleSupportEndDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleSupportEndDate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_SUPPORT_NAME_FIELD,
            LIFECYCLE_SUPPORT_START_DATE_FIELD, LIFECYCLE_SUPPORT_END_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lifecycleSupportName;

    private final Instant lifecycleSupportStartDate;

    private final Instant lifecycleSupportEndDate;

    private SupportedEngineLifecycle(BuilderImpl builder) {
        this.lifecycleSupportName = builder.lifecycleSupportName;
        this.lifecycleSupportStartDate = builder.lifecycleSupportStartDate;
        this.lifecycleSupportEndDate = builder.lifecycleSupportEndDate;
    }

    /**
     * <p>
     * The type of lifecycle support that the engine version is in.
     * </p>
     * <p>
     * This parameter returns the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>open-source-rds-standard-support</code> - Indicates RDS standard support or Aurora standard support.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>open-source-rds-extended-support</code> - Indicates Amazon RDS Extended Support.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For Amazon RDS for MySQL, Amazon RDS for PostgreSQL, Aurora MySQL, and Aurora PostgreSQL, this parameter returns
     * both <code>open-source-rds-standard-support</code> and <code>open-source-rds-extended-support</code>.
     * </p>
     * <p>
     * For Amazon RDS for MariaDB, this parameter only returns the value <code>open-source-rds-standard-support</code>.
     * </p>
     * <p>
     * For information about Amazon RDS Extended Support, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS Extended Support
     * with Amazon RDS</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Amazon RDS Extended
     * Support with Amazon Aurora</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lifecycleSupportName} will return {@link LifecycleSupportName#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lifecycleSupportNameAsString}.
     * </p>
     * 
     * @return The type of lifecycle support that the engine version is in.</p>
     *         <p>
     *         This parameter returns the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>open-source-rds-standard-support</code> - Indicates RDS standard support or Aurora standard
     *         support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>open-source-rds-extended-support</code> - Indicates Amazon RDS Extended Support.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For Amazon RDS for MySQL, Amazon RDS for PostgreSQL, Aurora MySQL, and Aurora PostgreSQL, this parameter
     *         returns both <code>open-source-rds-standard-support</code> and
     *         <code>open-source-rds-extended-support</code>.
     *         </p>
     *         <p>
     *         For Amazon RDS for MariaDB, this parameter only returns the value
     *         <code>open-source-rds-standard-support</code>.
     *         </p>
     *         <p>
     *         For information about Amazon RDS Extended Support, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS Extended
     *         Support with Amazon RDS</a> in the <i>Amazon RDS User Guide</i> and <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Amazon RDS
     *         Extended Support with Amazon Aurora</a> in the <i>Amazon Aurora User Guide</i>.
     * @see LifecycleSupportName
     */
    public final LifecycleSupportName lifecycleSupportName() {
        return LifecycleSupportName.fromValue(lifecycleSupportName);
    }

    /**
     * <p>
     * The type of lifecycle support that the engine version is in.
     * </p>
     * <p>
     * This parameter returns the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>open-source-rds-standard-support</code> - Indicates RDS standard support or Aurora standard support.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>open-source-rds-extended-support</code> - Indicates Amazon RDS Extended Support.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For Amazon RDS for MySQL, Amazon RDS for PostgreSQL, Aurora MySQL, and Aurora PostgreSQL, this parameter returns
     * both <code>open-source-rds-standard-support</code> and <code>open-source-rds-extended-support</code>.
     * </p>
     * <p>
     * For Amazon RDS for MariaDB, this parameter only returns the value <code>open-source-rds-standard-support</code>.
     * </p>
     * <p>
     * For information about Amazon RDS Extended Support, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS Extended Support
     * with Amazon RDS</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Amazon RDS Extended
     * Support with Amazon Aurora</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lifecycleSupportName} will return {@link LifecycleSupportName#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lifecycleSupportNameAsString}.
     * </p>
     * 
     * @return The type of lifecycle support that the engine version is in.</p>
     *         <p>
     *         This parameter returns the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>open-source-rds-standard-support</code> - Indicates RDS standard support or Aurora standard
     *         support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>open-source-rds-extended-support</code> - Indicates Amazon RDS Extended Support.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For Amazon RDS for MySQL, Amazon RDS for PostgreSQL, Aurora MySQL, and Aurora PostgreSQL, this parameter
     *         returns both <code>open-source-rds-standard-support</code> and
     *         <code>open-source-rds-extended-support</code>.
     *         </p>
     *         <p>
     *         For Amazon RDS for MariaDB, this parameter only returns the value
     *         <code>open-source-rds-standard-support</code>.
     *         </p>
     *         <p>
     *         For information about Amazon RDS Extended Support, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS Extended
     *         Support with Amazon RDS</a> in the <i>Amazon RDS User Guide</i> and <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Amazon RDS
     *         Extended Support with Amazon Aurora</a> in the <i>Amazon Aurora User Guide</i>.
     * @see LifecycleSupportName
     */
    public final String lifecycleSupportNameAsString() {
        return lifecycleSupportName;
    }

    /**
     * <p>
     * The start date for the type of support returned by <code>LifecycleSupportName</code>.
     * </p>
     * 
     * @return The start date for the type of support returned by <code>LifecycleSupportName</code>.
     */
    public final Instant lifecycleSupportStartDate() {
        return lifecycleSupportStartDate;
    }

    /**
     * <p>
     * The end date for the type of support returned by <code>LifecycleSupportName</code>.
     * </p>
     * 
     * @return The end date for the type of support returned by <code>LifecycleSupportName</code>.
     */
    public final Instant lifecycleSupportEndDate() {
        return lifecycleSupportEndDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleSupportNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleSupportStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleSupportEndDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedEngineLifecycle)) {
            return false;
        }
        SupportedEngineLifecycle other = (SupportedEngineLifecycle) obj;
        return Objects.equals(lifecycleSupportNameAsString(), other.lifecycleSupportNameAsString())
                && Objects.equals(lifecycleSupportStartDate(), other.lifecycleSupportStartDate())
                && Objects.equals(lifecycleSupportEndDate(), other.lifecycleSupportEndDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SupportedEngineLifecycle").add("LifecycleSupportName", lifecycleSupportNameAsString())
                .add("LifecycleSupportStartDate", lifecycleSupportStartDate())
                .add("LifecycleSupportEndDate", lifecycleSupportEndDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LifecycleSupportName":
            return Optional.ofNullable(clazz.cast(lifecycleSupportNameAsString()));
        case "LifecycleSupportStartDate":
            return Optional.ofNullable(clazz.cast(lifecycleSupportStartDate()));
        case "LifecycleSupportEndDate":
            return Optional.ofNullable(clazz.cast(lifecycleSupportEndDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LifecycleSupportName", LIFECYCLE_SUPPORT_NAME_FIELD);
        map.put("LifecycleSupportStartDate", LIFECYCLE_SUPPORT_START_DATE_FIELD);
        map.put("LifecycleSupportEndDate", LIFECYCLE_SUPPORT_END_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupportedEngineLifecycle, T> g) {
        return obj -> g.apply((SupportedEngineLifecycle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SupportedEngineLifecycle> {
        /**
         * <p>
         * The type of lifecycle support that the engine version is in.
         * </p>
         * <p>
         * This parameter returns the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open-source-rds-standard-support</code> - Indicates RDS standard support or Aurora standard support.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>open-source-rds-extended-support</code> - Indicates Amazon RDS Extended Support.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For Amazon RDS for MySQL, Amazon RDS for PostgreSQL, Aurora MySQL, and Aurora PostgreSQL, this parameter
         * returns both <code>open-source-rds-standard-support</code> and <code>open-source-rds-extended-support</code>.
         * </p>
         * <p>
         * For Amazon RDS for MariaDB, this parameter only returns the value
         * <code>open-source-rds-standard-support</code>.
         * </p>
         * <p>
         * For information about Amazon RDS Extended Support, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS Extended
         * Support with Amazon RDS</a> in the <i>Amazon RDS User Guide</i> and <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Amazon RDS Extended
         * Support with Amazon Aurora</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param lifecycleSupportName
         *        The type of lifecycle support that the engine version is in.</p>
         *        <p>
         *        This parameter returns the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>open-source-rds-standard-support</code> - Indicates RDS standard support or Aurora standard
         *        support.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>open-source-rds-extended-support</code> - Indicates Amazon RDS Extended Support.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For Amazon RDS for MySQL, Amazon RDS for PostgreSQL, Aurora MySQL, and Aurora PostgreSQL, this
         *        parameter returns both <code>open-source-rds-standard-support</code> and
         *        <code>open-source-rds-extended-support</code>.
         *        </p>
         *        <p>
         *        For Amazon RDS for MariaDB, this parameter only returns the value
         *        <code>open-source-rds-standard-support</code>.
         *        </p>
         *        <p>
         *        For information about Amazon RDS Extended Support, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS
         *        Extended Support with Amazon RDS</a> in the <i>Amazon RDS User Guide</i> and <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Amazon RDS
         *        Extended Support with Amazon Aurora</a> in the <i>Amazon Aurora User Guide</i>.
         * @see LifecycleSupportName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleSupportName
         */
        Builder lifecycleSupportName(String lifecycleSupportName);

        /**
         * <p>
         * The type of lifecycle support that the engine version is in.
         * </p>
         * <p>
         * This parameter returns the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open-source-rds-standard-support</code> - Indicates RDS standard support or Aurora standard support.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>open-source-rds-extended-support</code> - Indicates Amazon RDS Extended Support.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For Amazon RDS for MySQL, Amazon RDS for PostgreSQL, Aurora MySQL, and Aurora PostgreSQL, this parameter
         * returns both <code>open-source-rds-standard-support</code> and <code>open-source-rds-extended-support</code>.
         * </p>
         * <p>
         * For Amazon RDS for MariaDB, this parameter only returns the value
         * <code>open-source-rds-standard-support</code>.
         * </p>
         * <p>
         * For information about Amazon RDS Extended Support, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS Extended
         * Support with Amazon RDS</a> in the <i>Amazon RDS User Guide</i> and <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Amazon RDS Extended
         * Support with Amazon Aurora</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param lifecycleSupportName
         *        The type of lifecycle support that the engine version is in.</p>
         *        <p>
         *        This parameter returns the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>open-source-rds-standard-support</code> - Indicates RDS standard support or Aurora standard
         *        support.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>open-source-rds-extended-support</code> - Indicates Amazon RDS Extended Support.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For Amazon RDS for MySQL, Amazon RDS for PostgreSQL, Aurora MySQL, and Aurora PostgreSQL, this
         *        parameter returns both <code>open-source-rds-standard-support</code> and
         *        <code>open-source-rds-extended-support</code>.
         *        </p>
         *        <p>
         *        For Amazon RDS for MariaDB, this parameter only returns the value
         *        <code>open-source-rds-standard-support</code>.
         *        </p>
         *        <p>
         *        For information about Amazon RDS Extended Support, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS
         *        Extended Support with Amazon RDS</a> in the <i>Amazon RDS User Guide</i> and <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Amazon RDS
         *        Extended Support with Amazon Aurora</a> in the <i>Amazon Aurora User Guide</i>.
         * @see LifecycleSupportName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleSupportName
         */
        Builder lifecycleSupportName(LifecycleSupportName lifecycleSupportName);

        /**
         * <p>
         * The start date for the type of support returned by <code>LifecycleSupportName</code>.
         * </p>
         * 
         * @param lifecycleSupportStartDate
         *        The start date for the type of support returned by <code>LifecycleSupportName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleSupportStartDate(Instant lifecycleSupportStartDate);

        /**
         * <p>
         * The end date for the type of support returned by <code>LifecycleSupportName</code>.
         * </p>
         * 
         * @param lifecycleSupportEndDate
         *        The end date for the type of support returned by <code>LifecycleSupportName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleSupportEndDate(Instant lifecycleSupportEndDate);
    }

    static final class BuilderImpl implements Builder {
        private String lifecycleSupportName;

        private Instant lifecycleSupportStartDate;

        private Instant lifecycleSupportEndDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedEngineLifecycle model) {
            lifecycleSupportName(model.lifecycleSupportName);
            lifecycleSupportStartDate(model.lifecycleSupportStartDate);
            lifecycleSupportEndDate(model.lifecycleSupportEndDate);
        }

        public final String getLifecycleSupportName() {
            return lifecycleSupportName;
        }

        public final void setLifecycleSupportName(String lifecycleSupportName) {
            this.lifecycleSupportName = lifecycleSupportName;
        }

        @Override
        public final Builder lifecycleSupportName(String lifecycleSupportName) {
            this.lifecycleSupportName = lifecycleSupportName;
            return this;
        }

        @Override
        public final Builder lifecycleSupportName(LifecycleSupportName lifecycleSupportName) {
            this.lifecycleSupportName(lifecycleSupportName == null ? null : lifecycleSupportName.toString());
            return this;
        }

        public final Instant getLifecycleSupportStartDate() {
            return lifecycleSupportStartDate;
        }

        public final void setLifecycleSupportStartDate(Instant lifecycleSupportStartDate) {
            this.lifecycleSupportStartDate = lifecycleSupportStartDate;
        }

        @Override
        public final Builder lifecycleSupportStartDate(Instant lifecycleSupportStartDate) {
            this.lifecycleSupportStartDate = lifecycleSupportStartDate;
            return this;
        }

        public final Instant getLifecycleSupportEndDate() {
            return lifecycleSupportEndDate;
        }

        public final void setLifecycleSupportEndDate(Instant lifecycleSupportEndDate) {
            this.lifecycleSupportEndDate = lifecycleSupportEndDate;
        }

        @Override
        public final Builder lifecycleSupportEndDate(Instant lifecycleSupportEndDate) {
            this.lifecycleSupportEndDate = lifecycleSupportEndDate;
            return this;
        }

        @Override
        public SupportedEngineLifecycle build() {
            return new SupportedEngineLifecycle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
