/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DownloadDbLogFilePortionResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DownloadDbLogFilePortionResponse> {
    private static final SdkField<String> LOG_FILE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogFileData").getter(DownloadDbLogFilePortionResponse.getter(DownloadDbLogFilePortionResponse::logFileData)).setter(DownloadDbLogFilePortionResponse.setter(Builder::logFileData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFileData").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DownloadDbLogFilePortionResponse.getter(DownloadDbLogFilePortionResponse::marker)).setter(DownloadDbLogFilePortionResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Boolean> ADDITIONAL_DATA_PENDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AdditionalDataPending").getter(DownloadDbLogFilePortionResponse.getter(DownloadDbLogFilePortionResponse::additionalDataPending)).setter(DownloadDbLogFilePortionResponse.setter(Builder::additionalDataPending)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDataPending").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_FILE_DATA_FIELD, MARKER_FIELD, ADDITIONAL_DATA_PENDING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DownloadDbLogFilePortionResponse.memberNameToFieldInitializer();
    private final String logFileData;
    private final String marker;
    private final Boolean additionalDataPending;

    private DownloadDbLogFilePortionResponse(BuilderImpl builder) {
        super(builder);
        this.logFileData = builder.logFileData;
        this.marker = builder.marker;
        this.additionalDataPending = builder.additionalDataPending;
    }

    public final String logFileData() {
        return this.logFileData;
    }

    public final String marker() {
        return this.marker;
    }

    public final Boolean additionalDataPending() {
        return this.additionalDataPending;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.logFileData());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalDataPending());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DownloadDbLogFilePortionResponse)) {
            return false;
        }
        DownloadDbLogFilePortionResponse other = (DownloadDbLogFilePortionResponse)((Object)obj);
        return Objects.equals(this.logFileData(), other.logFileData()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.additionalDataPending(), other.additionalDataPending());
    }

    public final String toString() {
        return ToString.builder((String)"DownloadDbLogFilePortionResponse").add("LogFileData", (Object)this.logFileData()).add("Marker", (Object)this.marker()).add("AdditionalDataPending", (Object)this.additionalDataPending()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogFileData": {
                return Optional.ofNullable(clazz.cast(this.logFileData()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "AdditionalDataPending": {
                return Optional.ofNullable(clazz.cast(this.additionalDataPending()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LogFileData", LOG_FILE_DATA_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("AdditionalDataPending", ADDITIONAL_DATA_PENDING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DownloadDbLogFilePortionResponse, T> g) {
        return obj -> g.apply((DownloadDbLogFilePortionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String logFileData;
        private String marker;
        private Boolean additionalDataPending;

        private BuilderImpl() {
        }

        private BuilderImpl(DownloadDbLogFilePortionResponse model) {
            super(model);
            this.logFileData(model.logFileData);
            this.marker(model.marker);
            this.additionalDataPending(model.additionalDataPending);
        }

        public final String getLogFileData() {
            return this.logFileData;
        }

        public final void setLogFileData(String logFileData) {
            this.logFileData = logFileData;
        }

        @Override
        public final Builder logFileData(String logFileData) {
            this.logFileData = logFileData;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Boolean getAdditionalDataPending() {
            return this.additionalDataPending;
        }

        public final void setAdditionalDataPending(Boolean additionalDataPending) {
            this.additionalDataPending = additionalDataPending;
        }

        @Override
        public final Builder additionalDataPending(Boolean additionalDataPending) {
            this.additionalDataPending = additionalDataPending;
            return this;
        }

        @Override
        public DownloadDbLogFilePortionResponse build() {
            return new DownloadDbLogFilePortionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DownloadDbLogFilePortionResponse> {
        public Builder logFileData(String var1);

        public Builder marker(String var1);

        public Builder additionalDataPending(Boolean var1);
    }
}

