/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDbInstanceRequest extends RdsRequest implements
        ToCopyableBuilder<CreateDbInstanceRequest.Builder, CreateDbInstanceRequest> {
    private static final SdkField<String> DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DBName")
            .getter(getter(CreateDbInstanceRequest::dbName)).setter(setter(Builder::dbName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBName").build()).build();

    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(CreateDbInstanceRequest::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(CreateDbInstanceRequest::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(CreateDbInstanceRequest::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(CreateDbInstanceRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(CreateDbInstanceRequest::masterUsername))
            .setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserPassword").getter(getter(CreateDbInstanceRequest::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final SdkField<List<String>> DB_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DBSecurityGroups")
            .getter(getter(CreateDbInstanceRequest::dbSecurityGroups))
            .setter(setter(Builder::dbSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBSecurityGroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBSecurityGroupName").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(CreateDbInstanceRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(CreateDbInstanceRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSubnetGroupName").getter(getter(CreateDbInstanceRequest::dbSubnetGroupName))
            .setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(CreateDbInstanceRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<String> DB_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBParameterGroupName").getter(getter(CreateDbInstanceRequest::dbParameterGroupName))
            .setter(setter(Builder::dbParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupName").build())
            .build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(CreateDbInstanceRequest::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredBackupWindow").getter(getter(CreateDbInstanceRequest::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(CreateDbInstanceRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(CreateDbInstanceRequest::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(CreateDbInstanceRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(CreateDbInstanceRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseModel").getter(getter(CreateDbInstanceRequest::licenseModel))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(CreateDbInstanceRequest::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(CreateDbInstanceRequest::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CharacterSetName").getter(getter(CreateDbInstanceRequest::characterSetName))
            .setter(setter(Builder::characterSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()).build();

    private static final SdkField<String> NCHAR_CHARACTER_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NcharCharacterSetName").getter(getter(CreateDbInstanceRequest::ncharCharacterSetName))
            .setter(setter(Builder::ncharCharacterSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NcharCharacterSetName").build())
            .build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(CreateDbInstanceRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDbInstanceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(CreateDbInstanceRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(CreateDbInstanceRequest::storageType)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TdeCredentialArn").getter(getter(CreateDbInstanceRequest::tdeCredentialArn))
            .setter(setter(Builder::tdeCredentialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()).build();

    private static final SdkField<String> TDE_CREDENTIAL_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TdeCredentialPassword").getter(getter(CreateDbInstanceRequest::tdeCredentialPassword))
            .setter(setter(Builder::tdeCredentialPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialPassword").build())
            .build();

    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEncrypted").getter(getter(CreateDbInstanceRequest::storageEncrypted))
            .setter(setter(Builder::storageEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateDbInstanceRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(CreateDbInstanceRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> DOMAIN_FQDN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainFqdn").getter(getter(CreateDbInstanceRequest::domainFqdn)).setter(setter(Builder::domainFqdn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainFqdn").build()).build();

    private static final SdkField<String> DOMAIN_OU_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainOu").getter(getter(CreateDbInstanceRequest::domainOu)).setter(setter(Builder::domainOu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainOu").build()).build();

    private static final SdkField<String> DOMAIN_AUTH_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainAuthSecretArn").getter(getter(CreateDbInstanceRequest::domainAuthSecretArn))
            .setter(setter(Builder::domainAuthSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainAuthSecretArn").build())
            .build();

    private static final SdkField<List<String>> DOMAIN_DNS_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DomainDnsIps")
            .getter(getter(CreateDbInstanceRequest::domainDnsIps))
            .setter(setter(Builder::domainDnsIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainDnsIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToSnapshot").getter(getter(CreateDbInstanceRequest::copyTagsToSnapshot))
            .setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MonitoringInterval").getter(getter(CreateDbInstanceRequest::monitoringInterval))
            .setter(setter(Builder::monitoringInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build())
            .build();

    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringRoleArn").getter(getter(CreateDbInstanceRequest::monitoringRoleArn))
            .setter(setter(Builder::monitoringRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()).build();

    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainIAMRoleName").getter(getter(CreateDbInstanceRequest::domainIAMRoleName))
            .setter(setter(Builder::domainIAMRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()).build();

    private static final SdkField<Integer> PROMOTION_TIER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PromotionTier").getter(getter(CreateDbInstanceRequest::promotionTier))
            .setter(setter(Builder::promotionTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromotionTier").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(CreateDbInstanceRequest::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIAMDatabaseAuthentication")
            .getter(getter(CreateDbInstanceRequest::enableIAMDatabaseAuthentication))
            .setter(setter(Builder::enableIAMDatabaseAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication")
                    .build()).build();

    private static final SdkField<String> DATABASE_INSIGHTS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseInsightsMode").getter(getter(CreateDbInstanceRequest::databaseInsightsModeAsString))
            .setter(setter(Builder::databaseInsightsMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInsightsMode").build())
            .build();

    private static final SdkField<Boolean> ENABLE_PERFORMANCE_INSIGHTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnablePerformanceInsights")
            .getter(getter(CreateDbInstanceRequest::enablePerformanceInsights))
            .setter(setter(Builder::enablePerformanceInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePerformanceInsights").build())
            .build();

    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PerformanceInsightsKMSKeyId")
            .getter(getter(CreateDbInstanceRequest::performanceInsightsKMSKeyId))
            .setter(setter(Builder::performanceInsightsKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId")
                    .build()).build();

    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PerformanceInsightsRetentionPeriod")
            .getter(getter(CreateDbInstanceRequest::performanceInsightsRetentionPeriod))
            .setter(setter(Builder::performanceInsightsRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod")
                    .build()).build();

    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnableCloudwatchLogsExports")
            .getter(getter(CreateDbInstanceRequest::enableCloudwatchLogsExports))
            .setter(setter(Builder::enableCloudwatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProcessorFeature>> PROCESSOR_FEATURES_FIELD = SdkField
            .<List<ProcessorFeature>> builder(MarshallingType.LIST)
            .memberName("ProcessorFeatures")
            .getter(getter(CreateDbInstanceRequest::processorFeatures))
            .setter(setter(Builder::processorFeatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ProcessorFeature")
                            .memberFieldInfo(
                                    SdkField.<ProcessorFeature> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProcessorFeature::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ProcessorFeature").build()).build()).build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(CreateDbInstanceRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<Integer> MAX_ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAllocatedStorage").getter(getter(CreateDbInstanceRequest::maxAllocatedStorage))
            .setter(setter(Builder::maxAllocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllocatedStorage").build())
            .build();

    private static final SdkField<Boolean> ENABLE_CUSTOMER_OWNED_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableCustomerOwnedIp").getter(getter(CreateDbInstanceRequest::enableCustomerOwnedIp))
            .setter(setter(Builder::enableCustomerOwnedIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCustomerOwnedIp").build())
            .build();

    private static final SdkField<String> CUSTOM_IAM_INSTANCE_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomIamInstanceProfile").getter(getter(CreateDbInstanceRequest::customIamInstanceProfile))
            .setter(setter(Builder::customIamInstanceProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomIamInstanceProfile").build())
            .build();

    private static final SdkField<String> BACKUP_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupTarget").getter(getter(CreateDbInstanceRequest::backupTarget))
            .setter(setter(Builder::backupTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupTarget").build()).build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkType").getter(getter(CreateDbInstanceRequest::networkType)).setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()).build();

    private static final SdkField<Integer> STORAGE_THROUGHPUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StorageThroughput").getter(getter(CreateDbInstanceRequest::storageThroughput))
            .setter(setter(Builder::storageThroughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageThroughput").build()).build();

    private static final SdkField<Boolean> MANAGE_MASTER_USER_PASSWORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("ManageMasterUserPassword")
            .getter(getter(CreateDbInstanceRequest::manageMasterUserPassword)).setter(setter(Builder::manageMasterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManageMasterUserPassword").build())
            .build();

    private static final SdkField<String> MASTER_USER_SECRET_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserSecretKmsKeyId").getter(getter(CreateDbInstanceRequest::masterUserSecretKmsKeyId))
            .setter(setter(Builder::masterUserSecretKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserSecretKmsKeyId").build())
            .build();

    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CACertificateIdentifier").getter(getter(CreateDbInstanceRequest::caCertificateIdentifier))
            .setter(setter(Builder::caCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build())
            .build();

    private static final SdkField<String> DB_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSystemId").getter(getter(CreateDbInstanceRequest::dbSystemId)).setter(setter(Builder::dbSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSystemId").build()).build();

    private static final SdkField<Boolean> DEDICATED_LOG_VOLUME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DedicatedLogVolume").getter(getter(CreateDbInstanceRequest::dedicatedLogVolume))
            .setter(setter(Builder::dedicatedLogVolume))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedLogVolume").build())
            .build();

    private static final SdkField<Boolean> MULTI_TENANT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiTenant").getter(getter(CreateDbInstanceRequest::multiTenant)).setter(setter(Builder::multiTenant))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiTenant").build()).build();

    private static final SdkField<String> ENGINE_LIFECYCLE_SUPPORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineLifecycleSupport").getter(getter(CreateDbInstanceRequest::engineLifecycleSupport))
            .setter(setter(Builder::engineLifecycleSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineLifecycleSupport").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_NAME_FIELD,
            DB_INSTANCE_IDENTIFIER_FIELD, ALLOCATED_STORAGE_FIELD, DB_INSTANCE_CLASS_FIELD, ENGINE_FIELD, MASTER_USERNAME_FIELD,
            MASTER_USER_PASSWORD_FIELD, DB_SECURITY_GROUPS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, AVAILABILITY_ZONE_FIELD,
            DB_SUBNET_GROUP_NAME_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, DB_PARAMETER_GROUP_NAME_FIELD,
            BACKUP_RETENTION_PERIOD_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PORT_FIELD, MULTI_AZ_FIELD, ENGINE_VERSION_FIELD,
            AUTO_MINOR_VERSION_UPGRADE_FIELD, LICENSE_MODEL_FIELD, IOPS_FIELD, OPTION_GROUP_NAME_FIELD, CHARACTER_SET_NAME_FIELD,
            NCHAR_CHARACTER_SET_NAME_FIELD, PUBLICLY_ACCESSIBLE_FIELD, TAGS_FIELD, DB_CLUSTER_IDENTIFIER_FIELD,
            STORAGE_TYPE_FIELD, TDE_CREDENTIAL_ARN_FIELD, TDE_CREDENTIAL_PASSWORD_FIELD, STORAGE_ENCRYPTED_FIELD,
            KMS_KEY_ID_FIELD, DOMAIN_FIELD, DOMAIN_FQDN_FIELD, DOMAIN_OU_FIELD, DOMAIN_AUTH_SECRET_ARN_FIELD,
            DOMAIN_DNS_IPS_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, MONITORING_INTERVAL_FIELD, MONITORING_ROLE_ARN_FIELD,
            DOMAIN_IAM_ROLE_NAME_FIELD, PROMOTION_TIER_FIELD, TIMEZONE_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD,
            DATABASE_INSIGHTS_MODE_FIELD, ENABLE_PERFORMANCE_INSIGHTS_FIELD, PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD,
            PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD, ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, PROCESSOR_FEATURES_FIELD,
            DELETION_PROTECTION_FIELD, MAX_ALLOCATED_STORAGE_FIELD, ENABLE_CUSTOMER_OWNED_IP_FIELD,
            CUSTOM_IAM_INSTANCE_PROFILE_FIELD, BACKUP_TARGET_FIELD, NETWORK_TYPE_FIELD, STORAGE_THROUGHPUT_FIELD,
            MANAGE_MASTER_USER_PASSWORD_FIELD, MASTER_USER_SECRET_KMS_KEY_ID_FIELD, CA_CERTIFICATE_IDENTIFIER_FIELD,
            DB_SYSTEM_ID_FIELD, DEDICATED_LOG_VOLUME_FIELD, MULTI_TENANT_FIELD, ENGINE_LIFECYCLE_SUPPORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbName;

    private final String dbInstanceIdentifier;

    private final Integer allocatedStorage;

    private final String dbInstanceClass;

    private final String engine;

    private final String masterUsername;

    private final String masterUserPassword;

    private final List<String> dbSecurityGroups;

    private final List<String> vpcSecurityGroupIds;

    private final String availabilityZone;

    private final String dbSubnetGroupName;

    private final String preferredMaintenanceWindow;

    private final String dbParameterGroupName;

    private final Integer backupRetentionPeriod;

    private final String preferredBackupWindow;

    private final Integer port;

    private final Boolean multiAZ;

    private final String engineVersion;

    private final Boolean autoMinorVersionUpgrade;

    private final String licenseModel;

    private final Integer iops;

    private final String optionGroupName;

    private final String characterSetName;

    private final String ncharCharacterSetName;

    private final Boolean publiclyAccessible;

    private final List<Tag> tags;

    private final String dbClusterIdentifier;

    private final String storageType;

    private final String tdeCredentialArn;

    private final String tdeCredentialPassword;

    private final Boolean storageEncrypted;

    private final String kmsKeyId;

    private final String domain;

    private final String domainFqdn;

    private final String domainOu;

    private final String domainAuthSecretArn;

    private final List<String> domainDnsIps;

    private final Boolean copyTagsToSnapshot;

    private final Integer monitoringInterval;

    private final String monitoringRoleArn;

    private final String domainIAMRoleName;

    private final Integer promotionTier;

    private final String timezone;

    private final Boolean enableIAMDatabaseAuthentication;

    private final String databaseInsightsMode;

    private final Boolean enablePerformanceInsights;

    private final String performanceInsightsKMSKeyId;

    private final Integer performanceInsightsRetentionPeriod;

    private final List<String> enableCloudwatchLogsExports;

    private final List<ProcessorFeature> processorFeatures;

    private final Boolean deletionProtection;

    private final Integer maxAllocatedStorage;

    private final Boolean enableCustomerOwnedIp;

    private final String customIamInstanceProfile;

    private final String backupTarget;

    private final String networkType;

    private final Integer storageThroughput;

    private final Boolean manageMasterUserPassword;

    private final String masterUserSecretKmsKeyId;

    private final String caCertificateIdentifier;

    private final String dbSystemId;

    private final Boolean dedicatedLogVolume;

    private final Boolean multiTenant;

    private final String engineLifecycleSupport;

    private CreateDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.dbName = builder.dbName;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.allocatedStorage = builder.allocatedStorage;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.engine = builder.engine;
        this.masterUsername = builder.masterUsername;
        this.masterUserPassword = builder.masterUserPassword;
        this.dbSecurityGroups = builder.dbSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.availabilityZone = builder.availabilityZone;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.port = builder.port;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.characterSetName = builder.characterSetName;
        this.ncharCharacterSetName = builder.ncharCharacterSetName;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.tags = builder.tags;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.storageType = builder.storageType;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.tdeCredentialPassword = builder.tdeCredentialPassword;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.domain = builder.domain;
        this.domainFqdn = builder.domainFqdn;
        this.domainOu = builder.domainOu;
        this.domainAuthSecretArn = builder.domainAuthSecretArn;
        this.domainDnsIps = builder.domainDnsIps;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.promotionTier = builder.promotionTier;
        this.timezone = builder.timezone;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.databaseInsightsMode = builder.databaseInsightsMode;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.processorFeatures = builder.processorFeatures;
        this.deletionProtection = builder.deletionProtection;
        this.maxAllocatedStorage = builder.maxAllocatedStorage;
        this.enableCustomerOwnedIp = builder.enableCustomerOwnedIp;
        this.customIamInstanceProfile = builder.customIamInstanceProfile;
        this.backupTarget = builder.backupTarget;
        this.networkType = builder.networkType;
        this.storageThroughput = builder.storageThroughput;
        this.manageMasterUserPassword = builder.manageMasterUserPassword;
        this.masterUserSecretKmsKeyId = builder.masterUserSecretKmsKeyId;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.dbSystemId = builder.dbSystemId;
        this.dedicatedLogVolume = builder.dedicatedLogVolume;
        this.multiTenant = builder.multiTenant;
        this.engineLifecycleSupport = builder.engineLifecycleSupport;
    }

    /**
     * <p>
     * The meaning of this parameter differs according to the database engine you use.
     * </p>
     * <dl>
     * <dt>Amazon Aurora MySQL</dt>
     * <dd>
     * <p>
     * The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is created. If
     * this parameter isn't specified for an Aurora MySQL DB cluster, no database is created in the DB cluster.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain 1 to 64 alphanumeric characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a word reserved by the database engine.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Amazon Aurora PostgreSQL</dt>
     * <dd>
     * <p>
     * The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is created. A
     * database named <code>postgres</code> is always created. If this parameter is specified, an additional database
     * with this name is created.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It must contain 1 to 63 alphanumeric characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0 to 9).
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a word reserved by the database engine.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Amazon RDS Custom for Oracle</dt>
     * <dd>
     * <p>
     * The Oracle System ID (SID) of the created RDS Custom DB instance. If you don't specify a value, the default value
     * is <code>ORCL</code> for non-CDBs and <code>RDSCDB</code> for CDBs.
     * </p>
     * <p>
     * Default: <code>ORCL</code>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain 1 to 8 alphanumeric characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must contain a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a word reserved by the database engine.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>Amazon RDS Custom for SQL Server</dt>
     * <dd>
     * <p>
     * Not applicable. Must be null.
     * </p>
     * </dd>
     * <dt>RDS for Db2</dt>
     * <dd>
     * <p>
     * The name of the database to create when the DB instance is created. If this parameter isn't specified, no
     * database is created in the DB instance. In some cases, we recommend that you don't add a database name. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-db-instance-prereqs.html#db2-prereqs-additional-considerations"
     * >Additional considerations</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain 1 to 64 letters or numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a word reserved by the specified database engine.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>RDS for MariaDB</dt>
     * <dd>
     * <p>
     * The name of the database to create when the DB instance is created. If this parameter isn't specified, no
     * database is created in the DB instance.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain 1 to 64 letters or numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a word reserved by the specified database engine.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>RDS for MySQL</dt>
     * <dd>
     * <p>
     * The name of the database to create when the DB instance is created. If this parameter isn't specified, no
     * database is created in the DB instance.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain 1 to 64 letters or numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a word reserved by the specified database engine.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>RDS for Oracle</dt>
     * <dd>
     * <p>
     * The Oracle System ID (SID) of the created DB instance. If you don't specify a value, the default value is
     * <code>ORCL</code>. You can't specify the string <code>null</code>, or any other reserved word, for
     * <code>DBName</code>.
     * </p>
     * <p>
     * Default: <code>ORCL</code>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't be longer than 8 characters.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>RDS for PostgreSQL</dt>
     * <dd>
     * <p>
     * The name of the database to create when the DB instance is created. A database named <code>postgres</code> is
     * always created. If this parameter is specified, an additional database with this name is created.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain 1 to 63 letters, numbers, or underscores.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a word reserved by the specified database engine.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>RDS for SQL Server</dt>
     * <dd>
     * <p>
     * Not applicable. Must be null.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return The meaning of this parameter differs according to the database engine you use.</p>
     *         <dl>
     *         <dt>Amazon Aurora MySQL</dt>
     *         <dd>
     *         <p>
     *         The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is
     *         created. If this parameter isn't specified for an Aurora MySQL DB cluster, no database is created in the
     *         DB cluster.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain 1 to 64 alphanumeric characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a word reserved by the database engine.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Amazon Aurora PostgreSQL</dt>
     *         <dd>
     *         <p>
     *         The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is
     *         created. A database named <code>postgres</code> is always created. If this parameter is specified, an
     *         additional database with this name is created.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         It must contain 1 to 63 alphanumeric characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0 to 9).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a word reserved by the database engine.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Amazon RDS Custom for Oracle</dt>
     *         <dd>
     *         <p>
     *         The Oracle System ID (SID) of the created RDS Custom DB instance. If you don't specify a value, the
     *         default value is <code>ORCL</code> for non-CDBs and <code>RDSCDB</code> for CDBs.
     *         </p>
     *         <p>
     *         Default: <code>ORCL</code>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain 1 to 8 alphanumeric characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must contain a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a word reserved by the database engine.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Amazon RDS Custom for SQL Server</dt>
     *         <dd>
     *         <p>
     *         Not applicable. Must be null.
     *         </p>
     *         </dd>
     *         <dt>RDS for Db2</dt>
     *         <dd>
     *         <p>
     *         The name of the database to create when the DB instance is created. If this parameter isn't specified, no
     *         database is created in the DB instance. In some cases, we recommend that you don't add a database name.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-db-instance-prereqs.html#db2-prereqs-additional-considerations"
     *         >Additional considerations</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain 1 to 64 letters or numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a word reserved by the specified database engine.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>RDS for MariaDB</dt>
     *         <dd>
     *         <p>
     *         The name of the database to create when the DB instance is created. If this parameter isn't specified, no
     *         database is created in the DB instance.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain 1 to 64 letters or numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a word reserved by the specified database engine.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>RDS for MySQL</dt>
     *         <dd>
     *         <p>
     *         The name of the database to create when the DB instance is created. If this parameter isn't specified, no
     *         database is created in the DB instance.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain 1 to 64 letters or numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a word reserved by the specified database engine.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>RDS for Oracle</dt>
     *         <dd>
     *         <p>
     *         The Oracle System ID (SID) of the created DB instance. If you don't specify a value, the default value is
     *         <code>ORCL</code>. You can't specify the string <code>null</code>, or any other reserved word, for
     *         <code>DBName</code>.
     *         </p>
     *         <p>
     *         Default: <code>ORCL</code>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't be longer than 8 characters.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>RDS for PostgreSQL</dt>
     *         <dd>
     *         <p>
     *         The name of the database to create when the DB instance is created. A database named
     *         <code>postgres</code> is always created. If this parameter is specified, an additional database with this
     *         name is created.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain 1 to 63 letters, numbers, or underscores.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a word reserved by the specified database engine.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>RDS for SQL Server</dt>
     *         <dd>
     *         <p>
     *         Not applicable. Must be null.
     *         </p>
     *         </dd>
     */
    public final String dbName() {
        return dbName;
    }

    /**
     * <p>
     * The identifier for this DB instance. This parameter is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>mydbinstance</code>
     * </p>
     * 
     * @return The identifier for this DB instance. This parameter is stored as a lowercase string.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>mydbinstance</code>
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * The amount of storage in gibibytes (GiB) to allocate for the DB instance.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. Aurora cluster volumes automatically grow as the amount
     * of data in your database increases, though you are only charged for the space that you use in an Aurora cluster
     * volume.
     * </p>
     * <dl>
     * <dt>Amazon RDS Custom</dt>
     * <dd>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * General Purpose (SSD) storage (gp2, gp3): Must be an integer from 40 to 65536 for RDS Custom for Oracle, 16384
     * for RDS Custom for SQL Server.
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned IOPS storage (io1, io2): Must be an integer from 40 to 65536 for RDS Custom for Oracle, 16384 for RDS
     * Custom for SQL Server.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>RDS for Db2</dt>
     * <dd>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * General Purpose (SSD) storage (gp3): Must be an integer from 20 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>RDS for MariaDB</dt>
     * <dd>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Magnetic storage (standard): Must be an integer from 5 to 3072.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>RDS for MySQL</dt>
     * <dd>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Magnetic storage (standard): Must be an integer from 5 to 3072.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>RDS for Oracle</dt>
     * <dd>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Magnetic storage (standard): Must be an integer from 10 to 3072.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>RDS for PostgreSQL</dt>
     * <dd>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
     * </p>
     * </li>
     * <li>
     * <p>
     * Magnetic storage (standard): Must be an integer from 5 to 3072.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>RDS for SQL Server</dt>
     * <dd>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * General Purpose (SSD) storage (gp2, gp3):
     * </p>
     * <ul>
     * <li>
     * <p>
     * Enterprise and Standard editions: Must be an integer from 20 to 16384.
     * </p>
     * </li>
     * <li>
     * <p>
     * Web and Express editions: Must be an integer from 20 to 16384.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Provisioned IOPS storage (io1, io2):
     * </p>
     * <ul>
     * <li>
     * <p>
     * Enterprise and Standard editions: Must be an integer from 100 to 16384.
     * </p>
     * </li>
     * <li>
     * <p>
     * Web and Express editions: Must be an integer from 100 to 16384.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Magnetic storage (standard):
     * </p>
     * <ul>
     * <li>
     * <p>
     * Enterprise and Standard editions: Must be an integer from 20 to 1024.
     * </p>
     * </li>
     * <li>
     * <p>
     * Web and Express editions: Must be an integer from 20 to 1024.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * 
     * @return The amount of storage in gibibytes (GiB) to allocate for the DB instance.</p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora DB instances. Aurora cluster volumes automatically grow as
     *         the amount of data in your database increases, though you are only charged for the space that you use in
     *         an Aurora cluster volume.
     *         </p>
     *         <dl>
     *         <dt>Amazon RDS Custom</dt>
     *         <dd>
     *         <p>
     *         Constraints to the amount of storage for each storage type are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General Purpose (SSD) storage (gp2, gp3): Must be an integer from 40 to 65536 for RDS Custom for Oracle,
     *         16384 for RDS Custom for SQL Server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned IOPS storage (io1, io2): Must be an integer from 40 to 65536 for RDS Custom for Oracle, 16384
     *         for RDS Custom for SQL Server.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>RDS for Db2</dt>
     *         <dd>
     *         <p>
     *         Constraints to the amount of storage for each storage type are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General Purpose (SSD) storage (gp3): Must be an integer from 20 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>RDS for MariaDB</dt>
     *         <dd>
     *         <p>
     *         Constraints to the amount of storage for each storage type are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Magnetic storage (standard): Must be an integer from 5 to 3072.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>RDS for MySQL</dt>
     *         <dd>
     *         <p>
     *         Constraints to the amount of storage for each storage type are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Magnetic storage (standard): Must be an integer from 5 to 3072.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>RDS for Oracle</dt>
     *         <dd>
     *         <p>
     *         Constraints to the amount of storage for each storage type are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Magnetic storage (standard): Must be an integer from 10 to 3072.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>RDS for PostgreSQL</dt>
     *         <dd>
     *         <p>
     *         Constraints to the amount of storage for each storage type are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Magnetic storage (standard): Must be an integer from 5 to 3072.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>RDS for SQL Server</dt>
     *         <dd>
     *         <p>
     *         Constraints to the amount of storage for each storage type are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General Purpose (SSD) storage (gp2, gp3):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Enterprise and Standard editions: Must be an integer from 20 to 16384.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Web and Express editions: Must be an integer from 20 to 16384.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned IOPS storage (io1, io2):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Enterprise and Standard editions: Must be an integer from 100 to 16384.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Web and Express editions: Must be an integer from 100 to 16384.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Magnetic storage (standard):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Enterprise and Standard editions: Must be an integer from 20 to 1024.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Web and Express editions: Must be an integer from 20 to 1024.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * The compute and memory capacity of the DB instance, for example <code>db.m5.large</code>. Not all DB instance
     * classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB
     * instance classes, and availability for your engine, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance
     * classes</a> in the <i>Amazon RDS User Guide</i> or <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html">Aurora DB
     * instance classes</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * 
     * @return The compute and memory capacity of the DB instance, for example <code>db.m5.large</code>. Not all DB
     *         instance classes are available in all Amazon Web Services Regions, or for all database engines. For the
     *         full list of DB instance classes, and availability for your engine, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance
     *         classes</a> in the <i>Amazon RDS User Guide</i> or <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html">Aurora
     *         DB instance classes</a> in the <i>Amazon Aurora User Guide</i>.
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * The database engine to use for this DB instance.
     * </p>
     * <p>
     * Not every database engine is available in every Amazon Web Services Region.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aurora-mysql</code> (for Aurora MySQL DB instances)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aurora-postgresql</code> (for Aurora PostgreSQL DB instances)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-oracle-ee</code> (for RDS Custom for Oracle DB instances)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-oracle-ee-cdb</code> (for RDS Custom for Oracle DB instances)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-oracle-se2</code> (for RDS Custom for Oracle DB instances)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-oracle-se2-cdb</code> (for RDS Custom for Oracle DB instances)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-sqlserver-ee</code> (for RDS Custom for SQL Server DB instances)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-sqlserver-se</code> (for RDS Custom for SQL Server DB instances)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-sqlserver-web</code> (for RDS Custom for SQL Server DB instances)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-sqlserver-dev</code> (for RDS Custom for SQL Server DB instances)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db2-ae</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db2-se</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mariadb</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mysql</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-ee</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-ee-cdb</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-se2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-se2-cdb</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>postgres</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-ee</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-se</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-ex</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-web</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The database engine to use for this DB instance.</p>
     *         <p>
     *         Not every database engine is available in every Amazon Web Services Region.
     *         </p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>aurora-mysql</code> (for Aurora MySQL DB instances)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>aurora-postgresql</code> (for Aurora PostgreSQL DB instances)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-oracle-ee</code> (for RDS Custom for Oracle DB instances)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-oracle-ee-cdb</code> (for RDS Custom for Oracle DB instances)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-oracle-se2</code> (for RDS Custom for Oracle DB instances)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-oracle-se2-cdb</code> (for RDS Custom for Oracle DB instances)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-sqlserver-ee</code> (for RDS Custom for SQL Server DB instances)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-sqlserver-se</code> (for RDS Custom for SQL Server DB instances)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-sqlserver-web</code> (for RDS Custom for SQL Server DB instances)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-sqlserver-dev</code> (for RDS Custom for SQL Server DB instances)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db2-ae</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db2-se</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mariadb</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mysql</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-ee</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-ee-cdb</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-se2</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-se2-cdb</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>postgres</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-ee</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-se</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-ex</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-web</code>
     *         </p>
     *         </li>
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The name for the master user.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. The name for the master user is managed by the DB
     * cluster.
     * </p>
     * <p>
     * This setting is required for RDS DB instances.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 1 to 16 letters, numbers, or underscores.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a reserved word for the chosen database engine.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name for the master user.</p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora DB instances. The name for the master user is managed by the
     *         DB cluster.
     *         </p>
     *         <p>
     *         This setting is required for RDS DB instances.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 1 to 16 letters, numbers, or underscores.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a reserved word for the chosen database engine.
     *         </p>
     *         </li>
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The password for the master user.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. The password for the master user is managed by the DB
     * cluster.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't be specified if <code>ManageMasterUserPassword</code> is turned on.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can include any printable ASCII character except "/",
     * """, or "@". For RDS for Oracle, can't include the "&amp;" (ampersand) or the "'" (single quotes) character.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Length Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * RDS for Db2 - Must contain from 8 to 255 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for MariaDB - Must contain from 8 to 41 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for Microsoft SQL Server - Must contain from 8 to 128 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for MySQL - Must contain from 8 to 41 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for Oracle - Must contain from 8 to 30 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for PostgreSQL - Must contain from 8 to 128 characters.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The password for the master user.</p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora DB instances. The password for the master user is managed by
     *         the DB cluster.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't be specified if <code>ManageMasterUserPassword</code> is turned on.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can include any printable ASCII character except "/",
     *         """, or "@". For RDS for Oracle, can't include the "&amp;" (ampersand) or the "'" (single quotes)
     *         character.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Length Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         RDS for Db2 - Must contain from 8 to 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for MariaDB - Must contain from 8 to 41 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for Microsoft SQL Server - Must contain from 8 to 128 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for MySQL - Must contain from 8 to 41 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for Oracle - Must contain from 8 to 30 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for PostgreSQL - Must contain from 8 to 128 characters.
     *         </p>
     *         </li>
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * For responses, this returns true if the service returned a value for the DBSecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDbSecurityGroups() {
        return dbSecurityGroups != null && !(dbSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DB security groups to associate with this DB instance.
     * </p>
     * <p>
     * This setting applies to the legacy EC2-Classic platform, which is no longer used to create new DB instances. Use
     * the <code>VpcSecurityGroupIds</code> setting instead.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbSecurityGroups} method.
     * </p>
     * 
     * @return A list of DB security groups to associate with this DB instance.</p>
     *         <p>
     *         This setting applies to the legacy EC2-Classic platform, which is no longer used to create new DB
     *         instances. Use the <code>VpcSecurityGroupIds</code> setting instead.
     */
    public final List<String> dbSecurityGroups() {
        return dbSecurityGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon EC2 VPC security groups to associate with this DB instance.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. The associated list of EC2 VPC security groups is
     * managed by the DB cluster.
     * </p>
     * <p>
     * Default: The default EC2 VPC security group for the DB subnet group's VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of Amazon EC2 VPC security groups to associate with this DB instance.</p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora DB instances. The associated list of EC2 VPC security groups
     *         is managed by the DB cluster.
     *         </p>
     *         <p>
     *         Default: The default EC2 VPC security group for the DB subnet group's VPC.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The Availability Zone (AZ) where the database will be created. For information on Amazon Web Services Regions and
     * Availability Zones, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions
     * and Availability Zones</a>.
     * </p>
     * <p>
     * For Amazon Aurora, each Aurora DB cluster hosts copies of its storage in three separate Availability Zones.
     * Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you
     * don't specify one.
     * </p>
     * <p>
     * Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment.
     * </p>
     * </li>
     * <li>
     * <p>
     * The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>us-east-1d</code>
     * </p>
     * 
     * @return The Availability Zone (AZ) where the database will be created. For information on Amazon Web Services
     *         Regions and Availability Zones, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html"
     *         >Regions and Availability Zones</a>.</p>
     *         <p>
     *         For Amazon Aurora, each Aurora DB cluster hosts copies of its storage in three separate Availability
     *         Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability
     *         Zone if you don't specify one.
     *         </p>
     *         <p>
     *         Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ
     *         deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>us-east-1d</code>
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * A DB subnet group to associate with this DB instance.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the name of an existing DB subnet group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>mydbsubnetgroup</code>
     * </p>
     * 
     * @return A DB subnet group to associate with this DB instance.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the name of an existing DB subnet group.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>mydbsubnetgroup</code>
     */
    public final String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * <p>
     * The time range each week during which system maintenance can occur. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance"
     * >Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services
     * Region, occurring on a random day of the week.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The day values must be <code>mon | tue | wed | thu | fri | sat | sun</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be in Universal Coordinated Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred backup window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The time range each week during which system maintenance can occur. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance"
     *         >Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
     *         Services Region, occurring on a random day of the week.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The day values must be <code>mon | tue | wed | thu | fri | sat | sun</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be in Universal Coordinated Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not conflict with the preferred backup window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The name of the DB parameter group to associate with this DB instance. If you don't specify a value, then Amazon
     * RDS uses the default DB parameter group for the specified DB engine and version.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 1 to 255 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the DB parameter group to associate with this DB instance. If you don't specify a value, then
     *         Amazon RDS uses the default DB parameter group for the specified DB engine and version.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 1 to 255 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */
    public final String dbParameterGroupName() {
        return dbParameterGroupName;
    }

    /**
     * <p>
     * The number of days for which automated backups are retained. Setting this parameter to a positive number enables
     * backups. Setting this parameter to <code>0</code> disables automated backups.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. The retention period for automated backups is managed
     * by the DB cluster.
     * </p>
     * <p>
     * Default: <code>1</code>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be a value from 0 to 35.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be set to 0 if the DB instance is a source to read replicas.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be set to 0 for an RDS Custom for Oracle DB instance.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of days for which automated backups are retained. Setting this parameter to a positive number
     *         enables backups. Setting this parameter to <code>0</code> disables automated backups.</p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora DB instances. The retention period for automated backups is
     *         managed by the DB cluster.
     *         </p>
     *         <p>
     *         Default: <code>1</code>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be a value from 0 to 35.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be set to 0 if the DB instance is a source to read replicas.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be set to 0 for an RDS Custom for Oracle DB instance.
     *         </p>
     *         </li>
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created if automated backups are enabled, using the
     * <code>BackupRetentionPeriod</code> parameter. The default is a 30-minute window selected at random from an 8-hour
     * block of time for each Amazon Web Services Region. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
     * >Backup window</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. The daily time range for creating automated backups is
     * managed by the DB cluster.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the format <code>hh24:mi-hh24:mi</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be in Universal Coordinated Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The daily time range during which automated backups are created if automated backups are enabled, using
     *         the <code>BackupRetentionPeriod</code> parameter. The default is a 30-minute window selected at random
     *         from an 8-hour block of time for each Amazon Web Services Region. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
     *         >Backup window</a> in the <i>Amazon RDS User Guide</i>.</p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora DB instances. The daily time range for creating automated
     *         backups is managed by the DB cluster.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the format <code>hh24:mi-hh24:mi</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be in Universal Coordinated Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not conflict with the preferred maintenance window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The port number on which the database accepts connections.
     * </p>
     * <p>
     * This setting doesn't apply to Aurora DB instances. The port number is managed by the cluster.
     * </p>
     * <p>
     * Valid Values: <code>1150-65535</code>
     * </p>
     * <p>
     * Default:
     * </p>
     * <ul>
     * <li>
     * <p>
     * RDS for Db2 - <code>50000</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for MariaDB - <code>3306</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for Microsoft SQL Server - <code>1433</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for MySQL - <code>3306</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for Oracle - <code>1521</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for PostgreSQL - <code>5432</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For RDS for Microsoft SQL Server, the value can't be <code>1234</code>, <code>1434</code>, <code>3260</code>,
     * <code>3343</code>, <code>3389</code>, <code>47001</code>, or <code>49152-49156</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The port number on which the database accepts connections.</p>
     *         <p>
     *         This setting doesn't apply to Aurora DB instances. The port number is managed by the cluster.
     *         </p>
     *         <p>
     *         Valid Values: <code>1150-65535</code>
     *         </p>
     *         <p>
     *         Default:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         RDS for Db2 - <code>50000</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for MariaDB - <code>3306</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for Microsoft SQL Server - <code>1433</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for MySQL - <code>3306</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for Oracle - <code>1521</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for PostgreSQL - <code>5432</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For RDS for Microsoft SQL Server, the value can't be <code>1234</code>, <code>1434</code>,
     *         <code>3260</code>, <code>3343</code>, <code>3389</code>, <code>47001</code>, or <code>49152-49156</code>.
     *         </p>
     *         </li>
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * Specifies whether the DB instance is a Multi-AZ deployment. You can't set the <code>AvailabilityZone</code>
     * parameter if the DB instance is a Multi-AZ deployment.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora because the DB instance Availability Zones (AZs) are managed by the
     * DB cluster.
     * </p>
     * 
     * @return Specifies whether the DB instance is a Multi-AZ deployment. You can't set the
     *         <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora because the DB instance Availability Zones (AZs) are managed
     *         by the DB cluster.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * The version number of the database engine to use.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. The version number of the database engine the DB
     * instance uses is managed by the DB cluster.
     * </p>
     * <p>
     * For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> operation.
     * </p>
     * <p>
     * The following are the database engines and links to information about the major and minor versions that are
     * available with Amazon RDS. Not every database engine is available for every Amazon Web Services Region.
     * </p>
     * <dl>
     * <dt>Amazon RDS Custom for Oracle</dt>
     * <dd>
     * <p>
     * A custom engine version (CEV) that you have previously created. This setting is required for RDS Custom for
     * Oracle. The CEV name has the following format: 19.<i>customized_string</i>. A valid CEV name is
     * <code>19.my_cev1</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-creating.html#custom-creating.create">
     * Creating an RDS Custom for Oracle DB instance</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </dd>
     * <dt>Amazon RDS Custom for SQL Server</dt>
     * <dd>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits-MS.html">RDS Custom for
     * SQL Server general requirements</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </dd>
     * <dt>RDS for Db2</dt>
     * <dd>
     * <p>
     * For information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Db2.html#Db2.Concepts.VersionMgmt">Db2 on
     * Amazon RDS versions</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </dd>
     * <dt>RDS for MariaDB</dt>
     * <dd>
     * <p>
     * For information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt"
     * >MariaDB on Amazon RDS versions</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </dd>
     * <dt>RDS for Microsoft SQL Server</dt>
     * <dd>
     * <p>
     * For information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport"
     * >Microsoft SQL Server versions on Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </dd>
     * <dt>RDS for MySQL</dt>
     * <dd>
     * <p>
     * For information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on
     * Amazon RDS versions</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </dd>
     * <dt>RDS for Oracle</dt>
     * <dd>
     * <p>
     * For information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle
     * Database Engine release notes</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </dd>
     * <dt>RDS for PostgreSQL</dt>
     * <dd>
     * <p>
     * For information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS
     * for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return The version number of the database engine to use.</p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora DB instances. The version number of the database engine the
     *         DB instance uses is managed by the DB cluster.
     *         </p>
     *         <p>
     *         For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> operation.
     *         </p>
     *         <p>
     *         The following are the database engines and links to information about the major and minor versions that
     *         are available with Amazon RDS. Not every database engine is available for every Amazon Web Services
     *         Region.
     *         </p>
     *         <dl>
     *         <dt>Amazon RDS Custom for Oracle</dt>
     *         <dd>
     *         <p>
     *         A custom engine version (CEV) that you have previously created. This setting is required for RDS Custom
     *         for Oracle. The CEV name has the following format: 19.<i>customized_string</i>. A valid CEV name is
     *         <code>19.my_cev1</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-creating.html#custom-creating.create"
     *         > Creating an RDS Custom for Oracle DB instance</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         </dd>
     *         <dt>Amazon RDS Custom for SQL Server</dt>
     *         <dd>
     *         <p>
     *         See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits-MS.html">RDS
     *         Custom for SQL Server general requirements</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         </dd>
     *         <dt>RDS for Db2</dt>
     *         <dd>
     *         <p>
     *         For information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Db2.html#Db2.Concepts.VersionMgmt">Db2
     *         on Amazon RDS versions</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         </dd>
     *         <dt>RDS for MariaDB</dt>
     *         <dd>
     *         <p>
     *         For information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt"
     *         >MariaDB on Amazon RDS versions</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         </dd>
     *         <dt>RDS for Microsoft SQL Server</dt>
     *         <dd>
     *         <p>
     *         For information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport"
     *         >Microsoft SQL Server versions on Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         </dd>
     *         <dt>RDS for MySQL</dt>
     *         <dd>
     *         <p>
     *         For information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL
     *         on Amazon RDS versions</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         </dd>
     *         <dt>RDS for Oracle</dt>
     *         <dd>
     *         <p>
     *         For information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html"
     *         >Oracle Database Engine release notes</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         </dd>
     *         <dt>RDS for PostgreSQL</dt>
     *         <dd>
     *         <p>
     *         For information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts"
     *         >Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         </dd>
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Specifies whether minor engine upgrades are applied automatically to the DB instance during the maintenance
     * window. By default, minor engine upgrades are applied automatically.
     * </p>
     * <p>
     * If you create an RDS Custom DB instance, you must set <code>AutoMinorVersionUpgrade</code> to <code>false</code>.
     * </p>
     * <p>
     * For more information about automatic minor version upgrades, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades"
     * >Automatically upgrading the minor engine version</a>.
     * </p>
     * 
     * @return Specifies whether minor engine upgrades are applied automatically to the DB instance during the
     *         maintenance window. By default, minor engine upgrades are applied automatically.</p>
     *         <p>
     *         If you create an RDS Custom DB instance, you must set <code>AutoMinorVersionUpgrade</code> to
     *         <code>false</code>.
     *         </p>
     *         <p>
     *         For more information about automatic minor version upgrades, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades"
     *         >Automatically upgrading the minor engine version</a>.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The license model information for this DB instance.
     * </p>
     * <note>
     * <p>
     * License models for RDS for Db2 require additional configuration. The bring your own license (BYOL) model requires
     * a custom parameter group and an Amazon Web Services License Manager self-managed license. The Db2 license through
     * Amazon Web Services Marketplace model requires an Amazon Web Services Marketplace subscription. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html">Amazon RDS
     * for Db2 licensing options</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * The default for RDS for Db2 is <code>bring-your-own-license</code>.
     * </p>
     * </note>
     * <p>
     * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * RDS for Db2 - <code>bring-your-own-license | marketplace-license</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for MariaDB - <code>general-public-license</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for Microsoft SQL Server - <code>license-included</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for MySQL - <code>general-public-license</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for Oracle - <code>bring-your-own-license | license-included</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for PostgreSQL - <code>postgresql-license</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The license model information for this DB instance.</p> <note>
     *         <p>
     *         License models for RDS for Db2 require additional configuration. The bring your own license (BYOL) model
     *         requires a custom parameter group and an Amazon Web Services License Manager self-managed license. The
     *         Db2 license through Amazon Web Services Marketplace model requires an Amazon Web Services Marketplace
     *         subscription. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html">Amazon RDS for Db2
     *         licensing options</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         The default for RDS for Db2 is <code>bring-your-own-license</code>.
     *         </p>
     *         </note>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
     *         </p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         RDS for Db2 - <code>bring-your-own-license | marketplace-license</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for MariaDB - <code>general-public-license</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for Microsoft SQL Server - <code>license-included</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for MySQL - <code>general-public-license</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for Oracle - <code>bring-your-own-license | license-included</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for PostgreSQL - <code>postgresql-license</code>
     *         </p>
     *         </li>
     */
    public final String licenseModel() {
        return licenseModel;
    }

    /**
     * <p>
     * The amount of Provisioned IOPS (input/output operations per second) to initially allocate for the DB instance.
     * For information about valid IOPS values, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html">Amazon RDS DB instance
     * storage</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For RDS for Db2, MariaDB, MySQL, Oracle, and PostgreSQL - Must be a multiple between .5 and 50 of the storage
     * amount for the DB instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * For RDS for SQL Server - Must be a multiple between 1 and 50 of the storage amount for the DB instance.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The amount of Provisioned IOPS (input/output operations per second) to initially allocate for the DB
     *         instance. For information about valid IOPS values, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html">Amazon RDS DB instance
     *         storage</a> in the <i>Amazon RDS User Guide</i>.</p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For RDS for Db2, MariaDB, MySQL, Oracle, and PostgreSQL - Must be a multiple between .5 and 50 of the
     *         storage amount for the DB instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For RDS for SQL Server - Must be a multiple between 1 and 50 of the storage amount for the DB instance.
     *         </p>
     *         </li>
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The option group to associate the DB instance with.
     * </p>
     * <p>
     * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option
     * group. Also, that option group can't be removed from a DB instance after it is associated with a DB instance.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
     * </p>
     * 
     * @return The option group to associate the DB instance with.</p>
     *         <p>
     *         Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an
     *         option group. Also, that option group can't be removed from a DB instance after it is associated with a
     *         DB instance.
     *         </p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * <p>
     * For supported engines, the character set (<code>CharacterSet</code>) to associate the DB instance with.
     * </p>
     * <p>
     * This setting doesn't apply to the following DB instances:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Aurora - The character set is managed by the DB cluster. For more information, see
     * <code>CreateDBCluster</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS Custom - However, if you need to change the character set, you can change it on the database itself.
     * </p>
     * </li>
     * </ul>
     * 
     * @return For supported engines, the character set (<code>CharacterSet</code>) to associate the DB instance
     *         with.</p>
     *         <p>
     *         This setting doesn't apply to the following DB instances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Amazon Aurora - The character set is managed by the DB cluster. For more information, see
     *         <code>CreateDBCluster</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS Custom - However, if you need to change the character set, you can change it on the database itself.
     *         </p>
     *         </li>
     */
    public final String characterSetName() {
        return characterSetName;
    }

    /**
     * <p>
     * The name of the NCHAR character set for the Oracle DB instance.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * 
     * @return The name of the NCHAR character set for the Oracle DB instance.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final String ncharCharacterSetName() {
        return ncharCharacterSetName;
    }

    /**
     * <p>
     * Specifies whether the DB instance is publicly accessible.
     * </p>
     * <p>
     * When the DB instance is publicly accessible and you connect from outside of the DB instance's virtual private
     * cloud (VPC), its Domain Name System (DNS) endpoint resolves to the public IP address. When you connect from
     * within the same VPC as the DB instance, the endpoint resolves to the private IP address. Access to the DB
     * instance is ultimately controlled by the security group it uses. That public access is not permitted if the
     * security group assigned to the DB instance doesn't permit it.
     * </p>
     * <p>
     * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a
     * private IP address.
     * </p>
     * <p>
     * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     * </p>
     * <p>
     * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the
     * following applies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB instance is
     * private.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the default VPC in the target Region has an internet gateway attached to it, the DB instance is public.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
     * following applies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB instance is
     * private.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the subnets are part of a VPC that has an internet gateway attached to it, the DB instance is public.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether the DB instance is publicly accessible.</p>
     *         <p>
     *         When the DB instance is publicly accessible and you connect from outside of the DB instance's virtual
     *         private cloud (VPC), its Domain Name System (DNS) endpoint resolves to the public IP address. When you
     *         connect from within the same VPC as the DB instance, the endpoint resolves to the private IP address.
     *         Access to the DB instance is ultimately controlled by the security group it uses. That public access is
     *         not permitted if the security group assigned to the DB instance doesn't permit it.
     *         </p>
     *         <p>
     *         When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that
     *         resolves to a private IP address.
     *         </p>
     *         <p>
     *         Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     *         </p>
     *         <p>
     *         If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified,
     *         the following applies:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB instance
     *         is private.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the default VPC in the target Region has an internet gateway attached to it, the DB instance is
     *         public.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
     *         following applies:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB instance is
     *         private.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the subnets are part of a VPC that has an internet gateway attached to it, the DB instance is public.
     *         </p>
     *         </li>
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to assign to the DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to assign to the DB instance.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The identifier of the DB cluster that this DB instance will belong to.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * 
     * @return The identifier of the DB cluster that this DB instance will belong to.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The storage type to associate with the DB instance.
     * </p>
     * <p>
     * If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value for the
     * <code>Iops</code> parameter.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.
     * </p>
     * <p>
     * Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code>
     * </p>
     * <p>
     * Default: <code>io1</code>, if the <code>Iops</code> parameter is specified. Otherwise, <code>gp3</code>.
     * </p>
     * 
     * @return The storage type to associate with the DB instance.</p>
     *         <p>
     *         If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value for
     *         the <code>Iops</code> parameter.
     *         </p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.
     *         </p>
     *         <p>
     *         Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code>
     *         </p>
     *         <p>
     *         Default: <code>io1</code>, if the <code>Iops</code> parameter is specified. Otherwise, <code>gp3</code>.
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * The ARN from the key store with which to associate the instance for TDE encryption.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
     * </p>
     * 
     * @return The ARN from the key store with which to associate the instance for TDE encryption.</p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
     */
    public final String tdeCredentialArn() {
        return tdeCredentialArn;
    }

    /**
     * <p>
     * The password for the given ARN from the key store in order to access the device.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * 
     * @return The password for the given ARN from the key store in order to access the device.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final String tdeCredentialPassword() {
        return tdeCredentialPassword;
    }

    /**
     * <p>
     * Specifes whether the DB instance is encrypted. By default, it isn't encrypted.
     * </p>
     * <p>
     * For RDS Custom DB instances, either enable this setting or leave it unset. Otherwise, Amazon RDS reports an
     * error.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. The encryption for DB instances is managed by the DB
     * cluster.
     * </p>
     * 
     * @return Specifes whether the DB instance is encrypted. By default, it isn't encrypted.</p>
     *         <p>
     *         For RDS Custom DB instances, either enable this setting or leave it unset. Otherwise, Amazon RDS reports
     *         an error.
     *         </p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora DB instances. The encryption for DB instances is managed by
     *         the DB cluster.
     */
    public final Boolean storageEncrypted() {
        return storageEncrypted;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier for an encrypted DB instance.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To
     * use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. The Amazon Web Services KMS key identifier is managed
     * by the DB cluster. For more information, see <code>CreateDBCluster</code>.
     * </p>
     * <p>
     * If <code>StorageEncrypted</code> is enabled, and you do not specify a value for the <code>KmsKeyId</code>
     * parameter, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services
     * account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
     * </p>
     * <p>
     * For Amazon RDS Custom, a KMS key is required for DB instances. For most RDS engines, if you leave this parameter
     * empty while enabling <code>StorageEncrypted</code>, the engine uses the default KMS key. However, RDS Custom
     * doesn't use the default key when this parameter is empty. You must explicitly specify a key.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier for an encrypted DB instance.</p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *         </p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora DB instances. The Amazon Web Services KMS key identifier is
     *         managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.
     *         </p>
     *         <p>
     *         If <code>StorageEncrypted</code> is enabled, and you do not specify a value for the <code>KmsKeyId</code>
     *         parameter, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web
     *         Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web
     *         Services Region.
     *         </p>
     *         <p>
     *         For Amazon RDS Custom, a KMS key is required for DB instances. For most RDS engines, if you leave this
     *         parameter empty while enabling <code>StorageEncrypted</code>, the engine uses the default KMS key.
     *         However, RDS Custom doesn't use the default key when this parameter is empty. You must explicitly specify
     *         a key.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The Active Directory directory ID to create the DB instance in. Currently, you can create only Db2, MySQL,
     * Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
     * Authentication</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to the following DB instances:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Aurora (The domain is managed by the DB cluster.)
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS Custom
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Active Directory directory ID to create the DB instance in. Currently, you can create only Db2,
     *         MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
     *         Authentication</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         This setting doesn't apply to the following DB instances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Amazon Aurora (The domain is managed by the DB cluster.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS Custom
     *         </p>
     *         </li>
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The fully qualified domain name (FQDN) of an Active Directory domain.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't be longer than 64 characters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>mymanagedADtest.mymanagedAD.mydomain</code>
     * </p>
     * 
     * @return The fully qualified domain name (FQDN) of an Active Directory domain.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't be longer than 64 characters.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>mymanagedADtest.mymanagedAD.mydomain</code>
     */
    public final String domainFqdn() {
        return domainFqdn;
    }

    /**
     * <p>
     * The Active Directory organizational unit for your DB instance to join.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the distinguished name format.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be longer than 64 characters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain</code>
     * </p>
     * 
     * @return The Active Directory organizational unit for your DB instance to join.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the distinguished name format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be longer than 64 characters.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain</code>
     */
    public final String domainOu() {
        return domainOu;
    }

    /**
     * <p>
     * The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
     * </p>
     * <p>
     * Example: <code>arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456</code>
     * </p>
     * 
     * @return The ARN for the Secrets Manager secret with the credentials for the user joining the domain.</p>
     *         <p>
     *         Example:
     *         <code>arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456</code>
     */
    public final String domainAuthSecretArn() {
        return domainAuthSecretArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainDnsIps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDomainDnsIps() {
        return domainDnsIps != null && !(domainDnsIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the
     * primary domain controller for both entries in the list.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>123.124.125.126,234.235.236.237</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainDnsIps} method.
     * </p>
     * 
     * @return The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of
     *         the primary domain controller for both entries in the list.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>123.124.125.126,234.235.236.237</code>
     */
    public final List<String> domainDnsIps() {
        return domainDnsIps;
    }

    /**
     * <p>
     * Specifies whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not
     * copied.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster.
     * Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
     * </p>
     * 
     * @return Specifies whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are
     *         not copied.</p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB
     *         cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
     */
    public final Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    /**
     * <p>
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To
     * disable collection of Enhanced Monitoring metrics, specify <code>0</code>.
     * </p>
     * <p>
     * If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a value
     * other than <code>0</code>.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * <p>
     * Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
     * </p>
     * <p>
     * Default: <code>0</code>
     * </p>
     * 
     * @return The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
     *         instance. To disable collection of Enhanced Monitoring metrics, specify <code>0</code>.</p>
     *         <p>
     *         If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a
     *         value other than <code>0</code>.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     *         </p>
     *         <p>
     *         Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
     *         </p>
     *         <p>
     *         Default: <code>0</code>
     */
    public final Integer monitoringInterval() {
        return monitoringInterval;
    }

    /**
     * <p>
     * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
     * example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see
     * <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling"
     * >Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, then you must supply a
     * <code>MonitoringRoleArn</code> value.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * 
     * @return The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs.
     *         For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a
     *         monitoring role, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling"
     *         >Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
     *         <p>
     *         If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, then you must supply a
     *         <code>MonitoringRoleArn</code> value.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final String monitoringRoleArn() {
        return monitoringRoleArn;
    }

    /**
     * <p>
     * The name of the IAM role to use when making API calls to the Directory Service.
     * </p>
     * <p>
     * This setting doesn't apply to the following DB instances:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Aurora (The domain is managed by the DB cluster.)
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS Custom
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the IAM role to use when making API calls to the Directory Service.</p>
     *         <p>
     *         This setting doesn't apply to the following DB instances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Amazon Aurora (The domain is managed by the DB cluster.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS Custom
     *         </p>
     *         </li>
     */
    public final String domainIAMRoleName() {
        return domainIAMRoleName;
    }

    /**
     * <p>
     * The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the
     * existing primary instance. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance"
     * > Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * <p>
     * Default: <code>1</code>
     * </p>
     * <p>
     * Valid Values: <code>0 - 15</code>
     * </p>
     * 
     * @return The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of
     *         the existing primary instance. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance"
     *         > Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     *         </p>
     *         <p>
     *         Default: <code>1</code>
     *         </p>
     *         <p>
     *         Valid Values: <code>0 - 15</code>
     */
    public final Integer promotionTier() {
        return promotionTier;
    }

    /**
     * <p>
     * The time zone of the DB instance. The time zone parameter is currently supported only by <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-time-zone">RDS for Db2</a> and <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone"
     * >RDS for SQL Server</a>.
     * </p>
     * 
     * @return The time zone of the DB instance. The time zone parameter is currently supported only by <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-time-zone">RDS for Db2</a> and <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone"
     *         >RDS for SQL Server</a>.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to
     * database accounts. By default, mapping isn't enabled.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
     * Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to the following DB instances:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Aurora (Mapping Amazon Web Services IAM accounts to database accounts is managed by the DB cluster.)
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS Custom
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts
     *         to database accounts. By default, mapping isn't enabled.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
     *         Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         This setting doesn't apply to the following DB instances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Amazon Aurora (Mapping Amazon Web Services IAM accounts to database accounts is managed by the DB
     *         cluster.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS Custom
     *         </p>
     *         </li>
     */
    public final Boolean enableIAMDatabaseAuthentication() {
        return enableIAMDatabaseAuthentication;
    }

    /**
     * <p>
     * The mode of Database Insights to enable for the DB instance.
     * </p>
     * <note>
     * <p>
     * Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #databaseInsightsMode} will return {@link DatabaseInsightsMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #databaseInsightsModeAsString}.
     * </p>
     * 
     * @return The mode of Database Insights to enable for the DB instance.</p> <note>
     *         <p>
     *         Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
     *         </p>
     * @see DatabaseInsightsMode
     */
    public final DatabaseInsightsMode databaseInsightsMode() {
        return DatabaseInsightsMode.fromValue(databaseInsightsMode);
    }

    /**
     * <p>
     * The mode of Database Insights to enable for the DB instance.
     * </p>
     * <note>
     * <p>
     * Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #databaseInsightsMode} will return {@link DatabaseInsightsMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #databaseInsightsModeAsString}.
     * </p>
     * 
     * @return The mode of Database Insights to enable for the DB instance.</p> <note>
     *         <p>
     *         Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
     *         </p>
     * @see DatabaseInsightsMode
     */
    public final String databaseInsightsModeAsString() {
        return databaseInsightsMode;
    }

    /**
     * <p>
     * Specifies whether to enable Performance Insights for the DB instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance
     * Insights</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * 
     * @return Specifies whether to enable Performance Insights for the DB instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon
     *         Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final Boolean enablePerformanceInsights() {
        return enablePerformanceInsights;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * </p>
     * <p>
     * If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS
     * key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
     * different default KMS key for each Amazon Web Services Region.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key.
     *         </p>
     *         <p>
     *         If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your
     *         default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
     *         Services account has a different default KMS key for each Amazon Web Services Region.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     */
    public final String performanceInsightsKMSKeyId() {
        return performanceInsightsKMSKeyId;
    }

    /**
     * <p>
     * The number of days to retain Performance Insights data.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31),
     * <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>731</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>7</code> days
     * </p>
     * <p>
     * If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS returns an error.
     * </p>
     * 
     * @return The number of days to retain Performance Insights data.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     *         </p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3
     *         months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>731</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>7</code> days
     *         </p>
     *         <p>
     *         If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS returns an error.
     */
    public final Integer performanceInsightsRetentionPeriod() {
        return performanceInsightsRetentionPeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnableCloudwatchLogsExports property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports != null && !(enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of log types to enable for exporting to CloudWatch Logs. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     * > Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to the following DB instances:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Aurora (CloudWatch Logs exports are managed by the DB cluster.)
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS Custom
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following values are valid for each DB engine:
     * </p>
     * <ul>
     * <li>
     * <p>
     * RDS for Db2 - <code>diag.log | notify.log | iam-db-auth-error</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for MariaDB - <code>audit | error | general | slowquery | iam-db-auth-error</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for Microsoft SQL Server - <code>agent | error</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for MySQL - <code>audit | error | general | slowquery | iam-db-auth-error</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for Oracle - <code>alert | audit | listener | trace | oemagent</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for PostgreSQL - <code>postgresql | upgrade | iam-db-auth-error</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnableCloudwatchLogsExports} method.
     * </p>
     * 
     * @return The list of log types to enable for exporting to CloudWatch Logs. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     *         > Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>
     *         <p>
     *         This setting doesn't apply to the following DB instances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Amazon Aurora (CloudWatch Logs exports are managed by the DB cluster.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS Custom
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following values are valid for each DB engine:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         RDS for Db2 - <code>diag.log | notify.log | iam-db-auth-error</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for MariaDB - <code>audit | error | general | slowquery | iam-db-auth-error</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for Microsoft SQL Server - <code>agent | error</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for MySQL - <code>audit | error | general | slowquery | iam-db-auth-error</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for Oracle - <code>alert | audit | listener | trace | oemagent</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for PostgreSQL - <code>postgresql | upgrade | iam-db-auth-error</code>
     *         </p>
     *         </li>
     */
    public final List<String> enableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProcessorFeatures property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProcessorFeatures() {
        return processorFeatures != null && !(processorFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessorFeatures} method.
     * </p>
     * 
     * @return The number of CPU cores and the number of threads per core for the DB instance class of the DB
     *         instance.</p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
     */
    public final List<ProcessorFeature> processorFeatures() {
        return processorFeatures;
    }

    /**
     * <p>
     * Specifies whether the DB instance has deletion protection enabled. The database can't be deleted when deletion
     * protection is enabled. By default, deletion protection isn't enabled. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
     * Instance</a>.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora DB instances. You can enable or disable deletion protection for the
     * DB cluster. For more information, see <code>CreateDBCluster</code>. DB instances in a DB cluster can be deleted
     * even when deletion protection is enabled for the DB cluster.
     * </p>
     * 
     * @return Specifies whether the DB instance has deletion protection enabled. The database can't be deleted when
     *         deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see
     *         <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
     *         Instance</a>.</p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora DB instances. You can enable or disable deletion protection
     *         for the DB cluster. For more information, see <code>CreateDBCluster</code>. DB instances in a DB cluster
     *         can be deleted even when deletion protection is enabled for the DB cluster.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
     * </p>
     * <p>
     * For more information about this setting, including limitations that apply to it, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
     * Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This setting doesn't apply to the following DB instances:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Aurora (Storage is managed by the DB cluster.)
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS Custom
     * </p>
     * </li>
     * </ul>
     * 
     * @return The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB
     *         instance.</p>
     *         <p>
     *         For more information about this setting, including limitations that apply to it, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"
     *         > Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User
     *         Guide</i>.
     *         </p>
     *         <p>
     *         This setting doesn't apply to the following DB instances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Amazon Aurora (Storage is managed by the DB cluster.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS Custom
     *         </p>
     *         </li>
     */
    public final Integer maxAllocatedStorage() {
        return maxAllocatedStorage;
    }

    /**
     * <p>
     * Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.
     * </p>
     * <p>
     * A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your
     * on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from
     * outside of its virtual private cloud (VPC) on your local network.
     * </p>
     * <p>
     * For more information about RDS on Outposts, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on
     * Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about CoIPs, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing">Customer-owned IP
     * addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.
     * </p>
     * 
     * @return Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.</p>
     *         <p>
     *         A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your
     *         on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB
     *         instance from outside of its virtual private cloud (VPC) on your local network.
     *         </p>
     *         <p>
     *         For more information about RDS on Outposts, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon
     *         RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         For more information about CoIPs, see <a
     *         href="https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing">Customer-owned IP
     *         addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.
     */
    public final Boolean enableCustomerOwnedIp() {
        return enableCustomerOwnedIp;
    }

    /**
     * <p>
     * The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
     * </p>
     * <p>
     * This setting is required for RDS Custom.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The profile must exist in your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * The profile must have an IAM role that Amazon EC2 has permissions to assume.
     * </p>
     * </li>
     * <li>
     * <p>
     * The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For the list of permissions required for the IAM role, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc">
     * Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * 
     * @return The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.</p>
     *         <p>
     *         This setting is required for RDS Custom.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The profile must exist in your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The profile must have an IAM role that Amazon EC2 has permissions to assume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The instance profile name and the associated IAM role name must start with the prefix
     *         <code>AWSRDSCustom</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For the list of permissions required for the IAM role, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"
     *         > Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.
     */
    public final String customIamInstanceProfile() {
        return customIamInstanceProfile;
    }

    /**
     * <p>
     * The location for storing automated backups and manual snapshots.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>local</code> (Dedicated Local Zone)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>outposts</code> (Amazon Web Services Outposts)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>region</code> (Amazon Web Services Region)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>region</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on
     * Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * 
     * @return The location for storing automated backups and manual snapshots.</p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>local</code> (Dedicated Local Zone)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>outposts</code> (Amazon Web Services Outposts)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>region</code> (Amazon Web Services Region)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>region</code>
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon
     *         RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.
     */
    public final String backupTarget() {
        return backupTarget;
    }

    /**
     * <p>
     * The network type of the DB instance.
     * </p>
     * <p>
     * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A
     * <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
     * <code>DUAL</code>).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working
     * with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * Valid Values: <code>IPV4 | DUAL</code>
     * </p>
     * 
     * @return The network type of the DB instance.</p>
     *         <p>
     *         The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A
     *         <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
     *         <code>DUAL</code>).
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
     *         Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i>
     *         </p>
     *         <p>
     *         Valid Values: <code>IPV4 | DUAL</code>
     */
    public final String networkType() {
        return networkType;
    }

    /**
     * <p>
     * The storage throughput value, in mebibyte per second (MiBps), for the DB instance.
     * </p>
     * <p>
     * This setting applies only to the <code>gp3</code> storage type.
     * </p>
     * <p>
     * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
     * </p>
     * 
     * @return The storage throughput value, in mebibyte per second (MiBps), for the DB instance.</p>
     *         <p>
     *         This setting applies only to the <code>gp3</code> storage type.
     *         </p>
     *         <p>
     *         This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
     */
    public final Integer storageThroughput() {
        return storageThroughput;
    }

    /**
     * <p>
     * Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with
     * Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't manage the master user password with Amazon Web Services Secrets Manager if <code>MasterUserPassword</code>
     * is specified.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password
     *         management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't manage the master user password with Amazon Web Services Secrets Manager if
     *         <code>MasterUserPassword</code> is specified.
     *         </p>
     *         </li>
     */
    public final Boolean manageMasterUserPassword() {
        return manageMasterUserPassword;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in
     * Amazon Web Services Secrets Manager.
     * </p>
     * <p>
     * This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager
     * for the DB instance.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To
     * use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     * </p>
     * <p>
     * If you don't specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key is
     * used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can't use the
     * <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed KMS key.
     * </p>
     * <p>
     * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different
     * default KMS key for each Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and
     *         managed in Amazon Web Services Secrets Manager.</p>
     *         <p>
     *         This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets
     *         Manager for the DB instance.
     *         </p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *         </p>
     *         <p>
     *         If you don't specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS
     *         key is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you
     *         can't use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer
     *         managed KMS key.
     *         </p>
     *         <p>
     *         There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
     *         different default KMS key for each Amazon Web Services Region.
     */
    public final String masterUserSecretKmsKeyId() {
        return masterUserSecretKmsKeyId;
    }

    /**
     * <p>
     * The CA certificate identifier to use for the DB instance's server certificate.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom DB instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a
     * connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
     * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * 
     * @return The CA certificate identifier to use for the DB instance's server certificate.</p>
     *         <p>
     *         This setting doesn't apply to RDS Custom DB instances.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to
     *         encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS
     *         to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     */
    public final String caCertificateIdentifier() {
        return caCertificateIdentifier;
    }

    /**
     * <p>
     * The Oracle system identifier (SID), which is the name of the Oracle database instance that manages your database
     * files. In this context, the term "Oracle database instance" refers exclusively to the system global area (SGA)
     * and Oracle background processes. If you don't specify a SID, the value defaults to <code>RDSCDB</code>. The
     * Oracle SID is also the name of your CDB.
     * </p>
     * 
     * @return The Oracle system identifier (SID), which is the name of the Oracle database instance that manages your
     *         database files. In this context, the term "Oracle database instance" refers exclusively to the system
     *         global area (SGA) and Oracle background processes. If you don't specify a SID, the value defaults to
     *         <code>RDSCDB</code>. The Oracle SID is also the name of your CDB.
     */
    public final String dbSystemId() {
        return dbSystemId;
    }

    /**
     * <p>
     * Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
     * </p>
     * 
     * @return Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
     */
    public final Boolean dedicatedLogVolume() {
        return dedicatedLogVolume;
    }

    /**
     * <p>
     * Specifies whether to use the multi-tenant configuration or the single-tenant configuration (default). This
     * parameter only applies to RDS for Oracle container database (CDB) engines.
     * </p>
     * <p>
     * Note the following restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The DB engine that you specify in the request must support the multi-tenant configuration. If you attempt to
     * enable the multi-tenant configuration on a DB engine that doesn't support it, the request fails.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify the multi-tenant configuration when you create your DB instance, you can't later modify this DB
     * instance to use the single-tenant configuration.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether to use the multi-tenant configuration or the single-tenant configuration (default).
     *         This parameter only applies to RDS for Oracle container database (CDB) engines.</p>
     *         <p>
     *         Note the following restrictions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The DB engine that you specify in the request must support the multi-tenant configuration. If you attempt
     *         to enable the multi-tenant configuration on a DB engine that doesn't support it, the request fails.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify the multi-tenant configuration when you create your DB instance, you can't later modify
     *         this DB instance to use the single-tenant configuration.
     *         </p>
     *         </li>
     */
    public final Boolean multiTenant() {
        return multiTenant;
    }

    /**
     * <p>
     * The life cycle type for this DB instance.
     * </p>
     * <note>
     * <p>
     * By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB instance
     * into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by
     * setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case, creating the DB
     * instance will fail if the DB major version is past its end of standard support date.
     * </p>
     * </note>
     * <p>
     * This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle
     * type is managed by the DB cluster.
     * </p>
     * <p>
     * You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended Support,
     * you can run the selected major engine version on your DB instance past the end of standard support for that
     * engine version. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS Extended Support
     * with Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
     * </p>
     * <p>
     * Default: <code>open-source-rds-extended-support</code>
     * </p>
     * 
     * @return The life cycle type for this DB instance.</p> <note>
     *         <p>
     *         By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB
     *         instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for
     *         Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this
     *         case, creating the DB instance will fail if the DB major version is past its end of standard support
     *         date.
     *         </p>
     *         </note>
     *         <p>
     *         This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the
     *         life cycle type is managed by the DB cluster.
     *         </p>
     *         <p>
     *         You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended
     *         Support, you can run the selected major engine version on your DB instance past the end of standard
     *         support for that engine version. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS Extended
     *         Support with Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
     *         </p>
     *         <p>
     *         Default: <code>open-source-rds-extended-support</code>
     */
    public final String engineLifecycleSupport() {
        return engineLifecycleSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbName());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbSecurityGroups() ? dbSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(ncharCharacterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(tdeCredentialPassword());
        hashCode = 31 * hashCode + Objects.hashCode(storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainFqdn());
        hashCode = 31 * hashCode + Objects.hashCode(domainOu());
        hashCode = 31 * hashCode + Objects.hashCode(domainAuthSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainDnsIps() ? domainDnsIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(promotionTier());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(databaseInsightsModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessorFeatures() ? processorFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(maxAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(enableCustomerOwnedIp());
        hashCode = 31 * hashCode + Objects.hashCode(customIamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(backupTarget());
        hashCode = 31 * hashCode + Objects.hashCode(networkType());
        hashCode = 31 * hashCode + Objects.hashCode(storageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(manageMasterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserSecretKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedLogVolume());
        hashCode = 31 * hashCode + Objects.hashCode(multiTenant());
        hashCode = 31 * hashCode + Objects.hashCode(engineLifecycleSupport());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbInstanceRequest)) {
            return false;
        }
        CreateDbInstanceRequest other = (CreateDbInstanceRequest) obj;
        return Objects.equals(dbName(), other.dbName()) && Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(engine(), other.engine())
                && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(masterUserPassword(), other.masterUserPassword())
                && hasDbSecurityGroups() == other.hasDbSecurityGroups()
                && Objects.equals(dbSecurityGroups(), other.dbSecurityGroups())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(dbParameterGroupName(), other.dbParameterGroupName())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(port(), other.port())
                && Objects.equals(multiAZ(), other.multiAZ()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(licenseModel(), other.licenseModel()) && Objects.equals(iops(), other.iops())
                && Objects.equals(optionGroupName(), other.optionGroupName())
                && Objects.equals(characterSetName(), other.characterSetName())
                && Objects.equals(ncharCharacterSetName(), other.ncharCharacterSetName())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(storageType(), other.storageType())
                && Objects.equals(tdeCredentialArn(), other.tdeCredentialArn())
                && Objects.equals(tdeCredentialPassword(), other.tdeCredentialPassword())
                && Objects.equals(storageEncrypted(), other.storageEncrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(domain(), other.domain()) && Objects.equals(domainFqdn(), other.domainFqdn())
                && Objects.equals(domainOu(), other.domainOu())
                && Objects.equals(domainAuthSecretArn(), other.domainAuthSecretArn())
                && hasDomainDnsIps() == other.hasDomainDnsIps() && Objects.equals(domainDnsIps(), other.domainDnsIps())
                && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot())
                && Objects.equals(monitoringInterval(), other.monitoringInterval())
                && Objects.equals(monitoringRoleArn(), other.monitoringRoleArn())
                && Objects.equals(domainIAMRoleName(), other.domainIAMRoleName())
                && Objects.equals(promotionTier(), other.promotionTier()) && Objects.equals(timezone(), other.timezone())
                && Objects.equals(enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication())
                && Objects.equals(databaseInsightsModeAsString(), other.databaseInsightsModeAsString())
                && Objects.equals(enablePerformanceInsights(), other.enablePerformanceInsights())
                && Objects.equals(performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId())
                && Objects.equals(performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod())
                && hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports()
                && Objects.equals(enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports())
                && hasProcessorFeatures() == other.hasProcessorFeatures()
                && Objects.equals(processorFeatures(), other.processorFeatures())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(maxAllocatedStorage(), other.maxAllocatedStorage())
                && Objects.equals(enableCustomerOwnedIp(), other.enableCustomerOwnedIp())
                && Objects.equals(customIamInstanceProfile(), other.customIamInstanceProfile())
                && Objects.equals(backupTarget(), other.backupTarget()) && Objects.equals(networkType(), other.networkType())
                && Objects.equals(storageThroughput(), other.storageThroughput())
                && Objects.equals(manageMasterUserPassword(), other.manageMasterUserPassword())
                && Objects.equals(masterUserSecretKmsKeyId(), other.masterUserSecretKmsKeyId())
                && Objects.equals(caCertificateIdentifier(), other.caCertificateIdentifier())
                && Objects.equals(dbSystemId(), other.dbSystemId())
                && Objects.equals(dedicatedLogVolume(), other.dedicatedLogVolume())
                && Objects.equals(multiTenant(), other.multiTenant())
                && Objects.equals(engineLifecycleSupport(), other.engineLifecycleSupport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDbInstanceRequest").add("DBName", dbName())
                .add("DBInstanceIdentifier", dbInstanceIdentifier()).add("AllocatedStorage", allocatedStorage())
                .add("DBInstanceClass", dbInstanceClass()).add("Engine", engine()).add("MasterUsername", masterUsername())
                .add("MasterUserPassword", masterUserPassword())
                .add("DBSecurityGroups", hasDbSecurityGroups() ? dbSecurityGroups() : null)
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("AvailabilityZone", availabilityZone()).add("DBSubnetGroupName", dbSubnetGroupName())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("DBParameterGroupName", dbParameterGroupName()).add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("PreferredBackupWindow", preferredBackupWindow()).add("Port", port()).add("MultiAZ", multiAZ())
                .add("EngineVersion", engineVersion()).add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("LicenseModel", licenseModel()).add("Iops", iops()).add("OptionGroupName", optionGroupName())
                .add("CharacterSetName", characterSetName()).add("NcharCharacterSetName", ncharCharacterSetName())
                .add("PubliclyAccessible", publiclyAccessible()).add("Tags", hasTags() ? tags() : null)
                .add("DBClusterIdentifier", dbClusterIdentifier()).add("StorageType", storageType())
                .add("TdeCredentialArn", tdeCredentialArn()).add("TdeCredentialPassword", tdeCredentialPassword())
                .add("StorageEncrypted", storageEncrypted()).add("KmsKeyId", kmsKeyId()).add("Domain", domain())
                .add("DomainFqdn", domainFqdn()).add("DomainOu", domainOu()).add("DomainAuthSecretArn", domainAuthSecretArn())
                .add("DomainDnsIps", hasDomainDnsIps() ? domainDnsIps() : null).add("CopyTagsToSnapshot", copyTagsToSnapshot())
                .add("MonitoringInterval", monitoringInterval()).add("MonitoringRoleArn", monitoringRoleArn())
                .add("DomainIAMRoleName", domainIAMRoleName()).add("PromotionTier", promotionTier()).add("Timezone", timezone())
                .add("EnableIAMDatabaseAuthentication", enableIAMDatabaseAuthentication())
                .add("DatabaseInsightsMode", databaseInsightsModeAsString())
                .add("EnablePerformanceInsights", enablePerformanceInsights())
                .add("PerformanceInsightsKMSKeyId", performanceInsightsKMSKeyId())
                .add("PerformanceInsightsRetentionPeriod", performanceInsightsRetentionPeriod())
                .add("EnableCloudwatchLogsExports", hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null)
                .add("ProcessorFeatures", hasProcessorFeatures() ? processorFeatures() : null)
                .add("DeletionProtection", deletionProtection()).add("MaxAllocatedStorage", maxAllocatedStorage())
                .add("EnableCustomerOwnedIp", enableCustomerOwnedIp())
                .add("CustomIamInstanceProfile", customIamInstanceProfile()).add("BackupTarget", backupTarget())
                .add("NetworkType", networkType()).add("StorageThroughput", storageThroughput())
                .add("ManageMasterUserPassword", manageMasterUserPassword())
                .add("MasterUserSecretKmsKeyId", masterUserSecretKmsKeyId())
                .add("CACertificateIdentifier", caCertificateIdentifier()).add("DBSystemId", dbSystemId())
                .add("DedicatedLogVolume", dedicatedLogVolume()).add("MultiTenant", multiTenant())
                .add("EngineLifecycleSupport", engineLifecycleSupport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBName":
            return Optional.ofNullable(clazz.cast(dbName()));
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "DBSecurityGroups":
            return Optional.ofNullable(clazz.cast(dbSecurityGroups()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "DBSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "DBParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbParameterGroupName()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "LicenseModel":
            return Optional.ofNullable(clazz.cast(licenseModel()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "CharacterSetName":
            return Optional.ofNullable(clazz.cast(characterSetName()));
        case "NcharCharacterSetName":
            return Optional.ofNullable(clazz.cast(ncharCharacterSetName()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "TdeCredentialArn":
            return Optional.ofNullable(clazz.cast(tdeCredentialArn()));
        case "TdeCredentialPassword":
            return Optional.ofNullable(clazz.cast(tdeCredentialPassword()));
        case "StorageEncrypted":
            return Optional.ofNullable(clazz.cast(storageEncrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "DomainFqdn":
            return Optional.ofNullable(clazz.cast(domainFqdn()));
        case "DomainOu":
            return Optional.ofNullable(clazz.cast(domainOu()));
        case "DomainAuthSecretArn":
            return Optional.ofNullable(clazz.cast(domainAuthSecretArn()));
        case "DomainDnsIps":
            return Optional.ofNullable(clazz.cast(domainDnsIps()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        case "MonitoringInterval":
            return Optional.ofNullable(clazz.cast(monitoringInterval()));
        case "MonitoringRoleArn":
            return Optional.ofNullable(clazz.cast(monitoringRoleArn()));
        case "DomainIAMRoleName":
            return Optional.ofNullable(clazz.cast(domainIAMRoleName()));
        case "PromotionTier":
            return Optional.ofNullable(clazz.cast(promotionTier()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "EnableIAMDatabaseAuthentication":
            return Optional.ofNullable(clazz.cast(enableIAMDatabaseAuthentication()));
        case "DatabaseInsightsMode":
            return Optional.ofNullable(clazz.cast(databaseInsightsModeAsString()));
        case "EnablePerformanceInsights":
            return Optional.ofNullable(clazz.cast(enablePerformanceInsights()));
        case "PerformanceInsightsKMSKeyId":
            return Optional.ofNullable(clazz.cast(performanceInsightsKMSKeyId()));
        case "PerformanceInsightsRetentionPeriod":
            return Optional.ofNullable(clazz.cast(performanceInsightsRetentionPeriod()));
        case "EnableCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(enableCloudwatchLogsExports()));
        case "ProcessorFeatures":
            return Optional.ofNullable(clazz.cast(processorFeatures()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "MaxAllocatedStorage":
            return Optional.ofNullable(clazz.cast(maxAllocatedStorage()));
        case "EnableCustomerOwnedIp":
            return Optional.ofNullable(clazz.cast(enableCustomerOwnedIp()));
        case "CustomIamInstanceProfile":
            return Optional.ofNullable(clazz.cast(customIamInstanceProfile()));
        case "BackupTarget":
            return Optional.ofNullable(clazz.cast(backupTarget()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkType()));
        case "StorageThroughput":
            return Optional.ofNullable(clazz.cast(storageThroughput()));
        case "ManageMasterUserPassword":
            return Optional.ofNullable(clazz.cast(manageMasterUserPassword()));
        case "MasterUserSecretKmsKeyId":
            return Optional.ofNullable(clazz.cast(masterUserSecretKmsKeyId()));
        case "CACertificateIdentifier":
            return Optional.ofNullable(clazz.cast(caCertificateIdentifier()));
        case "DBSystemId":
            return Optional.ofNullable(clazz.cast(dbSystemId()));
        case "DedicatedLogVolume":
            return Optional.ofNullable(clazz.cast(dedicatedLogVolume()));
        case "MultiTenant":
            return Optional.ofNullable(clazz.cast(multiTenant()));
        case "EngineLifecycleSupport":
            return Optional.ofNullable(clazz.cast(engineLifecycleSupport()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBName", DB_NAME_FIELD);
        map.put("DBInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("AllocatedStorage", ALLOCATED_STORAGE_FIELD);
        map.put("DBInstanceClass", DB_INSTANCE_CLASS_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("MasterUsername", MASTER_USERNAME_FIELD);
        map.put("MasterUserPassword", MASTER_USER_PASSWORD_FIELD);
        map.put("DBSecurityGroups", DB_SECURITY_GROUPS_FIELD);
        map.put("VpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("DBSubnetGroupName", DB_SUBNET_GROUP_NAME_FIELD);
        map.put("PreferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("DBParameterGroupName", DB_PARAMETER_GROUP_NAME_FIELD);
        map.put("BackupRetentionPeriod", BACKUP_RETENTION_PERIOD_FIELD);
        map.put("PreferredBackupWindow", PREFERRED_BACKUP_WINDOW_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("MultiAZ", MULTI_AZ_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("AutoMinorVersionUpgrade", AUTO_MINOR_VERSION_UPGRADE_FIELD);
        map.put("LicenseModel", LICENSE_MODEL_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("OptionGroupName", OPTION_GROUP_NAME_FIELD);
        map.put("CharacterSetName", CHARACTER_SET_NAME_FIELD);
        map.put("NcharCharacterSetName", NCHAR_CHARACTER_SET_NAME_FIELD);
        map.put("PubliclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("DBClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("TdeCredentialArn", TDE_CREDENTIAL_ARN_FIELD);
        map.put("TdeCredentialPassword", TDE_CREDENTIAL_PASSWORD_FIELD);
        map.put("StorageEncrypted", STORAGE_ENCRYPTED_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("DomainFqdn", DOMAIN_FQDN_FIELD);
        map.put("DomainOu", DOMAIN_OU_FIELD);
        map.put("DomainAuthSecretArn", DOMAIN_AUTH_SECRET_ARN_FIELD);
        map.put("DomainDnsIps", DOMAIN_DNS_IPS_FIELD);
        map.put("CopyTagsToSnapshot", COPY_TAGS_TO_SNAPSHOT_FIELD);
        map.put("MonitoringInterval", MONITORING_INTERVAL_FIELD);
        map.put("MonitoringRoleArn", MONITORING_ROLE_ARN_FIELD);
        map.put("DomainIAMRoleName", DOMAIN_IAM_ROLE_NAME_FIELD);
        map.put("PromotionTier", PROMOTION_TIER_FIELD);
        map.put("Timezone", TIMEZONE_FIELD);
        map.put("EnableIAMDatabaseAuthentication", ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD);
        map.put("DatabaseInsightsMode", DATABASE_INSIGHTS_MODE_FIELD);
        map.put("EnablePerformanceInsights", ENABLE_PERFORMANCE_INSIGHTS_FIELD);
        map.put("PerformanceInsightsKMSKeyId", PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD);
        map.put("PerformanceInsightsRetentionPeriod", PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD);
        map.put("EnableCloudwatchLogsExports", ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD);
        map.put("ProcessorFeatures", PROCESSOR_FEATURES_FIELD);
        map.put("DeletionProtection", DELETION_PROTECTION_FIELD);
        map.put("MaxAllocatedStorage", MAX_ALLOCATED_STORAGE_FIELD);
        map.put("EnableCustomerOwnedIp", ENABLE_CUSTOMER_OWNED_IP_FIELD);
        map.put("CustomIamInstanceProfile", CUSTOM_IAM_INSTANCE_PROFILE_FIELD);
        map.put("BackupTarget", BACKUP_TARGET_FIELD);
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        map.put("StorageThroughput", STORAGE_THROUGHPUT_FIELD);
        map.put("ManageMasterUserPassword", MANAGE_MASTER_USER_PASSWORD_FIELD);
        map.put("MasterUserSecretKmsKeyId", MASTER_USER_SECRET_KMS_KEY_ID_FIELD);
        map.put("CACertificateIdentifier", CA_CERTIFICATE_IDENTIFIER_FIELD);
        map.put("DBSystemId", DB_SYSTEM_ID_FIELD);
        map.put("DedicatedLogVolume", DEDICATED_LOG_VOLUME_FIELD);
        map.put("MultiTenant", MULTI_TENANT_FIELD);
        map.put("EngineLifecycleSupport", ENGINE_LIFECYCLE_SUPPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDbInstanceRequest, T> g) {
        return obj -> g.apply((CreateDbInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDbInstanceRequest> {
        /**
         * <p>
         * The meaning of this parameter differs according to the database engine you use.
         * </p>
         * <dl>
         * <dt>Amazon Aurora MySQL</dt>
         * <dd>
         * <p>
         * The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is created. If
         * this parameter isn't specified for an Aurora MySQL DB cluster, no database is created in the DB cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain 1 to 64 alphanumeric characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a word reserved by the database engine.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>Amazon Aurora PostgreSQL</dt>
         * <dd>
         * <p>
         * The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is
         * created. A database named <code>postgres</code> is always created. If this parameter is specified, an
         * additional database with this name is created.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It must contain 1 to 63 alphanumeric characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0 to 9).
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a word reserved by the database engine.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>Amazon RDS Custom for Oracle</dt>
         * <dd>
         * <p>
         * The Oracle System ID (SID) of the created RDS Custom DB instance. If you don't specify a value, the default
         * value is <code>ORCL</code> for non-CDBs and <code>RDSCDB</code> for CDBs.
         * </p>
         * <p>
         * Default: <code>ORCL</code>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain 1 to 8 alphanumeric characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must contain a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a word reserved by the database engine.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>Amazon RDS Custom for SQL Server</dt>
         * <dd>
         * <p>
         * Not applicable. Must be null.
         * </p>
         * </dd>
         * <dt>RDS for Db2</dt>
         * <dd>
         * <p>
         * The name of the database to create when the DB instance is created. If this parameter isn't specified, no
         * database is created in the DB instance. In some cases, we recommend that you don't add a database name. For
         * more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-db-instance-prereqs.html#db2-prereqs-additional-considerations"
         * >Additional considerations</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain 1 to 64 letters or numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a word reserved by the specified database engine.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>RDS for MariaDB</dt>
         * <dd>
         * <p>
         * The name of the database to create when the DB instance is created. If this parameter isn't specified, no
         * database is created in the DB instance.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain 1 to 64 letters or numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a word reserved by the specified database engine.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>RDS for MySQL</dt>
         * <dd>
         * <p>
         * The name of the database to create when the DB instance is created. If this parameter isn't specified, no
         * database is created in the DB instance.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain 1 to 64 letters or numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a word reserved by the specified database engine.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>RDS for Oracle</dt>
         * <dd>
         * <p>
         * The Oracle System ID (SID) of the created DB instance. If you don't specify a value, the default value is
         * <code>ORCL</code>. You can't specify the string <code>null</code>, or any other reserved word, for
         * <code>DBName</code>.
         * </p>
         * <p>
         * Default: <code>ORCL</code>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't be longer than 8 characters.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>RDS for PostgreSQL</dt>
         * <dd>
         * <p>
         * The name of the database to create when the DB instance is created. A database named <code>postgres</code> is
         * always created. If this parameter is specified, an additional database with this name is created.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain 1 to 63 letters, numbers, or underscores.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a word reserved by the specified database engine.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>RDS for SQL Server</dt>
         * <dd>
         * <p>
         * Not applicable. Must be null.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param dbName
         *        The meaning of this parameter differs according to the database engine you use.</p>
         *        <dl>
         *        <dt>Amazon Aurora MySQL</dt>
         *        <dd>
         *        <p>
         *        The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is
         *        created. If this parameter isn't specified for an Aurora MySQL DB cluster, no database is created in
         *        the DB cluster.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain 1 to 64 alphanumeric characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a word reserved by the database engine.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Amazon Aurora PostgreSQL</dt>
         *        <dd>
         *        <p>
         *        The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is
         *        created. A database named <code>postgres</code> is always created. If this parameter is specified, an
         *        additional database with this name is created.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        It must contain 1 to 63 alphanumeric characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0 to 9).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a word reserved by the database engine.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Amazon RDS Custom for Oracle</dt>
         *        <dd>
         *        <p>
         *        The Oracle System ID (SID) of the created RDS Custom DB instance. If you don't specify a value, the
         *        default value is <code>ORCL</code> for non-CDBs and <code>RDSCDB</code> for CDBs.
         *        </p>
         *        <p>
         *        Default: <code>ORCL</code>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain 1 to 8 alphanumeric characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must contain a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a word reserved by the database engine.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Amazon RDS Custom for SQL Server</dt>
         *        <dd>
         *        <p>
         *        Not applicable. Must be null.
         *        </p>
         *        </dd>
         *        <dt>RDS for Db2</dt>
         *        <dd>
         *        <p>
         *        The name of the database to create when the DB instance is created. If this parameter isn't specified,
         *        no database is created in the DB instance. In some cases, we recommend that you don't add a database
         *        name. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-db-instance-prereqs.html#db2-prereqs-additional-considerations"
         *        >Additional considerations</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain 1 to 64 letters or numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a word reserved by the specified database engine.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>RDS for MariaDB</dt>
         *        <dd>
         *        <p>
         *        The name of the database to create when the DB instance is created. If this parameter isn't specified,
         *        no database is created in the DB instance.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain 1 to 64 letters or numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a word reserved by the specified database engine.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>RDS for MySQL</dt>
         *        <dd>
         *        <p>
         *        The name of the database to create when the DB instance is created. If this parameter isn't specified,
         *        no database is created in the DB instance.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain 1 to 64 letters or numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a word reserved by the specified database engine.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>RDS for Oracle</dt>
         *        <dd>
         *        <p>
         *        The Oracle System ID (SID) of the created DB instance. If you don't specify a value, the default value
         *        is <code>ORCL</code>. You can't specify the string <code>null</code>, or any other reserved word, for
         *        <code>DBName</code>.
         *        </p>
         *        <p>
         *        Default: <code>ORCL</code>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't be longer than 8 characters.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>RDS for PostgreSQL</dt>
         *        <dd>
         *        <p>
         *        The name of the database to create when the DB instance is created. A database named
         *        <code>postgres</code> is always created. If this parameter is specified, an additional database with
         *        this name is created.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain 1 to 63 letters, numbers, or underscores.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a word reserved by the specified database engine.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>RDS for SQL Server</dt>
         *        <dd>
         *        <p>
         *        Not applicable. Must be null.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbName(String dbName);

        /**
         * <p>
         * The identifier for this DB instance. This parameter is stored as a lowercase string.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>mydbinstance</code>
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        The identifier for this DB instance. This parameter is stored as a lowercase string.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>mydbinstance</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * The amount of storage in gibibytes (GiB) to allocate for the DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. Aurora cluster volumes automatically grow as the
         * amount of data in your database increases, though you are only charged for the space that you use in an
         * Aurora cluster volume.
         * </p>
         * <dl>
         * <dt>Amazon RDS Custom</dt>
         * <dd>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * General Purpose (SSD) storage (gp2, gp3): Must be an integer from 40 to 65536 for RDS Custom for Oracle,
         * 16384 for RDS Custom for SQL Server.
         * </p>
         * </li>
         * <li>
         * <p>
         * Provisioned IOPS storage (io1, io2): Must be an integer from 40 to 65536 for RDS Custom for Oracle, 16384 for
         * RDS Custom for SQL Server.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>RDS for Db2</dt>
         * <dd>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * General Purpose (SSD) storage (gp3): Must be an integer from 20 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>RDS for MariaDB</dt>
         * <dd>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Magnetic storage (standard): Must be an integer from 5 to 3072.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>RDS for MySQL</dt>
         * <dd>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Magnetic storage (standard): Must be an integer from 5 to 3072.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>RDS for Oracle</dt>
         * <dd>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Magnetic storage (standard): Must be an integer from 10 to 3072.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>RDS for PostgreSQL</dt>
         * <dd>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
         * </p>
         * </li>
         * <li>
         * <p>
         * Magnetic storage (standard): Must be an integer from 5 to 3072.
         * </p>
         * </li>
         * </ul>
         * </dd>
         * <dt>RDS for SQL Server</dt>
         * <dd>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * General Purpose (SSD) storage (gp2, gp3):
         * </p>
         * <ul>
         * <li>
         * <p>
         * Enterprise and Standard editions: Must be an integer from 20 to 16384.
         * </p>
         * </li>
         * <li>
         * <p>
         * Web and Express editions: Must be an integer from 20 to 16384.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Provisioned IOPS storage (io1, io2):
         * </p>
         * <ul>
         * <li>
         * <p>
         * Enterprise and Standard editions: Must be an integer from 100 to 16384.
         * </p>
         * </li>
         * <li>
         * <p>
         * Web and Express editions: Must be an integer from 100 to 16384.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Magnetic storage (standard):
         * </p>
         * <ul>
         * <li>
         * <p>
         * Enterprise and Standard editions: Must be an integer from 20 to 1024.
         * </p>
         * </li>
         * <li>
         * <p>
         * Web and Express editions: Must be an integer from 20 to 1024.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * </dl>
         * 
         * @param allocatedStorage
         *        The amount of storage in gibibytes (GiB) to allocate for the DB instance.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora DB instances. Aurora cluster volumes automatically grow as
         *        the amount of data in your database increases, though you are only charged for the space that you use
         *        in an Aurora cluster volume.
         *        </p>
         *        <dl>
         *        <dt>Amazon RDS Custom</dt>
         *        <dd>
         *        <p>
         *        Constraints to the amount of storage for each storage type are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General Purpose (SSD) storage (gp2, gp3): Must be an integer from 40 to 65536 for RDS Custom for
         *        Oracle, 16384 for RDS Custom for SQL Server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Provisioned IOPS storage (io1, io2): Must be an integer from 40 to 65536 for RDS Custom for Oracle,
         *        16384 for RDS Custom for SQL Server.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>RDS for Db2</dt>
         *        <dd>
         *        <p>
         *        Constraints to the amount of storage for each storage type are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General Purpose (SSD) storage (gp3): Must be an integer from 20 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>RDS for MariaDB</dt>
         *        <dd>
         *        <p>
         *        Constraints to the amount of storage for each storage type are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Magnetic storage (standard): Must be an integer from 5 to 3072.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>RDS for MySQL</dt>
         *        <dd>
         *        <p>
         *        Constraints to the amount of storage for each storage type are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Magnetic storage (standard): Must be an integer from 5 to 3072.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>RDS for Oracle</dt>
         *        <dd>
         *        <p>
         *        Constraints to the amount of storage for each storage type are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Magnetic storage (standard): Must be an integer from 10 to 3072.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>RDS for PostgreSQL</dt>
         *        <dd>
         *        <p>
         *        Constraints to the amount of storage for each storage type are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Magnetic storage (standard): Must be an integer from 5 to 3072.
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>RDS for SQL Server</dt>
         *        <dd>
         *        <p>
         *        Constraints to the amount of storage for each storage type are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General Purpose (SSD) storage (gp2, gp3):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Enterprise and Standard editions: Must be an integer from 20 to 16384.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Web and Express editions: Must be an integer from 20 to 16384.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Provisioned IOPS storage (io1, io2):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Enterprise and Standard editions: Must be an integer from 100 to 16384.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Web and Express editions: Must be an integer from 100 to 16384.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Magnetic storage (standard):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Enterprise and Standard editions: Must be an integer from 20 to 1024.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Web and Express editions: Must be an integer from 20 to 1024.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * The compute and memory capacity of the DB instance, for example <code>db.m5.large</code>. Not all DB instance
         * classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of
         * DB instance classes, and availability for your engine, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance
         * classes</a> in the <i>Amazon RDS User Guide</i> or <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html">Aurora DB
         * instance classes</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param dbInstanceClass
         *        The compute and memory capacity of the DB instance, for example <code>db.m5.large</code>. Not all DB
         *        instance classes are available in all Amazon Web Services Regions, or for all database engines. For
         *        the full list of DB instance classes, and availability for your engine, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB
         *        instance classes</a> in the <i>Amazon RDS User Guide</i> or <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html"
         *        >Aurora DB instance classes</a> in the <i>Amazon Aurora User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * The database engine to use for this DB instance.
         * </p>
         * <p>
         * Not every database engine is available in every Amazon Web Services Region.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>aurora-mysql</code> (for Aurora MySQL DB instances)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>aurora-postgresql</code> (for Aurora PostgreSQL DB instances)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-oracle-ee</code> (for RDS Custom for Oracle DB instances)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-oracle-ee-cdb</code> (for RDS Custom for Oracle DB instances)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-oracle-se2</code> (for RDS Custom for Oracle DB instances)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-oracle-se2-cdb</code> (for RDS Custom for Oracle DB instances)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-sqlserver-ee</code> (for RDS Custom for SQL Server DB instances)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-sqlserver-se</code> (for RDS Custom for SQL Server DB instances)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-sqlserver-web</code> (for RDS Custom for SQL Server DB instances)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-sqlserver-dev</code> (for RDS Custom for SQL Server DB instances)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db2-ae</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db2-se</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mariadb</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mysql</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-ee</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-ee-cdb</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-se2</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-se2-cdb</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>postgres</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-ee</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-se</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-ex</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-web</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param engine
         *        The database engine to use for this DB instance.</p>
         *        <p>
         *        Not every database engine is available in every Amazon Web Services Region.
         *        </p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>aurora-mysql</code> (for Aurora MySQL DB instances)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>aurora-postgresql</code> (for Aurora PostgreSQL DB instances)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-oracle-ee</code> (for RDS Custom for Oracle DB instances)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-oracle-ee-cdb</code> (for RDS Custom for Oracle DB instances)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-oracle-se2</code> (for RDS Custom for Oracle DB instances)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-oracle-se2-cdb</code> (for RDS Custom for Oracle DB instances)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-sqlserver-ee</code> (for RDS Custom for SQL Server DB instances)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-sqlserver-se</code> (for RDS Custom for SQL Server DB instances)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-sqlserver-web</code> (for RDS Custom for SQL Server DB instances)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-sqlserver-dev</code> (for RDS Custom for SQL Server DB instances)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db2-ae</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db2-se</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mariadb</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mysql</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-ee</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-ee-cdb</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-se2</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-se2-cdb</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>postgres</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-ee</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-se</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-ex</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-web</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The name for the master user.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. The name for the master user is managed by the DB
         * cluster.
         * </p>
         * <p>
         * This setting is required for RDS DB instances.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 16 letters, numbers, or underscores.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a reserved word for the chosen database engine.
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterUsername
         *        The name for the master user.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora DB instances. The name for the master user is managed by
         *        the DB cluster.
         *        </p>
         *        <p>
         *        This setting is required for RDS DB instances.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 16 letters, numbers, or underscores.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a reserved word for the chosen database engine.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The password for the master user.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. The password for the master user is managed by the
         * DB cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't be specified if <code>ManageMasterUserPassword</code> is turned on.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can include any printable ASCII character except "/",
         * """, or "@". For RDS for Oracle, can't include the "&amp;" (ampersand) or the "'" (single quotes) character.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Length Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * RDS for Db2 - Must contain from 8 to 255 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MariaDB - Must contain from 8 to 41 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for Microsoft SQL Server - Must contain from 8 to 128 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MySQL - Must contain from 8 to 41 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for Oracle - Must contain from 8 to 30 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for PostgreSQL - Must contain from 8 to 128 characters.
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterUserPassword
         *        The password for the master user.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora DB instances. The password for the master user is managed
         *        by the DB cluster.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't be specified if <code>ManageMasterUserPassword</code> is turned on.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can include any printable ASCII character except "/",
         *        """, or "@". For RDS for Oracle, can't include the "&amp;" (ampersand) or the "'" (single quotes)
         *        character.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Length Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        RDS for Db2 - Must contain from 8 to 255 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for MariaDB - Must contain from 8 to 41 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for Microsoft SQL Server - Must contain from 8 to 128 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for MySQL - Must contain from 8 to 41 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for Oracle - Must contain from 8 to 30 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for PostgreSQL - Must contain from 8 to 128 characters.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * A list of DB security groups to associate with this DB instance.
         * </p>
         * <p>
         * This setting applies to the legacy EC2-Classic platform, which is no longer used to create new DB instances.
         * Use the <code>VpcSecurityGroupIds</code> setting instead.
         * </p>
         * 
         * @param dbSecurityGroups
         *        A list of DB security groups to associate with this DB instance.</p>
         *        <p>
         *        This setting applies to the legacy EC2-Classic platform, which is no longer used to create new DB
         *        instances. Use the <code>VpcSecurityGroupIds</code> setting instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroups(Collection<String> dbSecurityGroups);

        /**
         * <p>
         * A list of DB security groups to associate with this DB instance.
         * </p>
         * <p>
         * This setting applies to the legacy EC2-Classic platform, which is no longer used to create new DB instances.
         * Use the <code>VpcSecurityGroupIds</code> setting instead.
         * </p>
         * 
         * @param dbSecurityGroups
         *        A list of DB security groups to associate with this DB instance.</p>
         *        <p>
         *        This setting applies to the legacy EC2-Classic platform, which is no longer used to create new DB
         *        instances. Use the <code>VpcSecurityGroupIds</code> setting instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroups(String... dbSecurityGroups);

        /**
         * <p>
         * A list of Amazon EC2 VPC security groups to associate with this DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. The associated list of EC2 VPC security groups is
         * managed by the DB cluster.
         * </p>
         * <p>
         * Default: The default EC2 VPC security group for the DB subnet group's VPC.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of Amazon EC2 VPC security groups to associate with this DB instance.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora DB instances. The associated list of EC2 VPC security
         *        groups is managed by the DB cluster.
         *        </p>
         *        <p>
         *        Default: The default EC2 VPC security group for the DB subnet group's VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of Amazon EC2 VPC security groups to associate with this DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. The associated list of EC2 VPC security groups is
         * managed by the DB cluster.
         * </p>
         * <p>
         * Default: The default EC2 VPC security group for the DB subnet group's VPC.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of Amazon EC2 VPC security groups to associate with this DB instance.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora DB instances. The associated list of EC2 VPC security
         *        groups is managed by the DB cluster.
         *        </p>
         *        <p>
         *        Default: The default EC2 VPC security group for the DB subnet group's VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The Availability Zone (AZ) where the database will be created. For information on Amazon Web Services Regions
         * and Availability Zones, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html"
         * >Regions and Availability Zones</a>.
         * </p>
         * <p>
         * For Amazon Aurora, each Aurora DB cluster hosts copies of its storage in three separate Availability Zones.
         * Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you
         * don't specify one.
         * </p>
         * <p>
         * Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>us-east-1d</code>
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone (AZ) where the database will be created. For information on Amazon Web Services
         *        Regions and Availability Zones, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html"
         *        >Regions and Availability Zones</a>.</p>
         *        <p>
         *        For Amazon Aurora, each Aurora DB cluster hosts copies of its storage in three separate Availability
         *        Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate
         *        Availability Zone if you don't specify one.
         *        </p>
         *        <p>
         *        Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ
         *        deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The specified Availability Zone must be in the same Amazon Web Services Region as the current
         *        endpoint.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>us-east-1d</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * A DB subnet group to associate with this DB instance.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the name of an existing DB subnet group.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>mydbsubnetgroup</code>
         * </p>
         * 
         * @param dbSubnetGroupName
         *        A DB subnet group to associate with this DB instance.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the name of an existing DB subnet group.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>mydbsubnetgroup</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * The time range each week during which system maintenance can occur. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance"
         * >Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
         * Services Region, occurring on a random day of the week.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The day values must be <code>mon | tue | wed | thu | fri | sat | sun</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be in Universal Coordinated Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not conflict with the preferred backup window.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredMaintenanceWindow
         *        The time range each week during which system maintenance can occur. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance"
         *        >Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
         *        Services Region, occurring on a random day of the week.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The day values must be <code>mon | tue | wed | thu | fri | sat | sun</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be in Universal Coordinated Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not conflict with the preferred backup window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The name of the DB parameter group to associate with this DB instance. If you don't specify a value, then
         * Amazon RDS uses the default DB parameter group for the specified DB engine and version.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 255 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbParameterGroupName
         *        The name of the DB parameter group to associate with this DB instance. If you don't specify a value,
         *        then Amazon RDS uses the default DB parameter group for the specified DB engine and version.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 255 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupName(String dbParameterGroupName);

        /**
         * <p>
         * The number of days for which automated backups are retained. Setting this parameter to a positive number
         * enables backups. Setting this parameter to <code>0</code> disables automated backups.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. The retention period for automated backups is
         * managed by the DB cluster.
         * </p>
         * <p>
         * Default: <code>1</code>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be a value from 0 to 35.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be set to 0 if the DB instance is a source to read replicas.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be set to 0 for an RDS Custom for Oracle DB instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupRetentionPeriod
         *        The number of days for which automated backups are retained. Setting this parameter to a positive
         *        number enables backups. Setting this parameter to <code>0</code> disables automated backups.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora DB instances. The retention period for automated backups
         *        is managed by the DB cluster.
         *        </p>
         *        <p>
         *        Default: <code>1</code>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be a value from 0 to 35.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be set to 0 if the DB instance is a source to read replicas.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be set to 0 for an RDS Custom for Oracle DB instance.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * The daily time range during which automated backups are created if automated backups are enabled, using the
         * <code>BackupRetentionPeriod</code> parameter. The default is a 30-minute window selected at random from an
         * 8-hour block of time for each Amazon Web Services Region. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
         * >Backup window</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. The daily time range for creating automated backups
         * is managed by the DB cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the format <code>hh24:mi-hh24:mi</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be in Universal Coordinated Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not conflict with the preferred maintenance window.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredBackupWindow
         *        The daily time range during which automated backups are created if automated backups are enabled,
         *        using the <code>BackupRetentionPeriod</code> parameter. The default is a 30-minute window selected at
         *        random from an 8-hour block of time for each Amazon Web Services Region. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
         *        >Backup window</a> in the <i>Amazon RDS User Guide</i>.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora DB instances. The daily time range for creating automated
         *        backups is managed by the DB cluster.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the format <code>hh24:mi-hh24:mi</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be in Universal Coordinated Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not conflict with the preferred maintenance window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The port number on which the database accepts connections.
         * </p>
         * <p>
         * This setting doesn't apply to Aurora DB instances. The port number is managed by the cluster.
         * </p>
         * <p>
         * Valid Values: <code>1150-65535</code>
         * </p>
         * <p>
         * Default:
         * </p>
         * <ul>
         * <li>
         * <p>
         * RDS for Db2 - <code>50000</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MariaDB - <code>3306</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for Microsoft SQL Server - <code>1433</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MySQL - <code>3306</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for Oracle - <code>1521</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for PostgreSQL - <code>5432</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For RDS for Microsoft SQL Server, the value can't be <code>1234</code>, <code>1434</code>, <code>3260</code>,
         * <code>3343</code>, <code>3389</code>, <code>47001</code>, or <code>49152-49156</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param port
         *        The port number on which the database accepts connections.</p>
         *        <p>
         *        This setting doesn't apply to Aurora DB instances. The port number is managed by the cluster.
         *        </p>
         *        <p>
         *        Valid Values: <code>1150-65535</code>
         *        </p>
         *        <p>
         *        Default:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        RDS for Db2 - <code>50000</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for MariaDB - <code>3306</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for Microsoft SQL Server - <code>1433</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for MySQL - <code>3306</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for Oracle - <code>1521</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for PostgreSQL - <code>5432</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For RDS for Microsoft SQL Server, the value can't be <code>1234</code>, <code>1434</code>,
         *        <code>3260</code>, <code>3343</code>, <code>3389</code>, <code>47001</code>, or
         *        <code>49152-49156</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Specifies whether the DB instance is a Multi-AZ deployment. You can't set the <code>AvailabilityZone</code>
         * parameter if the DB instance is a Multi-AZ deployment.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora because the DB instance Availability Zones (AZs) are managed by
         * the DB cluster.
         * </p>
         * 
         * @param multiAZ
         *        Specifies whether the DB instance is a Multi-AZ deployment. You can't set the
         *        <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora because the DB instance Availability Zones (AZs) are
         *        managed by the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * The version number of the database engine to use.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. The version number of the database engine the DB
         * instance uses is managed by the DB cluster.
         * </p>
         * <p>
         * For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> operation.
         * </p>
         * <p>
         * The following are the database engines and links to information about the major and minor versions that are
         * available with Amazon RDS. Not every database engine is available for every Amazon Web Services Region.
         * </p>
         * <dl>
         * <dt>Amazon RDS Custom for Oracle</dt>
         * <dd>
         * <p>
         * A custom engine version (CEV) that you have previously created. This setting is required for RDS Custom for
         * Oracle. The CEV name has the following format: 19.<i>customized_string</i>. A valid CEV name is
         * <code>19.my_cev1</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-creating.html#custom-creating.create">
         * Creating an RDS Custom for Oracle DB instance</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * </dd>
         * <dt>Amazon RDS Custom for SQL Server</dt>
         * <dd>
         * <p>
         * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits-MS.html">RDS Custom
         * for SQL Server general requirements</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * </dd>
         * <dt>RDS for Db2</dt>
         * <dd>
         * <p>
         * For information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Db2.html#Db2.Concepts.VersionMgmt">Db2 on
         * Amazon RDS versions</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * </dd>
         * <dt>RDS for MariaDB</dt>
         * <dd>
         * <p>
         * For information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt"
         * >MariaDB on Amazon RDS versions</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * </dd>
         * <dt>RDS for Microsoft SQL Server</dt>
         * <dd>
         * <p>
         * For information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport"
         * >Microsoft SQL Server versions on Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * </dd>
         * <dt>RDS for MySQL</dt>
         * <dd>
         * <p>
         * For information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt"
         * >MySQL on Amazon RDS versions</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * </dd>
         * <dt>RDS for Oracle</dt>
         * <dd>
         * <p>
         * For information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle
         * Database Engine release notes</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * </dd>
         * <dt>RDS for PostgreSQL</dt>
         * <dd>
         * <p>
         * For information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon
         * RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param engineVersion
         *        The version number of the database engine to use.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora DB instances. The version number of the database engine
         *        the DB instance uses is managed by the DB cluster.
         *        </p>
         *        <p>
         *        For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> operation.
         *        </p>
         *        <p>
         *        The following are the database engines and links to information about the major and minor versions
         *        that are available with Amazon RDS. Not every database engine is available for every Amazon Web
         *        Services Region.
         *        </p>
         *        <dl>
         *        <dt>Amazon RDS Custom for Oracle</dt>
         *        <dd>
         *        <p>
         *        A custom engine version (CEV) that you have previously created. This setting is required for RDS
         *        Custom for Oracle. The CEV name has the following format: 19.<i>customized_string</i>. A valid CEV
         *        name is <code>19.my_cev1</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-creating.html#custom-creating.create"
         *        > Creating an RDS Custom for Oracle DB instance</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        </dd>
         *        <dt>Amazon RDS Custom for SQL Server</dt>
         *        <dd>
         *        <p>
         *        See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits-MS.html">RDS
         *        Custom for SQL Server general requirements</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        </dd>
         *        <dt>RDS for Db2</dt>
         *        <dd>
         *        <p>
         *        For information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Db2.html#Db2.Concepts.VersionMgmt"
         *        >Db2 on Amazon RDS versions</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        </dd>
         *        <dt>RDS for MariaDB</dt>
         *        <dd>
         *        <p>
         *        For information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt"
         *        >MariaDB on Amazon RDS versions</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        </dd>
         *        <dt>RDS for Microsoft SQL Server</dt>
         *        <dd>
         *        <p>
         *        For information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport"
         *        >Microsoft SQL Server versions on Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        </dd>
         *        <dt>RDS for MySQL</dt>
         *        <dd>
         *        <p>
         *        For information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt"
         *        >MySQL on Amazon RDS versions</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        </dd>
         *        <dt>RDS for Oracle</dt>
         *        <dd>
         *        <p>
         *        For information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html"
         *        >Oracle Database Engine release notes</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        </dd>
         *        <dt>RDS for PostgreSQL</dt>
         *        <dd>
         *        <p>
         *        For information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts"
         *        >Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Specifies whether minor engine upgrades are applied automatically to the DB instance during the maintenance
         * window. By default, minor engine upgrades are applied automatically.
         * </p>
         * <p>
         * If you create an RDS Custom DB instance, you must set <code>AutoMinorVersionUpgrade</code> to
         * <code>false</code>.
         * </p>
         * <p>
         * For more information about automatic minor version upgrades, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades"
         * >Automatically upgrading the minor engine version</a>.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        Specifies whether minor engine upgrades are applied automatically to the DB instance during the
         *        maintenance window. By default, minor engine upgrades are applied automatically.</p>
         *        <p>
         *        If you create an RDS Custom DB instance, you must set <code>AutoMinorVersionUpgrade</code> to
         *        <code>false</code>.
         *        </p>
         *        <p>
         *        For more information about automatic minor version upgrades, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades"
         *        >Automatically upgrading the minor engine version</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The license model information for this DB instance.
         * </p>
         * <note>
         * <p>
         * License models for RDS for Db2 require additional configuration. The bring your own license (BYOL) model
         * requires a custom parameter group and an Amazon Web Services License Manager self-managed license. The Db2
         * license through Amazon Web Services Marketplace model requires an Amazon Web Services Marketplace
         * subscription. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html">Amazon RDS for Db2 licensing
         * options</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * The default for RDS for Db2 is <code>bring-your-own-license</code>.
         * </p>
         * </note>
         * <p>
         * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * RDS for Db2 - <code>bring-your-own-license | marketplace-license</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MariaDB - <code>general-public-license</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for Microsoft SQL Server - <code>license-included</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MySQL - <code>general-public-license</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for Oracle - <code>bring-your-own-license | license-included</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for PostgreSQL - <code>postgresql-license</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param licenseModel
         *        The license model information for this DB instance.</p> <note>
         *        <p>
         *        License models for RDS for Db2 require additional configuration. The bring your own license (BYOL)
         *        model requires a custom parameter group and an Amazon Web Services License Manager self-managed
         *        license. The Db2 license through Amazon Web Services Marketplace model requires an Amazon Web Services
         *        Marketplace subscription. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html">Amazon RDS for Db2
         *        licensing options</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        The default for RDS for Db2 is <code>bring-your-own-license</code>.
         *        </p>
         *        </note>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         *        </p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        RDS for Db2 - <code>bring-your-own-license | marketplace-license</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for MariaDB - <code>general-public-license</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for Microsoft SQL Server - <code>license-included</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for MySQL - <code>general-public-license</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for Oracle - <code>bring-your-own-license | license-included</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for PostgreSQL - <code>postgresql-license</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The amount of Provisioned IOPS (input/output operations per second) to initially allocate for the DB
         * instance. For information about valid IOPS values, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html">Amazon RDS DB instance
         * storage</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For RDS for Db2, MariaDB, MySQL, Oracle, and PostgreSQL - Must be a multiple between .5 and 50 of the storage
         * amount for the DB instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * For RDS for SQL Server - Must be a multiple between 1 and 50 of the storage amount for the DB instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param iops
         *        The amount of Provisioned IOPS (input/output operations per second) to initially allocate for the DB
         *        instance. For information about valid IOPS values, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html">Amazon RDS DB instance
         *        storage</a> in the <i>Amazon RDS User Guide</i>.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For RDS for Db2, MariaDB, MySQL, Oracle, and PostgreSQL - Must be a multiple between .5 and 50 of the
         *        storage amount for the DB instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For RDS for SQL Server - Must be a multiple between 1 and 50 of the storage amount for the DB
         *        instance.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The option group to associate the DB instance with.
         * </p>
         * <p>
         * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option
         * group. Also, that option group can't be removed from a DB instance after it is associated with a DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         * </p>
         * 
         * @param optionGroupName
         *        The option group to associate the DB instance with.</p>
         *        <p>
         *        Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an
         *        option group. Also, that option group can't be removed from a DB instance after it is associated with
         *        a DB instance.
         *        </p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * For supported engines, the character set (<code>CharacterSet</code>) to associate the DB instance with.
         * </p>
         * <p>
         * This setting doesn't apply to the following DB instances:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Aurora - The character set is managed by the DB cluster. For more information, see
         * <code>CreateDBCluster</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS Custom - However, if you need to change the character set, you can change it on the database itself.
         * </p>
         * </li>
         * </ul>
         * 
         * @param characterSetName
         *        For supported engines, the character set (<code>CharacterSet</code>) to associate the DB instance
         *        with.</p>
         *        <p>
         *        This setting doesn't apply to the following DB instances:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Aurora - The character set is managed by the DB cluster. For more information, see
         *        <code>CreateDBCluster</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS Custom - However, if you need to change the character set, you can change it on the database
         *        itself.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characterSetName(String characterSetName);

        /**
         * <p>
         * The name of the NCHAR character set for the Oracle DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param ncharCharacterSetName
         *        The name of the NCHAR character set for the Oracle DB instance.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ncharCharacterSetName(String ncharCharacterSetName);

        /**
         * <p>
         * Specifies whether the DB instance is publicly accessible.
         * </p>
         * <p>
         * When the DB instance is publicly accessible and you connect from outside of the DB instance's virtual private
         * cloud (VPC), its Domain Name System (DNS) endpoint resolves to the public IP address. When you connect from
         * within the same VPC as the DB instance, the endpoint resolves to the private IP address. Access to the DB
         * instance is ultimately controlled by the security group it uses. That public access is not permitted if the
         * security group assigned to the DB instance doesn't permit it.
         * </p>
         * <p>
         * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves
         * to a private IP address.
         * </p>
         * <p>
         * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         * </p>
         * <p>
         * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the
         * following applies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB instance is
         * private.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the default VPC in the target Region has an internet gateway attached to it, the DB instance is public.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the
         * following applies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB instance is
         * private.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the subnets are part of a VPC that has an internet gateway attached to it, the DB instance is public.
         * </p>
         * </li>
         * </ul>
         * 
         * @param publiclyAccessible
         *        Specifies whether the DB instance is publicly accessible.</p>
         *        <p>
         *        When the DB instance is publicly accessible and you connect from outside of the DB instance's virtual
         *        private cloud (VPC), its Domain Name System (DNS) endpoint resolves to the public IP address. When you
         *        connect from within the same VPC as the DB instance, the endpoint resolves to the private IP address.
         *        Access to the DB instance is ultimately controlled by the security group it uses. That public access
         *        is not permitted if the security group assigned to the DB instance doesn't permit it.
         *        </p>
         *        <p>
         *        When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that
         *        resolves to a private IP address.
         *        </p>
         *        <p>
         *        Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         *        </p>
         *        <p>
         *        If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't
         *        specified, the following applies:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB
         *        instance is private.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the default VPC in the target Region has an internet gateway attached to it, the DB instance is
         *        public.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified,
         *        the following applies:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB instance
         *        is private.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the subnets are part of a VPC that has an internet gateway attached to it, the DB instance is
         *        public.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * Tags to assign to the DB instance.
         * </p>
         * 
         * @param tags
         *        Tags to assign to the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags to assign to the DB instance.
         * </p>
         * 
         * @param tags
         *        Tags to assign to the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags to assign to the DB instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The identifier of the DB cluster that this DB instance will belong to.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The identifier of the DB cluster that this DB instance will belong to.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The storage type to associate with the DB instance.
         * </p>
         * <p>
         * If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value for the
         * <code>Iops</code> parameter.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.
         * </p>
         * <p>
         * Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code>
         * </p>
         * <p>
         * Default: <code>io1</code>, if the <code>Iops</code> parameter is specified. Otherwise, <code>gp3</code>.
         * </p>
         * 
         * @param storageType
         *        The storage type to associate with the DB instance.</p>
         *        <p>
         *        If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value
         *        for the <code>Iops</code> parameter.
         *        </p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.
         *        </p>
         *        <p>
         *        Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code>
         *        </p>
         *        <p>
         *        Default: <code>io1</code>, if the <code>Iops</code> parameter is specified. Otherwise,
         *        <code>gp3</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The ARN from the key store with which to associate the instance for TDE encryption.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         * </p>
         * 
         * @param tdeCredentialArn
         *        The ARN from the key store with which to associate the instance for TDE encryption.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdeCredentialArn(String tdeCredentialArn);

        /**
         * <p>
         * The password for the given ARN from the key store in order to access the device.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param tdeCredentialPassword
         *        The password for the given ARN from the key store in order to access the device.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdeCredentialPassword(String tdeCredentialPassword);

        /**
         * <p>
         * Specifes whether the DB instance is encrypted. By default, it isn't encrypted.
         * </p>
         * <p>
         * For RDS Custom DB instances, either enable this setting or leave it unset. Otherwise, Amazon RDS reports an
         * error.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. The encryption for DB instances is managed by the
         * DB cluster.
         * </p>
         * 
         * @param storageEncrypted
         *        Specifes whether the DB instance is encrypted. By default, it isn't encrypted.</p>
         *        <p>
         *        For RDS Custom DB instances, either enable this setting or leave it unset. Otherwise, Amazon RDS
         *        reports an error.
         *        </p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora DB instances. The encryption for DB instances is managed
         *        by the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEncrypted(Boolean storageEncrypted);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier for an encrypted DB instance.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. The Amazon Web Services KMS key identifier is
         * managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.
         * </p>
         * <p>
         * If <code>StorageEncrypted</code> is enabled, and you do not specify a value for the <code>KmsKeyId</code>
         * parameter, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services
         * account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services
         * Region.
         * </p>
         * <p>
         * For Amazon RDS Custom, a KMS key is required for DB instances. For most RDS engines, if you leave this
         * parameter empty while enabling <code>StorageEncrypted</code>, the engine uses the default KMS key. However,
         * RDS Custom doesn't use the default key when this parameter is empty. You must explicitly specify a key.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS key identifier for an encrypted DB instance.</p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias
         *        ARN.
         *        </p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora DB instances. The Amazon Web Services KMS key identifier
         *        is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.
         *        </p>
         *        <p>
         *        If <code>StorageEncrypted</code> is enabled, and you do not specify a value for the
         *        <code>KmsKeyId</code> parameter, then Amazon RDS uses your default KMS key. There is a default KMS key
         *        for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key
         *        for each Amazon Web Services Region.
         *        </p>
         *        <p>
         *        For Amazon RDS Custom, a KMS key is required for DB instances. For most RDS engines, if you leave this
         *        parameter empty while enabling <code>StorageEncrypted</code>, the engine uses the default KMS key.
         *        However, RDS Custom doesn't use the default key when this parameter is empty. You must explicitly
         *        specify a key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The Active Directory directory ID to create the DB instance in. Currently, you can create only Db2, MySQL,
         * Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
         * Authentication</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to the following DB instances:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Aurora (The domain is managed by the DB cluster.)
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS Custom
         * </p>
         * </li>
         * </ul>
         * 
         * @param domain
         *        The Active Directory directory ID to create the DB instance in. Currently, you can create only Db2,
         *        MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos
         *        Authentication</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        This setting doesn't apply to the following DB instances:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Aurora (The domain is managed by the DB cluster.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS Custom
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The fully qualified domain name (FQDN) of an Active Directory domain.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't be longer than 64 characters.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>mymanagedADtest.mymanagedAD.mydomain</code>
         * </p>
         * 
         * @param domainFqdn
         *        The fully qualified domain name (FQDN) of an Active Directory domain.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't be longer than 64 characters.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>mymanagedADtest.mymanagedAD.mydomain</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainFqdn(String domainFqdn);

        /**
         * <p>
         * The Active Directory organizational unit for your DB instance to join.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the distinguished name format.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be longer than 64 characters.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain</code>
         * </p>
         * 
         * @param domainOu
         *        The Active Directory organizational unit for your DB instance to join.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the distinguished name format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be longer than 64 characters.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOu(String domainOu);

        /**
         * <p>
         * The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
         * </p>
         * <p>
         * Example: <code>arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456</code>
         * </p>
         * 
         * @param domainAuthSecretArn
         *        The ARN for the Secrets Manager secret with the credentials for the user joining the domain.</p>
         *        <p>
         *        Example:
         *        <code>arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainAuthSecretArn(String domainAuthSecretArn);

        /**
         * <p>
         * The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the
         * primary domain controller for both entries in the list.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>123.124.125.126,234.235.236.237</code>
         * </p>
         * 
         * @param domainDnsIps
         *        The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of
         *        the primary domain controller for both entries in the list.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>123.124.125.126,234.235.236.237</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainDnsIps(Collection<String> domainDnsIps);

        /**
         * <p>
         * The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the
         * primary domain controller for both entries in the list.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>123.124.125.126,234.235.236.237</code>
         * </p>
         * 
         * @param domainDnsIps
         *        The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of
         *        the primary domain controller for both entries in the list.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>123.124.125.126,234.235.236.237</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainDnsIps(String... domainDnsIps);

        /**
         * <p>
         * Specifies whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not
         * copied.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB
         * cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        Specifies whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags
         *        are not copied.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the
         *        DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        /**
         * <p>
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
         * To disable collection of Enhanced Monitoring metrics, specify <code>0</code>.
         * </p>
         * <p>
         * If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a value
         * other than <code>0</code>.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * <p>
         * Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
         * </p>
         * <p>
         * Default: <code>0</code>
         * </p>
         * 
         * @param monitoringInterval
         *        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
         *        instance. To disable collection of Enhanced Monitoring metrics, specify <code>0</code>.</p>
         *        <p>
         *        If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a
         *        value other than <code>0</code>.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         *        </p>
         *        <p>
         *        Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
         *        </p>
         *        <p>
         *        Default: <code>0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringInterval(Integer monitoringInterval);

        /**
         * <p>
         * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
         * example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role,
         * see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling"
         * >Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, then you must supply a
         * <code>MonitoringRoleArn</code> value.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param monitoringRoleArn
         *        The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch
         *        Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a
         *        monitoring role, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling"
         *        >Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
         *        <p>
         *        If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, then you must supply a
         *        <code>MonitoringRoleArn</code> value.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringRoleArn(String monitoringRoleArn);

        /**
         * <p>
         * The name of the IAM role to use when making API calls to the Directory Service.
         * </p>
         * <p>
         * This setting doesn't apply to the following DB instances:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Aurora (The domain is managed by the DB cluster.)
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS Custom
         * </p>
         * </li>
         * </ul>
         * 
         * @param domainIAMRoleName
         *        The name of the IAM role to use when making API calls to the Directory Service.</p>
         *        <p>
         *        This setting doesn't apply to the following DB instances:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Aurora (The domain is managed by the DB cluster.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS Custom
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIAMRoleName(String domainIAMRoleName);

        /**
         * <p>
         * The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the
         * existing primary instance. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance"
         * > Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * <p>
         * Default: <code>1</code>
         * </p>
         * <p>
         * Valid Values: <code>0 - 15</code>
         * </p>
         * 
         * @param promotionTier
         *        The order of priority in which an Aurora Replica is promoted to the primary instance after a failure
         *        of the existing primary instance. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance"
         *        > Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         *        </p>
         *        <p>
         *        Default: <code>1</code>
         *        </p>
         *        <p>
         *        Valid Values: <code>0 - 15</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promotionTier(Integer promotionTier);

        /**
         * <p>
         * The time zone of the DB instance. The time zone parameter is currently supported only by <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-time-zone">RDS for Db2</a> and <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone"
         * >RDS for SQL Server</a>.
         * </p>
         * 
         * @param timezone
         *        The time zone of the DB instance. The time zone parameter is currently supported only by <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-time-zone">RDS for Db2</a> and <a
         *        href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone"
         *        >RDS for SQL Server</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to
         * database accounts. By default, mapping isn't enabled.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
         * Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to the following DB instances:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Aurora (Mapping Amazon Web Services IAM accounts to database accounts is managed by the DB cluster.)
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS Custom
         * </p>
         * </li>
         * </ul>
         * 
         * @param enableIAMDatabaseAuthentication
         *        Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM)
         *        accounts to database accounts. By default, mapping isn't enabled.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
         *        Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        This setting doesn't apply to the following DB instances:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Aurora (Mapping Amazon Web Services IAM accounts to database accounts is managed by the DB
         *        cluster.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS Custom
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication);

        /**
         * <p>
         * The mode of Database Insights to enable for the DB instance.
         * </p>
         * <note>
         * <p>
         * Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
         * </p>
         * </note>
         * 
         * @param databaseInsightsMode
         *        The mode of Database Insights to enable for the DB instance.</p> <note>
         *        <p>
         *        Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
         *        </p>
         * @see DatabaseInsightsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseInsightsMode
         */
        Builder databaseInsightsMode(String databaseInsightsMode);

        /**
         * <p>
         * The mode of Database Insights to enable for the DB instance.
         * </p>
         * <note>
         * <p>
         * Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
         * </p>
         * </note>
         * 
         * @param databaseInsightsMode
         *        The mode of Database Insights to enable for the DB instance.</p> <note>
         *        <p>
         *        Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
         *        </p>
         * @see DatabaseInsightsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseInsightsMode
         */
        Builder databaseInsightsMode(DatabaseInsightsMode databaseInsightsMode);

        /**
         * <p>
         * Specifies whether to enable Performance Insights for the DB instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance
         * Insights</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param enablePerformanceInsights
         *        Specifies whether to enable Performance Insights for the DB instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon
         *        Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePerformanceInsights(Boolean enablePerformanceInsights);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * </p>
         * <p>
         * If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default
         * KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account
         * has a different default KMS key for each Amazon Web Services Region.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * 
         * @param performanceInsightsKMSKeyId
         *        The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key.
         *        </p>
         *        <p>
         *        If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your
         *        default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
         *        Services account has a different default KMS key for each Amazon Web Services Region.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId);

        /**
         * <p>
         * The number of days to retain Performance Insights data.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months *
         * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>731</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>7</code> days
         * </p>
         * <p>
         * If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS returns an error.
         * </p>
         * 
         * @param performanceInsightsRetentionPeriod
         *        The number of days to retain Performance Insights data.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         *        </p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3
         *        months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>731</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>7</code> days
         *        </p>
         *        <p>
         *        If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS returns an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod);

        /**
         * <p>
         * The list of log types to enable for exporting to CloudWatch Logs. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * > Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to the following DB instances:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Aurora (CloudWatch Logs exports are managed by the DB cluster.)
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS Custom
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following values are valid for each DB engine:
         * </p>
         * <ul>
         * <li>
         * <p>
         * RDS for Db2 - <code>diag.log | notify.log | iam-db-auth-error</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MariaDB - <code>audit | error | general | slowquery | iam-db-auth-error</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for Microsoft SQL Server - <code>agent | error</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MySQL - <code>audit | error | general | slowquery | iam-db-auth-error</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for Oracle - <code>alert | audit | listener | trace | oemagent</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for PostgreSQL - <code>postgresql | upgrade | iam-db-auth-error</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of log types to enable for exporting to CloudWatch Logs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        > Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>
         *        <p>
         *        This setting doesn't apply to the following DB instances:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Aurora (CloudWatch Logs exports are managed by the DB cluster.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS Custom
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following values are valid for each DB engine:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        RDS for Db2 - <code>diag.log | notify.log | iam-db-auth-error</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for MariaDB - <code>audit | error | general | slowquery | iam-db-auth-error</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for Microsoft SQL Server - <code>agent | error</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for MySQL - <code>audit | error | general | slowquery | iam-db-auth-error</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for Oracle - <code>alert | audit | listener | trace | oemagent</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for PostgreSQL - <code>postgresql | upgrade | iam-db-auth-error</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports);

        /**
         * <p>
         * The list of log types to enable for exporting to CloudWatch Logs. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * > Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to the following DB instances:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Aurora (CloudWatch Logs exports are managed by the DB cluster.)
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS Custom
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following values are valid for each DB engine:
         * </p>
         * <ul>
         * <li>
         * <p>
         * RDS for Db2 - <code>diag.log | notify.log | iam-db-auth-error</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MariaDB - <code>audit | error | general | slowquery | iam-db-auth-error</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for Microsoft SQL Server - <code>agent | error</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MySQL - <code>audit | error | general | slowquery | iam-db-auth-error</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for Oracle - <code>alert | audit | listener | trace | oemagent</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for PostgreSQL - <code>postgresql | upgrade | iam-db-auth-error</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param enableCloudwatchLogsExports
         *        The list of log types to enable for exporting to CloudWatch Logs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        > Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>
         *        <p>
         *        This setting doesn't apply to the following DB instances:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Aurora (CloudWatch Logs exports are managed by the DB cluster.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS Custom
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following values are valid for each DB engine:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        RDS for Db2 - <code>diag.log | notify.log | iam-db-auth-error</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for MariaDB - <code>audit | error | general | slowquery | iam-db-auth-error</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for Microsoft SQL Server - <code>agent | error</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for MySQL - <code>audit | error | general | slowquery | iam-db-auth-error</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for Oracle - <code>alert | audit | listener | trace | oemagent</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for PostgreSQL - <code>postgresql | upgrade | iam-db-auth-error</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         * </p>
         * 
         * @param processorFeatures
         *        The number of CPU cores and the number of threads per core for the DB instance class of the DB
         *        instance.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorFeatures(Collection<ProcessorFeature> processorFeatures);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         * </p>
         * 
         * @param processorFeatures
         *        The number of CPU cores and the number of threads per core for the DB instance class of the DB
         *        instance.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorFeatures(ProcessorFeature... processorFeatures);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.ProcessorFeature.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.ProcessorFeature#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.ProcessorFeature.Builder#build()} is called immediately and
         * its result is passed to {@link #processorFeatures(List<ProcessorFeature>)}.
         * 
         * @param processorFeatures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.ProcessorFeature.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processorFeatures(java.util.Collection<ProcessorFeature>)
         */
        Builder processorFeatures(Consumer<ProcessorFeature.Builder>... processorFeatures);

        /**
         * <p>
         * Specifies whether the DB instance has deletion protection enabled. The database can't be deleted when
         * deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB
         * Instance</a>.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora DB instances. You can enable or disable deletion protection for
         * the DB cluster. For more information, see <code>CreateDBCluster</code>. DB instances in a DB cluster can be
         * deleted even when deletion protection is enabled for the DB cluster.
         * </p>
         * 
         * @param deletionProtection
         *        Specifies whether the DB instance has deletion protection enabled. The database can't be deleted when
         *        deletion protection is enabled. By default, deletion protection isn't enabled. For more information,
         *        see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">
         *        Deleting a DB Instance</a>.</p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora DB instances. You can enable or disable deletion
         *        protection for the DB cluster. For more information, see <code>CreateDBCluster</code>. DB instances in
         *        a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB
         * instance.
         * </p>
         * <p>
         * For more information about this setting, including limitations that apply to it, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
         * Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * This setting doesn't apply to the following DB instances:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Aurora (Storage is managed by the DB cluster.)
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS Custom
         * </p>
         * </li>
         * </ul>
         * 
         * @param maxAllocatedStorage
         *        The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB
         *        instance.</p>
         *        <p>
         *        For more information about this setting, including limitations that apply to it, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"
         *        > Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User
         *        Guide</i>.
         *        </p>
         *        <p>
         *        This setting doesn't apply to the following DB instances:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Aurora (Storage is managed by the DB cluster.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS Custom
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAllocatedStorage(Integer maxAllocatedStorage);

        /**
         * <p>
         * Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.
         * </p>
         * <p>
         * A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your
         * on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance
         * from outside of its virtual private cloud (VPC) on your local network.
         * </p>
         * <p>
         * For more information about RDS on Outposts, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on
         * Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * For more information about CoIPs, see <a
         * href="https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing">Customer-owned IP
         * addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.
         * </p>
         * 
         * @param enableCustomerOwnedIp
         *        Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.</p>
         *        <p>
         *        A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through
         *        your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the
         *        DB instance from outside of its virtual private cloud (VPC) on your local network.
         *        </p>
         *        <p>
         *        For more information about RDS on Outposts, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon
         *        RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        For more information about CoIPs, see <a
         *        href="https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing">Customer-owned
         *        IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCustomerOwnedIp(Boolean enableCustomerOwnedIp);

        /**
         * <p>
         * The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
         * </p>
         * <p>
         * This setting is required for RDS Custom.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The profile must exist in your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * The profile must have an IAM role that Amazon EC2 has permissions to assume.
         * </p>
         * </li>
         * <li>
         * <p>
         * The instance profile name and the associated IAM role name must start with the prefix
         * <code>AWSRDSCustom</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For the list of permissions required for the IAM role, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc">
         * Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * 
         * @param customIamInstanceProfile
         *        The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB
         *        instance.</p>
         *        <p>
         *        This setting is required for RDS Custom.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The profile must exist in your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The profile must have an IAM role that Amazon EC2 has permissions to assume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The instance profile name and the associated IAM role name must start with the prefix
         *        <code>AWSRDSCustom</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For the list of permissions required for the IAM role, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"
         *        > Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customIamInstanceProfile(String customIamInstanceProfile);

        /**
         * <p>
         * The location for storing automated backups and manual snapshots.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>local</code> (Dedicated Local Zone)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>outposts</code> (Amazon Web Services Outposts)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>region</code> (Amazon Web Services Region)
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>region</code>
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on
         * Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * 
         * @param backupTarget
         *        The location for storing automated backups and manual snapshots.</p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>local</code> (Dedicated Local Zone)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>outposts</code> (Amazon Web Services Outposts)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>region</code> (Amazon Web Services Region)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>region</code>
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon
         *        RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupTarget(String backupTarget);

        /**
         * <p>
         * The network type of the DB instance.
         * </p>
         * <p>
         * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A
         * <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
         * <code>DUAL</code>).
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
         * Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * Valid Values: <code>IPV4 | DUAL</code>
         * </p>
         * 
         * @param networkType
         *        The network type of the DB instance.</p>
         *        <p>
         *        The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A
         *        <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
         *        <code>DUAL</code>).
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
         *        Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        Valid Values: <code>IPV4 | DUAL</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * The storage throughput value, in mebibyte per second (MiBps), for the DB instance.
         * </p>
         * <p>
         * This setting applies only to the <code>gp3</code> storage type.
         * </p>
         * <p>
         * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         * </p>
         * 
         * @param storageThroughput
         *        The storage throughput value, in mebibyte per second (MiBps), for the DB instance.</p>
         *        <p>
         *        This setting applies only to the <code>gp3</code> storage type.
         *        </p>
         *        <p>
         *        This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageThroughput(Integer storageThroughput);

        /**
         * <p>
         * Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management
         * with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't manage the master user password with Amazon Web Services Secrets Manager if
         * <code>MasterUserPassword</code> is specified.
         * </p>
         * </li>
         * </ul>
         * 
         * @param manageMasterUserPassword
         *        Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password
         *        management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't manage the master user password with Amazon Web Services Secrets Manager if
         *        <code>MasterUserPassword</code> is specified.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manageMasterUserPassword(Boolean manageMasterUserPassword);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in
         * Amazon Web Services Secrets Manager.
         * </p>
         * <p>
         * This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets
         * Manager for the DB instance.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         * </p>
         * <p>
         * If you don't specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key
         * is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can't
         * use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed
         * KMS key.
         * </p>
         * <p>
         * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
         * different default KMS key for each Amazon Web Services Region.
         * </p>
         * 
         * @param masterUserSecretKmsKeyId
         *        The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and
         *        managed in Amazon Web Services Secrets Manager.</p>
         *        <p>
         *        This setting is valid only if the master user password is managed by RDS in Amazon Web Services
         *        Secrets Manager for the DB instance.
         *        </p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias
         *        ARN.
         *        </p>
         *        <p>
         *        If you don't specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code>
         *        KMS key is used to encrypt the secret. If the secret is in a different Amazon Web Services account,
         *        then you can't use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use
         *        a customer managed KMS key.
         *        </p>
         *        <p>
         *        There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has
         *        a different default KMS key for each Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserSecretKmsKeyId(String masterUserSecretKmsKeyId);

        /**
         * <p>
         * The CA certificate identifier to use for the DB instance's server certificate.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom DB instances.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt
         * a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
         * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param caCertificateIdentifier
         *        The CA certificate identifier to use for the DB instance's server certificate.</p>
         *        <p>
         *        This setting doesn't apply to RDS Custom DB instances.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to
         *        encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using
         *        SSL/TLS to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateIdentifier(String caCertificateIdentifier);

        /**
         * <p>
         * The Oracle system identifier (SID), which is the name of the Oracle database instance that manages your
         * database files. In this context, the term "Oracle database instance" refers exclusively to the system global
         * area (SGA) and Oracle background processes. If you don't specify a SID, the value defaults to
         * <code>RDSCDB</code>. The Oracle SID is also the name of your CDB.
         * </p>
         * 
         * @param dbSystemId
         *        The Oracle system identifier (SID), which is the name of the Oracle database instance that manages
         *        your database files. In this context, the term "Oracle database instance" refers exclusively to the
         *        system global area (SGA) and Oracle background processes. If you don't specify a SID, the value
         *        defaults to <code>RDSCDB</code>. The Oracle SID is also the name of your CDB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSystemId(String dbSystemId);

        /**
         * <p>
         * Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
         * </p>
         * 
         * @param dedicatedLogVolume
         *        Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedLogVolume(Boolean dedicatedLogVolume);

        /**
         * <p>
         * Specifies whether to use the multi-tenant configuration or the single-tenant configuration (default). This
         * parameter only applies to RDS for Oracle container database (CDB) engines.
         * </p>
         * <p>
         * Note the following restrictions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The DB engine that you specify in the request must support the multi-tenant configuration. If you attempt to
         * enable the multi-tenant configuration on a DB engine that doesn't support it, the request fails.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify the multi-tenant configuration when you create your DB instance, you can't later modify this
         * DB instance to use the single-tenant configuration.
         * </p>
         * </li>
         * </ul>
         * 
         * @param multiTenant
         *        Specifies whether to use the multi-tenant configuration or the single-tenant configuration (default).
         *        This parameter only applies to RDS for Oracle container database (CDB) engines.</p>
         *        <p>
         *        Note the following restrictions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The DB engine that you specify in the request must support the multi-tenant configuration. If you
         *        attempt to enable the multi-tenant configuration on a DB engine that doesn't support it, the request
         *        fails.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify the multi-tenant configuration when you create your DB instance, you can't later modify
         *        this DB instance to use the single-tenant configuration.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiTenant(Boolean multiTenant);

        /**
         * <p>
         * The life cycle type for this DB instance.
         * </p>
         * <note>
         * <p>
         * By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB
         * instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended
         * Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case,
         * creating the DB instance will fail if the DB major version is past its end of standard support date.
         * </p>
         * </note>
         * <p>
         * This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life
         * cycle type is managed by the DB cluster.
         * </p>
         * <p>
         * You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended
         * Support, you can run the selected major engine version on your DB instance past the end of standard support
         * for that engine version. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS Extended
         * Support with Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
         * </p>
         * <p>
         * Default: <code>open-source-rds-extended-support</code>
         * </p>
         * 
         * @param engineLifecycleSupport
         *        The life cycle type for this DB instance.</p> <note>
         *        <p>
         *        By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB
         *        instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for
         *        Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In
         *        this case, creating the DB instance will fail if the DB major version is past its end of standard
         *        support date.
         *        </p>
         *        </note>
         *        <p>
         *        This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the
         *        life cycle type is managed by the DB cluster.
         *        </p>
         *        <p>
         *        You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS
         *        Extended Support, you can run the selected major engine version on your DB instance past the end of
         *        standard support for that engine version. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS
         *        Extended Support with Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        Valid Values:
         *        <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
         *        </p>
         *        <p>
         *        Default: <code>open-source-rds-extended-support</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineLifecycleSupport(String engineLifecycleSupport);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbName;

        private String dbInstanceIdentifier;

        private Integer allocatedStorage;

        private String dbInstanceClass;

        private String engine;

        private String masterUsername;

        private String masterUserPassword;

        private List<String> dbSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String availabilityZone;

        private String dbSubnetGroupName;

        private String preferredMaintenanceWindow;

        private String dbParameterGroupName;

        private Integer backupRetentionPeriod;

        private String preferredBackupWindow;

        private Integer port;

        private Boolean multiAZ;

        private String engineVersion;

        private Boolean autoMinorVersionUpgrade;

        private String licenseModel;

        private Integer iops;

        private String optionGroupName;

        private String characterSetName;

        private String ncharCharacterSetName;

        private Boolean publiclyAccessible;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String dbClusterIdentifier;

        private String storageType;

        private String tdeCredentialArn;

        private String tdeCredentialPassword;

        private Boolean storageEncrypted;

        private String kmsKeyId;

        private String domain;

        private String domainFqdn;

        private String domainOu;

        private String domainAuthSecretArn;

        private List<String> domainDnsIps = DefaultSdkAutoConstructList.getInstance();

        private Boolean copyTagsToSnapshot;

        private Integer monitoringInterval;

        private String monitoringRoleArn;

        private String domainIAMRoleName;

        private Integer promotionTier;

        private String timezone;

        private Boolean enableIAMDatabaseAuthentication;

        private String databaseInsightsMode;

        private Boolean enablePerformanceInsights;

        private String performanceInsightsKMSKeyId;

        private Integer performanceInsightsRetentionPeriod;

        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private List<ProcessorFeature> processorFeatures = DefaultSdkAutoConstructList.getInstance();

        private Boolean deletionProtection;

        private Integer maxAllocatedStorage;

        private Boolean enableCustomerOwnedIp;

        private String customIamInstanceProfile;

        private String backupTarget;

        private String networkType;

        private Integer storageThroughput;

        private Boolean manageMasterUserPassword;

        private String masterUserSecretKmsKeyId;

        private String caCertificateIdentifier;

        private String dbSystemId;

        private Boolean dedicatedLogVolume;

        private Boolean multiTenant;

        private String engineLifecycleSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbInstanceRequest model) {
            super(model);
            dbName(model.dbName);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            allocatedStorage(model.allocatedStorage);
            dbInstanceClass(model.dbInstanceClass);
            engine(model.engine);
            masterUsername(model.masterUsername);
            masterUserPassword(model.masterUserPassword);
            dbSecurityGroups(model.dbSecurityGroups);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            availabilityZone(model.availabilityZone);
            dbSubnetGroupName(model.dbSubnetGroupName);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            dbParameterGroupName(model.dbParameterGroupName);
            backupRetentionPeriod(model.backupRetentionPeriod);
            preferredBackupWindow(model.preferredBackupWindow);
            port(model.port);
            multiAZ(model.multiAZ);
            engineVersion(model.engineVersion);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            licenseModel(model.licenseModel);
            iops(model.iops);
            optionGroupName(model.optionGroupName);
            characterSetName(model.characterSetName);
            ncharCharacterSetName(model.ncharCharacterSetName);
            publiclyAccessible(model.publiclyAccessible);
            tags(model.tags);
            dbClusterIdentifier(model.dbClusterIdentifier);
            storageType(model.storageType);
            tdeCredentialArn(model.tdeCredentialArn);
            tdeCredentialPassword(model.tdeCredentialPassword);
            storageEncrypted(model.storageEncrypted);
            kmsKeyId(model.kmsKeyId);
            domain(model.domain);
            domainFqdn(model.domainFqdn);
            domainOu(model.domainOu);
            domainAuthSecretArn(model.domainAuthSecretArn);
            domainDnsIps(model.domainDnsIps);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
            monitoringInterval(model.monitoringInterval);
            monitoringRoleArn(model.monitoringRoleArn);
            domainIAMRoleName(model.domainIAMRoleName);
            promotionTier(model.promotionTier);
            timezone(model.timezone);
            enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            databaseInsightsMode(model.databaseInsightsMode);
            enablePerformanceInsights(model.enablePerformanceInsights);
            performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            processorFeatures(model.processorFeatures);
            deletionProtection(model.deletionProtection);
            maxAllocatedStorage(model.maxAllocatedStorage);
            enableCustomerOwnedIp(model.enableCustomerOwnedIp);
            customIamInstanceProfile(model.customIamInstanceProfile);
            backupTarget(model.backupTarget);
            networkType(model.networkType);
            storageThroughput(model.storageThroughput);
            manageMasterUserPassword(model.manageMasterUserPassword);
            masterUserSecretKmsKeyId(model.masterUserSecretKmsKeyId);
            caCertificateIdentifier(model.caCertificateIdentifier);
            dbSystemId(model.dbSystemId);
            dedicatedLogVolume(model.dedicatedLogVolume);
            multiTenant(model.multiTenant);
            engineLifecycleSupport(model.engineLifecycleSupport);
        }

        public final String getDbName() {
            return dbName;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final Collection<String> getDbSecurityGroups() {
            if (dbSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return dbSecurityGroups;
        }

        public final void setDbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
        }

        @Override
        public final Builder dbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(String... dbSecurityGroups) {
            dbSecurityGroups(Arrays.asList(dbSecurityGroups));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getDbParameterGroupName() {
            return dbParameterGroupName;
        }

        public final void setDbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final String getCharacterSetName() {
            return characterSetName;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final String getNcharCharacterSetName() {
            return ncharCharacterSetName;
        }

        public final void setNcharCharacterSetName(String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
        }

        @Override
        public final Builder ncharCharacterSetName(String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final String getTdeCredentialArn() {
            return tdeCredentialArn;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final String getTdeCredentialPassword() {
            return tdeCredentialPassword;
        }

        public final void setTdeCredentialPassword(String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
        }

        @Override
        public final Builder tdeCredentialPassword(String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainFqdn() {
            return domainFqdn;
        }

        public final void setDomainFqdn(String domainFqdn) {
            this.domainFqdn = domainFqdn;
        }

        @Override
        public final Builder domainFqdn(String domainFqdn) {
            this.domainFqdn = domainFqdn;
            return this;
        }

        public final String getDomainOu() {
            return domainOu;
        }

        public final void setDomainOu(String domainOu) {
            this.domainOu = domainOu;
        }

        @Override
        public final Builder domainOu(String domainOu) {
            this.domainOu = domainOu;
            return this;
        }

        public final String getDomainAuthSecretArn() {
            return domainAuthSecretArn;
        }

        public final void setDomainAuthSecretArn(String domainAuthSecretArn) {
            this.domainAuthSecretArn = domainAuthSecretArn;
        }

        @Override
        public final Builder domainAuthSecretArn(String domainAuthSecretArn) {
            this.domainAuthSecretArn = domainAuthSecretArn;
            return this;
        }

        public final Collection<String> getDomainDnsIps() {
            if (domainDnsIps instanceof SdkAutoConstructList) {
                return null;
            }
            return domainDnsIps;
        }

        public final void setDomainDnsIps(Collection<String> domainDnsIps) {
            this.domainDnsIps = StringListCopier.copy(domainDnsIps);
        }

        @Override
        public final Builder domainDnsIps(Collection<String> domainDnsIps) {
            this.domainDnsIps = StringListCopier.copy(domainDnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainDnsIps(String... domainDnsIps) {
            domainDnsIps(Arrays.asList(domainDnsIps));
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final Integer getMonitoringInterval() {
            return monitoringInterval;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final String getMonitoringRoleArn() {
            return monitoringRoleArn;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final String getDomainIAMRoleName() {
            return domainIAMRoleName;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final Integer getPromotionTier() {
            return promotionTier;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        @Override
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return enableIAMDatabaseAuthentication;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final String getDatabaseInsightsMode() {
            return databaseInsightsMode;
        }

        public final void setDatabaseInsightsMode(String databaseInsightsMode) {
            this.databaseInsightsMode = databaseInsightsMode;
        }

        @Override
        public final Builder databaseInsightsMode(String databaseInsightsMode) {
            this.databaseInsightsMode = databaseInsightsMode;
            return this;
        }

        @Override
        public final Builder databaseInsightsMode(DatabaseInsightsMode databaseInsightsMode) {
            this.databaseInsightsMode(databaseInsightsMode == null ? null : databaseInsightsMode.toString());
            return this;
        }

        public final Boolean getEnablePerformanceInsights() {
            return enablePerformanceInsights;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        @Override
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return performanceInsightsKMSKeyId;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return performanceInsightsRetentionPeriod;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        @Override
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enableCloudwatchLogsExports;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports) {
            enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final List<ProcessorFeature.Builder> getProcessorFeatures() {
            List<ProcessorFeature.Builder> result = ProcessorFeatureListCopier.copyToBuilder(this.processorFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessorFeatures(Collection<ProcessorFeature.BuilderImpl> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copyFromBuilder(processorFeatures);
        }

        @Override
        public final Builder processorFeatures(Collection<ProcessorFeature> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copy(processorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(ProcessorFeature... processorFeatures) {
            processorFeatures(Arrays.asList(processorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(Consumer<ProcessorFeature.Builder>... processorFeatures) {
            processorFeatures(Stream.of(processorFeatures).map(c -> ProcessorFeature.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Integer getMaxAllocatedStorage() {
            return maxAllocatedStorage;
        }

        public final void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
        }

        @Override
        public final Builder maxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public final Boolean getEnableCustomerOwnedIp() {
            return enableCustomerOwnedIp;
        }

        public final void setEnableCustomerOwnedIp(Boolean enableCustomerOwnedIp) {
            this.enableCustomerOwnedIp = enableCustomerOwnedIp;
        }

        @Override
        public final Builder enableCustomerOwnedIp(Boolean enableCustomerOwnedIp) {
            this.enableCustomerOwnedIp = enableCustomerOwnedIp;
            return this;
        }

        public final String getCustomIamInstanceProfile() {
            return customIamInstanceProfile;
        }

        public final void setCustomIamInstanceProfile(String customIamInstanceProfile) {
            this.customIamInstanceProfile = customIamInstanceProfile;
        }

        @Override
        public final Builder customIamInstanceProfile(String customIamInstanceProfile) {
            this.customIamInstanceProfile = customIamInstanceProfile;
            return this;
        }

        public final String getBackupTarget() {
            return backupTarget;
        }

        public final void setBackupTarget(String backupTarget) {
            this.backupTarget = backupTarget;
        }

        @Override
        public final Builder backupTarget(String backupTarget) {
            this.backupTarget = backupTarget;
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public final Integer getStorageThroughput() {
            return storageThroughput;
        }

        public final void setStorageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
        }

        @Override
        public final Builder storageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
            return this;
        }

        public final Boolean getManageMasterUserPassword() {
            return manageMasterUserPassword;
        }

        public final void setManageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
        }

        @Override
        public final Builder manageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
            return this;
        }

        public final String getMasterUserSecretKmsKeyId() {
            return masterUserSecretKmsKeyId;
        }

        public final void setMasterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
        }

        @Override
        public final Builder masterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
            return this;
        }

        public final String getCaCertificateIdentifier() {
            return caCertificateIdentifier;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final String getDbSystemId() {
            return dbSystemId;
        }

        public final void setDbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
        }

        @Override
        public final Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public final Boolean getDedicatedLogVolume() {
            return dedicatedLogVolume;
        }

        public final void setDedicatedLogVolume(Boolean dedicatedLogVolume) {
            this.dedicatedLogVolume = dedicatedLogVolume;
        }

        @Override
        public final Builder dedicatedLogVolume(Boolean dedicatedLogVolume) {
            this.dedicatedLogVolume = dedicatedLogVolume;
            return this;
        }

        public final Boolean getMultiTenant() {
            return multiTenant;
        }

        public final void setMultiTenant(Boolean multiTenant) {
            this.multiTenant = multiTenant;
        }

        @Override
        public final Builder multiTenant(Boolean multiTenant) {
            this.multiTenant = multiTenant;
            return this;
        }

        public final String getEngineLifecycleSupport() {
            return engineLifecycleSupport;
        }

        public final void setEngineLifecycleSupport(String engineLifecycleSupport) {
            this.engineLifecycleSupport = engineLifecycleSupport;
        }

        @Override
        public final Builder engineLifecycleSupport(String engineLifecycleSupport) {
            this.engineLifecycleSupport = engineLifecycleSupport;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbInstanceRequest build() {
            return new CreateDbInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
