/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBSecurityGroup;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupsCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbSecurityGroupsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbSecurityGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbSecurityGroupsResponse.getter(DescribeDbSecurityGroupsResponse::marker)).setter(DescribeDbSecurityGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<DBSecurityGroup>> DB_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBSecurityGroups").getter(DescribeDbSecurityGroupsResponse.getter(DescribeDbSecurityGroupsResponse::dbSecurityGroups)).setter(DescribeDbSecurityGroupsResponse.setter(Builder::dbSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroups").build(), ListTrait.builder().memberLocationName("DBSecurityGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBSecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroup").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, DB_SECURITY_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDbSecurityGroupsResponse.memberNameToFieldInitializer();
    private final String marker;
    private final List<DBSecurityGroup> dbSecurityGroups;

    private DescribeDbSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbSecurityGroups = builder.dbSecurityGroups;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasDbSecurityGroups() {
        return this.dbSecurityGroups != null && !(this.dbSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<DBSecurityGroup> dbSecurityGroups() {
        return this.dbSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbSecurityGroups() ? this.dbSecurityGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbSecurityGroupsResponse)) {
            return false;
        }
        DescribeDbSecurityGroupsResponse other = (DescribeDbSecurityGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasDbSecurityGroups() == other.hasDbSecurityGroups() && Objects.equals(this.dbSecurityGroups(), other.dbSecurityGroups());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbSecurityGroupsResponse").add("Marker", (Object)this.marker()).add("DBSecurityGroups", this.hasDbSecurityGroups() ? this.dbSecurityGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.dbSecurityGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Marker", MARKER_FIELD);
        map.put("DBSecurityGroups", DB_SECURITY_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbSecurityGroupsResponse, T> g) {
        return obj -> g.apply((DescribeDbSecurityGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBSecurityGroup> dbSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbSecurityGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbSecurityGroups(model.dbSecurityGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<DBSecurityGroup.Builder> getDbSecurityGroups() {
            List<DBSecurityGroup.Builder> result = DBSecurityGroupsCopier.copyToBuilder(this.dbSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbSecurityGroups(Collection<DBSecurityGroup.BuilderImpl> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupsCopier.copyFromBuilder(dbSecurityGroups);
        }

        @Override
        public final Builder dbSecurityGroups(Collection<DBSecurityGroup> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupsCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(DBSecurityGroup ... dbSecurityGroups) {
            this.dbSecurityGroups(Arrays.asList(dbSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(Consumer<DBSecurityGroup.Builder> ... dbSecurityGroups) {
            this.dbSecurityGroups(Stream.of(dbSecurityGroups).map(c -> (DBSecurityGroup)((DBSecurityGroup.Builder)DBSecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDbSecurityGroupsResponse build() {
            return new DescribeDbSecurityGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbSecurityGroupsResponse> {
        public Builder marker(String var1);

        public Builder dbSecurityGroups(Collection<DBSecurityGroup> var1);

        public Builder dbSecurityGroups(DBSecurityGroup ... var1);

        public Builder dbSecurityGroups(Consumer<DBSecurityGroup.Builder> ... var1);
    }
}

