/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbClusterRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyDbClusterRequest.Builder, ModifyDbClusterRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(ModifyDbClusterRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> NEW_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewDBClusterIdentifier").getter(getter(ModifyDbClusterRequest::newDBClusterIdentifier))
            .setter(setter(Builder::newDBClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewDBClusterIdentifier").build())
            .build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApplyImmediately").getter(getter(ModifyDbClusterRequest::applyImmediately))
            .setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(ModifyDbClusterRequest::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBClusterParameterGroupName")
            .getter(getter(ModifyDbClusterRequest::dbClusterParameterGroupName))
            .setter(setter(Builder::dbClusterParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName")
                    .build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(ModifyDbClusterRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(ModifyDbClusterRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserPassword").getter(getter(ModifyDbClusterRequest::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(ModifyDbClusterRequest::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredBackupWindow").getter(getter(ModifyDbClusterRequest::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(ModifyDbClusterRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIAMDatabaseAuthentication")
            .getter(getter(ModifyDbClusterRequest::enableIAMDatabaseAuthentication))
            .setter(setter(Builder::enableIAMDatabaseAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication")
                    .build()).build();

    private static final SdkField<Long> BACKTRACK_WINDOW_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BacktrackWindow").getter(getter(ModifyDbClusterRequest::backtrackWindow))
            .setter(setter(Builder::backtrackWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackWindow").build()).build();

    private static final SdkField<CloudwatchLogsExportConfiguration> CLOUDWATCH_LOGS_EXPORT_CONFIGURATION_FIELD = SdkField
            .<CloudwatchLogsExportConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CloudwatchLogsExportConfiguration")
            .getter(getter(ModifyDbClusterRequest::cloudwatchLogsExportConfiguration))
            .setter(setter(Builder::cloudwatchLogsExportConfiguration))
            .constructor(CloudwatchLogsExportConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudwatchLogsExportConfiguration")
                    .build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(ModifyDbClusterRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> ALLOW_MAJOR_VERSION_UPGRADE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AllowMajorVersionUpgrade")
            .getter(getter(ModifyDbClusterRequest::allowMajorVersionUpgrade)).setter(setter(Builder::allowMajorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMajorVersionUpgrade").build())
            .build();

    private static final SdkField<String> DB_INSTANCE_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceParameterGroupName")
            .getter(getter(ModifyDbClusterRequest::dbInstanceParameterGroupName))
            .setter(setter(Builder::dbInstanceParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceParameterGroupName")
                    .build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(ModifyDbClusterRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainIAMRoleName").getter(getter(ModifyDbClusterRequest::domainIAMRoleName))
            .setter(setter(Builder::domainIAMRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()).build();

    private static final SdkField<ScalingConfiguration> SCALING_CONFIGURATION_FIELD = SdkField
            .<ScalingConfiguration> builder(MarshallingType.SDK_POJO).memberName("ScalingConfiguration")
            .getter(getter(ModifyDbClusterRequest::scalingConfiguration)).setter(setter(Builder::scalingConfiguration))
            .constructor(ScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingConfiguration").build())
            .build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(ModifyDbClusterRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<Boolean> ENABLE_HTTP_ENDPOINT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableHttpEndpoint").getter(getter(ModifyDbClusterRequest::enableHttpEndpoint))
            .setter(setter(Builder::enableHttpEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableHttpEndpoint").build())
            .build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToSnapshot").getter(getter(ModifyDbClusterRequest::copyTagsToSnapshot))
            .setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final SdkField<Boolean> ENABLE_GLOBAL_WRITE_FORWARDING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableGlobalWriteForwarding")
            .getter(getter(ModifyDbClusterRequest::enableGlobalWriteForwarding))
            .setter(setter(Builder::enableGlobalWriteForwarding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableGlobalWriteForwarding")
                    .build()).build();

    private static final SdkField<String> DB_CLUSTER_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterInstanceClass").getter(getter(ModifyDbClusterRequest::dbClusterInstanceClass))
            .setter(setter(Builder::dbClusterInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterInstanceClass").build())
            .build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(ModifyDbClusterRequest::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(ModifyDbClusterRequest::storageType)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(ModifyDbClusterRequest::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(ModifyDbClusterRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkType").getter(getter(ModifyDbClusterRequest::networkType)).setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()).build();

    private static final SdkField<ServerlessV2ScalingConfiguration> SERVERLESS_V2_SCALING_CONFIGURATION_FIELD = SdkField
            .<ServerlessV2ScalingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ServerlessV2ScalingConfiguration")
            .getter(getter(ModifyDbClusterRequest::serverlessV2ScalingConfiguration))
            .setter(setter(Builder::serverlessV2ScalingConfiguration))
            .constructor(ServerlessV2ScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessV2ScalingConfiguration")
                    .build()).build();

    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MonitoringInterval").getter(getter(ModifyDbClusterRequest::monitoringInterval))
            .setter(setter(Builder::monitoringInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build())
            .build();

    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringRoleArn").getter(getter(ModifyDbClusterRequest::monitoringRoleArn))
            .setter(setter(Builder::monitoringRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()).build();

    private static final SdkField<String> DATABASE_INSIGHTS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseInsightsMode").getter(getter(ModifyDbClusterRequest::databaseInsightsModeAsString))
            .setter(setter(Builder::databaseInsightsMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInsightsMode").build())
            .build();

    private static final SdkField<Boolean> ENABLE_PERFORMANCE_INSIGHTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnablePerformanceInsights")
            .getter(getter(ModifyDbClusterRequest::enablePerformanceInsights)).setter(setter(Builder::enablePerformanceInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePerformanceInsights").build())
            .build();

    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PerformanceInsightsKMSKeyId")
            .getter(getter(ModifyDbClusterRequest::performanceInsightsKMSKeyId))
            .setter(setter(Builder::performanceInsightsKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId")
                    .build()).build();

    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PerformanceInsightsRetentionPeriod")
            .getter(getter(ModifyDbClusterRequest::performanceInsightsRetentionPeriod))
            .setter(setter(Builder::performanceInsightsRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod")
                    .build()).build();

    private static final SdkField<Boolean> MANAGE_MASTER_USER_PASSWORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("ManageMasterUserPassword")
            .getter(getter(ModifyDbClusterRequest::manageMasterUserPassword)).setter(setter(Builder::manageMasterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManageMasterUserPassword").build())
            .build();

    private static final SdkField<Boolean> ROTATE_MASTER_USER_PASSWORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("RotateMasterUserPassword")
            .getter(getter(ModifyDbClusterRequest::rotateMasterUserPassword)).setter(setter(Builder::rotateMasterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotateMasterUserPassword").build())
            .build();

    private static final SdkField<Boolean> ENABLE_LOCAL_WRITE_FORWARDING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableLocalWriteForwarding")
            .getter(getter(ModifyDbClusterRequest::enableLocalWriteForwarding))
            .setter(setter(Builder::enableLocalWriteForwarding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableLocalWriteForwarding").build())
            .build();

    private static final SdkField<String> MASTER_USER_SECRET_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserSecretKmsKeyId").getter(getter(ModifyDbClusterRequest::masterUserSecretKmsKeyId))
            .setter(setter(Builder::masterUserSecretKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserSecretKmsKeyId").build())
            .build();

    private static final SdkField<String> ENGINE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineMode").getter(getter(ModifyDbClusterRequest::engineMode)).setter(setter(Builder::engineMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineMode").build()).build();

    private static final SdkField<Boolean> ALLOW_ENGINE_MODE_CHANGE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowEngineModeChange").getter(getter(ModifyDbClusterRequest::allowEngineModeChange))
            .setter(setter(Builder::allowEngineModeChange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowEngineModeChange").build())
            .build();

    private static final SdkField<String> AWS_BACKUP_RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsBackupRecoveryPointArn").getter(getter(ModifyDbClusterRequest::awsBackupRecoveryPointArn))
            .setter(setter(Builder::awsBackupRecoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsBackupRecoveryPointArn").build())
            .build();

    private static final SdkField<Boolean> ENABLE_LIMITLESS_DATABASE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableLimitlessDatabase").getter(getter(ModifyDbClusterRequest::enableLimitlessDatabase))
            .setter(setter(Builder::enableLimitlessDatabase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableLimitlessDatabase").build())
            .build();

    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CACertificateIdentifier").getter(getter(ModifyDbClusterRequest::caCertificateIdentifier))
            .setter(setter(Builder::caCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build())
            .build();

    private static final SdkField<String> MASTER_USER_AUTHENTICATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MasterUserAuthenticationType")
            .getter(getter(ModifyDbClusterRequest::masterUserAuthenticationTypeAsString))
            .setter(setter(Builder::masterUserAuthenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserAuthenticationType")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD,
            NEW_DB_CLUSTER_IDENTIFIER_FIELD, APPLY_IMMEDIATELY_FIELD, BACKUP_RETENTION_PERIOD_FIELD,
            DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, PORT_FIELD, MASTER_USER_PASSWORD_FIELD,
            OPTION_GROUP_NAME_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD,
            ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, BACKTRACK_WINDOW_FIELD, CLOUDWATCH_LOGS_EXPORT_CONFIGURATION_FIELD,
            ENGINE_VERSION_FIELD, ALLOW_MAJOR_VERSION_UPGRADE_FIELD, DB_INSTANCE_PARAMETER_GROUP_NAME_FIELD, DOMAIN_FIELD,
            DOMAIN_IAM_ROLE_NAME_FIELD, SCALING_CONFIGURATION_FIELD, DELETION_PROTECTION_FIELD, ENABLE_HTTP_ENDPOINT_FIELD,
            COPY_TAGS_TO_SNAPSHOT_FIELD, ENABLE_GLOBAL_WRITE_FORWARDING_FIELD, DB_CLUSTER_INSTANCE_CLASS_FIELD,
            ALLOCATED_STORAGE_FIELD, STORAGE_TYPE_FIELD, IOPS_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, NETWORK_TYPE_FIELD,
            SERVERLESS_V2_SCALING_CONFIGURATION_FIELD, MONITORING_INTERVAL_FIELD, MONITORING_ROLE_ARN_FIELD,
            DATABASE_INSIGHTS_MODE_FIELD, ENABLE_PERFORMANCE_INSIGHTS_FIELD, PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD,
            PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD, MANAGE_MASTER_USER_PASSWORD_FIELD, ROTATE_MASTER_USER_PASSWORD_FIELD,
            ENABLE_LOCAL_WRITE_FORWARDING_FIELD, MASTER_USER_SECRET_KMS_KEY_ID_FIELD, ENGINE_MODE_FIELD,
            ALLOW_ENGINE_MODE_CHANGE_FIELD, AWS_BACKUP_RECOVERY_POINT_ARN_FIELD, ENABLE_LIMITLESS_DATABASE_FIELD,
            CA_CERTIFICATE_IDENTIFIER_FIELD, MASTER_USER_AUTHENTICATION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbClusterIdentifier;

    private final String newDBClusterIdentifier;

    private final Boolean applyImmediately;

    private final Integer backupRetentionPeriod;

    private final String dbClusterParameterGroupName;

    private final List<String> vpcSecurityGroupIds;

    private final Integer port;

    private final String masterUserPassword;

    private final String optionGroupName;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final Boolean enableIAMDatabaseAuthentication;

    private final Long backtrackWindow;

    private final CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;

    private final String engineVersion;

    private final Boolean allowMajorVersionUpgrade;

    private final String dbInstanceParameterGroupName;

    private final String domain;

    private final String domainIAMRoleName;

    private final ScalingConfiguration scalingConfiguration;

    private final Boolean deletionProtection;

    private final Boolean enableHttpEndpoint;

    private final Boolean copyTagsToSnapshot;

    private final Boolean enableGlobalWriteForwarding;

    private final String dbClusterInstanceClass;

    private final Integer allocatedStorage;

    private final String storageType;

    private final Integer iops;

    private final Boolean autoMinorVersionUpgrade;

    private final String networkType;

    private final ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;

    private final Integer monitoringInterval;

    private final String monitoringRoleArn;

    private final String databaseInsightsMode;

    private final Boolean enablePerformanceInsights;

    private final String performanceInsightsKMSKeyId;

    private final Integer performanceInsightsRetentionPeriod;

    private final Boolean manageMasterUserPassword;

    private final Boolean rotateMasterUserPassword;

    private final Boolean enableLocalWriteForwarding;

    private final String masterUserSecretKmsKeyId;

    private final String engineMode;

    private final Boolean allowEngineModeChange;

    private final String awsBackupRecoveryPointArn;

    private final Boolean enableLimitlessDatabase;

    private final String caCertificateIdentifier;

    private final String masterUserAuthenticationType;

    private ModifyDbClusterRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.newDBClusterIdentifier = builder.newDBClusterIdentifier;
        this.applyImmediately = builder.applyImmediately;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.port = builder.port;
        this.masterUserPassword = builder.masterUserPassword;
        this.optionGroupName = builder.optionGroupName;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.backtrackWindow = builder.backtrackWindow;
        this.cloudwatchLogsExportConfiguration = builder.cloudwatchLogsExportConfiguration;
        this.engineVersion = builder.engineVersion;
        this.allowMajorVersionUpgrade = builder.allowMajorVersionUpgrade;
        this.dbInstanceParameterGroupName = builder.dbInstanceParameterGroupName;
        this.domain = builder.domain;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.scalingConfiguration = builder.scalingConfiguration;
        this.deletionProtection = builder.deletionProtection;
        this.enableHttpEndpoint = builder.enableHttpEndpoint;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.enableGlobalWriteForwarding = builder.enableGlobalWriteForwarding;
        this.dbClusterInstanceClass = builder.dbClusterInstanceClass;
        this.allocatedStorage = builder.allocatedStorage;
        this.storageType = builder.storageType;
        this.iops = builder.iops;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.networkType = builder.networkType;
        this.serverlessV2ScalingConfiguration = builder.serverlessV2ScalingConfiguration;
        this.monitoringInterval = builder.monitoringInterval;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.databaseInsightsMode = builder.databaseInsightsMode;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.manageMasterUserPassword = builder.manageMasterUserPassword;
        this.rotateMasterUserPassword = builder.rotateMasterUserPassword;
        this.enableLocalWriteForwarding = builder.enableLocalWriteForwarding;
        this.masterUserSecretKmsKeyId = builder.masterUserSecretKmsKeyId;
        this.engineMode = builder.engineMode;
        this.allowEngineModeChange = builder.allowEngineModeChange;
        this.awsBackupRecoveryPointArn = builder.awsBackupRecoveryPointArn;
        this.enableLimitlessDatabase = builder.enableLimitlessDatabase;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.masterUserAuthenticationType = builder.masterUserAuthenticationType;
    }

    /**
     * <p>
     * The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing DB cluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing DB cluster.
     *         </p>
     *         </li>
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase
     * string.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>my-cluster2</code>
     * </p>
     * 
     * @return The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a
     *         lowercase string.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>my-cluster2</code>
     */
    public final String newDBClusterIdentifier() {
        return newDBClusterIdentifier;
    }

    /**
     * <p>
     * Specifies whether the modifications in this request are asynchronously applied as soon as possible, regardless of
     * the <code>PreferredMaintenanceWindow</code> setting for the DB cluster. If this parameter is disabled, changes to
     * the DB cluster are applied during the next maintenance window.
     * </p>
     * <p>
     * Most modifications can be applied immediately or during the next scheduled maintenance window. Some
     * modifications, such as turning on deletion protection and changing the master password, are applied
     * immediately—regardless of when you choose to apply them.
     * </p>
     * <p>
     * By default, this parameter is disabled.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return Specifies whether the modifications in this request are asynchronously applied as soon as possible,
     *         regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB cluster. If this parameter
     *         is disabled, changes to the DB cluster are applied during the next maintenance window.</p>
     *         <p>
     *         Most modifications can be applied immediately or during the next scheduled maintenance window. Some
     *         modifications, such as turning on deletion protection and changing the master password, are applied
     *         immediately—regardless of when you choose to apply them.
     *         </p>
     *         <p>
     *         By default, this parameter is disabled.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Boolean applyImmediately() {
        return applyImmediately;
    }

    /**
     * <p>
     * The number of days for which automated backups are retained. Specify a minimum value of <code>1</code>.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Default: <code>1</code>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be a value from 1 to 35.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of days for which automated backups are retained. Specify a minimum value of <code>1</code>
     *         .</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Default: <code>1</code>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be a value from 1 to 35.
     *         </p>
     *         </li>
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * The name of the DB cluster parameter group to use for the DB cluster.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The name of the DB cluster parameter group to use for the DB cluster.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String dbClusterParameterGroupName() {
        return dbClusterParameterGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EC2 VPC security groups to associate with this DB cluster.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of EC2 VPC security groups to associate with this DB cluster.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The port number on which the DB cluster accepts connections.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * <p>
     * Valid Values: <code>1150-65535</code>
     * </p>
     * <p>
     * Default: The same port as the original DB cluster.
     * </p>
     * 
     * @return The port number on which the DB cluster accepts connections.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     *         </p>
     *         <p>
     *         Valid Values: <code>1150-65535</code>
     *         </p>
     *         <p>
     *         Default: The same port as the original DB cluster.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The new password for the master database user.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 8 to 41 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can contain any printable ASCII character except "/", """, or "@".
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be specified if <code>ManageMasterUserPassword</code> is turned on.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The new password for the master database user.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 8 to 41 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can contain any printable ASCII character except "/", """, or "@".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be specified if <code>ManageMasterUserPassword</code> is turned on.
     *         </p>
     *         </li>
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * The option group to associate the DB cluster with.
     * </p>
     * <p>
     * DB clusters are associated with a default option group that can't be modified.
     * </p>
     * 
     * @return The option group to associate the DB cluster with.</p>
     *         <p>
     *         DB clusters are associated with a default option group that can't be modified.
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created if automated backups are enabled, using the
     * <code>BackupRetentionPeriod</code> parameter.
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services
     * Region. To view the time blocks available, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"
     * > Backup window</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the format <code>hh24:mi-hh24:mi</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be in Universal Coordinated Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The daily time range during which automated backups are created if automated backups are enabled, using
     *         the <code>BackupRetentionPeriod</code> parameter.</p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
     *         Services Region. To view the time blocks available, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"
     *         > Backup window</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the format <code>hh24:mi-hh24:mi</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be in Universal Coordinated Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not conflict with the preferred maintenance window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services
     * Region, occurring on a random day of the week. To see the time blocks available, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
     * > Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Days must be one of <code>Mon | Tue | Wed | Thu | Fri | Sat | Sun</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be in Universal Coordinated Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
     *         Services Region, occurring on a random day of the week. To see the time blocks available, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
     *         > Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Days must be one of <code>Mon | Tue | Wed | Thu | Fri | Sat | Sun</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be in Universal Coordinated Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to
     * database accounts. By default, mapping isn't enabled.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
     * Authentication</a> in the <i>Amazon Aurora User Guide</i> or <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">IAM database
     * authentication for MariaDB, MySQL, and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts
     *         to database accounts. By default, mapping isn't enabled.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
     *         Database Authentication</a> in the <i>Amazon Aurora User Guide</i> or <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">IAM database
     *         authentication for MariaDB, MySQL, and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Boolean enableIAMDatabaseAuthentication() {
        return enableIAMDatabaseAuthentication;
    }

    /**
     * <p>
     * The target backtrack window, in seconds. To disable backtracking, set this value to <code>0</code>.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora MySQL DB clusters only
     * </p>
     * <p>
     * Default: <code>0</code>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     * </p>
     * </li>
     * </ul>
     * 
     * @return The target backtrack window, in seconds. To disable backtracking, set this value to <code>0</code>.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora MySQL DB clusters only
     *         </p>
     *         <p>
     *         Default: <code>0</code>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     *         </p>
     *         </li>
     */
    public final Long backtrackWindow() {
        return backtrackWindow;
    }

    /**
     * <p>
     * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB
     * cluster.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * The following values are valid for each DB engine:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora MySQL - <code>audit | error | general | instance | slowquery | iam-db-auth-error</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora PostgreSQL - <code>instance | postgresql | iam-db-auth-error</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for MySQL - <code>error | general | slowquery | iam-db-auth-error</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS for PostgreSQL - <code>postgresql | upgrade | iam-db-auth-error</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     * > Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * 
     * @return The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB
     *         cluster.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         The following values are valid for each DB engine:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aurora MySQL - <code>audit | error | general | instance | slowquery | iam-db-auth-error</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Aurora PostgreSQL - <code>instance | postgresql | iam-db-auth-error</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for MySQL - <code>error | general | slowquery | iam-db-auth-error</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDS for PostgreSQL - <code>postgresql | upgrade | iam-db-auth-error</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     *         > Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
     *         >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
     */
    public final CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration() {
        return cloudwatchLogsExportConfiguration;
    }

    /**
     * <p>
     * The version number of the database engine to which you want to upgrade. Changing this parameter results in an
     * outage. The change is applied during the next maintenance window unless <code>ApplyImmediately</code> is enabled.
     * </p>
     * <p>
     * If the cluster that you're modifying has one or more read replicas, all replicas must be running an engine
     * version that's the same or later than the version you specify.
     * </p>
     * <p>
     * To list all of the available engine versions for Aurora MySQL, use the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * To list all of the available engine versions for RDS for MySQL, use the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code>
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The version number of the database engine to which you want to upgrade. Changing this parameter results
     *         in an outage. The change is applied during the next maintenance window unless
     *         <code>ApplyImmediately</code> is enabled.</p>
     *         <p>
     *         If the cluster that you're modifying has one or more read replicas, all replicas must be running an
     *         engine version that's the same or later than the version you specify.
     *         </p>
     *         <p>
     *         To list all of the available engine versions for Aurora MySQL, use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         To list all of the available engine versions for Aurora PostgreSQL, use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         To list all of the available engine versions for RDS for MySQL, use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         To list all of the available engine versions for RDS for PostgreSQL, use the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code>
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Specifies whether major version upgrades are allowed.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must allow major version upgrades when specifying a value for the <code>EngineVersion</code> parameter that
     * is a different major version than the DB cluster's current version.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether major version upgrades are allowed.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You must allow major version upgrades when specifying a value for the <code>EngineVersion</code>
     *         parameter that is a different major version than the DB cluster's current version.
     *         </p>
     *         </li>
     */
    public final Boolean allowMajorVersionUpgrade() {
        return allowMajorVersionUpgrade;
    }

    /**
     * <p>
     * The name of the DB parameter group to apply to all instances of the DB cluster.
     * </p>
     * <note>
     * <p>
     * When you apply a parameter group using the <code>DBInstanceParameterGroupName</code> parameter, the DB cluster
     * isn't rebooted automatically. Also, parameter changes are applied immediately rather than during the next
     * maintenance window.
     * </p>
     * </note>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * <p>
     * Default: The existing name setting
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The DB parameter group must be in the same DB parameter group family as this DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>DBInstanceParameterGroupName</code> parameter is valid in combination with the
     * <code>AllowMajorVersionUpgrade</code> parameter for a major version upgrade only.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the DB parameter group to apply to all instances of the DB cluster.</p> <note>
     *         <p>
     *         When you apply a parameter group using the <code>DBInstanceParameterGroupName</code> parameter, the DB
     *         cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than during
     *         the next maintenance window.
     *         </p>
     *         </note>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     *         </p>
     *         <p>
     *         Default: The existing name setting
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The DB parameter group must be in the same DB parameter group family as this DB cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The <code>DBInstanceParameterGroupName</code> parameter is valid in combination with the
     *         <code>AllowMajorVersionUpgrade</code> parameter for a major version upgrade only.
     *         </p>
     *         </li>
     */
    public final String dbInstanceParameterGroupName() {
        return dbInstanceParameterGroupName;
    }

    /**
     * <p>
     * The Active Directory directory ID to move the DB cluster to. Specify <code>none</code> to remove the cluster from
     * its current domain. The domain must be created prior to this operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos
     * Authentication</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * 
     * @return The Active Directory directory ID to move the DB cluster to. Specify <code>none</code> to remove the
     *         cluster from its current domain. The domain must be created prior to this operation.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos
     *         Authentication</a> in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The name of the IAM role to use when making API calls to the Directory Service.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * 
     * @return The name of the IAM role to use when making API calls to the Directory Service.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final String domainIAMRoleName() {
        return domainIAMRoleName;
    }

    /**
     * <p>
     * The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in
     * <code>serverless</code> DB engine mode.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * 
     * @return The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in
     *         <code>serverless</code> DB engine mode.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final ScalingConfiguration scalingConfiguration() {
        return scalingConfiguration;
    }

    /**
     * <p>
     * Specifies whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion
     * protection is enabled. By default, deletion protection isn't enabled.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return Specifies whether the DB cluster has deletion protection enabled. The database can't be deleted when
     *         deletion protection is enabled. By default, deletion protection isn't enabled.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * Specifies whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP
     * endpoint isn't enabled.
     * </p>
     * <p>
     * When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries
     * on the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with the RDS
     * query editor.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using RDS Data API</a> in the
     * <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This parameter applies only to Aurora Serverless v1 DB clusters. To enable or disable the HTTP endpoint for an
     * Aurora Serverless v2 or provisioned DB cluster, use the <code>EnableHttpEndpoint</code> and
     * <code>DisableHttpEndpoint</code> operations.
     * </p>
     * </note>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * 
     * @return Specifies whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the
     *         HTTP endpoint isn't enabled.</p>
     *         <p>
     *         When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL
     *         queries on the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS
     *         console with the RDS query editor.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using RDS Data API</a>
     *         in the <i>Amazon Aurora User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter applies only to Aurora Serverless v1 DB clusters. To enable or disable the HTTP endpoint
     *         for an Aurora Serverless v2 or provisioned DB cluster, use the <code>EnableHttpEndpoint</code> and
     *         <code>DisableHttpEndpoint</code> operations.
     *         </p>
     *         </note>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final Boolean enableHttpEndpoint() {
        return enableHttpEndpoint;
    }

    /**
     * <p>
     * Specifies whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy
     * them.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return Specifies whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not
     *         to copy them.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    /**
     * <p>
     * Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global
     * cluster (Aurora global database). By default, write operations are not allowed on Aurora DB clusters that are
     * secondary clusters in an Aurora global database.
     * </p>
     * <p>
     * You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this
     * parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting
     * changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value
     * is used immediately if the primary is demoted by a global cluster API operation, but it does nothing until then.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * 
     * @return Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a
     *         global cluster (Aurora global database). By default, write operations are not allowed on Aurora DB
     *         clusters that are secondary clusters in an Aurora global database.</p>
     *         <p>
     *         You can set this value only on Aurora DB clusters that are members of an Aurora global database. With
     *         this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the
     *         resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global
     *         database, this value is used immediately if the primary is demoted by a global cluster API operation, but
     *         it does nothing until then.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final Boolean enableGlobalWriteForwarding() {
        return enableGlobalWriteForwarding;
    }

    /**
     * <p>
     * The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example
     * <code>db.m6gd.xlarge</code>. Not all DB instance classes are available in all Amazon Web Services Regions, or for
     * all database engines.
     * </p>
     * <p>
     * For the full list of DB instance classes and availability for your engine, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html"> DB Instance
     * Class</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * </p>
     * 
     * @return The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example
     *         <code>db.m6gd.xlarge</code>. Not all DB instance classes are available in all Amazon Web Services
     *         Regions, or for all database engines.</p>
     *         <p>
     *         For the full list of DB instance classes and availability for your engine, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html"> DB Instance
     *         Class</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public final String dbClusterInstanceClass() {
        return dbClusterInstanceClass;
    }

    /**
     * <p>
     * The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
     * </p>
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * </p>
     * 
     * @return The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.</p>
     *         <p>
     *         Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * The storage type to associate with the DB cluster.
     * </p>
     * <p>
     * For information on storage types for Aurora DB clusters, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type"
     * >Storage configurations for Amazon Aurora DB clusters</a>. For information on storage types for Multi-AZ DB
     * clusters, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings"
     * >Settings for creating Multi-AZ DB clusters</a>.
     * </p>
     * <p>
     * When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora DB clusters - <code>aurora | aurora-iopt1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Multi-AZ DB clusters - <code>io1 | io2 | gp3</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aurora DB clusters - <code>aurora</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Multi-AZ DB clusters - <code>io1</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The storage type to associate with the DB cluster.</p>
     *         <p>
     *         For information on storage types for Aurora DB clusters, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type"
     *         >Storage configurations for Amazon Aurora DB clusters</a>. For information on storage types for Multi-AZ
     *         DB clusters, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings"
     *         >Settings for creating Multi-AZ DB clusters</a>.
     *         </p>
     *         <p>
     *         When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aurora DB clusters - <code>aurora | aurora-iopt1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Multi-AZ DB clusters - <code>io1 | io2 | gp3</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aurora DB clusters - <code>aurora</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Multi-AZ DB clusters - <code>io1</code>
     *         </p>
     *         </li>
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB
     * instance in the Multi-AZ DB cluster.
     * </p>
     * <p>
     * For information about valid IOPS values, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned
     * IOPS storage</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB
     *         instance in the Multi-AZ DB cluster.</p>
     *         <p>
     *         For information about valid IOPS values, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS
     *         Provisioned IOPS storage</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Multi-AZ DB clusters only
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
     *         </p>
     *         </li>
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance
     * window. By default, minor engine upgrades are applied automatically.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters.
     * </p>
     * <p>
     * For more information about automatic minor version upgrades, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades"
     * >Automatically upgrading the minor engine version</a>.
     * </p>
     * 
     * @return Specifies whether minor engine upgrades are applied automatically to the DB cluster during the
     *         maintenance window. By default, minor engine upgrades are applied automatically.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters.
     *         </p>
     *         <p>
     *         For more information about automatic minor version upgrades, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades"
     *         >Automatically upgrading the minor engine version</a>.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The network type of the DB cluster.
     * </p>
     * <p>
     * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A
     * <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
     * <code>DUAL</code>).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
     * Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i>
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * <p>
     * Valid Values: <code>IPV4 | DUAL</code>
     * </p>
     * 
     * @return The network type of the DB cluster.</p>
     *         <p>
     *         The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A
     *         <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
     *         <code>DUAL</code>).
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"
     *         > Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i>
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     *         </p>
     *         <p>
     *         Valid Values: <code>IPV4 | DUAL</code>
     */
    public final String networkType() {
        return networkType;
    }

    /**
     * Returns the value of the ServerlessV2ScalingConfiguration property for this object.
     * 
     * @return The value of the ServerlessV2ScalingConfiguration property for this object.
     */
    public final ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration() {
        return serverlessV2ScalingConfiguration;
    }

    /**
     * <p>
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To
     * turn off collecting Enhanced Monitoring metrics, specify <code>0</code>.
     * </p>
     * <p>
     * If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other than
     * <code>0</code>.
     * </p>
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * </p>
     * <p>
     * Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
     * </p>
     * <p>
     * Default: <code>0</code>
     * </p>
     * 
     * @return The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
     *         cluster. To turn off collecting Enhanced Monitoring metrics, specify <code>0</code>.</p>
     *         <p>
     *         If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other
     *         than <code>0</code>.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Multi-AZ DB clusters only
     *         </p>
     *         <p>
     *         Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
     *         </p>
     *         <p>
     *         Default: <code>0</code>
     */
    public final Integer monitoringInterval() {
        return monitoringInterval;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon
     * CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a
     * monitoring role, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To
     * create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, supply a
     * <code>MonitoringRoleArn</code> value.
     * </p>
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to
     *         Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>. For
     *         information on creating a monitoring role, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole"
     *         >To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i> </p>
     *         <p>
     *         If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, supply a
     *         <code>MonitoringRoleArn</code> value.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public final String monitoringRoleArn() {
        return monitoringRoleArn;
    }

    /**
     * <p>
     * Specifies the mode of Database Insights to enable for the DB cluster.
     * </p>
     * <p>
     * If you change the value from <code>standard</code> to <code>advanced</code>, you must set the
     * <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> and the
     * <code>PerformanceInsightsRetentionPeriod</code> parameter to 465.
     * </p>
     * <p>
     * If you change the value from <code>advanced</code> to <code>standard</code>, you can set the
     * <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> to collect detailed database counter and
     * per-query metrics.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #databaseInsightsMode} will return {@link DatabaseInsightsMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #databaseInsightsModeAsString}.
     * </p>
     * 
     * @return Specifies the mode of Database Insights to enable for the DB cluster.</p>
     *         <p>
     *         If you change the value from <code>standard</code> to <code>advanced</code>, you must set the
     *         <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> and the
     *         <code>PerformanceInsightsRetentionPeriod</code> parameter to 465.
     *         </p>
     *         <p>
     *         If you change the value from <code>advanced</code> to <code>standard</code>, you can set the
     *         <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> to collect detailed database
     *         counter and per-query metrics.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * @see DatabaseInsightsMode
     */
    public final DatabaseInsightsMode databaseInsightsMode() {
        return DatabaseInsightsMode.fromValue(databaseInsightsMode);
    }

    /**
     * <p>
     * Specifies the mode of Database Insights to enable for the DB cluster.
     * </p>
     * <p>
     * If you change the value from <code>standard</code> to <code>advanced</code>, you must set the
     * <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> and the
     * <code>PerformanceInsightsRetentionPeriod</code> parameter to 465.
     * </p>
     * <p>
     * If you change the value from <code>advanced</code> to <code>standard</code>, you can set the
     * <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> to collect detailed database counter and
     * per-query metrics.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #databaseInsightsMode} will return {@link DatabaseInsightsMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #databaseInsightsModeAsString}.
     * </p>
     * 
     * @return Specifies the mode of Database Insights to enable for the DB cluster.</p>
     *         <p>
     *         If you change the value from <code>standard</code> to <code>advanced</code>, you must set the
     *         <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> and the
     *         <code>PerformanceInsightsRetentionPeriod</code> parameter to 465.
     *         </p>
     *         <p>
     *         If you change the value from <code>advanced</code> to <code>standard</code>, you can set the
     *         <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> to collect detailed database
     *         counter and per-query metrics.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * @see DatabaseInsightsMode
     */
    public final String databaseInsightsModeAsString() {
        return databaseInsightsMode;
    }

    /**
     * <p>
     * Specifies whether to turn on Performance Insights for the DB cluster.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Using Amazon Performance
     * Insights</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return Specifies whether to turn on Performance Insights for the DB cluster.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Using Amazon
     *         Performance Insights</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Boolean enablePerformanceInsights() {
        return enablePerformanceInsights;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * </p>
     * <p>
     * If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS
     * key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
     * different default KMS key for each Amazon Web Services Region.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key.
     *         </p>
     *         <p>
     *         If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your
     *         default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
     *         Services account has a different default KMS key for each Amazon Web Services Region.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String performanceInsightsKMSKeyId() {
        return performanceInsightsKMSKeyId;
    }

    /**
     * <p>
     * The number of days to retain Performance Insights data.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31),
     * <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>731</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>7</code> days
     * </p>
     * <p>
     * If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS issues an error.
     * </p>
     * 
     * @return The number of days to retain Performance Insights data.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3
     *         months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>731</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>7</code> days
     *         </p>
     *         <p>
     *         If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS issues an error.
     */
    public final Integer performanceInsightsRetentionPeriod() {
        return performanceInsightsRetentionPeriod;
    }

    /**
     * <p>
     * Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.
     * </p>
     * <p>
     * If the DB cluster doesn't manage the master user password with Amazon Web Services Secrets Manager, you can turn
     * on this management. In this case, you can't specify <code>MasterUserPassword</code>.
     * </p>
     * <p>
     * If the DB cluster already manages the master user password with Amazon Web Services Secrets Manager, and you
     * specify that the master user password is not managed with Amazon Web Services Secrets Manager, then you must
     * specify <code>MasterUserPassword</code>. In this case, RDS deletes the secret and uses the new password for the
     * master user specified by <code>MasterUserPassword</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with
     * Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management
     * with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i>
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.</p>
     *         <p>
     *         If the DB cluster doesn't manage the master user password with Amazon Web Services Secrets Manager, you
     *         can turn on this management. In this case, you can't specify <code>MasterUserPassword</code>.
     *         </p>
     *         <p>
     *         If the DB cluster already manages the master user password with Amazon Web Services Secrets Manager, and
     *         you specify that the master user password is not managed with Amazon Web Services Secrets Manager, then
     *         you must specify <code>MasterUserPassword</code>. In this case, RDS deletes the secret and uses the new
     *         password for the master user specified by <code>MasterUserPassword</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password
     *         management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password
     *         management with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i>
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final Boolean manageMasterUserPassword() {
        return manageMasterUserPassword;
    }

    /**
     * <p>
     * Specifies whether to rotate the secret managed by Amazon Web Services Secrets Manager for the master user
     * password.
     * </p>
     * <p>
     * This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager
     * for the DB cluster. The secret value contains the updated password.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with
     * Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management
     * with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i>
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must apply the change immediately when rotating the master user password.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether to rotate the secret managed by Amazon Web Services Secrets Manager for the master user
     *         password.</p>
     *         <p>
     *         This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets
     *         Manager for the DB cluster. The secret value contains the updated password.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password
     *         management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password
     *         management with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i>
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You must apply the change immediately when rotating the master user password.
     *         </p>
     *         </li>
     */
    public final Boolean rotateMasterUserPassword() {
        return rotateMasterUserPassword;
    }

    /**
     * <p>
     * Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster. By
     * default, write operations aren't allowed on reader DB instances.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     * 
     * @return Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster.
     *         By default, write operations aren't allowed on reader DB instances.</p>
     *         <p>
     *         Valid for: Aurora DB clusters only
     */
    public final Boolean enableLocalWriteForwarding() {
        return enableLocalWriteForwarding;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in
     * Amazon Web Services Secrets Manager.
     * </p>
     * <p>
     * This setting is valid only if both of the following conditions are met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The DB cluster doesn't manage the master user password in Amazon Web Services Secrets Manager.
     * </p>
     * <p>
     * If the DB cluster already manages the master user password in Amazon Web Services Secrets Manager, you can't
     * change the KMS key that is used to encrypt the secret.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are turning on <code>ManageMasterUserPassword</code> to manage the master user password in Amazon Web
     * Services Secrets Manager.
     * </p>
     * <p>
     * If you are turning on <code>ManageMasterUserPassword</code> and don't specify
     * <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key is used to encrypt the
     * secret. If the secret is in a different Amazon Web Services account, then you can't use the
     * <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed KMS key.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To
     * use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     * </p>
     * <p>
     * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different
     * default KMS key for each Amazon Web Services Region.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and
     *         managed in Amazon Web Services Secrets Manager.</p>
     *         <p>
     *         This setting is valid only if both of the following conditions are met:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The DB cluster doesn't manage the master user password in Amazon Web Services Secrets Manager.
     *         </p>
     *         <p>
     *         If the DB cluster already manages the master user password in Amazon Web Services Secrets Manager, you
     *         can't change the KMS key that is used to encrypt the secret.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are turning on <code>ManageMasterUserPassword</code> to manage the master user password in Amazon Web
     *         Services Secrets Manager.
     *         </p>
     *         <p>
     *         If you are turning on <code>ManageMasterUserPassword</code> and don't specify
     *         <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key is used to
     *         encrypt the secret. If the secret is in a different Amazon Web Services account, then you can't use the
     *         <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed KMS
     *         key.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *         </p>
     *         <p>
     *         There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
     *         different default KMS key for each Amazon Web Services Region.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public final String masterUserSecretKmsKeyId() {
        return masterUserSecretKmsKeyId;
    }

    /**
     * <p>
     * The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code>.
     * </p>
     * <note>
     * <p>
     * The DB engine mode can be modified only from <code>serverless</code> to <code>provisioned</code>.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html"> CreateDBCluster</a>.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * </p>
     * 
     * @return The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code>.</p>
     *         <note>
     *         <p>
     *         The DB engine mode can be modified only from <code>serverless</code> to <code>provisioned</code>.
     *         </p>
     *         </note>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html">
     *         CreateDBCluster</a>.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters only
     */
    public final String engineMode() {
        return engineMode;
    }

    /**
     * <p>
     * Specifies whether engine mode changes from <code>serverless</code> to <code>provisioned</code> are allowed.
     * </p>
     * <p>
     * Valid for Cluster Type: Aurora Serverless v1 DB clusters only
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must allow engine mode changes when specifying a different value for the <code>EngineMode</code> parameter
     * from the DB cluster's current engine mode.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether engine mode changes from <code>serverless</code> to <code>provisioned</code> are
     *         allowed.</p>
     *         <p>
     *         Valid for Cluster Type: Aurora Serverless v1 DB clusters only
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You must allow engine mode changes when specifying a different value for the <code>EngineMode</code>
     *         parameter from the DB cluster's current engine mode.
     *         </p>
     *         </li>
     */
    public final Boolean allowEngineModeChange() {
        return allowEngineModeChange;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
     */
    public final String awsBackupRecoveryPointArn() {
        return awsBackupRecoveryPointArn;
    }

    /**
     * <p>
     * Specifies whether to enable Aurora Limitless Database. You must enable Aurora Limitless Database to create a DB
     * shard group.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     * <note>
     * <p>
     * This setting is no longer used. Instead use the <code>ClusterScalabilityType</code> setting when you create your
     * Aurora Limitless Database DB cluster.
     * </p>
     * </note>
     * 
     * @return Specifies whether to enable Aurora Limitless Database. You must enable Aurora Limitless Database to
     *         create a DB shard group.</p>
     *         <p>
     *         Valid for: Aurora DB clusters only
     *         </p>
     *         <note>
     *         <p>
     *         This setting is no longer used. Instead use the <code>ClusterScalabilityType</code> setting when you
     *         create your Aurora Limitless Database DB cluster.
     *         </p>
     */
    public final Boolean enableLimitlessDatabase() {
        return enableLimitlessDatabase;
    }

    /**
     * <p>
     * The CA certificate identifier to use for the DB cluster's server certificate.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a
     * connection to a DB instance</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters
     * </p>
     * 
     * @return The CA certificate identifier to use for the DB cluster's server certificate.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to
     *         encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i>.
     *         </p>
     *         <p>
     *         Valid for Cluster Type: Multi-AZ DB clusters
     */
    public final String caCertificateIdentifier() {
        return caCertificateIdentifier;
    }

    /**
     * <p>
     * Specifies the authentication type for the master user. With IAM master user authentication, you can change the
     * master DB user to use IAM database authentication.
     * </p>
     * <p>
     * You can specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>password</code> - Use standard database authentication with a password.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>iam-db-auth</code> - Use IAM database authentication for the master user.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * This option is only valid for RDS for PostgreSQL and Aurora PostgreSQL engines.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #masterUserAuthenticationType} will return {@link MasterUserAuthenticationType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #masterUserAuthenticationTypeAsString}.
     * </p>
     * 
     * @return Specifies the authentication type for the master user. With IAM master user authentication, you can
     *         change the master DB user to use IAM database authentication.</p>
     *         <p>
     *         You can specify one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>password</code> - Use standard database authentication with a password.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>iam-db-auth</code> - Use IAM database authentication for the master user.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         This option is only valid for RDS for PostgreSQL and Aurora PostgreSQL engines.
     * @see MasterUserAuthenticationType
     */
    public final MasterUserAuthenticationType masterUserAuthenticationType() {
        return MasterUserAuthenticationType.fromValue(masterUserAuthenticationType);
    }

    /**
     * <p>
     * Specifies the authentication type for the master user. With IAM master user authentication, you can change the
     * master DB user to use IAM database authentication.
     * </p>
     * <p>
     * You can specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>password</code> - Use standard database authentication with a password.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>iam-db-auth</code> - Use IAM database authentication for the master user.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * </p>
     * <p>
     * This option is only valid for RDS for PostgreSQL and Aurora PostgreSQL engines.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #masterUserAuthenticationType} will return {@link MasterUserAuthenticationType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #masterUserAuthenticationTypeAsString}.
     * </p>
     * 
     * @return Specifies the authentication type for the master user. With IAM master user authentication, you can
     *         change the master DB user to use IAM database authentication.</p>
     *         <p>
     *         You can specify one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>password</code> - Use standard database authentication with a password.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>iam-db-auth</code> - Use IAM database authentication for the master user.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *         </p>
     *         <p>
     *         This option is only valid for RDS for PostgreSQL and Aurora PostgreSQL engines.
     * @see MasterUserAuthenticationType
     */
    public final String masterUserAuthenticationTypeAsString() {
        return masterUserAuthenticationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(newDBClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(backtrackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(cloudwatchLogsExportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(allowMajorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(scalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(enableHttpEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(enableGlobalWriteForwarding());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(networkType());
        hashCode = 31 * hashCode + Objects.hashCode(serverlessV2ScalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(databaseInsightsModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(manageMasterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(rotateMasterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(enableLocalWriteForwarding());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserSecretKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(engineMode());
        hashCode = 31 * hashCode + Objects.hashCode(allowEngineModeChange());
        hashCode = 31 * hashCode + Objects.hashCode(awsBackupRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(enableLimitlessDatabase());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserAuthenticationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbClusterRequest)) {
            return false;
        }
        ModifyDbClusterRequest other = (ModifyDbClusterRequest) obj;
        return Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(newDBClusterIdentifier(), other.newDBClusterIdentifier())
                && Objects.equals(applyImmediately(), other.applyImmediately())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(dbClusterParameterGroupName(), other.dbClusterParameterGroupName())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(port(), other.port())
                && Objects.equals(masterUserPassword(), other.masterUserPassword())
                && Objects.equals(optionGroupName(), other.optionGroupName())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication())
                && Objects.equals(backtrackWindow(), other.backtrackWindow())
                && Objects.equals(cloudwatchLogsExportConfiguration(), other.cloudwatchLogsExportConfiguration())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(allowMajorVersionUpgrade(), other.allowMajorVersionUpgrade())
                && Objects.equals(dbInstanceParameterGroupName(), other.dbInstanceParameterGroupName())
                && Objects.equals(domain(), other.domain()) && Objects.equals(domainIAMRoleName(), other.domainIAMRoleName())
                && Objects.equals(scalingConfiguration(), other.scalingConfiguration())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(enableHttpEndpoint(), other.enableHttpEndpoint())
                && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot())
                && Objects.equals(enableGlobalWriteForwarding(), other.enableGlobalWriteForwarding())
                && Objects.equals(dbClusterInstanceClass(), other.dbClusterInstanceClass())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(storageType(), other.storageType()) && Objects.equals(iops(), other.iops())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(networkType(), other.networkType())
                && Objects.equals(serverlessV2ScalingConfiguration(), other.serverlessV2ScalingConfiguration())
                && Objects.equals(monitoringInterval(), other.monitoringInterval())
                && Objects.equals(monitoringRoleArn(), other.monitoringRoleArn())
                && Objects.equals(databaseInsightsModeAsString(), other.databaseInsightsModeAsString())
                && Objects.equals(enablePerformanceInsights(), other.enablePerformanceInsights())
                && Objects.equals(performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId())
                && Objects.equals(performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod())
                && Objects.equals(manageMasterUserPassword(), other.manageMasterUserPassword())
                && Objects.equals(rotateMasterUserPassword(), other.rotateMasterUserPassword())
                && Objects.equals(enableLocalWriteForwarding(), other.enableLocalWriteForwarding())
                && Objects.equals(masterUserSecretKmsKeyId(), other.masterUserSecretKmsKeyId())
                && Objects.equals(engineMode(), other.engineMode())
                && Objects.equals(allowEngineModeChange(), other.allowEngineModeChange())
                && Objects.equals(awsBackupRecoveryPointArn(), other.awsBackupRecoveryPointArn())
                && Objects.equals(enableLimitlessDatabase(), other.enableLimitlessDatabase())
                && Objects.equals(caCertificateIdentifier(), other.caCertificateIdentifier())
                && Objects.equals(masterUserAuthenticationTypeAsString(), other.masterUserAuthenticationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDbClusterRequest").add("DBClusterIdentifier", dbClusterIdentifier())
                .add("NewDBClusterIdentifier", newDBClusterIdentifier()).add("ApplyImmediately", applyImmediately())
                .add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("DBClusterParameterGroupName", dbClusterParameterGroupName())
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null).add("Port", port())
                .add("MasterUserPassword", masterUserPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OptionGroupName", optionGroupName()).add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("EnableIAMDatabaseAuthentication", enableIAMDatabaseAuthentication())
                .add("BacktrackWindow", backtrackWindow())
                .add("CloudwatchLogsExportConfiguration", cloudwatchLogsExportConfiguration())
                .add("EngineVersion", engineVersion()).add("AllowMajorVersionUpgrade", allowMajorVersionUpgrade())
                .add("DBInstanceParameterGroupName", dbInstanceParameterGroupName()).add("Domain", domain())
                .add("DomainIAMRoleName", domainIAMRoleName()).add("ScalingConfiguration", scalingConfiguration())
                .add("DeletionProtection", deletionProtection()).add("EnableHttpEndpoint", enableHttpEndpoint())
                .add("CopyTagsToSnapshot", copyTagsToSnapshot())
                .add("EnableGlobalWriteForwarding", enableGlobalWriteForwarding())
                .add("DBClusterInstanceClass", dbClusterInstanceClass()).add("AllocatedStorage", allocatedStorage())
                .add("StorageType", storageType()).add("Iops", iops()).add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("NetworkType", networkType()).add("ServerlessV2ScalingConfiguration", serverlessV2ScalingConfiguration())
                .add("MonitoringInterval", monitoringInterval()).add("MonitoringRoleArn", monitoringRoleArn())
                .add("DatabaseInsightsMode", databaseInsightsModeAsString())
                .add("EnablePerformanceInsights", enablePerformanceInsights())
                .add("PerformanceInsightsKMSKeyId", performanceInsightsKMSKeyId())
                .add("PerformanceInsightsRetentionPeriod", performanceInsightsRetentionPeriod())
                .add("ManageMasterUserPassword", manageMasterUserPassword())
                .add("RotateMasterUserPassword", rotateMasterUserPassword())
                .add("EnableLocalWriteForwarding", enableLocalWriteForwarding())
                .add("MasterUserSecretKmsKeyId", masterUserSecretKmsKeyId()).add("EngineMode", engineMode())
                .add("AllowEngineModeChange", allowEngineModeChange())
                .add("AwsBackupRecoveryPointArn", awsBackupRecoveryPointArn())
                .add("EnableLimitlessDatabase", enableLimitlessDatabase())
                .add("CACertificateIdentifier", caCertificateIdentifier())
                .add("MasterUserAuthenticationType", masterUserAuthenticationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "NewDBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(newDBClusterIdentifier()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "DBClusterParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroupName()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "EnableIAMDatabaseAuthentication":
            return Optional.ofNullable(clazz.cast(enableIAMDatabaseAuthentication()));
        case "BacktrackWindow":
            return Optional.ofNullable(clazz.cast(backtrackWindow()));
        case "CloudwatchLogsExportConfiguration":
            return Optional.ofNullable(clazz.cast(cloudwatchLogsExportConfiguration()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AllowMajorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(allowMajorVersionUpgrade()));
        case "DBInstanceParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbInstanceParameterGroupName()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "DomainIAMRoleName":
            return Optional.ofNullable(clazz.cast(domainIAMRoleName()));
        case "ScalingConfiguration":
            return Optional.ofNullable(clazz.cast(scalingConfiguration()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "EnableHttpEndpoint":
            return Optional.ofNullable(clazz.cast(enableHttpEndpoint()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        case "EnableGlobalWriteForwarding":
            return Optional.ofNullable(clazz.cast(enableGlobalWriteForwarding()));
        case "DBClusterInstanceClass":
            return Optional.ofNullable(clazz.cast(dbClusterInstanceClass()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkType()));
        case "ServerlessV2ScalingConfiguration":
            return Optional.ofNullable(clazz.cast(serverlessV2ScalingConfiguration()));
        case "MonitoringInterval":
            return Optional.ofNullable(clazz.cast(monitoringInterval()));
        case "MonitoringRoleArn":
            return Optional.ofNullable(clazz.cast(monitoringRoleArn()));
        case "DatabaseInsightsMode":
            return Optional.ofNullable(clazz.cast(databaseInsightsModeAsString()));
        case "EnablePerformanceInsights":
            return Optional.ofNullable(clazz.cast(enablePerformanceInsights()));
        case "PerformanceInsightsKMSKeyId":
            return Optional.ofNullable(clazz.cast(performanceInsightsKMSKeyId()));
        case "PerformanceInsightsRetentionPeriod":
            return Optional.ofNullable(clazz.cast(performanceInsightsRetentionPeriod()));
        case "ManageMasterUserPassword":
            return Optional.ofNullable(clazz.cast(manageMasterUserPassword()));
        case "RotateMasterUserPassword":
            return Optional.ofNullable(clazz.cast(rotateMasterUserPassword()));
        case "EnableLocalWriteForwarding":
            return Optional.ofNullable(clazz.cast(enableLocalWriteForwarding()));
        case "MasterUserSecretKmsKeyId":
            return Optional.ofNullable(clazz.cast(masterUserSecretKmsKeyId()));
        case "EngineMode":
            return Optional.ofNullable(clazz.cast(engineMode()));
        case "AllowEngineModeChange":
            return Optional.ofNullable(clazz.cast(allowEngineModeChange()));
        case "AwsBackupRecoveryPointArn":
            return Optional.ofNullable(clazz.cast(awsBackupRecoveryPointArn()));
        case "EnableLimitlessDatabase":
            return Optional.ofNullable(clazz.cast(enableLimitlessDatabase()));
        case "CACertificateIdentifier":
            return Optional.ofNullable(clazz.cast(caCertificateIdentifier()));
        case "MasterUserAuthenticationType":
            return Optional.ofNullable(clazz.cast(masterUserAuthenticationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("NewDBClusterIdentifier", NEW_DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("ApplyImmediately", APPLY_IMMEDIATELY_FIELD);
        map.put("BackupRetentionPeriod", BACKUP_RETENTION_PERIOD_FIELD);
        map.put("DBClusterParameterGroupName", DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD);
        map.put("VpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("MasterUserPassword", MASTER_USER_PASSWORD_FIELD);
        map.put("OptionGroupName", OPTION_GROUP_NAME_FIELD);
        map.put("PreferredBackupWindow", PREFERRED_BACKUP_WINDOW_FIELD);
        map.put("PreferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("EnableIAMDatabaseAuthentication", ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD);
        map.put("BacktrackWindow", BACKTRACK_WINDOW_FIELD);
        map.put("CloudwatchLogsExportConfiguration", CLOUDWATCH_LOGS_EXPORT_CONFIGURATION_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("AllowMajorVersionUpgrade", ALLOW_MAJOR_VERSION_UPGRADE_FIELD);
        map.put("DBInstanceParameterGroupName", DB_INSTANCE_PARAMETER_GROUP_NAME_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("DomainIAMRoleName", DOMAIN_IAM_ROLE_NAME_FIELD);
        map.put("ScalingConfiguration", SCALING_CONFIGURATION_FIELD);
        map.put("DeletionProtection", DELETION_PROTECTION_FIELD);
        map.put("EnableHttpEndpoint", ENABLE_HTTP_ENDPOINT_FIELD);
        map.put("CopyTagsToSnapshot", COPY_TAGS_TO_SNAPSHOT_FIELD);
        map.put("EnableGlobalWriteForwarding", ENABLE_GLOBAL_WRITE_FORWARDING_FIELD);
        map.put("DBClusterInstanceClass", DB_CLUSTER_INSTANCE_CLASS_FIELD);
        map.put("AllocatedStorage", ALLOCATED_STORAGE_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("AutoMinorVersionUpgrade", AUTO_MINOR_VERSION_UPGRADE_FIELD);
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        map.put("ServerlessV2ScalingConfiguration", SERVERLESS_V2_SCALING_CONFIGURATION_FIELD);
        map.put("MonitoringInterval", MONITORING_INTERVAL_FIELD);
        map.put("MonitoringRoleArn", MONITORING_ROLE_ARN_FIELD);
        map.put("DatabaseInsightsMode", DATABASE_INSIGHTS_MODE_FIELD);
        map.put("EnablePerformanceInsights", ENABLE_PERFORMANCE_INSIGHTS_FIELD);
        map.put("PerformanceInsightsKMSKeyId", PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD);
        map.put("PerformanceInsightsRetentionPeriod", PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD);
        map.put("ManageMasterUserPassword", MANAGE_MASTER_USER_PASSWORD_FIELD);
        map.put("RotateMasterUserPassword", ROTATE_MASTER_USER_PASSWORD_FIELD);
        map.put("EnableLocalWriteForwarding", ENABLE_LOCAL_WRITE_FORWARDING_FIELD);
        map.put("MasterUserSecretKmsKeyId", MASTER_USER_SECRET_KMS_KEY_ID_FIELD);
        map.put("EngineMode", ENGINE_MODE_FIELD);
        map.put("AllowEngineModeChange", ALLOW_ENGINE_MODE_CHANGE_FIELD);
        map.put("AwsBackupRecoveryPointArn", AWS_BACKUP_RECOVERY_POINT_ARN_FIELD);
        map.put("EnableLimitlessDatabase", ENABLE_LIMITLESS_DATABASE_FIELD);
        map.put("CACertificateIdentifier", CA_CERTIFICATE_IDENTIFIER_FIELD);
        map.put("MasterUserAuthenticationType", MASTER_USER_AUTHENTICATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbClusterRequest, T> g) {
        return obj -> g.apply((ModifyDbClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbClusterRequest> {
        /**
         * <p>
         * The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing DB cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbClusterIdentifier
         *        The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing DB cluster.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a
         * lowercase string.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>my-cluster2</code>
         * </p>
         * 
         * @param newDBClusterIdentifier
         *        The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a
         *        lowercase string.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>my-cluster2</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newDBClusterIdentifier(String newDBClusterIdentifier);

        /**
         * <p>
         * Specifies whether the modifications in this request are asynchronously applied as soon as possible,
         * regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB cluster. If this parameter is
         * disabled, changes to the DB cluster are applied during the next maintenance window.
         * </p>
         * <p>
         * Most modifications can be applied immediately or during the next scheduled maintenance window. Some
         * modifications, such as turning on deletion protection and changing the master password, are applied
         * immediately—regardless of when you choose to apply them.
         * </p>
         * <p>
         * By default, this parameter is disabled.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param applyImmediately
         *        Specifies whether the modifications in this request are asynchronously applied as soon as possible,
         *        regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB cluster. If this
         *        parameter is disabled, changes to the DB cluster are applied during the next maintenance window.</p>
         *        <p>
         *        Most modifications can be applied immediately or during the next scheduled maintenance window. Some
         *        modifications, such as turning on deletion protection and changing the master password, are applied
         *        immediately—regardless of when you choose to apply them.
         *        </p>
         *        <p>
         *        By default, this parameter is disabled.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        /**
         * <p>
         * The number of days for which automated backups are retained. Specify a minimum value of <code>1</code>.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Default: <code>1</code>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be a value from 1 to 35.
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupRetentionPeriod
         *        The number of days for which automated backups are retained. Specify a minimum value of <code>1</code>
         *        .</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Default: <code>1</code>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be a value from 1 to 35.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * The name of the DB cluster parameter group to use for the DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param dbClusterParameterGroupName
         *        The name of the DB cluster parameter group to use for the DB cluster.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroupName(String dbClusterParameterGroupName);

        /**
         * <p>
         * A list of EC2 VPC security groups to associate with this DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups to associate with this DB cluster.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of EC2 VPC security groups to associate with this DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups to associate with this DB cluster.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The port number on which the DB cluster accepts connections.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * <p>
         * Valid Values: <code>1150-65535</code>
         * </p>
         * <p>
         * Default: The same port as the original DB cluster.
         * </p>
         * 
         * @param port
         *        The port number on which the DB cluster accepts connections.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         *        </p>
         *        <p>
         *        Valid Values: <code>1150-65535</code>
         *        </p>
         *        <p>
         *        Default: The same port as the original DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The new password for the master database user.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 8 to 41 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can contain any printable ASCII character except "/", """, or "@".
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be specified if <code>ManageMasterUserPassword</code> is turned on.
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterUserPassword
         *        The new password for the master database user.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 8 to 41 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can contain any printable ASCII character except "/", """, or "@".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be specified if <code>ManageMasterUserPassword</code> is turned on.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * The option group to associate the DB cluster with.
         * </p>
         * <p>
         * DB clusters are associated with a default option group that can't be modified.
         * </p>
         * 
         * @param optionGroupName
         *        The option group to associate the DB cluster with.</p>
         *        <p>
         *        DB clusters are associated with a default option group that can't be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * The daily time range during which automated backups are created if automated backups are enabled, using the
         * <code>BackupRetentionPeriod</code> parameter.
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
         * Services Region. To view the time blocks available, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"
         * > Backup window</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the format <code>hh24:mi-hh24:mi</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be in Universal Coordinated Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not conflict with the preferred maintenance window.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredBackupWindow
         *        The daily time range during which automated backups are created if automated backups are enabled,
         *        using the <code>BackupRetentionPeriod</code> parameter.</p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
         *        Services Region. To view the time blocks available, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"
         *        > Backup window</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the format <code>hh24:mi-hh24:mi</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be in Universal Coordinated Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not conflict with the preferred maintenance window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
         * Services Region, occurring on a random day of the week. To see the time blocks available, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
         * > Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Days must be one of <code>Mon | Tue | Wed | Thu | Fri | Sat | Sun</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be in Universal Coordinated Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range during which system maintenance can occur, in Universal Coordinated Time
         *        (UTC).</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
         *        Services Region, occurring on a random day of the week. To see the time blocks available, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"
         *        > Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Days must be one of <code>Mon | Tue | Wed | Thu | Fri | Sat | Sun</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be in Universal Coordinated Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to
         * database accounts. By default, mapping isn't enabled.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database
         * Authentication</a> in the <i>Amazon Aurora User Guide</i> or <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">IAM database
         * authentication for MariaDB, MySQL, and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param enableIAMDatabaseAuthentication
         *        Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM)
         *        accounts to database accounts. By default, mapping isn't enabled.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM
         *        Database Authentication</a> in the <i>Amazon Aurora User Guide</i> or <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">IAM database
         *        authentication for MariaDB, MySQL, and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication);

        /**
         * <p>
         * The target backtrack window, in seconds. To disable backtracking, set this value to <code>0</code>.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora MySQL DB clusters only
         * </p>
         * <p>
         * Default: <code>0</code>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         * </p>
         * </li>
         * </ul>
         * 
         * @param backtrackWindow
         *        The target backtrack window, in seconds. To disable backtracking, set this value to <code>0</code>
         *        .</p>
         *        <p>
         *        Valid for Cluster Type: Aurora MySQL DB clusters only
         *        </p>
         *        <p>
         *        Default: <code>0</code>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backtrackWindow(Long backtrackWindow);

        /**
         * <p>
         * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB
         * cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * The following values are valid for each DB engine:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aurora MySQL - <code>audit | error | general | instance | slowquery | iam-db-auth-error</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Aurora PostgreSQL - <code>instance | postgresql | iam-db-auth-error</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MySQL - <code>error | general | slowquery | iam-db-auth-error</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for PostgreSQL - <code>postgresql | upgrade | iam-db-auth-error</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * > Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param cloudwatchLogsExportConfiguration
         *        The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific
         *        DB cluster.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        The following values are valid for each DB engine:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Aurora MySQL - <code>audit | error | general | instance | slowquery | iam-db-auth-error</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Aurora PostgreSQL - <code>instance | postgresql | iam-db-auth-error</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for MySQL - <code>error | general | slowquery | iam-db-auth-error</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDS for PostgreSQL - <code>postgresql | upgrade | iam-db-auth-error</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        > Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         *        >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration);

        /**
         * <p>
         * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB
         * cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * The following values are valid for each DB engine:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aurora MySQL - <code>audit | error | general | instance | slowquery | iam-db-auth-error</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Aurora PostgreSQL - <code>instance | postgresql | iam-db-auth-error</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for MySQL - <code>error | general | slowquery | iam-db-auth-error</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDS for PostgreSQL - <code>postgresql | upgrade | iam-db-auth-error</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about exporting CloudWatch Logs for Amazon RDS, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * > Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"
         * >Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CloudwatchLogsExportConfiguration.Builder} avoiding the need to create one manually via
         * {@link CloudwatchLogsExportConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudwatchLogsExportConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration)}.
         * 
         * @param cloudwatchLogsExportConfiguration
         *        a consumer that will call methods on {@link CloudwatchLogsExportConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration)
         */
        default Builder cloudwatchLogsExportConfiguration(
                Consumer<CloudwatchLogsExportConfiguration.Builder> cloudwatchLogsExportConfiguration) {
            return cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration.builder()
                    .applyMutation(cloudwatchLogsExportConfiguration).build());
        }

        /**
         * <p>
         * The version number of the database engine to which you want to upgrade. Changing this parameter results in an
         * outage. The change is applied during the next maintenance window unless <code>ApplyImmediately</code> is
         * enabled.
         * </p>
         * <p>
         * If the cluster that you're modifying has one or more read replicas, all replicas must be running an engine
         * version that's the same or later than the version you specify.
         * </p>
         * <p>
         * To list all of the available engine versions for Aurora MySQL, use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * To list all of the available engine versions for RDS for MySQL, use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code>
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param engineVersion
         *        The version number of the database engine to which you want to upgrade. Changing this parameter
         *        results in an outage. The change is applied during the next maintenance window unless
         *        <code>ApplyImmediately</code> is enabled.</p>
         *        <p>
         *        If the cluster that you're modifying has one or more read replicas, all replicas must be running an
         *        engine version that's the same or later than the version you specify.
         *        </p>
         *        <p>
         *        To list all of the available engine versions for Aurora MySQL, use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        To list all of the available engine versions for Aurora PostgreSQL, use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        To list all of the available engine versions for RDS for MySQL, use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        To list all of the available engine versions for RDS for PostgreSQL, use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code>
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Specifies whether major version upgrades are allowed.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You must allow major version upgrades when specifying a value for the <code>EngineVersion</code> parameter
         * that is a different major version than the DB cluster's current version.
         * </p>
         * </li>
         * </ul>
         * 
         * @param allowMajorVersionUpgrade
         *        Specifies whether major version upgrades are allowed.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You must allow major version upgrades when specifying a value for the <code>EngineVersion</code>
         *        parameter that is a different major version than the DB cluster's current version.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade);

        /**
         * <p>
         * The name of the DB parameter group to apply to all instances of the DB cluster.
         * </p>
         * <note>
         * <p>
         * When you apply a parameter group using the <code>DBInstanceParameterGroupName</code> parameter, the DB
         * cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than during the
         * next maintenance window.
         * </p>
         * </note>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * <p>
         * Default: The existing name setting
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The DB parameter group must be in the same DB parameter group family as this DB cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>DBInstanceParameterGroupName</code> parameter is valid in combination with the
         * <code>AllowMajorVersionUpgrade</code> parameter for a major version upgrade only.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbInstanceParameterGroupName
         *        The name of the DB parameter group to apply to all instances of the DB cluster.</p> <note>
         *        <p>
         *        When you apply a parameter group using the <code>DBInstanceParameterGroupName</code> parameter, the DB
         *        cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than
         *        during the next maintenance window.
         *        </p>
         *        </note>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         *        </p>
         *        <p>
         *        Default: The existing name setting
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The DB parameter group must be in the same DB parameter group family as this DB cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <code>DBInstanceParameterGroupName</code> parameter is valid in combination with the
         *        <code>AllowMajorVersionUpgrade</code> parameter for a major version upgrade only.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceParameterGroupName(String dbInstanceParameterGroupName);

        /**
         * <p>
         * The Active Directory directory ID to move the DB cluster to. Specify <code>none</code> to remove the cluster
         * from its current domain. The domain must be created prior to this operation.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos
         * Authentication</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param domain
         *        The Active Directory directory ID to move the DB cluster to. Specify <code>none</code> to remove the
         *        cluster from its current domain. The domain must be created prior to this operation.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html"
         *        >Kerberos Authentication</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The name of the IAM role to use when making API calls to the Directory Service.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param domainIAMRoleName
         *        The name of the IAM role to use when making API calls to the Directory Service.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIAMRoleName(String domainIAMRoleName);

        /**
         * <p>
         * The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in
         * <code>serverless</code> DB engine mode.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param scalingConfiguration
         *        The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in
         *        <code>serverless</code> DB engine mode.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingConfiguration(ScalingConfiguration scalingConfiguration);

        /**
         * <p>
         * The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in
         * <code>serverless</code> DB engine mode.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * This is a convenience method that creates an instance of the {@link ScalingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ScalingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScalingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scalingConfiguration(ScalingConfiguration)}.
         * 
         * @param scalingConfiguration
         *        a consumer that will call methods on {@link ScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingConfiguration(ScalingConfiguration)
         */
        default Builder scalingConfiguration(Consumer<ScalingConfiguration.Builder> scalingConfiguration) {
            return scalingConfiguration(ScalingConfiguration.builder().applyMutation(scalingConfiguration).build());
        }

        /**
         * <p>
         * Specifies whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion
         * protection is enabled. By default, deletion protection isn't enabled.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param deletionProtection
         *        Specifies whether the DB cluster has deletion protection enabled. The database can't be deleted when
         *        deletion protection is enabled. By default, deletion protection isn't enabled.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * Specifies whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP
         * endpoint isn't enabled.
         * </p>
         * <p>
         * When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL
         * queries on the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console
         * with the RDS query editor.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using RDS Data API</a> in
         * the <i>Amazon Aurora User Guide</i>.
         * </p>
         * <note>
         * <p>
         * This parameter applies only to Aurora Serverless v1 DB clusters. To enable or disable the HTTP endpoint for
         * an Aurora Serverless v2 or provisioned DB cluster, use the <code>EnableHttpEndpoint</code> and
         * <code>DisableHttpEndpoint</code> operations.
         * </p>
         * </note>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param enableHttpEndpoint
         *        Specifies whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the
         *        HTTP endpoint isn't enabled.</p>
         *        <p>
         *        When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running
         *        SQL queries on the Aurora Serverless v1 DB cluster. You can also query your database from inside the
         *        RDS console with the RDS query editor.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using RDS Data
         *        API</a> in the <i>Amazon Aurora User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter applies only to Aurora Serverless v1 DB clusters. To enable or disable the HTTP
         *        endpoint for an Aurora Serverless v2 or provisioned DB cluster, use the
         *        <code>EnableHttpEndpoint</code> and <code>DisableHttpEndpoint</code> operations.
         *        </p>
         *        </note>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableHttpEndpoint(Boolean enableHttpEndpoint);

        /**
         * <p>
         * Specifies whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to
         * copy them.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        Specifies whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is
         *        not to copy them.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        /**
         * <p>
         * Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global
         * cluster (Aurora global database). By default, write operations are not allowed on Aurora DB clusters that are
         * secondary clusters in an Aurora global database.
         * </p>
         * <p>
         * You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this
         * parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting
         * changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this
         * value is used immediately if the primary is demoted by a global cluster API operation, but it does nothing
         * until then.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param enableGlobalWriteForwarding
         *        Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a
         *        global cluster (Aurora global database). By default, write operations are not allowed on Aurora DB
         *        clusters that are secondary clusters in an Aurora global database.</p>
         *        <p>
         *        You can set this value only on Aurora DB clusters that are members of an Aurora global database. With
         *        this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the
         *        resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global
         *        database, this value is used immediately if the primary is demoted by a global cluster API operation,
         *        but it does nothing until then.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableGlobalWriteForwarding(Boolean enableGlobalWriteForwarding);

        /**
         * <p>
         * The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example
         * <code>db.m6gd.xlarge</code>. Not all DB instance classes are available in all Amazon Web Services Regions, or
         * for all database engines.
         * </p>
         * <p>
         * For the full list of DB instance classes and availability for your engine, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html"> DB Instance
         * Class</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * Valid for Cluster Type: Multi-AZ DB clusters only
         * </p>
         * 
         * @param dbClusterInstanceClass
         *        The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example
         *        <code>db.m6gd.xlarge</code>. Not all DB instance classes are available in all Amazon Web Services
         *        Regions, or for all database engines.</p>
         *        <p>
         *        For the full list of DB instance classes and availability for your engine, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html"> DB
         *        Instance Class</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Multi-AZ DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterInstanceClass(String dbClusterInstanceClass);

        /**
         * <p>
         * The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
         * </p>
         * <p>
         * Valid for Cluster Type: Multi-AZ DB clusters only
         * </p>
         * 
         * @param allocatedStorage
         *        The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB
         *        cluster.</p>
         *        <p>
         *        Valid for Cluster Type: Multi-AZ DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * The storage type to associate with the DB cluster.
         * </p>
         * <p>
         * For information on storage types for Aurora DB clusters, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type"
         * >Storage configurations for Amazon Aurora DB clusters</a>. For information on storage types for Multi-AZ DB
         * clusters, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings"
         * >Settings for creating Multi-AZ DB clusters</a>.
         * </p>
         * <p>
         * When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aurora DB clusters - <code>aurora | aurora-iopt1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Multi-AZ DB clusters - <code>io1 | io2 | gp3</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aurora DB clusters - <code>aurora</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Multi-AZ DB clusters - <code>io1</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param storageType
         *        The storage type to associate with the DB cluster.</p>
         *        <p>
         *        For information on storage types for Aurora DB clusters, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type"
         *        >Storage configurations for Amazon Aurora DB clusters</a>. For information on storage types for
         *        Multi-AZ DB clusters, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings"
         *        >Settings for creating Multi-AZ DB clusters</a>.
         *        </p>
         *        <p>
         *        When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Aurora DB clusters - <code>aurora | aurora-iopt1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Multi-AZ DB clusters - <code>io1 | io2 | gp3</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Aurora DB clusters - <code>aurora</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Multi-AZ DB clusters - <code>io1</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB
         * instance in the Multi-AZ DB cluster.
         * </p>
         * <p>
         * For information about valid IOPS values, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS
         * Provisioned IOPS storage</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * Valid for Cluster Type: Multi-AZ DB clusters only
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param iops
         *        The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each
         *        DB instance in the Multi-AZ DB cluster.</p>
         *        <p>
         *        For information about valid IOPS values, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS
         *        Provisioned IOPS storage</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Multi-AZ DB clusters only
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance
         * window. By default, minor engine upgrades are applied automatically.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters.
         * </p>
         * <p>
         * For more information about automatic minor version upgrades, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades"
         * >Automatically upgrading the minor engine version</a>.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        Specifies whether minor engine upgrades are applied automatically to the DB cluster during the
         *        maintenance window. By default, minor engine upgrades are applied automatically.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters.
         *        </p>
         *        <p>
         *        For more information about automatic minor version upgrades, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades"
         *        >Automatically upgrading the minor engine version</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The network type of the DB cluster.
         * </p>
         * <p>
         * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A
         * <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
         * <code>DUAL</code>).
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">
         * Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i>
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * <p>
         * Valid Values: <code>IPV4 | DUAL</code>
         * </p>
         * 
         * @param networkType
         *        The network type of the DB cluster.</p>
         *        <p>
         *        The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A
         *        <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (
         *        <code>DUAL</code>).
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"
         *        > Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i>
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         *        </p>
         *        <p>
         *        Valid Values: <code>IPV4 | DUAL</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkType(String networkType);

        /**
         * Sets the value of the ServerlessV2ScalingConfiguration property for this object.
         *
         * @param serverlessV2ScalingConfiguration
         *        The new value for the ServerlessV2ScalingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration);

        /**
         * Sets the value of the ServerlessV2ScalingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ServerlessV2ScalingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ServerlessV2ScalingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerlessV2ScalingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration)}.
         * 
         * @param serverlessV2ScalingConfiguration
         *        a consumer that will call methods on {@link ServerlessV2ScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration)
         */
        default Builder serverlessV2ScalingConfiguration(
                Consumer<ServerlessV2ScalingConfiguration.Builder> serverlessV2ScalingConfiguration) {
            return serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration.builder()
                    .applyMutation(serverlessV2ScalingConfiguration).build());
        }

        /**
         * <p>
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.
         * To turn off collecting Enhanced Monitoring metrics, specify <code>0</code>.
         * </p>
         * <p>
         * If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other
         * than <code>0</code>.
         * </p>
         * <p>
         * Valid for Cluster Type: Multi-AZ DB clusters only
         * </p>
         * <p>
         * Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
         * </p>
         * <p>
         * Default: <code>0</code>
         * </p>
         * 
         * @param monitoringInterval
         *        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB
         *        cluster. To turn off collecting Enhanced Monitoring metrics, specify <code>0</code>.</p>
         *        <p>
         *        If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value
         *        other than <code>0</code>.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Multi-AZ DB clusters only
         *        </p>
         *        <p>
         *        Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
         *        </p>
         *        <p>
         *        Default: <code>0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringInterval(Integer monitoringInterval);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to
         * Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on
         * creating a monitoring role, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To
         * create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, supply a
         * <code>MonitoringRoleArn</code> value.
         * </p>
         * <p>
         * Valid for Cluster Type: Multi-AZ DB clusters only
         * </p>
         * 
         * @param monitoringRoleArn
         *        The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics
         *        to Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>. For
         *        information on creating a monitoring role, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole"
         *        >To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, supply a
         *        <code>MonitoringRoleArn</code> value.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Multi-AZ DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringRoleArn(String monitoringRoleArn);

        /**
         * <p>
         * Specifies the mode of Database Insights to enable for the DB cluster.
         * </p>
         * <p>
         * If you change the value from <code>standard</code> to <code>advanced</code>, you must set the
         * <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> and the
         * <code>PerformanceInsightsRetentionPeriod</code> parameter to 465.
         * </p>
         * <p>
         * If you change the value from <code>advanced</code> to <code>standard</code>, you can set the
         * <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> to collect detailed database counter
         * and per-query metrics.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param databaseInsightsMode
         *        Specifies the mode of Database Insights to enable for the DB cluster.</p>
         *        <p>
         *        If you change the value from <code>standard</code> to <code>advanced</code>, you must set the
         *        <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> and the
         *        <code>PerformanceInsightsRetentionPeriod</code> parameter to 465.
         *        </p>
         *        <p>
         *        If you change the value from <code>advanced</code> to <code>standard</code>, you can set the
         *        <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> to collect detailed database
         *        counter and per-query metrics.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @see DatabaseInsightsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseInsightsMode
         */
        Builder databaseInsightsMode(String databaseInsightsMode);

        /**
         * <p>
         * Specifies the mode of Database Insights to enable for the DB cluster.
         * </p>
         * <p>
         * If you change the value from <code>standard</code> to <code>advanced</code>, you must set the
         * <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> and the
         * <code>PerformanceInsightsRetentionPeriod</code> parameter to 465.
         * </p>
         * <p>
         * If you change the value from <code>advanced</code> to <code>standard</code>, you can set the
         * <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> to collect detailed database counter
         * and per-query metrics.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param databaseInsightsMode
         *        Specifies the mode of Database Insights to enable for the DB cluster.</p>
         *        <p>
         *        If you change the value from <code>standard</code> to <code>advanced</code>, you must set the
         *        <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> and the
         *        <code>PerformanceInsightsRetentionPeriod</code> parameter to 465.
         *        </p>
         *        <p>
         *        If you change the value from <code>advanced</code> to <code>standard</code>, you can set the
         *        <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> to collect detailed database
         *        counter and per-query metrics.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @see DatabaseInsightsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseInsightsMode
         */
        Builder databaseInsightsMode(DatabaseInsightsMode databaseInsightsMode);

        /**
         * <p>
         * Specifies whether to turn on Performance Insights for the DB cluster.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Using Amazon
         * Performance Insights</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param enablePerformanceInsights
         *        Specifies whether to turn on Performance Insights for the DB cluster.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Using Amazon
         *        Performance Insights</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePerformanceInsights(Boolean enablePerformanceInsights);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * </p>
         * <p>
         * If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default
         * KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account
         * has a different default KMS key for each Amazon Web Services Region.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param performanceInsightsKMSKeyId
         *        The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key.
         *        </p>
         *        <p>
         *        If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your
         *        default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
         *        Services account has a different default KMS key for each Amazon Web Services Region.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId);

        /**
         * <p>
         * The number of days to retain Performance Insights data.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months *
         * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>731</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>7</code> days
         * </p>
         * <p>
         * If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS issues an error.
         * </p>
         * 
         * @param performanceInsightsRetentionPeriod
         *        The number of days to retain Performance Insights data.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3
         *        months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>731</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>7</code> days
         *        </p>
         *        <p>
         *        If you specify a retention period that isn't valid, such as <code>94</code>, Amazon RDS issues an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod);

        /**
         * <p>
         * Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.
         * </p>
         * <p>
         * If the DB cluster doesn't manage the master user password with Amazon Web Services Secrets Manager, you can
         * turn on this management. In this case, you can't specify <code>MasterUserPassword</code>.
         * </p>
         * <p>
         * If the DB cluster already manages the master user password with Amazon Web Services Secrets Manager, and you
         * specify that the master user password is not managed with Amazon Web Services Secrets Manager, then you must
         * specify <code>MasterUserPassword</code>. In this case, RDS deletes the secret and uses the new password for
         * the master user specified by <code>MasterUserPassword</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management
         * with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password
         * management with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i>
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param manageMasterUserPassword
         *        Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.</p>
         *        <p>
         *        If the DB cluster doesn't manage the master user password with Amazon Web Services Secrets Manager,
         *        you can turn on this management. In this case, you can't specify <code>MasterUserPassword</code>.
         *        </p>
         *        <p>
         *        If the DB cluster already manages the master user password with Amazon Web Services Secrets Manager,
         *        and you specify that the master user password is not managed with Amazon Web Services Secrets Manager,
         *        then you must specify <code>MasterUserPassword</code>. In this case, RDS deletes the secret and uses
         *        the new password for the master user specified by <code>MasterUserPassword</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password
         *        management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password
         *        management with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i>
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manageMasterUserPassword(Boolean manageMasterUserPassword);

        /**
         * <p>
         * Specifies whether to rotate the secret managed by Amazon Web Services Secrets Manager for the master user
         * password.
         * </p>
         * <p>
         * This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets
         * Manager for the DB cluster. The secret value contains the updated password.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management
         * with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password
         * management with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i>
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You must apply the change immediately when rotating the master user password.
         * </p>
         * </li>
         * </ul>
         * 
         * @param rotateMasterUserPassword
         *        Specifies whether to rotate the secret managed by Amazon Web Services Secrets Manager for the master
         *        user password.</p>
         *        <p>
         *        This setting is valid only if the master user password is managed by RDS in Amazon Web Services
         *        Secrets Manager for the DB cluster. The secret value contains the updated password.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password
         *        management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password
         *        management with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i>
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You must apply the change immediately when rotating the master user password.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotateMasterUserPassword(Boolean rotateMasterUserPassword);

        /**
         * <p>
         * Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster. By
         * default, write operations aren't allowed on reader DB instances.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * 
         * @param enableLocalWriteForwarding
         *        Specifies whether read replicas can forward write operations to the writer DB instance in the DB
         *        cluster. By default, write operations aren't allowed on reader DB instances.</p>
         *        <p>
         *        Valid for: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableLocalWriteForwarding(Boolean enableLocalWriteForwarding);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in
         * Amazon Web Services Secrets Manager.
         * </p>
         * <p>
         * This setting is valid only if both of the following conditions are met:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The DB cluster doesn't manage the master user password in Amazon Web Services Secrets Manager.
         * </p>
         * <p>
         * If the DB cluster already manages the master user password in Amazon Web Services Secrets Manager, you can't
         * change the KMS key that is used to encrypt the secret.
         * </p>
         * </li>
         * <li>
         * <p>
         * You are turning on <code>ManageMasterUserPassword</code> to manage the master user password in Amazon Web
         * Services Secrets Manager.
         * </p>
         * <p>
         * If you are turning on <code>ManageMasterUserPassword</code> and don't specify
         * <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key is used to encrypt
         * the secret. If the secret is in a different Amazon Web Services account, then you can't use the
         * <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed KMS key.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         * </p>
         * <p>
         * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
         * different default KMS key for each Amazon Web Services Region.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * 
         * @param masterUserSecretKmsKeyId
         *        The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and
         *        managed in Amazon Web Services Secrets Manager.</p>
         *        <p>
         *        This setting is valid only if both of the following conditions are met:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The DB cluster doesn't manage the master user password in Amazon Web Services Secrets Manager.
         *        </p>
         *        <p>
         *        If the DB cluster already manages the master user password in Amazon Web Services Secrets Manager, you
         *        can't change the KMS key that is used to encrypt the secret.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You are turning on <code>ManageMasterUserPassword</code> to manage the master user password in Amazon
         *        Web Services Secrets Manager.
         *        </p>
         *        <p>
         *        If you are turning on <code>ManageMasterUserPassword</code> and don't specify
         *        <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key is used to
         *        encrypt the secret. If the secret is in a different Amazon Web Services account, then you can't use
         *        the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed
         *        KMS key.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias
         *        ARN.
         *        </p>
         *        <p>
         *        There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has
         *        a different default KMS key for each Amazon Web Services Region.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserSecretKmsKeyId(String masterUserSecretKmsKeyId);

        /**
         * <p>
         * The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code>.
         * </p>
         * <note>
         * <p>
         * The DB engine mode can be modified only from <code>serverless</code> to <code>provisioned</code>.
         * </p>
         * </note>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html">
         * CreateDBCluster</a>.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters only
         * </p>
         * 
         * @param engineMode
         *        The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code>.</p>
         *        <note>
         *        <p>
         *        The DB engine mode can be modified only from <code>serverless</code> to <code>provisioned</code>.
         *        </p>
         *        </note>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html">
         *        CreateDBCluster</a>.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters only
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineMode(String engineMode);

        /**
         * <p>
         * Specifies whether engine mode changes from <code>serverless</code> to <code>provisioned</code> are allowed.
         * </p>
         * <p>
         * Valid for Cluster Type: Aurora Serverless v1 DB clusters only
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You must allow engine mode changes when specifying a different value for the <code>EngineMode</code>
         * parameter from the DB cluster's current engine mode.
         * </p>
         * </li>
         * </ul>
         * 
         * @param allowEngineModeChange
         *        Specifies whether engine mode changes from <code>serverless</code> to <code>provisioned</code> are
         *        allowed.</p>
         *        <p>
         *        Valid for Cluster Type: Aurora Serverless v1 DB clusters only
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You must allow engine mode changes when specifying a different value for the <code>EngineMode</code>
         *        parameter from the DB cluster's current engine mode.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowEngineModeChange(Boolean allowEngineModeChange);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
         * </p>
         * 
         * @param awsBackupRecoveryPointArn
         *        The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsBackupRecoveryPointArn(String awsBackupRecoveryPointArn);

        /**
         * <p>
         * Specifies whether to enable Aurora Limitless Database. You must enable Aurora Limitless Database to create a
         * DB shard group.
         * </p>
         * <p>
         * Valid for: Aurora DB clusters only
         * </p>
         * <note>
         * <p>
         * This setting is no longer used. Instead use the <code>ClusterScalabilityType</code> setting when you create
         * your Aurora Limitless Database DB cluster.
         * </p>
         * </note>
         * 
         * @param enableLimitlessDatabase
         *        Specifies whether to enable Aurora Limitless Database. You must enable Aurora Limitless Database to
         *        create a DB shard group.</p>
         *        <p>
         *        Valid for: Aurora DB clusters only
         *        </p>
         *        <note>
         *        <p>
         *        This setting is no longer used. Instead use the <code>ClusterScalabilityType</code> setting when you
         *        create your Aurora Limitless Database DB cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableLimitlessDatabase(Boolean enableLimitlessDatabase);

        /**
         * <p>
         * The CA certificate identifier to use for the DB cluster's server certificate.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt
         * a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * <p>
         * Valid for Cluster Type: Multi-AZ DB clusters
         * </p>
         * 
         * @param caCertificateIdentifier
         *        The CA certificate identifier to use for the DB cluster's server certificate.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to
         *        encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i>.
         *        </p>
         *        <p>
         *        Valid for Cluster Type: Multi-AZ DB clusters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateIdentifier(String caCertificateIdentifier);

        /**
         * <p>
         * Specifies the authentication type for the master user. With IAM master user authentication, you can change
         * the master DB user to use IAM database authentication.
         * </p>
         * <p>
         * You can specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>password</code> - Use standard database authentication with a password.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam-db-auth</code> - Use IAM database authentication for the master user.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * This option is only valid for RDS for PostgreSQL and Aurora PostgreSQL engines.
         * </p>
         * 
         * @param masterUserAuthenticationType
         *        Specifies the authentication type for the master user. With IAM master user authentication, you can
         *        change the master DB user to use IAM database authentication.</p>
         *        <p>
         *        You can specify one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>password</code> - Use standard database authentication with a password.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>iam-db-auth</code> - Use IAM database authentication for the master user.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        This option is only valid for RDS for PostgreSQL and Aurora PostgreSQL engines.
         * @see MasterUserAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MasterUserAuthenticationType
         */
        Builder masterUserAuthenticationType(String masterUserAuthenticationType);

        /**
         * <p>
         * Specifies the authentication type for the master user. With IAM master user authentication, you can change
         * the master DB user to use IAM database authentication.
         * </p>
         * <p>
         * You can specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>password</code> - Use standard database authentication with a password.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam-db-auth</code> - Use IAM database authentication for the master user.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * </p>
         * <p>
         * This option is only valid for RDS for PostgreSQL and Aurora PostgreSQL engines.
         * </p>
         * 
         * @param masterUserAuthenticationType
         *        Specifies the authentication type for the master user. With IAM master user authentication, you can
         *        change the master DB user to use IAM database authentication.</p>
         *        <p>
         *        You can specify one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>password</code> - Use standard database authentication with a password.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>iam-db-auth</code> - Use IAM database authentication for the master user.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *        </p>
         *        <p>
         *        This option is only valid for RDS for PostgreSQL and Aurora PostgreSQL engines.
         * @see MasterUserAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MasterUserAuthenticationType
         */
        Builder masterUserAuthenticationType(MasterUserAuthenticationType masterUserAuthenticationType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbClusterIdentifier;

        private String newDBClusterIdentifier;

        private Boolean applyImmediately;

        private Integer backupRetentionPeriod;

        private String dbClusterParameterGroupName;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Integer port;

        private String masterUserPassword;

        private String optionGroupName;

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private Boolean enableIAMDatabaseAuthentication;

        private Long backtrackWindow;

        private CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;

        private String engineVersion;

        private Boolean allowMajorVersionUpgrade;

        private String dbInstanceParameterGroupName;

        private String domain;

        private String domainIAMRoleName;

        private ScalingConfiguration scalingConfiguration;

        private Boolean deletionProtection;

        private Boolean enableHttpEndpoint;

        private Boolean copyTagsToSnapshot;

        private Boolean enableGlobalWriteForwarding;

        private String dbClusterInstanceClass;

        private Integer allocatedStorage;

        private String storageType;

        private Integer iops;

        private Boolean autoMinorVersionUpgrade;

        private String networkType;

        private ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;

        private Integer monitoringInterval;

        private String monitoringRoleArn;

        private String databaseInsightsMode;

        private Boolean enablePerformanceInsights;

        private String performanceInsightsKMSKeyId;

        private Integer performanceInsightsRetentionPeriod;

        private Boolean manageMasterUserPassword;

        private Boolean rotateMasterUserPassword;

        private Boolean enableLocalWriteForwarding;

        private String masterUserSecretKmsKeyId;

        private String engineMode;

        private Boolean allowEngineModeChange;

        private String awsBackupRecoveryPointArn;

        private Boolean enableLimitlessDatabase;

        private String caCertificateIdentifier;

        private String masterUserAuthenticationType;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbClusterRequest model) {
            super(model);
            dbClusterIdentifier(model.dbClusterIdentifier);
            newDBClusterIdentifier(model.newDBClusterIdentifier);
            applyImmediately(model.applyImmediately);
            backupRetentionPeriod(model.backupRetentionPeriod);
            dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            port(model.port);
            masterUserPassword(model.masterUserPassword);
            optionGroupName(model.optionGroupName);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            backtrackWindow(model.backtrackWindow);
            cloudwatchLogsExportConfiguration(model.cloudwatchLogsExportConfiguration);
            engineVersion(model.engineVersion);
            allowMajorVersionUpgrade(model.allowMajorVersionUpgrade);
            dbInstanceParameterGroupName(model.dbInstanceParameterGroupName);
            domain(model.domain);
            domainIAMRoleName(model.domainIAMRoleName);
            scalingConfiguration(model.scalingConfiguration);
            deletionProtection(model.deletionProtection);
            enableHttpEndpoint(model.enableHttpEndpoint);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
            enableGlobalWriteForwarding(model.enableGlobalWriteForwarding);
            dbClusterInstanceClass(model.dbClusterInstanceClass);
            allocatedStorage(model.allocatedStorage);
            storageType(model.storageType);
            iops(model.iops);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            networkType(model.networkType);
            serverlessV2ScalingConfiguration(model.serverlessV2ScalingConfiguration);
            monitoringInterval(model.monitoringInterval);
            monitoringRoleArn(model.monitoringRoleArn);
            databaseInsightsMode(model.databaseInsightsMode);
            enablePerformanceInsights(model.enablePerformanceInsights);
            performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            manageMasterUserPassword(model.manageMasterUserPassword);
            rotateMasterUserPassword(model.rotateMasterUserPassword);
            enableLocalWriteForwarding(model.enableLocalWriteForwarding);
            masterUserSecretKmsKeyId(model.masterUserSecretKmsKeyId);
            engineMode(model.engineMode);
            allowEngineModeChange(model.allowEngineModeChange);
            awsBackupRecoveryPointArn(model.awsBackupRecoveryPointArn);
            enableLimitlessDatabase(model.enableLimitlessDatabase);
            caCertificateIdentifier(model.caCertificateIdentifier);
            masterUserAuthenticationType(model.masterUserAuthenticationType);
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getNewDBClusterIdentifier() {
            return newDBClusterIdentifier;
        }

        public final void setNewDBClusterIdentifier(String newDBClusterIdentifier) {
            this.newDBClusterIdentifier = newDBClusterIdentifier;
        }

        @Override
        public final Builder newDBClusterIdentifier(String newDBClusterIdentifier) {
            this.newDBClusterIdentifier = newDBClusterIdentifier;
            return this;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getDbClusterParameterGroupName() {
            return dbClusterParameterGroupName;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return enableIAMDatabaseAuthentication;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final Long getBacktrackWindow() {
            return backtrackWindow;
        }

        public final void setBacktrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
        }

        @Override
        public final Builder backtrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        public final CloudwatchLogsExportConfiguration.Builder getCloudwatchLogsExportConfiguration() {
            return cloudwatchLogsExportConfiguration != null ? cloudwatchLogsExportConfiguration.toBuilder() : null;
        }

        public final void setCloudwatchLogsExportConfiguration(
                CloudwatchLogsExportConfiguration.BuilderImpl cloudwatchLogsExportConfiguration) {
            this.cloudwatchLogsExportConfiguration = cloudwatchLogsExportConfiguration != null ? cloudwatchLogsExportConfiguration
                    .build() : null;
        }

        @Override
        public final Builder cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration) {
            this.cloudwatchLogsExportConfiguration = cloudwatchLogsExportConfiguration;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getAllowMajorVersionUpgrade() {
            return allowMajorVersionUpgrade;
        }

        public final void setAllowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
        }

        @Override
        public final Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
            return this;
        }

        public final String getDbInstanceParameterGroupName() {
            return dbInstanceParameterGroupName;
        }

        public final void setDbInstanceParameterGroupName(String dbInstanceParameterGroupName) {
            this.dbInstanceParameterGroupName = dbInstanceParameterGroupName;
        }

        @Override
        public final Builder dbInstanceParameterGroupName(String dbInstanceParameterGroupName) {
            this.dbInstanceParameterGroupName = dbInstanceParameterGroupName;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainIAMRoleName() {
            return domainIAMRoleName;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final ScalingConfiguration.Builder getScalingConfiguration() {
            return scalingConfiguration != null ? scalingConfiguration.toBuilder() : null;
        }

        public final void setScalingConfiguration(ScalingConfiguration.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfiguration scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Boolean getEnableHttpEndpoint() {
            return enableHttpEndpoint;
        }

        public final void setEnableHttpEndpoint(Boolean enableHttpEndpoint) {
            this.enableHttpEndpoint = enableHttpEndpoint;
        }

        @Override
        public final Builder enableHttpEndpoint(Boolean enableHttpEndpoint) {
            this.enableHttpEndpoint = enableHttpEndpoint;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final Boolean getEnableGlobalWriteForwarding() {
            return enableGlobalWriteForwarding;
        }

        public final void setEnableGlobalWriteForwarding(Boolean enableGlobalWriteForwarding) {
            this.enableGlobalWriteForwarding = enableGlobalWriteForwarding;
        }

        @Override
        public final Builder enableGlobalWriteForwarding(Boolean enableGlobalWriteForwarding) {
            this.enableGlobalWriteForwarding = enableGlobalWriteForwarding;
            return this;
        }

        public final String getDbClusterInstanceClass() {
            return dbClusterInstanceClass;
        }

        public final void setDbClusterInstanceClass(String dbClusterInstanceClass) {
            this.dbClusterInstanceClass = dbClusterInstanceClass;
        }

        @Override
        public final Builder dbClusterInstanceClass(String dbClusterInstanceClass) {
            this.dbClusterInstanceClass = dbClusterInstanceClass;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public final ServerlessV2ScalingConfiguration.Builder getServerlessV2ScalingConfiguration() {
            return serverlessV2ScalingConfiguration != null ? serverlessV2ScalingConfiguration.toBuilder() : null;
        }

        public final void setServerlessV2ScalingConfiguration(
                ServerlessV2ScalingConfiguration.BuilderImpl serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration != null ? serverlessV2ScalingConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration;
            return this;
        }

        public final Integer getMonitoringInterval() {
            return monitoringInterval;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final String getMonitoringRoleArn() {
            return monitoringRoleArn;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final String getDatabaseInsightsMode() {
            return databaseInsightsMode;
        }

        public final void setDatabaseInsightsMode(String databaseInsightsMode) {
            this.databaseInsightsMode = databaseInsightsMode;
        }

        @Override
        public final Builder databaseInsightsMode(String databaseInsightsMode) {
            this.databaseInsightsMode = databaseInsightsMode;
            return this;
        }

        @Override
        public final Builder databaseInsightsMode(DatabaseInsightsMode databaseInsightsMode) {
            this.databaseInsightsMode(databaseInsightsMode == null ? null : databaseInsightsMode.toString());
            return this;
        }

        public final Boolean getEnablePerformanceInsights() {
            return enablePerformanceInsights;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        @Override
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return performanceInsightsKMSKeyId;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return performanceInsightsRetentionPeriod;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        @Override
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final Boolean getManageMasterUserPassword() {
            return manageMasterUserPassword;
        }

        public final void setManageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
        }

        @Override
        public final Builder manageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
            return this;
        }

        public final Boolean getRotateMasterUserPassword() {
            return rotateMasterUserPassword;
        }

        public final void setRotateMasterUserPassword(Boolean rotateMasterUserPassword) {
            this.rotateMasterUserPassword = rotateMasterUserPassword;
        }

        @Override
        public final Builder rotateMasterUserPassword(Boolean rotateMasterUserPassword) {
            this.rotateMasterUserPassword = rotateMasterUserPassword;
            return this;
        }

        public final Boolean getEnableLocalWriteForwarding() {
            return enableLocalWriteForwarding;
        }

        public final void setEnableLocalWriteForwarding(Boolean enableLocalWriteForwarding) {
            this.enableLocalWriteForwarding = enableLocalWriteForwarding;
        }

        @Override
        public final Builder enableLocalWriteForwarding(Boolean enableLocalWriteForwarding) {
            this.enableLocalWriteForwarding = enableLocalWriteForwarding;
            return this;
        }

        public final String getMasterUserSecretKmsKeyId() {
            return masterUserSecretKmsKeyId;
        }

        public final void setMasterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
        }

        @Override
        public final Builder masterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
            return this;
        }

        public final String getEngineMode() {
            return engineMode;
        }

        public final void setEngineMode(String engineMode) {
            this.engineMode = engineMode;
        }

        @Override
        public final Builder engineMode(String engineMode) {
            this.engineMode = engineMode;
            return this;
        }

        public final Boolean getAllowEngineModeChange() {
            return allowEngineModeChange;
        }

        public final void setAllowEngineModeChange(Boolean allowEngineModeChange) {
            this.allowEngineModeChange = allowEngineModeChange;
        }

        @Override
        public final Builder allowEngineModeChange(Boolean allowEngineModeChange) {
            this.allowEngineModeChange = allowEngineModeChange;
            return this;
        }

        public final String getAwsBackupRecoveryPointArn() {
            return awsBackupRecoveryPointArn;
        }

        public final void setAwsBackupRecoveryPointArn(String awsBackupRecoveryPointArn) {
            this.awsBackupRecoveryPointArn = awsBackupRecoveryPointArn;
        }

        @Override
        public final Builder awsBackupRecoveryPointArn(String awsBackupRecoveryPointArn) {
            this.awsBackupRecoveryPointArn = awsBackupRecoveryPointArn;
            return this;
        }

        public final Boolean getEnableLimitlessDatabase() {
            return enableLimitlessDatabase;
        }

        public final void setEnableLimitlessDatabase(Boolean enableLimitlessDatabase) {
            this.enableLimitlessDatabase = enableLimitlessDatabase;
        }

        @Override
        public final Builder enableLimitlessDatabase(Boolean enableLimitlessDatabase) {
            this.enableLimitlessDatabase = enableLimitlessDatabase;
            return this;
        }

        public final String getCaCertificateIdentifier() {
            return caCertificateIdentifier;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final String getMasterUserAuthenticationType() {
            return masterUserAuthenticationType;
        }

        public final void setMasterUserAuthenticationType(String masterUserAuthenticationType) {
            this.masterUserAuthenticationType = masterUserAuthenticationType;
        }

        @Override
        public final Builder masterUserAuthenticationType(String masterUserAuthenticationType) {
            this.masterUserAuthenticationType = masterUserAuthenticationType;
            return this;
        }

        @Override
        public final Builder masterUserAuthenticationType(MasterUserAuthenticationType masterUserAuthenticationType) {
            this.masterUserAuthenticationType(masterUserAuthenticationType == null ? null : masterUserAuthenticationType
                    .toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbClusterRequest build() {
            return new ModifyDbClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
