/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDbProxyRequest extends RdsRequest implements
        ToCopyableBuilder<CreateDbProxyRequest.Builder, CreateDbProxyRequest> {
    private static final SdkField<String> DB_PROXY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBProxyName").getter(getter(CreateDbProxyRequest::dbProxyName)).setter(setter(Builder::dbProxyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyName").build()).build();

    private static final SdkField<String> ENGINE_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineFamily").getter(getter(CreateDbProxyRequest::engineFamilyAsString))
            .setter(setter(Builder::engineFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineFamily").build()).build();

    private static final SdkField<String> DEFAULT_AUTH_SCHEME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultAuthScheme").getter(getter(CreateDbProxyRequest::defaultAuthSchemeAsString))
            .setter(setter(Builder::defaultAuthScheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAuthScheme").build()).build();

    private static final SdkField<List<UserAuthConfig>> AUTH_FIELD = SdkField
            .<List<UserAuthConfig>> builder(MarshallingType.LIST)
            .memberName("Auth")
            .getter(getter(CreateDbProxyRequest::auth))
            .setter(setter(Builder::auth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Auth").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserAuthConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserAuthConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateDbProxyRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<String>> VPC_SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSubnetIds")
            .getter(getter(CreateDbProxyRequest::vpcSubnetIds))
            .setter(setter(Builder::vpcSubnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(CreateDbProxyRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> REQUIRE_TLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireTLS").getter(getter(CreateDbProxyRequest::requireTLS)).setter(setter(Builder::requireTLS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireTLS").build()).build();

    private static final SdkField<Integer> IDLE_CLIENT_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IdleClientTimeout").getter(getter(CreateDbProxyRequest::idleClientTimeout))
            .setter(setter(Builder::idleClientTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleClientTimeout").build()).build();

    private static final SdkField<Boolean> DEBUG_LOGGING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DebugLogging").getter(getter(CreateDbProxyRequest::debugLogging)).setter(setter(Builder::debugLogging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugLogging").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDbProxyRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<String> ENDPOINT_NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointNetworkType").getter(getter(CreateDbProxyRequest::endpointNetworkTypeAsString))
            .setter(setter(Builder::endpointNetworkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointNetworkType").build())
            .build();

    private static final SdkField<String> TARGET_CONNECTION_NETWORK_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetConnectionNetworkType")
            .getter(getter(CreateDbProxyRequest::targetConnectionNetworkTypeAsString))
            .setter(setter(Builder::targetConnectionNetworkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConnectionNetworkType")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_NAME_FIELD,
            ENGINE_FAMILY_FIELD, DEFAULT_AUTH_SCHEME_FIELD, AUTH_FIELD, ROLE_ARN_FIELD, VPC_SUBNET_IDS_FIELD,
            VPC_SECURITY_GROUP_IDS_FIELD, REQUIRE_TLS_FIELD, IDLE_CLIENT_TIMEOUT_FIELD, DEBUG_LOGGING_FIELD, TAGS_FIELD,
            ENDPOINT_NETWORK_TYPE_FIELD, TARGET_CONNECTION_NETWORK_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbProxyName;

    private final String engineFamily;

    private final String defaultAuthScheme;

    private final List<UserAuthConfig> auth;

    private final String roleArn;

    private final List<String> vpcSubnetIds;

    private final List<String> vpcSecurityGroupIds;

    private final Boolean requireTLS;

    private final Integer idleClientTimeout;

    private final Boolean debugLogging;

    private final List<Tag> tags;

    private final String endpointNetworkType;

    private final String targetConnectionNetworkType;

    private CreateDbProxyRequest(BuilderImpl builder) {
        super(builder);
        this.dbProxyName = builder.dbProxyName;
        this.engineFamily = builder.engineFamily;
        this.defaultAuthScheme = builder.defaultAuthScheme;
        this.auth = builder.auth;
        this.roleArn = builder.roleArn;
        this.vpcSubnetIds = builder.vpcSubnetIds;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.requireTLS = builder.requireTLS;
        this.idleClientTimeout = builder.idleClientTimeout;
        this.debugLogging = builder.debugLogging;
        this.tags = builder.tags;
        this.endpointNetworkType = builder.endpointNetworkType;
        this.targetConnectionNetworkType = builder.targetConnectionNetworkType;
    }

    /**
     * <p>
     * The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account
     * in the specified Amazon Web Services Region. An identifier must begin with a letter and must contain only ASCII
     * letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * 
     * @return The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services
     *         account in the specified Amazon Web Services Region. An identifier must begin with a letter and must
     *         contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive
     *         hyphens.
     */
    public final String dbProxyName() {
        return dbProxyName;
    }

    /**
     * <p>
     * The kinds of databases that the proxy can connect to. This value determines which database network protocol the
     * proxy recognizes when it interprets network traffic to and from the database. For Aurora MySQL, RDS for MariaDB,
     * and RDS for MySQL databases, specify <code>MYSQL</code>. For Aurora PostgreSQL and RDS for PostgreSQL databases,
     * specify <code>POSTGRESQL</code>. For RDS for Microsoft SQL Server, specify <code>SQLSERVER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineFamily} will
     * return {@link EngineFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineFamilyAsString}.
     * </p>
     * 
     * @return The kinds of databases that the proxy can connect to. This value determines which database network
     *         protocol the proxy recognizes when it interprets network traffic to and from the database. For Aurora
     *         MySQL, RDS for MariaDB, and RDS for MySQL databases, specify <code>MYSQL</code>. For Aurora PostgreSQL
     *         and RDS for PostgreSQL databases, specify <code>POSTGRESQL</code>. For RDS for Microsoft SQL Server,
     *         specify <code>SQLSERVER</code>.
     * @see EngineFamily
     */
    public final EngineFamily engineFamily() {
        return EngineFamily.fromValue(engineFamily);
    }

    /**
     * <p>
     * The kinds of databases that the proxy can connect to. This value determines which database network protocol the
     * proxy recognizes when it interprets network traffic to and from the database. For Aurora MySQL, RDS for MariaDB,
     * and RDS for MySQL databases, specify <code>MYSQL</code>. For Aurora PostgreSQL and RDS for PostgreSQL databases,
     * specify <code>POSTGRESQL</code>. For RDS for Microsoft SQL Server, specify <code>SQLSERVER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineFamily} will
     * return {@link EngineFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineFamilyAsString}.
     * </p>
     * 
     * @return The kinds of databases that the proxy can connect to. This value determines which database network
     *         protocol the proxy recognizes when it interprets network traffic to and from the database. For Aurora
     *         MySQL, RDS for MariaDB, and RDS for MySQL databases, specify <code>MYSQL</code>. For Aurora PostgreSQL
     *         and RDS for PostgreSQL databases, specify <code>POSTGRESQL</code>. For RDS for Microsoft SQL Server,
     *         specify <code>SQLSERVER</code>.
     * @see EngineFamily
     */
    public final String engineFamilyAsString() {
        return engineFamily;
    }

    /**
     * <p>
     * The default authentication scheme that the proxy uses for client connections to the proxy and connections from
     * the proxy to the underlying database. Valid values are <code>NONE</code> and <code>IAM_AUTH</code>. When set to
     * <code>IAM_AUTH</code>, the proxy uses end-to-end IAM authentication to connect to the database. If you don't
     * specify <code>DefaultAuthScheme</code> or specify this parameter as <code>NONE</code>, you must specify the
     * <code>Auth</code> option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultAuthScheme}
     * will return {@link DefaultAuthScheme#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #defaultAuthSchemeAsString}.
     * </p>
     * 
     * @return The default authentication scheme that the proxy uses for client connections to the proxy and connections
     *         from the proxy to the underlying database. Valid values are <code>NONE</code> and <code>IAM_AUTH</code>.
     *         When set to <code>IAM_AUTH</code>, the proxy uses end-to-end IAM authentication to connect to the
     *         database. If you don't specify <code>DefaultAuthScheme</code> or specify this parameter as
     *         <code>NONE</code>, you must specify the <code>Auth</code> option.
     * @see DefaultAuthScheme
     */
    public final DefaultAuthScheme defaultAuthScheme() {
        return DefaultAuthScheme.fromValue(defaultAuthScheme);
    }

    /**
     * <p>
     * The default authentication scheme that the proxy uses for client connections to the proxy and connections from
     * the proxy to the underlying database. Valid values are <code>NONE</code> and <code>IAM_AUTH</code>. When set to
     * <code>IAM_AUTH</code>, the proxy uses end-to-end IAM authentication to connect to the database. If you don't
     * specify <code>DefaultAuthScheme</code> or specify this parameter as <code>NONE</code>, you must specify the
     * <code>Auth</code> option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultAuthScheme}
     * will return {@link DefaultAuthScheme#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #defaultAuthSchemeAsString}.
     * </p>
     * 
     * @return The default authentication scheme that the proxy uses for client connections to the proxy and connections
     *         from the proxy to the underlying database. Valid values are <code>NONE</code> and <code>IAM_AUTH</code>.
     *         When set to <code>IAM_AUTH</code>, the proxy uses end-to-end IAM authentication to connect to the
     *         database. If you don't specify <code>DefaultAuthScheme</code> or specify this parameter as
     *         <code>NONE</code>, you must specify the <code>Auth</code> option.
     * @see DefaultAuthScheme
     */
    public final String defaultAuthSchemeAsString() {
        return defaultAuthScheme;
    }

    /**
     * For responses, this returns true if the service returned a value for the Auth property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAuth() {
        return auth != null && !(auth instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The authorization mechanism that the proxy uses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuth} method.
     * </p>
     * 
     * @return The authorization mechanism that the proxy uses.
     */
    public final List<UserAuthConfig> auth() {
        return auth;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services
     * Secrets Manager.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web
     *         Services Secrets Manager.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSubnetIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSubnetIds() {
        return vpcSubnetIds != null && !(vpcSubnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more VPC subnet IDs to associate with the new proxy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSubnetIds} method.
     * </p>
     * 
     * @return One or more VPC subnet IDs to associate with the new proxy.
     */
    public final List<String> vpcSubnetIds() {
        return vpcSubnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more VPC security group IDs to associate with the new proxy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return One or more VPC security group IDs to associate with the new proxy.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * Specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling
     * this setting, you can enforce encrypted TLS connections to the proxy.
     * </p>
     * 
     * @return Specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By
     *         enabling this setting, you can enforce encrypted TLS connections to the proxy.
     */
    public final Boolean requireTLS() {
        return requireTLS;
    }

    /**
     * <p>
     * The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set
     * this value higher or lower than the connection timeout limit for the associated database.
     * </p>
     * 
     * @return The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You
     *         can set this value higher or lower than the connection timeout limit for the associated database.
     */
    public final Integer idleClientTimeout() {
        return idleClientTimeout;
    }

    /**
     * <p>
     * Specifies whether the proxy logs detailed connection and query information. When you enable
     * <code>DebugLogging</code>, the proxy captures connection details and connection pool behavior from your queries.
     * Debug logging increases CloudWatch costs and can impact proxy performance. Enable this option only when you need
     * to troubleshoot connection or performance issues.
     * </p>
     * 
     * @return Specifies whether the proxy logs detailed connection and query information. When you enable
     *         <code>DebugLogging</code>, the proxy captures connection details and connection pool behavior from your
     *         queries. Debug logging increases CloudWatch costs and can impact proxy performance. Enable this option
     *         only when you need to troubleshoot connection or performance issues.
     */
    public final Boolean debugLogging() {
        return debugLogging;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The network type of the DB proxy endpoint. The network type determines the IP version that the proxy endpoint
     * supports.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IPV4</code> - The proxy endpoint supports IPv4 only.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IPV6</code> - The proxy endpoint supports IPv6 only.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DUAL</code> - The proxy endpoint supports both IPv4 and IPv6.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>IPV4</code>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify <code>IPV6</code> or <code>DUAL</code>, the VPC and all subnets must have an IPv6 CIDR block.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify <code>IPV6</code> or <code>DUAL</code>, the VPC tenancy cannot be <code>dedicated</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #endpointNetworkType} will return {@link EndpointNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #endpointNetworkTypeAsString}.
     * </p>
     * 
     * @return The network type of the DB proxy endpoint. The network type determines the IP version that the proxy
     *         endpoint supports.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IPV4</code> - The proxy endpoint supports IPv4 only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IPV6</code> - The proxy endpoint supports IPv6 only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DUAL</code> - The proxy endpoint supports both IPv4 and IPv6.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>IPV4</code>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify <code>IPV6</code> or <code>DUAL</code>, the VPC and all subnets must have an IPv6 CIDR
     *         block.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify <code>IPV6</code> or <code>DUAL</code>, the VPC tenancy cannot be <code>dedicated</code>.
     *         </p>
     *         </li>
     * @see EndpointNetworkType
     */
    public final EndpointNetworkType endpointNetworkType() {
        return EndpointNetworkType.fromValue(endpointNetworkType);
    }

    /**
     * <p>
     * The network type of the DB proxy endpoint. The network type determines the IP version that the proxy endpoint
     * supports.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IPV4</code> - The proxy endpoint supports IPv4 only.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IPV6</code> - The proxy endpoint supports IPv6 only.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DUAL</code> - The proxy endpoint supports both IPv4 and IPv6.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>IPV4</code>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify <code>IPV6</code> or <code>DUAL</code>, the VPC and all subnets must have an IPv6 CIDR block.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify <code>IPV6</code> or <code>DUAL</code>, the VPC tenancy cannot be <code>dedicated</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #endpointNetworkType} will return {@link EndpointNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #endpointNetworkTypeAsString}.
     * </p>
     * 
     * @return The network type of the DB proxy endpoint. The network type determines the IP version that the proxy
     *         endpoint supports.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IPV4</code> - The proxy endpoint supports IPv4 only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IPV6</code> - The proxy endpoint supports IPv6 only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DUAL</code> - The proxy endpoint supports both IPv4 and IPv6.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>IPV4</code>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify <code>IPV6</code> or <code>DUAL</code>, the VPC and all subnets must have an IPv6 CIDR
     *         block.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify <code>IPV6</code> or <code>DUAL</code>, the VPC tenancy cannot be <code>dedicated</code>.
     *         </p>
     *         </li>
     * @see EndpointNetworkType
     */
    public final String endpointNetworkTypeAsString() {
        return endpointNetworkType;
    }

    /**
     * <p>
     * The network type that the proxy uses to connect to the target database. The network type determines the IP
     * version that the proxy uses for connections to the database.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IPV4</code> - The proxy connects to the database using IPv4 only.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IPV6</code> - The proxy connects to the database using IPv6 only.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>IPV4</code>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify <code>IPV6</code>, the database must support dual-stack mode. RDS doesn't support IPv6-only
     * databases.
     * </p>
     * </li>
     * <li>
     * <p>
     * All targets registered with the proxy must be compatible with the specified network type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetConnectionNetworkType} will return {@link TargetConnectionNetworkType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #targetConnectionNetworkTypeAsString}.
     * </p>
     * 
     * @return The network type that the proxy uses to connect to the target database. The network type determines the
     *         IP version that the proxy uses for connections to the database.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IPV4</code> - The proxy connects to the database using IPv4 only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IPV6</code> - The proxy connects to the database using IPv6 only.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>IPV4</code>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify <code>IPV6</code>, the database must support dual-stack mode. RDS doesn't support
     *         IPv6-only databases.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         All targets registered with the proxy must be compatible with the specified network type.
     *         </p>
     *         </li>
     * @see TargetConnectionNetworkType
     */
    public final TargetConnectionNetworkType targetConnectionNetworkType() {
        return TargetConnectionNetworkType.fromValue(targetConnectionNetworkType);
    }

    /**
     * <p>
     * The network type that the proxy uses to connect to the target database. The network type determines the IP
     * version that the proxy uses for connections to the database.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IPV4</code> - The proxy connects to the database using IPv4 only.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IPV6</code> - The proxy connects to the database using IPv6 only.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>IPV4</code>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify <code>IPV6</code>, the database must support dual-stack mode. RDS doesn't support IPv6-only
     * databases.
     * </p>
     * </li>
     * <li>
     * <p>
     * All targets registered with the proxy must be compatible with the specified network type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetConnectionNetworkType} will return {@link TargetConnectionNetworkType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #targetConnectionNetworkTypeAsString}.
     * </p>
     * 
     * @return The network type that the proxy uses to connect to the target database. The network type determines the
     *         IP version that the proxy uses for connections to the database.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IPV4</code> - The proxy connects to the database using IPv4 only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IPV6</code> - The proxy connects to the database using IPv6 only.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>IPV4</code>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify <code>IPV6</code>, the database must support dual-stack mode. RDS doesn't support
     *         IPv6-only databases.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         All targets registered with the proxy must be compatible with the specified network type.
     *         </p>
     *         </li>
     * @see TargetConnectionNetworkType
     */
    public final String targetConnectionNetworkTypeAsString() {
        return targetConnectionNetworkType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbProxyName());
        hashCode = 31 * hashCode + Objects.hashCode(engineFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAuthSchemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuth() ? auth() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSubnetIds() ? vpcSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requireTLS());
        hashCode = 31 * hashCode + Objects.hashCode(idleClientTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(debugLogging());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(endpointNetworkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetConnectionNetworkTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbProxyRequest)) {
            return false;
        }
        CreateDbProxyRequest other = (CreateDbProxyRequest) obj;
        return Objects.equals(dbProxyName(), other.dbProxyName())
                && Objects.equals(engineFamilyAsString(), other.engineFamilyAsString())
                && Objects.equals(defaultAuthSchemeAsString(), other.defaultAuthSchemeAsString()) && hasAuth() == other.hasAuth()
                && Objects.equals(auth(), other.auth()) && Objects.equals(roleArn(), other.roleArn())
                && hasVpcSubnetIds() == other.hasVpcSubnetIds() && Objects.equals(vpcSubnetIds(), other.vpcSubnetIds())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(requireTLS(), other.requireTLS())
                && Objects.equals(idleClientTimeout(), other.idleClientTimeout())
                && Objects.equals(debugLogging(), other.debugLogging()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(endpointNetworkTypeAsString(), other.endpointNetworkTypeAsString())
                && Objects.equals(targetConnectionNetworkTypeAsString(), other.targetConnectionNetworkTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDbProxyRequest").add("DBProxyName", dbProxyName())
                .add("EngineFamily", engineFamilyAsString()).add("DefaultAuthScheme", defaultAuthSchemeAsString())
                .add("Auth", hasAuth() ? auth() : null).add("RoleArn", roleArn())
                .add("VpcSubnetIds", hasVpcSubnetIds() ? vpcSubnetIds() : null)
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("RequireTLS", requireTLS()).add("IdleClientTimeout", idleClientTimeout())
                .add("DebugLogging", debugLogging()).add("Tags", hasTags() ? tags() : null)
                .add("EndpointNetworkType", endpointNetworkTypeAsString())
                .add("TargetConnectionNetworkType", targetConnectionNetworkTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBProxyName":
            return Optional.ofNullable(clazz.cast(dbProxyName()));
        case "EngineFamily":
            return Optional.ofNullable(clazz.cast(engineFamilyAsString()));
        case "DefaultAuthScheme":
            return Optional.ofNullable(clazz.cast(defaultAuthSchemeAsString()));
        case "Auth":
            return Optional.ofNullable(clazz.cast(auth()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "VpcSubnetIds":
            return Optional.ofNullable(clazz.cast(vpcSubnetIds()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "RequireTLS":
            return Optional.ofNullable(clazz.cast(requireTLS()));
        case "IdleClientTimeout":
            return Optional.ofNullable(clazz.cast(idleClientTimeout()));
        case "DebugLogging":
            return Optional.ofNullable(clazz.cast(debugLogging()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "EndpointNetworkType":
            return Optional.ofNullable(clazz.cast(endpointNetworkTypeAsString()));
        case "TargetConnectionNetworkType":
            return Optional.ofNullable(clazz.cast(targetConnectionNetworkTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBProxyName", DB_PROXY_NAME_FIELD);
        map.put("EngineFamily", ENGINE_FAMILY_FIELD);
        map.put("DefaultAuthScheme", DEFAULT_AUTH_SCHEME_FIELD);
        map.put("Auth", AUTH_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("VpcSubnetIds", VPC_SUBNET_IDS_FIELD);
        map.put("VpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("RequireTLS", REQUIRE_TLS_FIELD);
        map.put("IdleClientTimeout", IDLE_CLIENT_TIMEOUT_FIELD);
        map.put("DebugLogging", DEBUG_LOGGING_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("EndpointNetworkType", ENDPOINT_NETWORK_TYPE_FIELD);
        map.put("TargetConnectionNetworkType", TARGET_CONNECTION_NETWORK_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDbProxyRequest, T> g) {
        return obj -> g.apply((CreateDbProxyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDbProxyRequest> {
        /**
         * <p>
         * The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services
         * account in the specified Amazon Web Services Region. An identifier must begin with a letter and must contain
         * only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * 
         * @param dbProxyName
         *        The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web
         *        Services account in the specified Amazon Web Services Region. An identifier must begin with a letter
         *        and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two
         *        consecutive hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbProxyName(String dbProxyName);

        /**
         * <p>
         * The kinds of databases that the proxy can connect to. This value determines which database network protocol
         * the proxy recognizes when it interprets network traffic to and from the database. For Aurora MySQL, RDS for
         * MariaDB, and RDS for MySQL databases, specify <code>MYSQL</code>. For Aurora PostgreSQL and RDS for
         * PostgreSQL databases, specify <code>POSTGRESQL</code>. For RDS for Microsoft SQL Server, specify
         * <code>SQLSERVER</code>.
         * </p>
         * 
         * @param engineFamily
         *        The kinds of databases that the proxy can connect to. This value determines which database network
         *        protocol the proxy recognizes when it interprets network traffic to and from the database. For Aurora
         *        MySQL, RDS for MariaDB, and RDS for MySQL databases, specify <code>MYSQL</code>. For Aurora PostgreSQL
         *        and RDS for PostgreSQL databases, specify <code>POSTGRESQL</code>. For RDS for Microsoft SQL Server,
         *        specify <code>SQLSERVER</code>.
         * @see EngineFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineFamily
         */
        Builder engineFamily(String engineFamily);

        /**
         * <p>
         * The kinds of databases that the proxy can connect to. This value determines which database network protocol
         * the proxy recognizes when it interprets network traffic to and from the database. For Aurora MySQL, RDS for
         * MariaDB, and RDS for MySQL databases, specify <code>MYSQL</code>. For Aurora PostgreSQL and RDS for
         * PostgreSQL databases, specify <code>POSTGRESQL</code>. For RDS for Microsoft SQL Server, specify
         * <code>SQLSERVER</code>.
         * </p>
         * 
         * @param engineFamily
         *        The kinds of databases that the proxy can connect to. This value determines which database network
         *        protocol the proxy recognizes when it interprets network traffic to and from the database. For Aurora
         *        MySQL, RDS for MariaDB, and RDS for MySQL databases, specify <code>MYSQL</code>. For Aurora PostgreSQL
         *        and RDS for PostgreSQL databases, specify <code>POSTGRESQL</code>. For RDS for Microsoft SQL Server,
         *        specify <code>SQLSERVER</code>.
         * @see EngineFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineFamily
         */
        Builder engineFamily(EngineFamily engineFamily);

        /**
         * <p>
         * The default authentication scheme that the proxy uses for client connections to the proxy and connections
         * from the proxy to the underlying database. Valid values are <code>NONE</code> and <code>IAM_AUTH</code>. When
         * set to <code>IAM_AUTH</code>, the proxy uses end-to-end IAM authentication to connect to the database. If you
         * don't specify <code>DefaultAuthScheme</code> or specify this parameter as <code>NONE</code>, you must specify
         * the <code>Auth</code> option.
         * </p>
         * 
         * @param defaultAuthScheme
         *        The default authentication scheme that the proxy uses for client connections to the proxy and
         *        connections from the proxy to the underlying database. Valid values are <code>NONE</code> and
         *        <code>IAM_AUTH</code>. When set to <code>IAM_AUTH</code>, the proxy uses end-to-end IAM authentication
         *        to connect to the database. If you don't specify <code>DefaultAuthScheme</code> or specify this
         *        parameter as <code>NONE</code>, you must specify the <code>Auth</code> option.
         * @see DefaultAuthScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultAuthScheme
         */
        Builder defaultAuthScheme(String defaultAuthScheme);

        /**
         * <p>
         * The default authentication scheme that the proxy uses for client connections to the proxy and connections
         * from the proxy to the underlying database. Valid values are <code>NONE</code> and <code>IAM_AUTH</code>. When
         * set to <code>IAM_AUTH</code>, the proxy uses end-to-end IAM authentication to connect to the database. If you
         * don't specify <code>DefaultAuthScheme</code> or specify this parameter as <code>NONE</code>, you must specify
         * the <code>Auth</code> option.
         * </p>
         * 
         * @param defaultAuthScheme
         *        The default authentication scheme that the proxy uses for client connections to the proxy and
         *        connections from the proxy to the underlying database. Valid values are <code>NONE</code> and
         *        <code>IAM_AUTH</code>. When set to <code>IAM_AUTH</code>, the proxy uses end-to-end IAM authentication
         *        to connect to the database. If you don't specify <code>DefaultAuthScheme</code> or specify this
         *        parameter as <code>NONE</code>, you must specify the <code>Auth</code> option.
         * @see DefaultAuthScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultAuthScheme
         */
        Builder defaultAuthScheme(DefaultAuthScheme defaultAuthScheme);

        /**
         * <p>
         * The authorization mechanism that the proxy uses.
         * </p>
         * 
         * @param auth
         *        The authorization mechanism that the proxy uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auth(Collection<UserAuthConfig> auth);

        /**
         * <p>
         * The authorization mechanism that the proxy uses.
         * </p>
         * 
         * @param auth
         *        The authorization mechanism that the proxy uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auth(UserAuthConfig... auth);

        /**
         * <p>
         * The authorization mechanism that the proxy uses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.UserAuthConfig.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.UserAuthConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.UserAuthConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #auth(List<UserAuthConfig>)}.
         * 
         * @param auth
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.UserAuthConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auth(java.util.Collection<UserAuthConfig>)
         */
        Builder auth(Consumer<UserAuthConfig.Builder>... auth);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services
         * Secrets Manager.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web
         *        Services Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * One or more VPC subnet IDs to associate with the new proxy.
         * </p>
         * 
         * @param vpcSubnetIds
         *        One or more VPC subnet IDs to associate with the new proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSubnetIds(Collection<String> vpcSubnetIds);

        /**
         * <p>
         * One or more VPC subnet IDs to associate with the new proxy.
         * </p>
         * 
         * @param vpcSubnetIds
         *        One or more VPC subnet IDs to associate with the new proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSubnetIds(String... vpcSubnetIds);

        /**
         * <p>
         * One or more VPC security group IDs to associate with the new proxy.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        One or more VPC security group IDs to associate with the new proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * One or more VPC security group IDs to associate with the new proxy.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        One or more VPC security group IDs to associate with the new proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * Specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By
         * enabling this setting, you can enforce encrypted TLS connections to the proxy.
         * </p>
         * 
         * @param requireTLS
         *        Specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
         *        By enabling this setting, you can enforce encrypted TLS connections to the proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireTLS(Boolean requireTLS);

        /**
         * <p>
         * The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can
         * set this value higher or lower than the connection timeout limit for the associated database.
         * </p>
         * 
         * @param idleClientTimeout
         *        The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it.
         *        You can set this value higher or lower than the connection timeout limit for the associated database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleClientTimeout(Integer idleClientTimeout);

        /**
         * <p>
         * Specifies whether the proxy logs detailed connection and query information. When you enable
         * <code>DebugLogging</code>, the proxy captures connection details and connection pool behavior from your
         * queries. Debug logging increases CloudWatch costs and can impact proxy performance. Enable this option only
         * when you need to troubleshoot connection or performance issues.
         * </p>
         * 
         * @param debugLogging
         *        Specifies whether the proxy logs detailed connection and query information. When you enable
         *        <code>DebugLogging</code>, the proxy captures connection details and connection pool behavior from
         *        your queries. Debug logging increases CloudWatch costs and can impact proxy performance. Enable this
         *        option only when you need to troubleshoot connection or performance issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder debugLogging(Boolean debugLogging);

        /**
         * <p>
         * An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.
         * </p>
         * 
         * @param tags
         *        An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.
         * </p>
         * 
         * @param tags
         *        An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The network type of the DB proxy endpoint. The network type determines the IP version that the proxy endpoint
         * supports.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IPV4</code> - The proxy endpoint supports IPv4 only.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IPV6</code> - The proxy endpoint supports IPv6 only.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DUAL</code> - The proxy endpoint supports both IPv4 and IPv6.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>IPV4</code>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify <code>IPV6</code> or <code>DUAL</code>, the VPC and all subnets must have an IPv6 CIDR block.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <code>IPV6</code> or <code>DUAL</code>, the VPC tenancy cannot be <code>dedicated</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endpointNetworkType
         *        The network type of the DB proxy endpoint. The network type determines the IP version that the proxy
         *        endpoint supports.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IPV4</code> - The proxy endpoint supports IPv4 only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IPV6</code> - The proxy endpoint supports IPv6 only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DUAL</code> - The proxy endpoint supports both IPv4 and IPv6.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>IPV4</code>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify <code>IPV6</code> or <code>DUAL</code>, the VPC and all subnets must have an IPv6 CIDR
         *        block.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify <code>IPV6</code> or <code>DUAL</code>, the VPC tenancy cannot be
         *        <code>dedicated</code>.
         *        </p>
         *        </li>
         * @see EndpointNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointNetworkType
         */
        Builder endpointNetworkType(String endpointNetworkType);

        /**
         * <p>
         * The network type of the DB proxy endpoint. The network type determines the IP version that the proxy endpoint
         * supports.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IPV4</code> - The proxy endpoint supports IPv4 only.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IPV6</code> - The proxy endpoint supports IPv6 only.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DUAL</code> - The proxy endpoint supports both IPv4 and IPv6.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>IPV4</code>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify <code>IPV6</code> or <code>DUAL</code>, the VPC and all subnets must have an IPv6 CIDR block.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <code>IPV6</code> or <code>DUAL</code>, the VPC tenancy cannot be <code>dedicated</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endpointNetworkType
         *        The network type of the DB proxy endpoint. The network type determines the IP version that the proxy
         *        endpoint supports.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IPV4</code> - The proxy endpoint supports IPv4 only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IPV6</code> - The proxy endpoint supports IPv6 only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DUAL</code> - The proxy endpoint supports both IPv4 and IPv6.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>IPV4</code>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify <code>IPV6</code> or <code>DUAL</code>, the VPC and all subnets must have an IPv6 CIDR
         *        block.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify <code>IPV6</code> or <code>DUAL</code>, the VPC tenancy cannot be
         *        <code>dedicated</code>.
         *        </p>
         *        </li>
         * @see EndpointNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointNetworkType
         */
        Builder endpointNetworkType(EndpointNetworkType endpointNetworkType);

        /**
         * <p>
         * The network type that the proxy uses to connect to the target database. The network type determines the IP
         * version that the proxy uses for connections to the database.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IPV4</code> - The proxy connects to the database using IPv4 only.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IPV6</code> - The proxy connects to the database using IPv6 only.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>IPV4</code>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify <code>IPV6</code>, the database must support dual-stack mode. RDS doesn't support IPv6-only
         * databases.
         * </p>
         * </li>
         * <li>
         * <p>
         * All targets registered with the proxy must be compatible with the specified network type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetConnectionNetworkType
         *        The network type that the proxy uses to connect to the target database. The network type determines
         *        the IP version that the proxy uses for connections to the database.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IPV4</code> - The proxy connects to the database using IPv4 only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IPV6</code> - The proxy connects to the database using IPv6 only.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>IPV4</code>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify <code>IPV6</code>, the database must support dual-stack mode. RDS doesn't support
         *        IPv6-only databases.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        All targets registered with the proxy must be compatible with the specified network type.
         *        </p>
         *        </li>
         * @see TargetConnectionNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetConnectionNetworkType
         */
        Builder targetConnectionNetworkType(String targetConnectionNetworkType);

        /**
         * <p>
         * The network type that the proxy uses to connect to the target database. The network type determines the IP
         * version that the proxy uses for connections to the database.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IPV4</code> - The proxy connects to the database using IPv4 only.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IPV6</code> - The proxy connects to the database using IPv6 only.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>IPV4</code>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify <code>IPV6</code>, the database must support dual-stack mode. RDS doesn't support IPv6-only
         * databases.
         * </p>
         * </li>
         * <li>
         * <p>
         * All targets registered with the proxy must be compatible with the specified network type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetConnectionNetworkType
         *        The network type that the proxy uses to connect to the target database. The network type determines
         *        the IP version that the proxy uses for connections to the database.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IPV4</code> - The proxy connects to the database using IPv4 only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IPV6</code> - The proxy connects to the database using IPv6 only.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>IPV4</code>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify <code>IPV6</code>, the database must support dual-stack mode. RDS doesn't support
         *        IPv6-only databases.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        All targets registered with the proxy must be compatible with the specified network type.
         *        </p>
         *        </li>
         * @see TargetConnectionNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetConnectionNetworkType
         */
        Builder targetConnectionNetworkType(TargetConnectionNetworkType targetConnectionNetworkType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbProxyName;

        private String engineFamily;

        private String defaultAuthScheme;

        private List<UserAuthConfig> auth = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private List<String> vpcSubnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean requireTLS;

        private Integer idleClientTimeout;

        private Boolean debugLogging;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String endpointNetworkType;

        private String targetConnectionNetworkType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbProxyRequest model) {
            super(model);
            dbProxyName(model.dbProxyName);
            engineFamily(model.engineFamily);
            defaultAuthScheme(model.defaultAuthScheme);
            auth(model.auth);
            roleArn(model.roleArn);
            vpcSubnetIds(model.vpcSubnetIds);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            requireTLS(model.requireTLS);
            idleClientTimeout(model.idleClientTimeout);
            debugLogging(model.debugLogging);
            tags(model.tags);
            endpointNetworkType(model.endpointNetworkType);
            targetConnectionNetworkType(model.targetConnectionNetworkType);
        }

        public final String getDbProxyName() {
            return dbProxyName;
        }

        public final void setDbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
        }

        @Override
        public final Builder dbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        public final String getEngineFamily() {
            return engineFamily;
        }

        public final void setEngineFamily(String engineFamily) {
            this.engineFamily = engineFamily;
        }

        @Override
        public final Builder engineFamily(String engineFamily) {
            this.engineFamily = engineFamily;
            return this;
        }

        @Override
        public final Builder engineFamily(EngineFamily engineFamily) {
            this.engineFamily(engineFamily == null ? null : engineFamily.toString());
            return this;
        }

        public final String getDefaultAuthScheme() {
            return defaultAuthScheme;
        }

        public final void setDefaultAuthScheme(String defaultAuthScheme) {
            this.defaultAuthScheme = defaultAuthScheme;
        }

        @Override
        public final Builder defaultAuthScheme(String defaultAuthScheme) {
            this.defaultAuthScheme = defaultAuthScheme;
            return this;
        }

        @Override
        public final Builder defaultAuthScheme(DefaultAuthScheme defaultAuthScheme) {
            this.defaultAuthScheme(defaultAuthScheme == null ? null : defaultAuthScheme.toString());
            return this;
        }

        public final List<UserAuthConfig.Builder> getAuth() {
            List<UserAuthConfig.Builder> result = UserAuthConfigListCopier.copyToBuilder(this.auth);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuth(Collection<UserAuthConfig.BuilderImpl> auth) {
            this.auth = UserAuthConfigListCopier.copyFromBuilder(auth);
        }

        @Override
        public final Builder auth(Collection<UserAuthConfig> auth) {
            this.auth = UserAuthConfigListCopier.copy(auth);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auth(UserAuthConfig... auth) {
            auth(Arrays.asList(auth));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auth(Consumer<UserAuthConfig.Builder>... auth) {
            auth(Stream.of(auth).map(c -> UserAuthConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Collection<String> getVpcSubnetIds() {
            if (vpcSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSubnetIds;
        }

        public final void setVpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = StringListCopier.copy(vpcSubnetIds);
        }

        @Override
        public final Builder vpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = StringListCopier.copy(vpcSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSubnetIds(String... vpcSubnetIds) {
            vpcSubnetIds(Arrays.asList(vpcSubnetIds));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final Boolean getRequireTLS() {
            return requireTLS;
        }

        public final void setRequireTLS(Boolean requireTLS) {
            this.requireTLS = requireTLS;
        }

        @Override
        public final Builder requireTLS(Boolean requireTLS) {
            this.requireTLS = requireTLS;
            return this;
        }

        public final Integer getIdleClientTimeout() {
            return idleClientTimeout;
        }

        public final void setIdleClientTimeout(Integer idleClientTimeout) {
            this.idleClientTimeout = idleClientTimeout;
        }

        @Override
        public final Builder idleClientTimeout(Integer idleClientTimeout) {
            this.idleClientTimeout = idleClientTimeout;
            return this;
        }

        public final Boolean getDebugLogging() {
            return debugLogging;
        }

        public final void setDebugLogging(Boolean debugLogging) {
            this.debugLogging = debugLogging;
        }

        @Override
        public final Builder debugLogging(Boolean debugLogging) {
            this.debugLogging = debugLogging;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEndpointNetworkType() {
            return endpointNetworkType;
        }

        public final void setEndpointNetworkType(String endpointNetworkType) {
            this.endpointNetworkType = endpointNetworkType;
        }

        @Override
        public final Builder endpointNetworkType(String endpointNetworkType) {
            this.endpointNetworkType = endpointNetworkType;
            return this;
        }

        @Override
        public final Builder endpointNetworkType(EndpointNetworkType endpointNetworkType) {
            this.endpointNetworkType(endpointNetworkType == null ? null : endpointNetworkType.toString());
            return this;
        }

        public final String getTargetConnectionNetworkType() {
            return targetConnectionNetworkType;
        }

        public final void setTargetConnectionNetworkType(String targetConnectionNetworkType) {
            this.targetConnectionNetworkType = targetConnectionNetworkType;
        }

        @Override
        public final Builder targetConnectionNetworkType(String targetConnectionNetworkType) {
            this.targetConnectionNetworkType = targetConnectionNetworkType;
            return this;
        }

        @Override
        public final Builder targetConnectionNetworkType(TargetConnectionNetworkType targetConnectionNetworkType) {
            this.targetConnectionNetworkType(targetConnectionNetworkType == null ? null : targetConnectionNetworkType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbProxyRequest build() {
            return new CreateDbProxyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
