/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbMajorEngineVersionsResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeDbMajorEngineVersionsResponse.Builder, DescribeDbMajorEngineVersionsResponse> {
    private static final SdkField<List<DBMajorEngineVersion>> DB_MAJOR_ENGINE_VERSIONS_FIELD = SdkField
            .<List<DBMajorEngineVersion>> builder(MarshallingType.LIST)
            .memberName("DBMajorEngineVersions")
            .getter(getter(DescribeDbMajorEngineVersionsResponse::dbMajorEngineVersions))
            .setter(setter(Builder::dbMajorEngineVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBMajorEngineVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBMajorEngineVersion")
                            .memberFieldInfo(
                                    SdkField.<DBMajorEngineVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBMajorEngineVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBMajorEngineVersion").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbMajorEngineVersionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DB_MAJOR_ENGINE_VERSIONS_FIELD, MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DBMajorEngineVersion> dbMajorEngineVersions;

    private final String marker;

    private DescribeDbMajorEngineVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.dbMajorEngineVersions = builder.dbMajorEngineVersions;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the DBMajorEngineVersions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDbMajorEngineVersions() {
        return dbMajorEngineVersions != null && !(dbMajorEngineVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DBMajorEngineVersion</code> elements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbMajorEngineVersions} method.
     * </p>
     * 
     * @return A list of <code>DBMajorEngineVersion</code> elements.
     */
    public final List<DBMajorEngineVersion> dbMajorEngineVersions() {
        return dbMajorEngineVersions;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDbMajorEngineVersions() ? dbMajorEngineVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbMajorEngineVersionsResponse)) {
            return false;
        }
        DescribeDbMajorEngineVersionsResponse other = (DescribeDbMajorEngineVersionsResponse) obj;
        return hasDbMajorEngineVersions() == other.hasDbMajorEngineVersions()
                && Objects.equals(dbMajorEngineVersions(), other.dbMajorEngineVersions())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbMajorEngineVersionsResponse")
                .add("DBMajorEngineVersions", hasDbMajorEngineVersions() ? dbMajorEngineVersions() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBMajorEngineVersions":
            return Optional.ofNullable(clazz.cast(dbMajorEngineVersions()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBMajorEngineVersions", DB_MAJOR_ENGINE_VERSIONS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbMajorEngineVersionsResponse, T> g) {
        return obj -> g.apply((DescribeDbMajorEngineVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDbMajorEngineVersionsResponse> {
        /**
         * <p>
         * A list of <code>DBMajorEngineVersion</code> elements.
         * </p>
         * 
         * @param dbMajorEngineVersions
         *        A list of <code>DBMajorEngineVersion</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbMajorEngineVersions(Collection<DBMajorEngineVersion> dbMajorEngineVersions);

        /**
         * <p>
         * A list of <code>DBMajorEngineVersion</code> elements.
         * </p>
         * 
         * @param dbMajorEngineVersions
         *        A list of <code>DBMajorEngineVersion</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbMajorEngineVersions(DBMajorEngineVersion... dbMajorEngineVersions);

        /**
         * <p>
         * A list of <code>DBMajorEngineVersion</code> elements.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.DBMajorEngineVersion.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rds.model.DBMajorEngineVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.DBMajorEngineVersion.Builder#build()} is called immediately
         * and its result is passed to {@link #dbMajorEngineVersions(List<DBMajorEngineVersion>)}.
         * 
         * @param dbMajorEngineVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.DBMajorEngineVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbMajorEngineVersions(java.util.Collection<DBMajorEngineVersion>)
         */
        Builder dbMajorEngineVersions(Consumer<DBMajorEngineVersion.Builder>... dbMajorEngineVersions);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private List<DBMajorEngineVersion> dbMajorEngineVersions = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbMajorEngineVersionsResponse model) {
            super(model);
            dbMajorEngineVersions(model.dbMajorEngineVersions);
            marker(model.marker);
        }

        public final List<DBMajorEngineVersion.Builder> getDbMajorEngineVersions() {
            List<DBMajorEngineVersion.Builder> result = DBMajorEngineVersionsListCopier.copyToBuilder(this.dbMajorEngineVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbMajorEngineVersions(Collection<DBMajorEngineVersion.BuilderImpl> dbMajorEngineVersions) {
            this.dbMajorEngineVersions = DBMajorEngineVersionsListCopier.copyFromBuilder(dbMajorEngineVersions);
        }

        @Override
        public final Builder dbMajorEngineVersions(Collection<DBMajorEngineVersion> dbMajorEngineVersions) {
            this.dbMajorEngineVersions = DBMajorEngineVersionsListCopier.copy(dbMajorEngineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbMajorEngineVersions(DBMajorEngineVersion... dbMajorEngineVersions) {
            dbMajorEngineVersions(Arrays.asList(dbMajorEngineVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbMajorEngineVersions(Consumer<DBMajorEngineVersion.Builder>... dbMajorEngineVersions) {
            dbMajorEngineVersions(Stream.of(dbMajorEngineVersions)
                    .map(c -> DBMajorEngineVersion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeDbMajorEngineVersionsResponse build() {
            return new DescribeDbMajorEngineVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
