/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DBCluster;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse;

public class DescribeDBClustersIterable
implements SdkIterable<DescribeDbClustersResponse> {
    private final RdsClient client;
    private final DescribeDbClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBClustersIterable(RdsClient client, DescribeDbClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbClustersResponseFetcher();
    }

    public Iterator<DescribeDbClustersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBCluster> dbClusters() {
        Function<DescribeDbClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbClusters() != null) {
                return response.dbClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbClustersResponseFetcher
    implements SyncPageFetcher<DescribeDbClustersResponse> {
        private DescribeDbClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbClustersResponse nextPage(DescribeDbClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBClustersIterable.this.client.describeDBClusters(DescribeDBClustersIterable.this.firstRequest);
            }
            return DescribeDBClustersIterable.this.client.describeDBClusters((DescribeDbClustersRequest)((Object)DescribeDBClustersIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

