/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Execute SQL response
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteSqlResponse extends RdsDataResponse implements
        ToCopyableBuilder<ExecuteSqlResponse.Builder, ExecuteSqlResponse> {
    private static final SdkField<List<SqlStatementResult>> SQL_STATEMENT_RESULTS_FIELD = SdkField
            .<List<SqlStatementResult>> builder(MarshallingType.LIST)
            .getter(getter(ExecuteSqlResponse::sqlStatementResults))
            .setter(setter(Builder::sqlStatementResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlStatementResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SqlStatementResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(SqlStatementResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SQL_STATEMENT_RESULTS_FIELD));

    private final List<SqlStatementResult> sqlStatementResults;

    private ExecuteSqlResponse(BuilderImpl builder) {
        super(builder);
        this.sqlStatementResults = builder.sqlStatementResults;
    }

    /**
     * Results returned by executing the sql statement(s)
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Results returned by executing the sql statement(s)
     */
    public List<SqlStatementResult> sqlStatementResults() {
        return sqlStatementResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sqlStatementResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteSqlResponse)) {
            return false;
        }
        ExecuteSqlResponse other = (ExecuteSqlResponse) obj;
        return Objects.equals(sqlStatementResults(), other.sqlStatementResults());
    }

    @Override
    public String toString() {
        return ToString.builder("ExecuteSqlResponse").add("SqlStatementResults", sqlStatementResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sqlStatementResults":
            return Optional.ofNullable(clazz.cast(sqlStatementResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteSqlResponse, T> g) {
        return obj -> g.apply((ExecuteSqlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteSqlResponse> {
        /**
         * Results returned by executing the sql statement(s)
         * 
         * @param sqlStatementResults
         *        Results returned by executing the sql statement(s)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlStatementResults(Collection<SqlStatementResult> sqlStatementResults);

        /**
         * Results returned by executing the sql statement(s)
         * 
         * @param sqlStatementResults
         *        Results returned by executing the sql statement(s)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlStatementResults(SqlStatementResult... sqlStatementResults);

        /**
         * Results returned by executing the sql statement(s) This is a convenience that creates an instance of the
         * {@link List<SqlStatementResult>.Builder} avoiding the need to create one manually via {@link List
         * <SqlStatementResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SqlStatementResult>.Builder#build()} is called immediately
         * and its result is passed to {@link #sqlStatementResults(List<SqlStatementResult>)}.
         * 
         * @param sqlStatementResults
         *        a consumer that will call methods on {@link List<SqlStatementResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlStatementResults(List<SqlStatementResult>)
         */
        Builder sqlStatementResults(Consumer<SqlStatementResult.Builder>... sqlStatementResults);
    }

    static final class BuilderImpl extends RdsDataResponse.BuilderImpl implements Builder {
        private List<SqlStatementResult> sqlStatementResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteSqlResponse model) {
            super(model);
            sqlStatementResults(model.sqlStatementResults);
        }

        public final Collection<SqlStatementResult.Builder> getSqlStatementResults() {
            return sqlStatementResults != null ? sqlStatementResults.stream().map(SqlStatementResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sqlStatementResults(Collection<SqlStatementResult> sqlStatementResults) {
            this.sqlStatementResults = SqlStatementResultsCopier.copy(sqlStatementResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlStatementResults(SqlStatementResult... sqlStatementResults) {
            sqlStatementResults(Arrays.asList(sqlStatementResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlStatementResults(Consumer<SqlStatementResult.Builder>... sqlStatementResults) {
            sqlStatementResults(Stream.of(sqlStatementResults).map(c -> SqlStatementResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSqlStatementResults(Collection<SqlStatementResult.BuilderImpl> sqlStatementResults) {
            this.sqlStatementResults = SqlStatementResultsCopier.copyFromBuilder(sqlStatementResults);
        }

        @Override
        public ExecuteSqlResponse build() {
            return new ExecuteSqlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
