/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an array.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArrayValue implements SdkPojo, Serializable, ToCopyableBuilder<ArrayValue.Builder, ArrayValue> {
    private static final SdkField<List<ArrayValue>> ARRAY_VALUES_FIELD = SdkField
            .<List<ArrayValue>> builder(MarshallingType.LIST)
            .getter(getter(ArrayValue::arrayValues))
            .setter(setter(Builder::arrayValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ArrayValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ArrayValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Boolean>> BOOLEAN_VALUES_FIELD = SdkField
            .<List<Boolean>> builder(MarshallingType.LIST)
            .getter(getter(ArrayValue::booleanValues))
            .setter(setter(Builder::booleanValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Double>> DOUBLE_VALUES_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .getter(getter(ArrayValue::doubleValues))
            .setter(setter(Builder::doubleValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Long>> LONG_VALUES_FIELD = SdkField
            .<List<Long>> builder(MarshallingType.LIST)
            .getter(getter(ArrayValue::longValues))
            .setter(setter(Builder::longValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STRING_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ArrayValue::stringValues))
            .setter(setter(Builder::stringValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARRAY_VALUES_FIELD,
            BOOLEAN_VALUES_FIELD, DOUBLE_VALUES_FIELD, LONG_VALUES_FIELD, STRING_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ArrayValue> arrayValues;

    private final List<Boolean> booleanValues;

    private final List<Double> doubleValues;

    private final List<Long> longValues;

    private final List<String> stringValues;

    private ArrayValue(BuilderImpl builder) {
        this.arrayValues = builder.arrayValues;
        this.booleanValues = builder.booleanValues;
        this.doubleValues = builder.doubleValues;
        this.longValues = builder.longValues;
        this.stringValues = builder.stringValues;
    }

    /**
     * <p>
     * An array of arrays.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of arrays.
     */
    public List<ArrayValue> arrayValues() {
        return arrayValues;
    }

    /**
     * <p>
     * An array of Boolean values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of Boolean values.
     */
    public List<Boolean> booleanValues() {
        return booleanValues;
    }

    /**
     * <p>
     * An array of integers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of integers.
     */
    public List<Double> doubleValues() {
        return doubleValues;
    }

    /**
     * <p>
     * An array of floating point numbers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of floating point numbers.
     */
    public List<Long> longValues() {
        return longValues;
    }

    /**
     * <p>
     * An array of strings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of strings.
     */
    public List<String> stringValues() {
        return stringValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arrayValues());
        hashCode = 31 * hashCode + Objects.hashCode(booleanValues());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValues());
        hashCode = 31 * hashCode + Objects.hashCode(longValues());
        hashCode = 31 * hashCode + Objects.hashCode(stringValues());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArrayValue)) {
            return false;
        }
        ArrayValue other = (ArrayValue) obj;
        return Objects.equals(arrayValues(), other.arrayValues()) && Objects.equals(booleanValues(), other.booleanValues())
                && Objects.equals(doubleValues(), other.doubleValues()) && Objects.equals(longValues(), other.longValues())
                && Objects.equals(stringValues(), other.stringValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ArrayValue").add("ArrayValues", arrayValues()).add("BooleanValues", booleanValues())
                .add("DoubleValues", doubleValues()).add("LongValues", longValues()).add("StringValues", stringValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arrayValues":
            return Optional.ofNullable(clazz.cast(arrayValues()));
        case "booleanValues":
            return Optional.ofNullable(clazz.cast(booleanValues()));
        case "doubleValues":
            return Optional.ofNullable(clazz.cast(doubleValues()));
        case "longValues":
            return Optional.ofNullable(clazz.cast(longValues()));
        case "stringValues":
            return Optional.ofNullable(clazz.cast(stringValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArrayValue, T> g) {
        return obj -> g.apply((ArrayValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArrayValue> {
        /**
         * <p>
         * An array of arrays.
         * </p>
         * 
         * @param arrayValues
         *        An array of arrays.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayValues(Collection<ArrayValue> arrayValues);

        /**
         * <p>
         * An array of arrays.
         * </p>
         * 
         * @param arrayValues
         *        An array of arrays.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayValues(ArrayValue... arrayValues);

        /**
         * <p>
         * An array of arrays.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ArrayValue>.Builder} avoiding the need to
         * create one manually via {@link List<ArrayValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ArrayValue>.Builder#build()} is called immediately and its
         * result is passed to {@link #arrayValues(List<ArrayValue>)}.
         * 
         * @param arrayValues
         *        a consumer that will call methods on {@link List<ArrayValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arrayValues(List<ArrayValue>)
         */
        Builder arrayValues(Consumer<Builder>... arrayValues);

        /**
         * <p>
         * An array of Boolean values.
         * </p>
         * 
         * @param booleanValues
         *        An array of Boolean values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValues(Collection<Boolean> booleanValues);

        /**
         * <p>
         * An array of Boolean values.
         * </p>
         * 
         * @param booleanValues
         *        An array of Boolean values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValues(Boolean... booleanValues);

        /**
         * <p>
         * An array of integers.
         * </p>
         * 
         * @param doubleValues
         *        An array of integers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValues(Collection<Double> doubleValues);

        /**
         * <p>
         * An array of integers.
         * </p>
         * 
         * @param doubleValues
         *        An array of integers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValues(Double... doubleValues);

        /**
         * <p>
         * An array of floating point numbers.
         * </p>
         * 
         * @param longValues
         *        An array of floating point numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longValues(Collection<Long> longValues);

        /**
         * <p>
         * An array of floating point numbers.
         * </p>
         * 
         * @param longValues
         *        An array of floating point numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longValues(Long... longValues);

        /**
         * <p>
         * An array of strings.
         * </p>
         * 
         * @param stringValues
         *        An array of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValues(Collection<String> stringValues);

        /**
         * <p>
         * An array of strings.
         * </p>
         * 
         * @param stringValues
         *        An array of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValues(String... stringValues);
    }

    static final class BuilderImpl implements Builder {
        private List<ArrayValue> arrayValues = DefaultSdkAutoConstructList.getInstance();

        private List<Boolean> booleanValues = DefaultSdkAutoConstructList.getInstance();

        private List<Double> doubleValues = DefaultSdkAutoConstructList.getInstance();

        private List<Long> longValues = DefaultSdkAutoConstructList.getInstance();

        private List<String> stringValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ArrayValue model) {
            arrayValues(model.arrayValues);
            booleanValues(model.booleanValues);
            doubleValues(model.doubleValues);
            longValues(model.longValues);
            stringValues(model.stringValues);
        }

        public final Collection<Builder> getArrayValues() {
            return arrayValues != null ? arrayValues.stream().map(ArrayValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder arrayValues(Collection<ArrayValue> arrayValues) {
            this.arrayValues = ArrayOfArrayCopier.copy(arrayValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValues(ArrayValue... arrayValues) {
            arrayValues(Arrays.asList(arrayValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValues(Consumer<Builder>... arrayValues) {
            arrayValues(Stream.of(arrayValues).map(c -> ArrayValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setArrayValues(Collection<BuilderImpl> arrayValues) {
            this.arrayValues = ArrayOfArrayCopier.copyFromBuilder(arrayValues);
        }

        public final Collection<Boolean> getBooleanValues() {
            return booleanValues;
        }

        @Override
        public final Builder booleanValues(Collection<Boolean> booleanValues) {
            this.booleanValues = BooleanArrayCopier.copy(booleanValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder booleanValues(Boolean... booleanValues) {
            booleanValues(Arrays.asList(booleanValues));
            return this;
        }

        public final void setBooleanValues(Collection<Boolean> booleanValues) {
            this.booleanValues = BooleanArrayCopier.copy(booleanValues);
        }

        public final Collection<Double> getDoubleValues() {
            return doubleValues;
        }

        @Override
        public final Builder doubleValues(Collection<Double> doubleValues) {
            this.doubleValues = DoubleArrayCopier.copy(doubleValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder doubleValues(Double... doubleValues) {
            doubleValues(Arrays.asList(doubleValues));
            return this;
        }

        public final void setDoubleValues(Collection<Double> doubleValues) {
            this.doubleValues = DoubleArrayCopier.copy(doubleValues);
        }

        public final Collection<Long> getLongValues() {
            return longValues;
        }

        @Override
        public final Builder longValues(Collection<Long> longValues) {
            this.longValues = LongArrayCopier.copy(longValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder longValues(Long... longValues) {
            longValues(Arrays.asList(longValues));
            return this;
        }

        public final void setLongValues(Collection<Long> longValues) {
            this.longValues = LongArrayCopier.copy(longValues);
        }

        public final Collection<String> getStringValues() {
            return stringValues;
        }

        @Override
        public final Builder stringValues(Collection<String> stringValues) {
            this.stringValues = StringArrayCopier.copy(stringValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringValues(String... stringValues) {
            stringValues(Arrays.asList(stringValues));
            return this;
        }

        public final void setStringValues(Collection<String> stringValues) {
            this.stringValues = StringArrayCopier.copy(stringValues);
        }

        @Override
        public ArrayValue build() {
            return new ArrayValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
