/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a SQL statement.
 * </p>
 * 
 * <pre>
 * <code> &lt;important&gt; &lt;p&gt;This data type is deprecated.&lt;/p&gt; &lt;/important&gt; </code>
 * </pre>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SqlStatementResult implements SdkPojo, Serializable,
        ToCopyableBuilder<SqlStatementResult.Builder, SqlStatementResult> {
    private static final SdkField<Long> NUMBER_OF_RECORDS_UPDATED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(SqlStatementResult::numberOfRecordsUpdated)).setter(setter(Builder::numberOfRecordsUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecordsUpdated").build())
            .build();

    private static final SdkField<ResultFrame> RESULT_FRAME_FIELD = SdkField.<ResultFrame> builder(MarshallingType.SDK_POJO)
            .getter(getter(SqlStatementResult::resultFrame)).setter(setter(Builder::resultFrame))
            .constructor(ResultFrame::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultFrame").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMBER_OF_RECORDS_UPDATED_FIELD, RESULT_FRAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long numberOfRecordsUpdated;

    private final ResultFrame resultFrame;

    private SqlStatementResult(BuilderImpl builder) {
        this.numberOfRecordsUpdated = builder.numberOfRecordsUpdated;
        this.resultFrame = builder.resultFrame;
    }

    /**
     * <p>
     * The number of records updated by a SQL statement.
     * </p>
     * 
     * @return The number of records updated by a SQL statement.
     */
    public Long numberOfRecordsUpdated() {
        return numberOfRecordsUpdated;
    }

    /**
     * <p>
     * The result set of the SQL statement.
     * </p>
     * 
     * @return The result set of the SQL statement.
     */
    public ResultFrame resultFrame() {
        return resultFrame;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRecordsUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(resultFrame());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlStatementResult)) {
            return false;
        }
        SqlStatementResult other = (SqlStatementResult) obj;
        return Objects.equals(numberOfRecordsUpdated(), other.numberOfRecordsUpdated())
                && Objects.equals(resultFrame(), other.resultFrame());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SqlStatementResult").add("NumberOfRecordsUpdated", numberOfRecordsUpdated())
                .add("ResultFrame", resultFrame()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "numberOfRecordsUpdated":
            return Optional.ofNullable(clazz.cast(numberOfRecordsUpdated()));
        case "resultFrame":
            return Optional.ofNullable(clazz.cast(resultFrame()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlStatementResult, T> g) {
        return obj -> g.apply((SqlStatementResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SqlStatementResult> {
        /**
         * <p>
         * The number of records updated by a SQL statement.
         * </p>
         * 
         * @param numberOfRecordsUpdated
         *        The number of records updated by a SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRecordsUpdated(Long numberOfRecordsUpdated);

        /**
         * <p>
         * The result set of the SQL statement.
         * </p>
         * 
         * @param resultFrame
         *        The result set of the SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultFrame(ResultFrame resultFrame);

        /**
         * <p>
         * The result set of the SQL statement.
         * </p>
         * This is a convenience that creates an instance of the {@link ResultFrame.Builder} avoiding the need to create
         * one manually via {@link ResultFrame#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResultFrame.Builder#build()} is called immediately and its result
         * is passed to {@link #resultFrame(ResultFrame)}.
         * 
         * @param resultFrame
         *        a consumer that will call methods on {@link ResultFrame.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultFrame(ResultFrame)
         */
        default Builder resultFrame(Consumer<ResultFrame.Builder> resultFrame) {
            return resultFrame(ResultFrame.builder().applyMutation(resultFrame).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long numberOfRecordsUpdated;

        private ResultFrame resultFrame;

        private BuilderImpl() {
        }

        private BuilderImpl(SqlStatementResult model) {
            numberOfRecordsUpdated(model.numberOfRecordsUpdated);
            resultFrame(model.resultFrame);
        }

        public final Long getNumberOfRecordsUpdated() {
            return numberOfRecordsUpdated;
        }

        @Override
        public final Builder numberOfRecordsUpdated(Long numberOfRecordsUpdated) {
            this.numberOfRecordsUpdated = numberOfRecordsUpdated;
            return this;
        }

        public final void setNumberOfRecordsUpdated(Long numberOfRecordsUpdated) {
            this.numberOfRecordsUpdated = numberOfRecordsUpdated;
        }

        public final ResultFrame.Builder getResultFrame() {
            return resultFrame != null ? resultFrame.toBuilder() : null;
        }

        @Override
        public final Builder resultFrame(ResultFrame resultFrame) {
            this.resultFrame = resultFrame;
            return this;
        }

        public final void setResultFrame(ResultFrame.BuilderImpl resultFrame) {
            this.resultFrame = resultFrame != null ? resultFrame.build() : null;
        }

        @Override
        public SqlStatementResult build() {
            return new SqlStatementResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
