/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options that control how the result set is returned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultSetOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ResultSetOptions.Builder, ResultSetOptions> {
    private static final SdkField<String> DECIMAL_RETURN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResultSetOptions::decimalReturnTypeAsString)).setter(setter(Builder::decimalReturnType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decimalReturnType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECIMAL_RETURN_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String decimalReturnType;

    private ResultSetOptions(BuilderImpl builder) {
        this.decimalReturnType = builder.decimalReturnType;
    }

    /**
     * <p>
     * A value that indicates how a field of <code>DECIMAL</code> type is represented in the response. The value of
     * <code>STRING</code>, the default, specifies that it is converted to a String value. The value of
     * <code>DOUBLE_OR_LONG</code> specifies that it is converted to a Long value if its scale is 0, or to a Double
     * value otherwise.
     * </p>
     * <important>
     * <p>
     * Conversion to Double or Long can result in roundoff errors due to precision loss. We recommend converting to
     * String, especially when working with currency values.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #decimalReturnType}
     * will return {@link DecimalReturnType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #decimalReturnTypeAsString}.
     * </p>
     * 
     * @return A value that indicates how a field of <code>DECIMAL</code> type is represented in the response. The value
     *         of <code>STRING</code>, the default, specifies that it is converted to a String value. The value of
     *         <code>DOUBLE_OR_LONG</code> specifies that it is converted to a Long value if its scale is 0, or to a
     *         Double value otherwise.</p> <important>
     *         <p>
     *         Conversion to Double or Long can result in roundoff errors due to precision loss. We recommend converting
     *         to String, especially when working with currency values.
     *         </p>
     * @see DecimalReturnType
     */
    public DecimalReturnType decimalReturnType() {
        return DecimalReturnType.fromValue(decimalReturnType);
    }

    /**
     * <p>
     * A value that indicates how a field of <code>DECIMAL</code> type is represented in the response. The value of
     * <code>STRING</code>, the default, specifies that it is converted to a String value. The value of
     * <code>DOUBLE_OR_LONG</code> specifies that it is converted to a Long value if its scale is 0, or to a Double
     * value otherwise.
     * </p>
     * <important>
     * <p>
     * Conversion to Double or Long can result in roundoff errors due to precision loss. We recommend converting to
     * String, especially when working with currency values.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #decimalReturnType}
     * will return {@link DecimalReturnType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #decimalReturnTypeAsString}.
     * </p>
     * 
     * @return A value that indicates how a field of <code>DECIMAL</code> type is represented in the response. The value
     *         of <code>STRING</code>, the default, specifies that it is converted to a String value. The value of
     *         <code>DOUBLE_OR_LONG</code> specifies that it is converted to a Long value if its scale is 0, or to a
     *         Double value otherwise.</p> <important>
     *         <p>
     *         Conversion to Double or Long can result in roundoff errors due to precision loss. We recommend converting
     *         to String, especially when working with currency values.
     *         </p>
     * @see DecimalReturnType
     */
    public String decimalReturnTypeAsString() {
        return decimalReturnType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(decimalReturnTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSetOptions)) {
            return false;
        }
        ResultSetOptions other = (ResultSetOptions) obj;
        return Objects.equals(decimalReturnTypeAsString(), other.decimalReturnTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResultSetOptions").add("DecimalReturnType", decimalReturnTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "decimalReturnType":
            return Optional.ofNullable(clazz.cast(decimalReturnTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultSetOptions, T> g) {
        return obj -> g.apply((ResultSetOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultSetOptions> {
        /**
         * <p>
         * A value that indicates how a field of <code>DECIMAL</code> type is represented in the response. The value of
         * <code>STRING</code>, the default, specifies that it is converted to a String value. The value of
         * <code>DOUBLE_OR_LONG</code> specifies that it is converted to a Long value if its scale is 0, or to a Double
         * value otherwise.
         * </p>
         * <important>
         * <p>
         * Conversion to Double or Long can result in roundoff errors due to precision loss. We recommend converting to
         * String, especially when working with currency values.
         * </p>
         * </important>
         * 
         * @param decimalReturnType
         *        A value that indicates how a field of <code>DECIMAL</code> type is represented in the response. The
         *        value of <code>STRING</code>, the default, specifies that it is converted to a String value. The value
         *        of <code>DOUBLE_OR_LONG</code> specifies that it is converted to a Long value if its scale is 0, or to
         *        a Double value otherwise.</p> <important>
         *        <p>
         *        Conversion to Double or Long can result in roundoff errors due to precision loss. We recommend
         *        converting to String, especially when working with currency values.
         *        </p>
         * @see DecimalReturnType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DecimalReturnType
         */
        Builder decimalReturnType(String decimalReturnType);

        /**
         * <p>
         * A value that indicates how a field of <code>DECIMAL</code> type is represented in the response. The value of
         * <code>STRING</code>, the default, specifies that it is converted to a String value. The value of
         * <code>DOUBLE_OR_LONG</code> specifies that it is converted to a Long value if its scale is 0, or to a Double
         * value otherwise.
         * </p>
         * <important>
         * <p>
         * Conversion to Double or Long can result in roundoff errors due to precision loss. We recommend converting to
         * String, especially when working with currency values.
         * </p>
         * </important>
         * 
         * @param decimalReturnType
         *        A value that indicates how a field of <code>DECIMAL</code> type is represented in the response. The
         *        value of <code>STRING</code>, the default, specifies that it is converted to a String value. The value
         *        of <code>DOUBLE_OR_LONG</code> specifies that it is converted to a Long value if its scale is 0, or to
         *        a Double value otherwise.</p> <important>
         *        <p>
         *        Conversion to Double or Long can result in roundoff errors due to precision loss. We recommend
         *        converting to String, especially when working with currency values.
         *        </p>
         * @see DecimalReturnType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DecimalReturnType
         */
        Builder decimalReturnType(DecimalReturnType decimalReturnType);
    }

    static final class BuilderImpl implements Builder {
        private String decimalReturnType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultSetOptions model) {
            decimalReturnType(model.decimalReturnType);
        }

        public final String getDecimalReturnTypeAsString() {
            return decimalReturnType;
        }

        @Override
        public final Builder decimalReturnType(String decimalReturnType) {
            this.decimalReturnType = decimalReturnType;
            return this;
        }

        @Override
        public final Builder decimalReturnType(DecimalReturnType decimalReturnType) {
            this.decimalReturnType(decimalReturnType == null ? null : decimalReturnType.toString());
            return this;
        }

        public final void setDecimalReturnType(String decimalReturnType) {
            this.decimalReturnType = decimalReturnType;
        }

        @Override
        public ResultSetOptions build() {
            return new ResultSetOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
