/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request parameters represent the input of a SQL statement over an array of data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchExecuteStatementRequest extends RdsDataRequest implements
        ToCopyableBuilder<BatchExecuteStatementRequest.Builder, BatchExecuteStatementRequest> {
    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchExecuteStatementRequest::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("database").build()).build();

    private static final SdkField<List<List<SqlParameter>>> PARAMETER_SETS_FIELD = SdkField
            .<List<List<SqlParameter>>> builder(MarshallingType.LIST)
            .getter(getter(BatchExecuteStatementRequest::parameterSets))
            .setter(setter(Builder::parameterSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<SqlParameter>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<SqlParameter> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(SqlParameter::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchExecuteStatementRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchExecuteStatementRequest::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchExecuteStatementRequest::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()).build();

    private static final SdkField<String> SQL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchExecuteStatementRequest::sql)).setter(setter(Builder::sql))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sql").build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchExecuteStatementRequest::transactionId)).setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_FIELD,
            PARAMETER_SETS_FIELD, RESOURCE_ARN_FIELD, SCHEMA_FIELD, SECRET_ARN_FIELD, SQL_FIELD, TRANSACTION_ID_FIELD));

    private final String database;

    private final List<List<SqlParameter>> parameterSets;

    private final String resourceArn;

    private final String schema;

    private final String secretArn;

    private final String sql;

    private final String transactionId;

    private BatchExecuteStatementRequest(BuilderImpl builder) {
        super(builder);
        this.database = builder.database;
        this.parameterSets = builder.parameterSets;
        this.resourceArn = builder.resourceArn;
        this.schema = builder.schema;
        this.secretArn = builder.secretArn;
        this.sql = builder.sql;
        this.transactionId = builder.transactionId;
    }

    /**
     * <p>
     * The name of the database.
     * </p>
     * 
     * @return The name of the database.
     */
    public String database() {
        return database;
    }

    /**
     * Returns true if the ParameterSets property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasParameterSets() {
        return parameterSets != null && !(parameterSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameter set for the batch operation.
     * </p>
     * <p>
     * The maximum number of parameters in a parameter set is 1,000.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameterSets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The parameter set for the batch operation.</p>
     *         <p>
     *         The maximum number of parameters in a parameter set is 1,000.
     */
    public List<List<SqlParameter>> parameterSets() {
        return parameterSets;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The name of the database schema.
     * </p>
     * 
     * @return The name of the database schema.
     */
    public String schema() {
        return schema;
    }

    /**
     * <p>
     * The name or ARN of the secret that enables access to the DB cluster.
     * </p>
     * 
     * @return The name or ARN of the secret that enables access to the DB cluster.
     */
    public String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The SQL statement to run.
     * </p>
     * 
     * @return The SQL statement to run.
     */
    public String sql() {
        return sql;
    }

    /**
     * <p>
     * The identifier of a transaction that was started by using the <code>BeginTransaction</code> operation. Specify
     * the transaction ID of the transaction that you want to include the SQL statement in.
     * </p>
     * <p>
     * If the SQL statement is not part of a transaction, don't set this parameter.
     * </p>
     * 
     * @return The identifier of a transaction that was started by using the <code>BeginTransaction</code> operation.
     *         Specify the transaction ID of the transaction that you want to include the SQL statement in.</p>
     *         <p>
     *         If the SQL statement is not part of a transaction, don't set this parameter.
     */
    public String transactionId() {
        return transactionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(parameterSets());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(sql());
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchExecuteStatementRequest)) {
            return false;
        }
        BatchExecuteStatementRequest other = (BatchExecuteStatementRequest) obj;
        return Objects.equals(database(), other.database()) && Objects.equals(parameterSets(), other.parameterSets())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(schema(), other.schema())
                && Objects.equals(secretArn(), other.secretArn()) && Objects.equals(sql(), other.sql())
                && Objects.equals(transactionId(), other.transactionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchExecuteStatementRequest").add("Database", database()).add("ParameterSets", parameterSets())
                .add("ResourceArn", resourceArn()).add("Schema", schema()).add("SecretArn", secretArn()).add("Sql", sql())
                .add("TransactionId", transactionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "database":
            return Optional.ofNullable(clazz.cast(database()));
        case "parameterSets":
            return Optional.ofNullable(clazz.cast(parameterSets()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "secretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "sql":
            return Optional.ofNullable(clazz.cast(sql()));
        case "transactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchExecuteStatementRequest, T> g) {
        return obj -> g.apply((BatchExecuteStatementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchExecuteStatementRequest> {
        /**
         * <p>
         * The name of the database.
         * </p>
         * 
         * @param database
         *        The name of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The parameter set for the batch operation.
         * </p>
         * <p>
         * The maximum number of parameters in a parameter set is 1,000.
         * </p>
         * 
         * @param parameterSets
         *        The parameter set for the batch operation.</p>
         *        <p>
         *        The maximum number of parameters in a parameter set is 1,000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterSets(Collection<? extends Collection<SqlParameter>> parameterSets);

        /**
         * <p>
         * The parameter set for the batch operation.
         * </p>
         * <p>
         * The maximum number of parameters in a parameter set is 1,000.
         * </p>
         * 
         * @param parameterSets
         *        The parameter set for the batch operation.</p>
         *        <p>
         *        The maximum number of parameters in a parameter set is 1,000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterSets(Collection<SqlParameter>... parameterSets);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The name of the database schema.
         * </p>
         * 
         * @param schema
         *        The name of the database schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * <p>
         * The name or ARN of the secret that enables access to the DB cluster.
         * </p>
         * 
         * @param secretArn
         *        The name or ARN of the secret that enables access to the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The SQL statement to run.
         * </p>
         * 
         * @param sql
         *        The SQL statement to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sql(String sql);

        /**
         * <p>
         * The identifier of a transaction that was started by using the <code>BeginTransaction</code> operation.
         * Specify the transaction ID of the transaction that you want to include the SQL statement in.
         * </p>
         * <p>
         * If the SQL statement is not part of a transaction, don't set this parameter.
         * </p>
         * 
         * @param transactionId
         *        The identifier of a transaction that was started by using the <code>BeginTransaction</code> operation.
         *        Specify the transaction ID of the transaction that you want to include the SQL statement in.</p>
         *        <p>
         *        If the SQL statement is not part of a transaction, don't set this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsDataRequest.BuilderImpl implements Builder {
        private String database;

        private List<List<SqlParameter>> parameterSets = DefaultSdkAutoConstructList.getInstance();

        private String resourceArn;

        private String schema;

        private String secretArn;

        private String sql;

        private String transactionId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchExecuteStatementRequest model) {
            super(model);
            database(model.database);
            parameterSets(model.parameterSets);
            resourceArn(model.resourceArn);
            schema(model.schema);
            secretArn(model.secretArn);
            sql(model.sql);
            transactionId(model.transactionId);
        }

        public final String getDatabase() {
            return database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public final Collection<? extends Collection<SqlParameter>> getParameterSets() {
            return parameterSets;
        }

        @Override
        public final Builder parameterSets(Collection<? extends Collection<SqlParameter>> parameterSets) {
            this.parameterSets = SqlParameterSetsCopier.copy(parameterSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterSets(Collection<SqlParameter>... parameterSets) {
            parameterSets(Arrays.asList(parameterSets));
            return this;
        }

        public final void setParameterSets(Collection<? extends Collection<SqlParameter>> parameterSets) {
            this.parameterSets = SqlParameterSetsCopier.copy(parameterSets);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getSchema() {
            return schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public final String getSql() {
            return sql;
        }

        @Override
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchExecuteStatementRequest build() {
            return new BatchExecuteStatementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
