/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rdsdata.model.ColumnMetadata;
import software.amazon.awssdk.services.rdsdata.model.Field;
import software.amazon.awssdk.services.rdsdata.model.FieldListCopier;
import software.amazon.awssdk.services.rdsdata.model.MetadataCopier;
import software.amazon.awssdk.services.rdsdata.model.RdsDataResponse;
import software.amazon.awssdk.services.rdsdata.model.SqlRecordsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteStatementResponse
extends RdsDataResponse
implements ToCopyableBuilder<Builder, ExecuteStatementResponse> {
    private static final SdkField<List<ColumnMetadata>> COLUMN_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ExecuteStatementResponse.getter(ExecuteStatementResponse::columnMetadata)).setter(ExecuteStatementResponse.setter(Builder::columnMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Field>> GENERATED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ExecuteStatementResponse.getter(ExecuteStatementResponse::generatedFields)).setter(ExecuteStatementResponse.setter(Builder::generatedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Field::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> NUMBER_OF_RECORDS_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ExecuteStatementResponse.getter(ExecuteStatementResponse::numberOfRecordsUpdated)).setter(ExecuteStatementResponse.setter(Builder::numberOfRecordsUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecordsUpdated").build()}).build();
    private static final SdkField<List<List<Field>>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ExecuteStatementResponse.getter(ExecuteStatementResponse::records)).setter(ExecuteStatementResponse.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Field::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_METADATA_FIELD, GENERATED_FIELDS_FIELD, NUMBER_OF_RECORDS_UPDATED_FIELD, RECORDS_FIELD));
    private final List<ColumnMetadata> columnMetadata;
    private final List<Field> generatedFields;
    private final Long numberOfRecordsUpdated;
    private final List<List<Field>> records;

    private ExecuteStatementResponse(BuilderImpl builder) {
        super(builder);
        this.columnMetadata = builder.columnMetadata;
        this.generatedFields = builder.generatedFields;
        this.numberOfRecordsUpdated = builder.numberOfRecordsUpdated;
        this.records = builder.records;
    }

    public boolean hasColumnMetadata() {
        return this.columnMetadata != null && !(this.columnMetadata instanceof SdkAutoConstructList);
    }

    public List<ColumnMetadata> columnMetadata() {
        return this.columnMetadata;
    }

    public boolean hasGeneratedFields() {
        return this.generatedFields != null && !(this.generatedFields instanceof SdkAutoConstructList);
    }

    public List<Field> generatedFields() {
        return this.generatedFields;
    }

    public Long numberOfRecordsUpdated() {
        return this.numberOfRecordsUpdated;
    }

    public boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public List<List<Field>> records() {
        return this.records;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.columnMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedFields());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRecordsUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.records());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementResponse)) {
            return false;
        }
        ExecuteStatementResponse other = (ExecuteStatementResponse)((Object)obj);
        return Objects.equals(this.columnMetadata(), other.columnMetadata()) && Objects.equals(this.generatedFields(), other.generatedFields()) && Objects.equals(this.numberOfRecordsUpdated(), other.numberOfRecordsUpdated()) && Objects.equals(this.records(), other.records());
    }

    public String toString() {
        return ToString.builder((String)"ExecuteStatementResponse").add("ColumnMetadata", this.columnMetadata()).add("GeneratedFields", this.generatedFields()).add("NumberOfRecordsUpdated", (Object)this.numberOfRecordsUpdated()).add("Records", this.records()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "columnMetadata": {
                return Optional.ofNullable(clazz.cast(this.columnMetadata()));
            }
            case "generatedFields": {
                return Optional.ofNullable(clazz.cast(this.generatedFields()));
            }
            case "numberOfRecordsUpdated": {
                return Optional.ofNullable(clazz.cast(this.numberOfRecordsUpdated()));
            }
            case "records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteStatementResponse, T> g) {
        return obj -> g.apply((ExecuteStatementResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsDataResponse.BuilderImpl
    implements Builder {
        private List<ColumnMetadata> columnMetadata = DefaultSdkAutoConstructList.getInstance();
        private List<Field> generatedFields = DefaultSdkAutoConstructList.getInstance();
        private Long numberOfRecordsUpdated;
        private List<List<Field>> records = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteStatementResponse model) {
            super(model);
            this.columnMetadata(model.columnMetadata);
            this.generatedFields(model.generatedFields);
            this.numberOfRecordsUpdated(model.numberOfRecordsUpdated);
            this.records(model.records);
        }

        public final Collection<ColumnMetadata.Builder> getColumnMetadata() {
            return this.columnMetadata != null ? (Collection)this.columnMetadata.stream().map(ColumnMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder columnMetadata(Collection<ColumnMetadata> columnMetadata) {
            this.columnMetadata = MetadataCopier.copy(columnMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(ColumnMetadata ... columnMetadata) {
            this.columnMetadata(Arrays.asList(columnMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(Consumer<ColumnMetadata.Builder> ... columnMetadata) {
            this.columnMetadata(Stream.of(columnMetadata).map(c -> (ColumnMetadata)((ColumnMetadata.Builder)ColumnMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setColumnMetadata(Collection<ColumnMetadata.BuilderImpl> columnMetadata) {
            this.columnMetadata = MetadataCopier.copyFromBuilder(columnMetadata);
        }

        public final Collection<Field.Builder> getGeneratedFields() {
            return this.generatedFields != null ? (Collection)this.generatedFields.stream().map(Field::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder generatedFields(Collection<Field> generatedFields) {
            this.generatedFields = FieldListCopier.copy(generatedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedFields(Field ... generatedFields) {
            this.generatedFields(Arrays.asList(generatedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedFields(Consumer<Field.Builder> ... generatedFields) {
            this.generatedFields(Stream.of(generatedFields).map(c -> (Field)((Field.Builder)Field.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGeneratedFields(Collection<Field.BuilderImpl> generatedFields) {
            this.generatedFields = FieldListCopier.copyFromBuilder(generatedFields);
        }

        public final Long getNumberOfRecordsUpdated() {
            return this.numberOfRecordsUpdated;
        }

        @Override
        public final Builder numberOfRecordsUpdated(Long numberOfRecordsUpdated) {
            this.numberOfRecordsUpdated = numberOfRecordsUpdated;
            return this;
        }

        public final void setNumberOfRecordsUpdated(Long numberOfRecordsUpdated) {
            this.numberOfRecordsUpdated = numberOfRecordsUpdated;
        }

        public final Collection<? extends Collection<Field>> getRecords() {
            return this.records;
        }

        @Override
        public final Builder records(Collection<? extends Collection<Field>> records) {
            this.records = SqlRecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Collection<Field> ... records) {
            this.records((Collection<? extends Collection<Field>>)Arrays.asList(records));
            return this;
        }

        public final void setRecords(Collection<? extends Collection<Field>> records) {
            this.records = SqlRecordsCopier.copy(records);
        }

        @Override
        public ExecuteStatementResponse build() {
            return new ExecuteStatementResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteStatementResponse> {
        public Builder columnMetadata(Collection<ColumnMetadata> var1);

        public Builder columnMetadata(ColumnMetadata ... var1);

        public Builder columnMetadata(Consumer<ColumnMetadata.Builder> ... var1);

        public Builder generatedFields(Collection<Field> var1);

        public Builder generatedFields(Field ... var1);

        public Builder generatedFields(Consumer<Field.Builder> ... var1);

        public Builder numberOfRecordsUpdated(Long var1);

        public Builder records(Collection<? extends Collection<Field>> var1);

        public Builder records(Collection<Field> ... var1);
    }
}

