/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rdsdata.model.RdsDataResponse;
import software.amazon.awssdk.services.rdsdata.model.SqlStatementResult;
import software.amazon.awssdk.services.rdsdata.model.SqlStatementResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteSqlResponse
extends RdsDataResponse
implements ToCopyableBuilder<Builder, ExecuteSqlResponse> {
    private static final SdkField<List<SqlStatementResult>> SQL_STATEMENT_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sqlStatementResults").getter(ExecuteSqlResponse.getter(ExecuteSqlResponse::sqlStatementResults)).setter(ExecuteSqlResponse.setter(Builder::sqlStatementResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlStatementResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SqlStatementResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SQL_STATEMENT_RESULTS_FIELD));
    private final List<SqlStatementResult> sqlStatementResults;

    private ExecuteSqlResponse(BuilderImpl builder) {
        super(builder);
        this.sqlStatementResults = builder.sqlStatementResults;
    }

    public boolean hasSqlStatementResults() {
        return this.sqlStatementResults != null && !(this.sqlStatementResults instanceof SdkAutoConstructList);
    }

    public List<SqlStatementResult> sqlStatementResults() {
        return this.sqlStatementResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlStatementResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteSqlResponse)) {
            return false;
        }
        ExecuteSqlResponse other = (ExecuteSqlResponse)((Object)obj);
        return Objects.equals(this.sqlStatementResults(), other.sqlStatementResults());
    }

    public String toString() {
        return ToString.builder((String)"ExecuteSqlResponse").add("SqlStatementResults", this.sqlStatementResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sqlStatementResults": {
                return Optional.ofNullable(clazz.cast(this.sqlStatementResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteSqlResponse, T> g) {
        return obj -> g.apply((ExecuteSqlResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsDataResponse.BuilderImpl
    implements Builder {
        private List<SqlStatementResult> sqlStatementResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteSqlResponse model) {
            super(model);
            this.sqlStatementResults(model.sqlStatementResults);
        }

        public final Collection<SqlStatementResult.Builder> getSqlStatementResults() {
            return this.sqlStatementResults != null ? (Collection)this.sqlStatementResults.stream().map(SqlStatementResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sqlStatementResults(Collection<SqlStatementResult> sqlStatementResults) {
            this.sqlStatementResults = SqlStatementResultsCopier.copy(sqlStatementResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlStatementResults(SqlStatementResult ... sqlStatementResults) {
            this.sqlStatementResults(Arrays.asList(sqlStatementResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlStatementResults(Consumer<SqlStatementResult.Builder> ... sqlStatementResults) {
            this.sqlStatementResults(Stream.of(sqlStatementResults).map(c -> (SqlStatementResult)((SqlStatementResult.Builder)SqlStatementResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSqlStatementResults(Collection<SqlStatementResult.BuilderImpl> sqlStatementResults) {
            this.sqlStatementResults = SqlStatementResultsCopier.copyFromBuilder(sqlStatementResults);
        }

        @Override
        public ExecuteSqlResponse build() {
            return new ExecuteSqlResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteSqlResponse> {
        public Builder sqlStatementResults(Collection<SqlStatementResult> var1);

        public Builder sqlStatementResults(SqlStatementResult ... var1);

        public Builder sqlStatementResults(Consumer<SqlStatementResult.Builder> ... var1);
    }
}

