/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rdsdata.model.Record;
import software.amazon.awssdk.services.rdsdata.model.RecordsCopier;
import software.amazon.awssdk.services.rdsdata.model.ResultSetMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResultFrame
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResultFrame> {
    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("records").getter(ResultFrame.getter(ResultFrame::records)).setter(ResultFrame.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Record::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ResultSetMetadata> RESULT_SET_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resultSetMetadata").getter(ResultFrame.getter(ResultFrame::resultSetMetadata)).setter(ResultFrame.setter(Builder::resultSetMetadata)).constructor(ResultSetMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultSetMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD, RESULT_SET_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Record> records;
    private final ResultSetMetadata resultSetMetadata;

    private ResultFrame(BuilderImpl builder) {
        this.records = builder.records;
        this.resultSetMetadata = builder.resultSetMetadata;
    }

    public boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public List<Record> records() {
        return this.records;
    }

    public ResultSetMetadata resultSetMetadata() {
        return this.resultSetMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.records());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultSetMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultFrame)) {
            return false;
        }
        ResultFrame other = (ResultFrame)obj;
        return Objects.equals(this.records(), other.records()) && Objects.equals(this.resultSetMetadata(), other.resultSetMetadata());
    }

    public String toString() {
        return ToString.builder((String)"ResultFrame").add("Records", this.records()).add("ResultSetMetadata", (Object)this.resultSetMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "resultSetMetadata": {
                return Optional.ofNullable(clazz.cast(this.resultSetMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultFrame, T> g) {
        return obj -> g.apply((ResultFrame)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Record> records = DefaultSdkAutoConstructList.getInstance();
        private ResultSetMetadata resultSetMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultFrame model) {
            this.records(model.records);
            this.resultSetMetadata(model.resultSetMetadata);
        }

        public final Collection<Record.Builder> getRecords() {
            return this.records != null ? (Collection)this.records.stream().map(Record::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (Record)((Record.Builder)Record.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordsCopier.copyFromBuilder(records);
        }

        public final ResultSetMetadata.Builder getResultSetMetadata() {
            return this.resultSetMetadata != null ? this.resultSetMetadata.toBuilder() : null;
        }

        @Override
        public final Builder resultSetMetadata(ResultSetMetadata resultSetMetadata) {
            this.resultSetMetadata = resultSetMetadata;
            return this;
        }

        public final void setResultSetMetadata(ResultSetMetadata.BuilderImpl resultSetMetadata) {
            this.resultSetMetadata = resultSetMetadata != null ? resultSetMetadata.build() : null;
        }

        public ResultFrame build() {
            return new ResultFrame(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResultFrame> {
        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);

        public Builder records(Consumer<Record.Builder> ... var1);

        public Builder resultSetMetadata(ResultSetMetadata var1);

        default public Builder resultSetMetadata(Consumer<ResultSetMetadata.Builder> resultSetMetadata) {
            return this.resultSetMetadata((ResultSetMetadata)((ResultSetMetadata.Builder)ResultSetMetadata.builder().applyMutation(resultSetMetadata)).build());
        }
    }
}

