/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request parameters represent the input of a request to run one or more SQL statements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteSqlRequest extends RdsDataRequest implements
        ToCopyableBuilder<ExecuteSqlRequest.Builder, ExecuteSqlRequest> {
    private static final SdkField<String> AWS_SECRET_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsSecretStoreArn").getter(getter(ExecuteSqlRequest::awsSecretStoreArn))
            .setter(setter(Builder::awsSecretStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsSecretStoreArn").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("database").getter(getter(ExecuteSqlRequest::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("database").build()).build();

    private static final SdkField<String> DB_CLUSTER_OR_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbClusterOrInstanceArn").getter(getter(ExecuteSqlRequest::dbClusterOrInstanceArn))
            .setter(setter(Builder::dbClusterOrInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbClusterOrInstanceArn").build())
            .build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("schema")
            .getter(getter(ExecuteSqlRequest::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()).build();

    private static final SdkField<String> SQL_STATEMENTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sqlStatements").getter(getter(ExecuteSqlRequest::sqlStatements)).setter(setter(Builder::sqlStatements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlStatements").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_SECRET_STORE_ARN_FIELD,
            DATABASE_FIELD, DB_CLUSTER_OR_INSTANCE_ARN_FIELD, SCHEMA_FIELD, SQL_STATEMENTS_FIELD));

    private final String awsSecretStoreArn;

    private final String database;

    private final String dbClusterOrInstanceArn;

    private final String schema;

    private final String sqlStatements;

    private ExecuteSqlRequest(BuilderImpl builder) {
        super(builder);
        this.awsSecretStoreArn = builder.awsSecretStoreArn;
        this.database = builder.database;
        this.dbClusterOrInstanceArn = builder.dbClusterOrInstanceArn;
        this.schema = builder.schema;
        this.sqlStatements = builder.sqlStatements;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster.
     */
    public String awsSecretStoreArn() {
        return awsSecretStoreArn;
    }

    /**
     * <p>
     * The name of the database.
     * </p>
     * 
     * @return The name of the database.
     */
    public String database() {
        return database;
    }

    /**
     * <p>
     * The ARN of the Aurora Serverless DB cluster.
     * </p>
     * 
     * @return The ARN of the Aurora Serverless DB cluster.
     */
    public String dbClusterOrInstanceArn() {
        return dbClusterOrInstanceArn;
    }

    /**
     * <p>
     * The name of the database schema.
     * </p>
     * 
     * @return The name of the database schema.
     */
    public String schema() {
        return schema;
    }

    /**
     * <p>
     * One or more SQL statements to run on the DB cluster.
     * </p>
     * <p>
     * You can separate SQL statements from each other with a semicolon (;). Any valid SQL statement is permitted,
     * including data definition, data manipulation, and commit statements.
     * </p>
     * 
     * @return One or more SQL statements to run on the DB cluster.</p>
     *         <p>
     *         You can separate SQL statements from each other with a semicolon (;). Any valid SQL statement is
     *         permitted, including data definition, data manipulation, and commit statements.
     */
    public String sqlStatements() {
        return sqlStatements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsSecretStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterOrInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(sqlStatements());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteSqlRequest)) {
            return false;
        }
        ExecuteSqlRequest other = (ExecuteSqlRequest) obj;
        return Objects.equals(awsSecretStoreArn(), other.awsSecretStoreArn()) && Objects.equals(database(), other.database())
                && Objects.equals(dbClusterOrInstanceArn(), other.dbClusterOrInstanceArn())
                && Objects.equals(schema(), other.schema()) && Objects.equals(sqlStatements(), other.sqlStatements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExecuteSqlRequest").add("AwsSecretStoreArn", awsSecretStoreArn()).add("Database", database())
                .add("DbClusterOrInstanceArn", dbClusterOrInstanceArn()).add("Schema", schema())
                .add("SqlStatements", sqlStatements()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsSecretStoreArn":
            return Optional.ofNullable(clazz.cast(awsSecretStoreArn()));
        case "database":
            return Optional.ofNullable(clazz.cast(database()));
        case "dbClusterOrInstanceArn":
            return Optional.ofNullable(clazz.cast(dbClusterOrInstanceArn()));
        case "schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "sqlStatements":
            return Optional.ofNullable(clazz.cast(sqlStatements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteSqlRequest, T> g) {
        return obj -> g.apply((ExecuteSqlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteSqlRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster.
         * </p>
         * 
         * @param awsSecretStoreArn
         *        The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSecretStoreArn(String awsSecretStoreArn);

        /**
         * <p>
         * The name of the database.
         * </p>
         * 
         * @param database
         *        The name of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The ARN of the Aurora Serverless DB cluster.
         * </p>
         * 
         * @param dbClusterOrInstanceArn
         *        The ARN of the Aurora Serverless DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterOrInstanceArn(String dbClusterOrInstanceArn);

        /**
         * <p>
         * The name of the database schema.
         * </p>
         * 
         * @param schema
         *        The name of the database schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * <p>
         * One or more SQL statements to run on the DB cluster.
         * </p>
         * <p>
         * You can separate SQL statements from each other with a semicolon (;). Any valid SQL statement is permitted,
         * including data definition, data manipulation, and commit statements.
         * </p>
         * 
         * @param sqlStatements
         *        One or more SQL statements to run on the DB cluster.</p>
         *        <p>
         *        You can separate SQL statements from each other with a semicolon (;). Any valid SQL statement is
         *        permitted, including data definition, data manipulation, and commit statements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlStatements(String sqlStatements);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsDataRequest.BuilderImpl implements Builder {
        private String awsSecretStoreArn;

        private String database;

        private String dbClusterOrInstanceArn;

        private String schema;

        private String sqlStatements;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteSqlRequest model) {
            super(model);
            awsSecretStoreArn(model.awsSecretStoreArn);
            database(model.database);
            dbClusterOrInstanceArn(model.dbClusterOrInstanceArn);
            schema(model.schema);
            sqlStatements(model.sqlStatements);
        }

        public final String getAwsSecretStoreArn() {
            return awsSecretStoreArn;
        }

        @Override
        public final Builder awsSecretStoreArn(String awsSecretStoreArn) {
            this.awsSecretStoreArn = awsSecretStoreArn;
            return this;
        }

        public final void setAwsSecretStoreArn(String awsSecretStoreArn) {
            this.awsSecretStoreArn = awsSecretStoreArn;
        }

        public final String getDatabase() {
            return database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public final String getDbClusterOrInstanceArn() {
            return dbClusterOrInstanceArn;
        }

        @Override
        public final Builder dbClusterOrInstanceArn(String dbClusterOrInstanceArn) {
            this.dbClusterOrInstanceArn = dbClusterOrInstanceArn;
            return this;
        }

        public final void setDbClusterOrInstanceArn(String dbClusterOrInstanceArn) {
            this.dbClusterOrInstanceArn = dbClusterOrInstanceArn;
        }

        public final String getSchema() {
            return schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        public final String getSqlStatements() {
            return sqlStatements;
        }

        @Override
        public final Builder sqlStatements(String sqlStatements) {
            this.sqlStatements = sqlStatements;
            return this;
        }

        public final void setSqlStatements(String sqlStatements) {
            this.sqlStatements = sqlStatements;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteSqlRequest build() {
            return new ExecuteSqlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
