/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response elements represent the output of a SQL statement over an array of data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchExecuteStatementResponse extends RdsDataResponse implements
        ToCopyableBuilder<BatchExecuteStatementResponse.Builder, BatchExecuteStatementResponse> {
    private static final SdkField<List<UpdateResult>> UPDATE_RESULTS_FIELD = SdkField
            .<List<UpdateResult>> builder(MarshallingType.LIST)
            .memberName("updateResults")
            .getter(getter(BatchExecuteStatementResponse::updateResults))
            .setter(setter(Builder::updateResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_RESULTS_FIELD));

    private final List<UpdateResult> updateResults;

    private BatchExecuteStatementResponse(BuilderImpl builder) {
        super(builder);
        this.updateResults = builder.updateResults;
    }

    /**
     * Returns true if the UpdateResults property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUpdateResults() {
        return updateResults != null && !(updateResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The execution results of each batch entry.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUpdateResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The execution results of each batch entry.
     */
    public List<UpdateResult> updateResults() {
        return updateResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(updateResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchExecuteStatementResponse)) {
            return false;
        }
        BatchExecuteStatementResponse other = (BatchExecuteStatementResponse) obj;
        return Objects.equals(updateResults(), other.updateResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchExecuteStatementResponse").add("UpdateResults", updateResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "updateResults":
            return Optional.ofNullable(clazz.cast(updateResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchExecuteStatementResponse, T> g) {
        return obj -> g.apply((BatchExecuteStatementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchExecuteStatementResponse> {
        /**
         * <p>
         * The execution results of each batch entry.
         * </p>
         * 
         * @param updateResults
         *        The execution results of each batch entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateResults(Collection<UpdateResult> updateResults);

        /**
         * <p>
         * The execution results of each batch entry.
         * </p>
         * 
         * @param updateResults
         *        The execution results of each batch entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateResults(UpdateResult... updateResults);

        /**
         * <p>
         * The execution results of each batch entry.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UpdateResult>.Builder} avoiding the need to
         * create one manually via {@link List<UpdateResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpdateResult>.Builder#build()} is called immediately and its
         * result is passed to {@link #updateResults(List<UpdateResult>)}.
         * 
         * @param updateResults
         *        a consumer that will call methods on {@link List<UpdateResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateResults(List<UpdateResult>)
         */
        Builder updateResults(Consumer<UpdateResult.Builder>... updateResults);
    }

    static final class BuilderImpl extends RdsDataResponse.BuilderImpl implements Builder {
        private List<UpdateResult> updateResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchExecuteStatementResponse model) {
            super(model);
            updateResults(model.updateResults);
        }

        public final Collection<UpdateResult.Builder> getUpdateResults() {
            return updateResults != null ? updateResults.stream().map(UpdateResult::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder updateResults(Collection<UpdateResult> updateResults) {
            this.updateResults = UpdateResultsCopier.copy(updateResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateResults(UpdateResult... updateResults) {
            updateResults(Arrays.asList(updateResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateResults(Consumer<UpdateResult.Builder>... updateResults) {
            updateResults(Stream.of(updateResults).map(c -> UpdateResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUpdateResults(Collection<UpdateResult.BuilderImpl> updateResults) {
            this.updateResults = UpdateResultsCopier.copyFromBuilder(updateResults);
        }

        @Override
        public BatchExecuteStatementResponse build() {
            return new BatchExecuteStatementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
