/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rdsdata.model.ArrayOfArrayCopier;
import software.amazon.awssdk.services.rdsdata.model.BooleanArrayCopier;
import software.amazon.awssdk.services.rdsdata.model.DoubleArrayCopier;
import software.amazon.awssdk.services.rdsdata.model.LongArrayCopier;
import software.amazon.awssdk.services.rdsdata.model.StringArrayCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArrayValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArrayValue> {
    private static final SdkField<List<ArrayValue>> ARRAY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("arrayValues").getter(ArrayValue.getter(ArrayValue::arrayValues)).setter(ArrayValue.setter(Builder::arrayValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ArrayValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Boolean>> BOOLEAN_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("booleanValues").getter(ArrayValue.getter(ArrayValue::booleanValues)).setter(ArrayValue.setter(Builder::booleanValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> DOUBLE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("doubleValues").getter(ArrayValue.getter(ArrayValue::doubleValues)).setter(ArrayValue.setter(Builder::doubleValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Long>> LONG_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("longValues").getter(ArrayValue.getter(ArrayValue::longValues)).setter(ArrayValue.setter(Builder::longValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STRING_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stringValues").getter(ArrayValue.getter(ArrayValue::stringValues)).setter(ArrayValue.setter(Builder::stringValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARRAY_VALUES_FIELD, BOOLEAN_VALUES_FIELD, DOUBLE_VALUES_FIELD, LONG_VALUES_FIELD, STRING_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ArrayValue> arrayValues;
    private final List<Boolean> booleanValues;
    private final List<Double> doubleValues;
    private final List<Long> longValues;
    private final List<String> stringValues;

    private ArrayValue(BuilderImpl builder) {
        this.arrayValues = builder.arrayValues;
        this.booleanValues = builder.booleanValues;
        this.doubleValues = builder.doubleValues;
        this.longValues = builder.longValues;
        this.stringValues = builder.stringValues;
    }

    public boolean hasArrayValues() {
        return this.arrayValues != null && !(this.arrayValues instanceof SdkAutoConstructList);
    }

    public List<ArrayValue> arrayValues() {
        return this.arrayValues;
    }

    public boolean hasBooleanValues() {
        return this.booleanValues != null && !(this.booleanValues instanceof SdkAutoConstructList);
    }

    public List<Boolean> booleanValues() {
        return this.booleanValues;
    }

    public boolean hasDoubleValues() {
        return this.doubleValues != null && !(this.doubleValues instanceof SdkAutoConstructList);
    }

    public List<Double> doubleValues() {
        return this.doubleValues;
    }

    public boolean hasLongValues() {
        return this.longValues != null && !(this.longValues instanceof SdkAutoConstructList);
    }

    public List<Long> longValues() {
        return this.longValues;
    }

    public boolean hasStringValues() {
        return this.stringValues != null && !(this.stringValues instanceof SdkAutoConstructList);
    }

    public List<String> stringValues() {
        return this.stringValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArrayValues() ? this.arrayValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBooleanValues() ? this.booleanValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDoubleValues() ? this.doubleValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLongValues() ? this.longValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringValues() ? this.stringValues() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArrayValue)) {
            return false;
        }
        ArrayValue other = (ArrayValue)obj;
        return this.hasArrayValues() == other.hasArrayValues() && Objects.equals(this.arrayValues(), other.arrayValues()) && this.hasBooleanValues() == other.hasBooleanValues() && Objects.equals(this.booleanValues(), other.booleanValues()) && this.hasDoubleValues() == other.hasDoubleValues() && Objects.equals(this.doubleValues(), other.doubleValues()) && this.hasLongValues() == other.hasLongValues() && Objects.equals(this.longValues(), other.longValues()) && this.hasStringValues() == other.hasStringValues() && Objects.equals(this.stringValues(), other.stringValues());
    }

    public String toString() {
        return ToString.builder((String)"ArrayValue").add("ArrayValues", this.hasArrayValues() ? this.arrayValues() : null).add("BooleanValues", this.hasBooleanValues() ? this.booleanValues() : null).add("DoubleValues", this.hasDoubleValues() ? this.doubleValues() : null).add("LongValues", this.hasLongValues() ? this.longValues() : null).add("StringValues", this.hasStringValues() ? this.stringValues() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arrayValues": {
                return Optional.ofNullable(clazz.cast(this.arrayValues()));
            }
            case "booleanValues": {
                return Optional.ofNullable(clazz.cast(this.booleanValues()));
            }
            case "doubleValues": {
                return Optional.ofNullable(clazz.cast(this.doubleValues()));
            }
            case "longValues": {
                return Optional.ofNullable(clazz.cast(this.longValues()));
            }
            case "stringValues": {
                return Optional.ofNullable(clazz.cast(this.stringValues()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArrayValue, T> g) {
        return obj -> g.apply((ArrayValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ArrayValue> arrayValues = DefaultSdkAutoConstructList.getInstance();
        private List<Boolean> booleanValues = DefaultSdkAutoConstructList.getInstance();
        private List<Double> doubleValues = DefaultSdkAutoConstructList.getInstance();
        private List<Long> longValues = DefaultSdkAutoConstructList.getInstance();
        private List<String> stringValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ArrayValue model) {
            this.arrayValues(model.arrayValues);
            this.booleanValues(model.booleanValues);
            this.doubleValues(model.doubleValues);
            this.longValues(model.longValues);
            this.stringValues(model.stringValues);
        }

        public final Collection<Builder> getArrayValues() {
            if (this.arrayValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.arrayValues != null ? (Collection)this.arrayValues.stream().map(ArrayValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder arrayValues(Collection<ArrayValue> arrayValues) {
            this.arrayValues = ArrayOfArrayCopier.copy(arrayValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValues(ArrayValue ... arrayValues) {
            this.arrayValues(Arrays.asList(arrayValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValues(Consumer<Builder> ... arrayValues) {
            this.arrayValues(Stream.of(arrayValues).map(c -> (ArrayValue)((Builder)ArrayValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setArrayValues(Collection<BuilderImpl> arrayValues) {
            this.arrayValues = ArrayOfArrayCopier.copyFromBuilder(arrayValues);
        }

        public final Collection<Boolean> getBooleanValues() {
            if (this.booleanValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.booleanValues;
        }

        @Override
        public final Builder booleanValues(Collection<Boolean> booleanValues) {
            this.booleanValues = BooleanArrayCopier.copy(booleanValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder booleanValues(Boolean ... booleanValues) {
            this.booleanValues(Arrays.asList(booleanValues));
            return this;
        }

        public final void setBooleanValues(Collection<Boolean> booleanValues) {
            this.booleanValues = BooleanArrayCopier.copy(booleanValues);
        }

        public final Collection<Double> getDoubleValues() {
            if (this.doubleValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.doubleValues;
        }

        @Override
        public final Builder doubleValues(Collection<Double> doubleValues) {
            this.doubleValues = DoubleArrayCopier.copy(doubleValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder doubleValues(Double ... doubleValues) {
            this.doubleValues(Arrays.asList(doubleValues));
            return this;
        }

        public final void setDoubleValues(Collection<Double> doubleValues) {
            this.doubleValues = DoubleArrayCopier.copy(doubleValues);
        }

        public final Collection<Long> getLongValues() {
            if (this.longValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.longValues;
        }

        @Override
        public final Builder longValues(Collection<Long> longValues) {
            this.longValues = LongArrayCopier.copy(longValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder longValues(Long ... longValues) {
            this.longValues(Arrays.asList(longValues));
            return this;
        }

        public final void setLongValues(Collection<Long> longValues) {
            this.longValues = LongArrayCopier.copy(longValues);
        }

        public final Collection<String> getStringValues() {
            if (this.stringValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stringValues;
        }

        @Override
        public final Builder stringValues(Collection<String> stringValues) {
            this.stringValues = StringArrayCopier.copy(stringValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringValues(String ... stringValues) {
            this.stringValues(Arrays.asList(stringValues));
            return this;
        }

        public final void setStringValues(Collection<String> stringValues) {
            this.stringValues = StringArrayCopier.copy(stringValues);
        }

        public ArrayValue build() {
            return new ArrayValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArrayValue> {
        public Builder arrayValues(Collection<ArrayValue> var1);

        public Builder arrayValues(ArrayValue ... var1);

        public Builder arrayValues(Consumer<Builder> ... var1);

        public Builder booleanValues(Collection<Boolean> var1);

        public Builder booleanValues(Boolean ... var1);

        public Builder doubleValues(Collection<Double> var1);

        public Builder doubleValues(Double ... var1);

        public Builder longValues(Collection<Long> var1);

        public Builder longValues(Long ... var1);

        public Builder stringValues(Collection<String> var1);

        public Builder stringValues(String ... var1);
    }
}

