/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TypeHint {
    JSON("JSON"),
    UUID("UUID"),
    TIMESTAMP("TIMESTAMP"),
    DATE("DATE"),
    TIME("TIME"),
    DECIMAL("DECIMAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TypeHint(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TypeHint fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TypeHint.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TypeHint> knownValues() {
        return Stream.of(TypeHint.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

