/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata of the result set returned by a SQL statement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultSetMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ResultSetMetadata.Builder, ResultSetMetadata> {
    private static final SdkField<Long> COLUMN_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("columnCount").getter(getter(ResultSetMetadata::columnCount)).setter(setter(Builder::columnCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnCount").build()).build();

    private static final SdkField<List<ColumnMetadata>> COLUMN_METADATA_FIELD = SdkField
            .<List<ColumnMetadata>> builder(MarshallingType.LIST)
            .memberName("columnMetadata")
            .getter(getter(ResultSetMetadata::columnMetadata))
            .setter(setter(Builder::columnMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_COUNT_FIELD,
            COLUMN_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long columnCount;

    private final List<ColumnMetadata> columnMetadata;

    private ResultSetMetadata(BuilderImpl builder) {
        this.columnCount = builder.columnCount;
        this.columnMetadata = builder.columnMetadata;
    }

    /**
     * <p>
     * The number of columns in the result set.
     * </p>
     * 
     * @return The number of columns in the result set.
     */
    public final Long columnCount() {
        return columnCount;
    }

    /**
     * Returns true if the ColumnMetadata property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasColumnMetadata() {
        return columnMetadata != null && !(columnMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata of the columns in the result set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasColumnMetadata()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metadata of the columns in the result set.
     */
    public final List<ColumnMetadata> columnMetadata() {
        return columnMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnMetadata() ? columnMetadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSetMetadata)) {
            return false;
        }
        ResultSetMetadata other = (ResultSetMetadata) obj;
        return Objects.equals(columnCount(), other.columnCount()) && hasColumnMetadata() == other.hasColumnMetadata()
                && Objects.equals(columnMetadata(), other.columnMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResultSetMetadata").add("ColumnCount", columnCount())
                .add("ColumnMetadata", hasColumnMetadata() ? columnMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columnCount":
            return Optional.ofNullable(clazz.cast(columnCount()));
        case "columnMetadata":
            return Optional.ofNullable(clazz.cast(columnMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultSetMetadata, T> g) {
        return obj -> g.apply((ResultSetMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultSetMetadata> {
        /**
         * <p>
         * The number of columns in the result set.
         * </p>
         * 
         * @param columnCount
         *        The number of columns in the result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnCount(Long columnCount);

        /**
         * <p>
         * The metadata of the columns in the result set.
         * </p>
         * 
         * @param columnMetadata
         *        The metadata of the columns in the result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnMetadata(Collection<ColumnMetadata> columnMetadata);

        /**
         * <p>
         * The metadata of the columns in the result set.
         * </p>
         * 
         * @param columnMetadata
         *        The metadata of the columns in the result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnMetadata(ColumnMetadata... columnMetadata);

        /**
         * <p>
         * The metadata of the columns in the result set.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ColumnMetadata>.Builder} avoiding the need
         * to create one manually via {@link List<ColumnMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ColumnMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #columnMetadata(List<ColumnMetadata>)}.
         * 
         * @param columnMetadata
         *        a consumer that will call methods on {@link List<ColumnMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnMetadata(List<ColumnMetadata>)
         */
        Builder columnMetadata(Consumer<ColumnMetadata.Builder>... columnMetadata);
    }

    static final class BuilderImpl implements Builder {
        private Long columnCount;

        private List<ColumnMetadata> columnMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResultSetMetadata model) {
            columnCount(model.columnCount);
            columnMetadata(model.columnMetadata);
        }

        public final Long getColumnCount() {
            return columnCount;
        }

        public final void setColumnCount(Long columnCount) {
            this.columnCount = columnCount;
        }

        @Override
        @Transient
        public final Builder columnCount(Long columnCount) {
            this.columnCount = columnCount;
            return this;
        }

        public final List<ColumnMetadata.Builder> getColumnMetadata() {
            List<ColumnMetadata.Builder> result = MetadataCopier.copyToBuilder(this.columnMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnMetadata(Collection<ColumnMetadata.BuilderImpl> columnMetadata) {
            this.columnMetadata = MetadataCopier.copyFromBuilder(columnMetadata);
        }

        @Override
        @Transient
        public final Builder columnMetadata(Collection<ColumnMetadata> columnMetadata) {
            this.columnMetadata = MetadataCopier.copy(columnMetadata);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columnMetadata(ColumnMetadata... columnMetadata) {
            columnMetadata(Arrays.asList(columnMetadata));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columnMetadata(Consumer<ColumnMetadata.Builder>... columnMetadata) {
            columnMetadata(Stream.of(columnMetadata).map(c -> ColumnMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ResultSetMetadata build() {
            return new ResultSetMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
