/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response elements represent the results of an update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResult implements SdkPojo, Serializable, ToCopyableBuilder<UpdateResult.Builder, UpdateResult> {
    private static final SdkField<List<Field>> GENERATED_FIELDS_FIELD = SdkField
            .<List<Field>> builder(MarshallingType.LIST)
            .memberName("generatedFields")
            .getter(getter(UpdateResult::generatedFields))
            .setter(setter(Builder::generatedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                            .constructor(Field::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_FIELDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Field> generatedFields;

    private UpdateResult(BuilderImpl builder) {
        this.generatedFields = builder.generatedFields;
    }

    /**
     * Returns true if the GeneratedFields property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasGeneratedFields() {
        return generatedFields != null && !(generatedFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Values for fields generated during the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGeneratedFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Values for fields generated during the request.
     */
    public final List<Field> generatedFields() {
        return generatedFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGeneratedFields() ? generatedFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResult)) {
            return false;
        }
        UpdateResult other = (UpdateResult) obj;
        return hasGeneratedFields() == other.hasGeneratedFields() && Objects.equals(generatedFields(), other.generatedFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResult").add("GeneratedFields", hasGeneratedFields() ? generatedFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "generatedFields":
            return Optional.ofNullable(clazz.cast(generatedFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResult, T> g) {
        return obj -> g.apply((UpdateResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateResult> {
        /**
         * <p>
         * Values for fields generated during the request.
         * </p>
         * 
         * @param generatedFields
         *        Values for fields generated during the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedFields(Collection<Field> generatedFields);

        /**
         * <p>
         * Values for fields generated during the request.
         * </p>
         * 
         * @param generatedFields
         *        Values for fields generated during the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedFields(Field... generatedFields);

        /**
         * <p>
         * Values for fields generated during the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Field>.Builder} avoiding the need to create
         * one manually via {@link List<Field>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Field>.Builder#build()} is called immediately and its result
         * is passed to {@link #generatedFields(List<Field>)}.
         * 
         * @param generatedFields
         *        a consumer that will call methods on {@link List<Field>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generatedFields(List<Field>)
         */
        Builder generatedFields(Consumer<Field.Builder>... generatedFields);
    }

    static final class BuilderImpl implements Builder {
        private List<Field> generatedFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResult model) {
            generatedFields(model.generatedFields);
        }

        public final List<Field.Builder> getGeneratedFields() {
            List<Field.Builder> result = FieldListCopier.copyToBuilder(this.generatedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeneratedFields(Collection<Field.BuilderImpl> generatedFields) {
            this.generatedFields = FieldListCopier.copyFromBuilder(generatedFields);
        }

        @Override
        @Transient
        public final Builder generatedFields(Collection<Field> generatedFields) {
            this.generatedFields = FieldListCopier.copy(generatedFields);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder generatedFields(Field... generatedFields) {
            generatedFields(Arrays.asList(generatedFields));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder generatedFields(Consumer<Field.Builder>... generatedFields) {
            generatedFields(Stream.of(generatedFields).map(c -> Field.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdateResult build() {
            return new UpdateResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
