/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rdsdata.model.ArrayOfArrayCopier;
import software.amazon.awssdk.services.rdsdata.model.BooleanArrayCopier;
import software.amazon.awssdk.services.rdsdata.model.DoubleArrayCopier;
import software.amazon.awssdk.services.rdsdata.model.LongArrayCopier;
import software.amazon.awssdk.services.rdsdata.model.StringArrayCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArrayValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArrayValue> {
    private static final SdkField<List<ArrayValue>> ARRAY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("arrayValues").getter(ArrayValue.getter(ArrayValue::arrayValues)).setter(ArrayValue.setter(Builder::arrayValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ArrayValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Boolean>> BOOLEAN_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("booleanValues").getter(ArrayValue.getter(ArrayValue::booleanValues)).setter(ArrayValue.setter(Builder::booleanValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> DOUBLE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("doubleValues").getter(ArrayValue.getter(ArrayValue::doubleValues)).setter(ArrayValue.setter(Builder::doubleValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Long>> LONG_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("longValues").getter(ArrayValue.getter(ArrayValue::longValues)).setter(ArrayValue.setter(Builder::longValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STRING_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stringValues").getter(ArrayValue.getter(ArrayValue::stringValues)).setter(ArrayValue.setter(Builder::stringValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARRAY_VALUES_FIELD, BOOLEAN_VALUES_FIELD, DOUBLE_VALUES_FIELD, LONG_VALUES_FIELD, STRING_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ArrayValue> arrayValues;
    private final List<Boolean> booleanValues;
    private final List<Double> doubleValues;
    private final List<Long> longValues;
    private final List<String> stringValues;
    private final Type type;

    private ArrayValue(BuilderImpl builder) {
        this.arrayValues = builder.arrayValues;
        this.booleanValues = builder.booleanValues;
        this.doubleValues = builder.doubleValues;
        this.longValues = builder.longValues;
        this.stringValues = builder.stringValues;
        this.type = builder.type;
    }

    public final boolean hasArrayValues() {
        return this.arrayValues != null && !(this.arrayValues instanceof SdkAutoConstructList);
    }

    public final List<ArrayValue> arrayValues() {
        return this.arrayValues;
    }

    public final boolean hasBooleanValues() {
        return this.booleanValues != null && !(this.booleanValues instanceof SdkAutoConstructList);
    }

    public final List<Boolean> booleanValues() {
        return this.booleanValues;
    }

    public final boolean hasDoubleValues() {
        return this.doubleValues != null && !(this.doubleValues instanceof SdkAutoConstructList);
    }

    public final List<Double> doubleValues() {
        return this.doubleValues;
    }

    public final boolean hasLongValues() {
        return this.longValues != null && !(this.longValues instanceof SdkAutoConstructList);
    }

    public final List<Long> longValues() {
        return this.longValues;
    }

    public final boolean hasStringValues() {
        return this.stringValues != null && !(this.stringValues instanceof SdkAutoConstructList);
    }

    public final List<String> stringValues() {
        return this.stringValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArrayValues() ? this.arrayValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBooleanValues() ? this.booleanValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDoubleValues() ? this.doubleValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLongValues() ? this.longValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringValues() ? this.stringValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArrayValue)) {
            return false;
        }
        ArrayValue other = (ArrayValue)obj;
        return this.hasArrayValues() == other.hasArrayValues() && Objects.equals(this.arrayValues(), other.arrayValues()) && this.hasBooleanValues() == other.hasBooleanValues() && Objects.equals(this.booleanValues(), other.booleanValues()) && this.hasDoubleValues() == other.hasDoubleValues() && Objects.equals(this.doubleValues(), other.doubleValues()) && this.hasLongValues() == other.hasLongValues() && Objects.equals(this.longValues(), other.longValues()) && this.hasStringValues() == other.hasStringValues() && Objects.equals(this.stringValues(), other.stringValues());
    }

    public final String toString() {
        return ToString.builder((String)"ArrayValue").add("ArrayValues", this.hasArrayValues() ? this.arrayValues() : null).add("BooleanValues", this.hasBooleanValues() ? this.booleanValues() : null).add("DoubleValues", this.hasDoubleValues() ? this.doubleValues() : null).add("LongValues", this.hasLongValues() ? this.longValues() : null).add("StringValues", this.hasStringValues() ? this.stringValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arrayValues": {
                return Optional.ofNullable(clazz.cast(this.arrayValues()));
            }
            case "booleanValues": {
                return Optional.ofNullable(clazz.cast(this.booleanValues()));
            }
            case "doubleValues": {
                return Optional.ofNullable(clazz.cast(this.doubleValues()));
            }
            case "longValues": {
                return Optional.ofNullable(clazz.cast(this.longValues()));
            }
            case "stringValues": {
                return Optional.ofNullable(clazz.cast(this.stringValues()));
            }
        }
        return Optional.empty();
    }

    public static ArrayValue fromArrayValues(List<ArrayValue> arrayValues) {
        return (ArrayValue)ArrayValue.builder().arrayValues(arrayValues).build();
    }

    public static ArrayValue fromBooleanValues(List<Boolean> booleanValues) {
        return (ArrayValue)ArrayValue.builder().booleanValues(booleanValues).build();
    }

    public static ArrayValue fromDoubleValues(List<Double> doubleValues) {
        return (ArrayValue)ArrayValue.builder().doubleValues(doubleValues).build();
    }

    public static ArrayValue fromLongValues(List<Long> longValues) {
        return (ArrayValue)ArrayValue.builder().longValues(longValues).build();
    }

    public static ArrayValue fromStringValues(List<String> stringValues) {
        return (ArrayValue)ArrayValue.builder().stringValues(stringValues).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArrayValue, T> g) {
        return obj -> g.apply((ArrayValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ARRAY_VALUES,
        BOOLEAN_VALUES,
        DOUBLE_VALUES,
        LONG_VALUES,
        STRING_VALUES,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<ArrayValue> arrayValues = DefaultSdkAutoConstructList.getInstance();
        private List<Boolean> booleanValues = DefaultSdkAutoConstructList.getInstance();
        private List<Double> doubleValues = DefaultSdkAutoConstructList.getInstance();
        private List<Long> longValues = DefaultSdkAutoConstructList.getInstance();
        private List<String> stringValues = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ArrayValue model) {
            this.arrayValues(model.arrayValues);
            this.booleanValues(model.booleanValues);
            this.doubleValues(model.doubleValues);
            this.longValues(model.longValues);
            this.stringValues(model.stringValues);
        }

        public final List<Builder> getArrayValues() {
            List<Builder> result = ArrayOfArrayCopier.copyToBuilder(this.arrayValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArrayValues(Collection<BuilderImpl> arrayValues) {
            List<ArrayValue> oldValue = this.arrayValues;
            this.arrayValues = ArrayOfArrayCopier.copyFromBuilder(arrayValues);
            this.handleUnionValueChange(Type.ARRAY_VALUES, oldValue, this.arrayValues);
        }

        @Override
        public final Builder arrayValues(Collection<ArrayValue> arrayValues) {
            List<ArrayValue> oldValue = this.arrayValues;
            this.arrayValues = ArrayOfArrayCopier.copy(arrayValues);
            this.handleUnionValueChange(Type.ARRAY_VALUES, oldValue, this.arrayValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValues(ArrayValue ... arrayValues) {
            this.arrayValues(Arrays.asList(arrayValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValues(Consumer<Builder> ... arrayValues) {
            this.arrayValues(Stream.of(arrayValues).map(c -> (ArrayValue)((Builder)ArrayValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<Boolean> getBooleanValues() {
            if (this.booleanValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.booleanValues;
        }

        public final void setBooleanValues(Collection<Boolean> booleanValues) {
            List<Boolean> oldValue = this.booleanValues;
            this.booleanValues = BooleanArrayCopier.copy(booleanValues);
            this.handleUnionValueChange(Type.BOOLEAN_VALUES, oldValue, this.booleanValues);
        }

        @Override
        public final Builder booleanValues(Collection<Boolean> booleanValues) {
            List<Boolean> oldValue = this.booleanValues;
            this.booleanValues = BooleanArrayCopier.copy(booleanValues);
            this.handleUnionValueChange(Type.BOOLEAN_VALUES, oldValue, this.booleanValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder booleanValues(Boolean ... booleanValues) {
            this.booleanValues(Arrays.asList(booleanValues));
            return this;
        }

        public final Collection<Double> getDoubleValues() {
            if (this.doubleValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.doubleValues;
        }

        public final void setDoubleValues(Collection<Double> doubleValues) {
            List<Double> oldValue = this.doubleValues;
            this.doubleValues = DoubleArrayCopier.copy(doubleValues);
            this.handleUnionValueChange(Type.DOUBLE_VALUES, oldValue, this.doubleValues);
        }

        @Override
        public final Builder doubleValues(Collection<Double> doubleValues) {
            List<Double> oldValue = this.doubleValues;
            this.doubleValues = DoubleArrayCopier.copy(doubleValues);
            this.handleUnionValueChange(Type.DOUBLE_VALUES, oldValue, this.doubleValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder doubleValues(Double ... doubleValues) {
            this.doubleValues(Arrays.asList(doubleValues));
            return this;
        }

        public final Collection<Long> getLongValues() {
            if (this.longValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.longValues;
        }

        public final void setLongValues(Collection<Long> longValues) {
            List<Long> oldValue = this.longValues;
            this.longValues = LongArrayCopier.copy(longValues);
            this.handleUnionValueChange(Type.LONG_VALUES, oldValue, this.longValues);
        }

        @Override
        public final Builder longValues(Collection<Long> longValues) {
            List<Long> oldValue = this.longValues;
            this.longValues = LongArrayCopier.copy(longValues);
            this.handleUnionValueChange(Type.LONG_VALUES, oldValue, this.longValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder longValues(Long ... longValues) {
            this.longValues(Arrays.asList(longValues));
            return this;
        }

        public final Collection<String> getStringValues() {
            if (this.stringValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stringValues;
        }

        public final void setStringValues(Collection<String> stringValues) {
            List<String> oldValue = this.stringValues;
            this.stringValues = StringArrayCopier.copy(stringValues);
            this.handleUnionValueChange(Type.STRING_VALUES, oldValue, this.stringValues);
        }

        @Override
        public final Builder stringValues(Collection<String> stringValues) {
            List<String> oldValue = this.stringValues;
            this.stringValues = StringArrayCopier.copy(stringValues);
            this.handleUnionValueChange(Type.STRING_VALUES, oldValue, this.stringValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringValues(String ... stringValues) {
            this.stringValues(Arrays.asList(stringValues));
            return this;
        }

        public ArrayValue build() {
            return new ArrayValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArrayValue> {
        public Builder arrayValues(Collection<ArrayValue> var1);

        public Builder arrayValues(ArrayValue ... var1);

        public Builder arrayValues(Consumer<Builder> ... var1);

        public Builder booleanValues(Collection<Boolean> var1);

        public Builder booleanValues(Boolean ... var1);

        public Builder doubleValues(Collection<Double> var1);

        public Builder doubleValues(Double ... var1);

        public Builder longValues(Collection<Long> var1);

        public Builder longValues(Long ... var1);

        public Builder stringValues(Collection<String> var1);

        public Builder stringValues(String ... var1);
    }
}

