/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an array.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArrayValue implements SdkPojo, Serializable, ToCopyableBuilder<ArrayValue.Builder, ArrayValue> {
    private static final SdkField<List<ArrayValue>> ARRAY_VALUES_FIELD = SdkField
            .<List<ArrayValue>> builder(MarshallingType.LIST)
            .memberName("arrayValues")
            .getter(getter(ArrayValue::arrayValues))
            .setter(setter(Builder::arrayValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ArrayValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ArrayValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Boolean>> BOOLEAN_VALUES_FIELD = SdkField
            .<List<Boolean>> builder(MarshallingType.LIST)
            .memberName("booleanValues")
            .getter(getter(ArrayValue::booleanValues))
            .setter(setter(Builder::booleanValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Double>> DOUBLE_VALUES_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("doubleValues")
            .getter(getter(ArrayValue::doubleValues))
            .setter(setter(Builder::doubleValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Long>> LONG_VALUES_FIELD = SdkField
            .<List<Long>> builder(MarshallingType.LIST)
            .memberName("longValues")
            .getter(getter(ArrayValue::longValues))
            .setter(setter(Builder::longValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STRING_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stringValues")
            .getter(getter(ArrayValue::stringValues))
            .setter(setter(Builder::stringValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARRAY_VALUES_FIELD,
            BOOLEAN_VALUES_FIELD, DOUBLE_VALUES_FIELD, LONG_VALUES_FIELD, STRING_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ArrayValue> arrayValues;

    private final List<Boolean> booleanValues;

    private final List<Double> doubleValues;

    private final List<Long> longValues;

    private final List<String> stringValues;

    private final Type type;

    private ArrayValue(BuilderImpl builder) {
        this.arrayValues = builder.arrayValues;
        this.booleanValues = builder.booleanValues;
        this.doubleValues = builder.doubleValues;
        this.longValues = builder.longValues;
        this.stringValues = builder.stringValues;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the ArrayValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasArrayValues() {
        return arrayValues != null && !(arrayValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of arrays.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArrayValues} method.
     * </p>
     * 
     * @return An array of arrays.
     */
    public final List<ArrayValue> arrayValues() {
        return arrayValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the BooleanValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBooleanValues() {
        return booleanValues != null && !(booleanValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Boolean values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBooleanValues} method.
     * </p>
     * 
     * @return An array of Boolean values.
     */
    public final List<Boolean> booleanValues() {
        return booleanValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the DoubleValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDoubleValues() {
        return doubleValues != null && !(doubleValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of floating-point numbers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDoubleValues} method.
     * </p>
     * 
     * @return An array of floating-point numbers.
     */
    public final List<Double> doubleValues() {
        return doubleValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the LongValues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLongValues() {
        return longValues != null && !(longValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of integers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLongValues} method.
     * </p>
     * 
     * @return An array of integers.
     */
    public final List<Long> longValues() {
        return longValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringValues() {
        return stringValues != null && !(stringValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringValues} method.
     * </p>
     * 
     * @return An array of strings.
     */
    public final List<String> stringValues() {
        return stringValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasArrayValues() ? arrayValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBooleanValues() ? booleanValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDoubleValues() ? doubleValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLongValues() ? longValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStringValues() ? stringValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArrayValue)) {
            return false;
        }
        ArrayValue other = (ArrayValue) obj;
        return hasArrayValues() == other.hasArrayValues() && Objects.equals(arrayValues(), other.arrayValues())
                && hasBooleanValues() == other.hasBooleanValues() && Objects.equals(booleanValues(), other.booleanValues())
                && hasDoubleValues() == other.hasDoubleValues() && Objects.equals(doubleValues(), other.doubleValues())
                && hasLongValues() == other.hasLongValues() && Objects.equals(longValues(), other.longValues())
                && hasStringValues() == other.hasStringValues() && Objects.equals(stringValues(), other.stringValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArrayValue").add("ArrayValues", hasArrayValues() ? arrayValues() : null)
                .add("BooleanValues", hasBooleanValues() ? booleanValues() : null)
                .add("DoubleValues", hasDoubleValues() ? doubleValues() : null)
                .add("LongValues", hasLongValues() ? longValues() : null)
                .add("StringValues", hasStringValues() ? stringValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arrayValues":
            return Optional.ofNullable(clazz.cast(arrayValues()));
        case "booleanValues":
            return Optional.ofNullable(clazz.cast(booleanValues()));
        case "doubleValues":
            return Optional.ofNullable(clazz.cast(doubleValues()));
        case "longValues":
            return Optional.ofNullable(clazz.cast(longValues()));
        case "stringValues":
            return Optional.ofNullable(clazz.cast(stringValues()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #arrayValues()} initialized to the given value.
     *
     * <p>
     * An array of arrays.
     * </p>
     * 
     * @param arrayValues
     *        An array of arrays.
     */
    public static ArrayValue fromArrayValues(List<ArrayValue> arrayValues) {
        return builder().arrayValues(arrayValues).build();
    }

    /**
     * Create an instance of this class with {@link #booleanValues()} initialized to the given value.
     *
     * <p>
     * An array of Boolean values.
     * </p>
     * 
     * @param booleanValues
     *        An array of Boolean values.
     */
    public static ArrayValue fromBooleanValues(List<Boolean> booleanValues) {
        return builder().booleanValues(booleanValues).build();
    }

    /**
     * Create an instance of this class with {@link #doubleValues()} initialized to the given value.
     *
     * <p>
     * An array of floating-point numbers.
     * </p>
     * 
     * @param doubleValues
     *        An array of floating-point numbers.
     */
    public static ArrayValue fromDoubleValues(List<Double> doubleValues) {
        return builder().doubleValues(doubleValues).build();
    }

    /**
     * Create an instance of this class with {@link #longValues()} initialized to the given value.
     *
     * <p>
     * An array of integers.
     * </p>
     * 
     * @param longValues
     *        An array of integers.
     */
    public static ArrayValue fromLongValues(List<Long> longValues) {
        return builder().longValues(longValues).build();
    }

    /**
     * Create an instance of this class with {@link #stringValues()} initialized to the given value.
     *
     * <p>
     * An array of strings.
     * </p>
     * 
     * @param stringValues
     *        An array of strings.
     */
    public static ArrayValue fromStringValues(List<String> stringValues) {
        return builder().stringValues(stringValues).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArrayValue, T> g) {
        return obj -> g.apply((ArrayValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArrayValue> {
        /**
         * <p>
         * An array of arrays.
         * </p>
         * 
         * @param arrayValues
         *        An array of arrays.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayValues(Collection<ArrayValue> arrayValues);

        /**
         * <p>
         * An array of arrays.
         * </p>
         * 
         * @param arrayValues
         *        An array of arrays.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayValues(ArrayValue... arrayValues);

        /**
         * <p>
         * An array of arrays.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ArrayValue>.Builder} avoiding the
         * need to create one manually via {@link List<ArrayValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ArrayValue>.Builder#build()} is called immediately and its
         * result is passed to {@link #arrayValues(List<ArrayValue>)}.
         * 
         * @param arrayValues
         *        a consumer that will call methods on {@link List<ArrayValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arrayValues(List<ArrayValue>)
         */
        Builder arrayValues(Consumer<Builder>... arrayValues);

        /**
         * <p>
         * An array of Boolean values.
         * </p>
         * 
         * @param booleanValues
         *        An array of Boolean values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValues(Collection<Boolean> booleanValues);

        /**
         * <p>
         * An array of Boolean values.
         * </p>
         * 
         * @param booleanValues
         *        An array of Boolean values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValues(Boolean... booleanValues);

        /**
         * <p>
         * An array of floating-point numbers.
         * </p>
         * 
         * @param doubleValues
         *        An array of floating-point numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValues(Collection<Double> doubleValues);

        /**
         * <p>
         * An array of floating-point numbers.
         * </p>
         * 
         * @param doubleValues
         *        An array of floating-point numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValues(Double... doubleValues);

        /**
         * <p>
         * An array of integers.
         * </p>
         * 
         * @param longValues
         *        An array of integers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longValues(Collection<Long> longValues);

        /**
         * <p>
         * An array of integers.
         * </p>
         * 
         * @param longValues
         *        An array of integers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longValues(Long... longValues);

        /**
         * <p>
         * An array of strings.
         * </p>
         * 
         * @param stringValues
         *        An array of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValues(Collection<String> stringValues);

        /**
         * <p>
         * An array of strings.
         * </p>
         * 
         * @param stringValues
         *        An array of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValues(String... stringValues);
    }

    static final class BuilderImpl implements Builder {
        private List<ArrayValue> arrayValues = DefaultSdkAutoConstructList.getInstance();

        private List<Boolean> booleanValues = DefaultSdkAutoConstructList.getInstance();

        private List<Double> doubleValues = DefaultSdkAutoConstructList.getInstance();

        private List<Long> longValues = DefaultSdkAutoConstructList.getInstance();

        private List<String> stringValues = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ArrayValue model) {
            arrayValues(model.arrayValues);
            booleanValues(model.booleanValues);
            doubleValues(model.doubleValues);
            longValues(model.longValues);
            stringValues(model.stringValues);
        }

        public final List<Builder> getArrayValues() {
            List<Builder> result = ArrayOfArrayCopier.copyToBuilder(this.arrayValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArrayValues(Collection<BuilderImpl> arrayValues) {
            Object oldValue = this.arrayValues;
            this.arrayValues = ArrayOfArrayCopier.copyFromBuilder(arrayValues);
            handleUnionValueChange(Type.ARRAY_VALUES, oldValue, this.arrayValues);
        }

        @Override
        public final Builder arrayValues(Collection<ArrayValue> arrayValues) {
            Object oldValue = this.arrayValues;
            this.arrayValues = ArrayOfArrayCopier.copy(arrayValues);
            handleUnionValueChange(Type.ARRAY_VALUES, oldValue, this.arrayValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValues(ArrayValue... arrayValues) {
            arrayValues(Arrays.asList(arrayValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValues(Consumer<Builder>... arrayValues) {
            arrayValues(Stream.of(arrayValues).map(c -> ArrayValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<Boolean> getBooleanValues() {
            if (booleanValues instanceof SdkAutoConstructList) {
                return null;
            }
            return booleanValues;
        }

        public final void setBooleanValues(Collection<Boolean> booleanValues) {
            Object oldValue = this.booleanValues;
            this.booleanValues = BooleanArrayCopier.copy(booleanValues);
            handleUnionValueChange(Type.BOOLEAN_VALUES, oldValue, this.booleanValues);
        }

        @Override
        public final Builder booleanValues(Collection<Boolean> booleanValues) {
            Object oldValue = this.booleanValues;
            this.booleanValues = BooleanArrayCopier.copy(booleanValues);
            handleUnionValueChange(Type.BOOLEAN_VALUES, oldValue, this.booleanValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder booleanValues(Boolean... booleanValues) {
            booleanValues(Arrays.asList(booleanValues));
            return this;
        }

        public final Collection<Double> getDoubleValues() {
            if (doubleValues instanceof SdkAutoConstructList) {
                return null;
            }
            return doubleValues;
        }

        public final void setDoubleValues(Collection<Double> doubleValues) {
            Object oldValue = this.doubleValues;
            this.doubleValues = DoubleArrayCopier.copy(doubleValues);
            handleUnionValueChange(Type.DOUBLE_VALUES, oldValue, this.doubleValues);
        }

        @Override
        public final Builder doubleValues(Collection<Double> doubleValues) {
            Object oldValue = this.doubleValues;
            this.doubleValues = DoubleArrayCopier.copy(doubleValues);
            handleUnionValueChange(Type.DOUBLE_VALUES, oldValue, this.doubleValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder doubleValues(Double... doubleValues) {
            doubleValues(Arrays.asList(doubleValues));
            return this;
        }

        public final Collection<Long> getLongValues() {
            if (longValues instanceof SdkAutoConstructList) {
                return null;
            }
            return longValues;
        }

        public final void setLongValues(Collection<Long> longValues) {
            Object oldValue = this.longValues;
            this.longValues = LongArrayCopier.copy(longValues);
            handleUnionValueChange(Type.LONG_VALUES, oldValue, this.longValues);
        }

        @Override
        public final Builder longValues(Collection<Long> longValues) {
            Object oldValue = this.longValues;
            this.longValues = LongArrayCopier.copy(longValues);
            handleUnionValueChange(Type.LONG_VALUES, oldValue, this.longValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder longValues(Long... longValues) {
            longValues(Arrays.asList(longValues));
            return this;
        }

        public final Collection<String> getStringValues() {
            if (stringValues instanceof SdkAutoConstructList) {
                return null;
            }
            return stringValues;
        }

        public final void setStringValues(Collection<String> stringValues) {
            Object oldValue = this.stringValues;
            this.stringValues = StringArrayCopier.copy(stringValues);
            handleUnionValueChange(Type.STRING_VALUES, oldValue, this.stringValues);
        }

        @Override
        public final Builder stringValues(Collection<String> stringValues) {
            Object oldValue = this.stringValues;
            this.stringValues = StringArrayCopier.copy(stringValues);
            handleUnionValueChange(Type.STRING_VALUES, oldValue, this.stringValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringValues(String... stringValues) {
            stringValues(Arrays.asList(stringValues));
            return this;
        }

        @Override
        public ArrayValue build() {
            return new ArrayValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ArrayValue#type()
     */
    public enum Type {
        ARRAY_VALUES,

        BOOLEAN_VALUES,

        DOUBLE_VALUES,

        LONG_VALUES,

        STRING_VALUES,

        UNKNOWN_TO_SDK_VERSION
    }
}
