/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rdsdata.model.ColumnMetadata;
import software.amazon.awssdk.services.rdsdata.model.Field;
import software.amazon.awssdk.services.rdsdata.model.FieldListCopier;
import software.amazon.awssdk.services.rdsdata.model.MetadataCopier;
import software.amazon.awssdk.services.rdsdata.model.RdsDataResponse;
import software.amazon.awssdk.services.rdsdata.model.SqlRecordsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteStatementResponse
extends RdsDataResponse
implements ToCopyableBuilder<Builder, ExecuteStatementResponse> {
    private static final SdkField<List<ColumnMetadata>> COLUMN_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("columnMetadata").getter(ExecuteStatementResponse.getter(ExecuteStatementResponse::columnMetadata)).setter(ExecuteStatementResponse.setter(Builder::columnMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FORMATTED_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("formattedRecords").getter(ExecuteStatementResponse.getter(ExecuteStatementResponse::formattedRecords)).setter(ExecuteStatementResponse.setter(Builder::formattedRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formattedRecords").build()}).build();
    private static final SdkField<List<Field>> GENERATED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("generatedFields").getter(ExecuteStatementResponse.getter(ExecuteStatementResponse::generatedFields)).setter(ExecuteStatementResponse.setter(Builder::generatedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Field::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> NUMBER_OF_RECORDS_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfRecordsUpdated").getter(ExecuteStatementResponse.getter(ExecuteStatementResponse::numberOfRecordsUpdated)).setter(ExecuteStatementResponse.setter(Builder::numberOfRecordsUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecordsUpdated").build()}).build();
    private static final SdkField<List<List<Field>>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("records").getter(ExecuteStatementResponse.getter(ExecuteStatementResponse::records)).setter(ExecuteStatementResponse.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Field::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_METADATA_FIELD, FORMATTED_RECORDS_FIELD, GENERATED_FIELDS_FIELD, NUMBER_OF_RECORDS_UPDATED_FIELD, RECORDS_FIELD));
    private final List<ColumnMetadata> columnMetadata;
    private final String formattedRecords;
    private final List<Field> generatedFields;
    private final Long numberOfRecordsUpdated;
    private final List<List<Field>> records;

    private ExecuteStatementResponse(BuilderImpl builder) {
        super(builder);
        this.columnMetadata = builder.columnMetadata;
        this.formattedRecords = builder.formattedRecords;
        this.generatedFields = builder.generatedFields;
        this.numberOfRecordsUpdated = builder.numberOfRecordsUpdated;
        this.records = builder.records;
    }

    public final boolean hasColumnMetadata() {
        return this.columnMetadata != null && !(this.columnMetadata instanceof SdkAutoConstructList);
    }

    public final List<ColumnMetadata> columnMetadata() {
        return this.columnMetadata;
    }

    public final String formattedRecords() {
        return this.formattedRecords;
    }

    public final boolean hasGeneratedFields() {
        return this.generatedFields != null && !(this.generatedFields instanceof SdkAutoConstructList);
    }

    public final List<Field> generatedFields() {
        return this.generatedFields;
    }

    public final Long numberOfRecordsUpdated() {
        return this.numberOfRecordsUpdated;
    }

    public final boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public final List<List<Field>> records() {
        return this.records;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnMetadata() ? this.columnMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.formattedRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeneratedFields() ? this.generatedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRecordsUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementResponse)) {
            return false;
        }
        ExecuteStatementResponse other = (ExecuteStatementResponse)((Object)obj);
        return this.hasColumnMetadata() == other.hasColumnMetadata() && Objects.equals(this.columnMetadata(), other.columnMetadata()) && Objects.equals(this.formattedRecords(), other.formattedRecords()) && this.hasGeneratedFields() == other.hasGeneratedFields() && Objects.equals(this.generatedFields(), other.generatedFields()) && Objects.equals(this.numberOfRecordsUpdated(), other.numberOfRecordsUpdated()) && this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteStatementResponse").add("ColumnMetadata", this.hasColumnMetadata() ? this.columnMetadata() : null).add("FormattedRecords", (Object)this.formattedRecords()).add("GeneratedFields", this.hasGeneratedFields() ? this.generatedFields() : null).add("NumberOfRecordsUpdated", (Object)this.numberOfRecordsUpdated()).add("Records", this.hasRecords() ? this.records() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "columnMetadata": {
                return Optional.ofNullable(clazz.cast(this.columnMetadata()));
            }
            case "formattedRecords": {
                return Optional.ofNullable(clazz.cast(this.formattedRecords()));
            }
            case "generatedFields": {
                return Optional.ofNullable(clazz.cast(this.generatedFields()));
            }
            case "numberOfRecordsUpdated": {
                return Optional.ofNullable(clazz.cast(this.numberOfRecordsUpdated()));
            }
            case "records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteStatementResponse, T> g) {
        return obj -> g.apply((ExecuteStatementResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsDataResponse.BuilderImpl
    implements Builder {
        private List<ColumnMetadata> columnMetadata = DefaultSdkAutoConstructList.getInstance();
        private String formattedRecords;
        private List<Field> generatedFields = DefaultSdkAutoConstructList.getInstance();
        private Long numberOfRecordsUpdated;
        private List<List<Field>> records = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteStatementResponse model) {
            super(model);
            this.columnMetadata(model.columnMetadata);
            this.formattedRecords(model.formattedRecords);
            this.generatedFields(model.generatedFields);
            this.numberOfRecordsUpdated(model.numberOfRecordsUpdated);
            this.records(model.records);
        }

        public final List<ColumnMetadata.Builder> getColumnMetadata() {
            List<ColumnMetadata.Builder> result = MetadataCopier.copyToBuilder(this.columnMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnMetadata(Collection<ColumnMetadata.BuilderImpl> columnMetadata) {
            this.columnMetadata = MetadataCopier.copyFromBuilder(columnMetadata);
        }

        @Override
        public final Builder columnMetadata(Collection<ColumnMetadata> columnMetadata) {
            this.columnMetadata = MetadataCopier.copy(columnMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(ColumnMetadata ... columnMetadata) {
            this.columnMetadata(Arrays.asList(columnMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(Consumer<ColumnMetadata.Builder> ... columnMetadata) {
            this.columnMetadata(Stream.of(columnMetadata).map(c -> (ColumnMetadata)((ColumnMetadata.Builder)ColumnMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFormattedRecords() {
            return this.formattedRecords;
        }

        public final void setFormattedRecords(String formattedRecords) {
            this.formattedRecords = formattedRecords;
        }

        @Override
        public final Builder formattedRecords(String formattedRecords) {
            this.formattedRecords = formattedRecords;
            return this;
        }

        public final List<Field.Builder> getGeneratedFields() {
            List<Field.Builder> result = FieldListCopier.copyToBuilder(this.generatedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeneratedFields(Collection<Field.BuilderImpl> generatedFields) {
            this.generatedFields = FieldListCopier.copyFromBuilder(generatedFields);
        }

        @Override
        public final Builder generatedFields(Collection<Field> generatedFields) {
            this.generatedFields = FieldListCopier.copy(generatedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedFields(Field ... generatedFields) {
            this.generatedFields(Arrays.asList(generatedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedFields(Consumer<Field.Builder> ... generatedFields) {
            this.generatedFields(Stream.of(generatedFields).map(c -> (Field)((Field.Builder)Field.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getNumberOfRecordsUpdated() {
            return this.numberOfRecordsUpdated;
        }

        public final void setNumberOfRecordsUpdated(Long numberOfRecordsUpdated) {
            this.numberOfRecordsUpdated = numberOfRecordsUpdated;
        }

        @Override
        public final Builder numberOfRecordsUpdated(Long numberOfRecordsUpdated) {
            this.numberOfRecordsUpdated = numberOfRecordsUpdated;
            return this;
        }

        public final List<List<Field.Builder>> getRecords() {
            List<List<Field.Builder>> result = SqlRecordsCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<? extends Collection<Field.BuilderImpl>> records) {
            this.records = SqlRecordsCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<? extends Collection<Field>> records) {
            this.records = SqlRecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Collection<Field> ... records) {
            this.records((Collection<? extends Collection<Field>>)Arrays.asList(records));
            return this;
        }

        @Override
        public ExecuteStatementResponse build() {
            return new ExecuteStatementResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteStatementResponse> {
        public Builder columnMetadata(Collection<ColumnMetadata> var1);

        public Builder columnMetadata(ColumnMetadata ... var1);

        public Builder columnMetadata(Consumer<ColumnMetadata.Builder> ... var1);

        public Builder formattedRecords(String var1);

        public Builder generatedFields(Collection<Field> var1);

        public Builder generatedFields(Field ... var1);

        public Builder generatedFields(Consumer<Field.Builder> ... var1);

        public Builder numberOfRecordsUpdated(Long var1);

        public Builder records(Collection<? extends Collection<Field>> var1);

        public Builder records(Collection<Field> ... var1);
    }
}

