/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A parameter used in a SQL statement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SqlParameter implements SdkPojo, Serializable, ToCopyableBuilder<SqlParameter.Builder, SqlParameter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SqlParameter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Field> VALUE_FIELD = SdkField.<Field> builder(MarshallingType.SDK_POJO).memberName("value")
            .getter(getter(SqlParameter::value)).setter(setter(Builder::value)).constructor(Field::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> TYPE_HINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeHint").getter(getter(SqlParameter::typeHintAsString)).setter(setter(Builder::typeHint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeHint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD,
            TYPE_HINT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Field value;

    private final String typeHint;

    private SqlParameter(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.typeHint = builder.typeHint;
    }

    /**
     * <p>
     * The name of the parameter.
     * </p>
     * 
     * @return The name of the parameter.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The value of the parameter.
     * </p>
     * 
     * @return The value of the parameter.
     */
    public final Field value() {
        return value;
    }

    /**
     * <p>
     * A hint that specifies the correct object type for data type mapping. Possible values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DATE</code> - The corresponding <code>String</code> parameter value is sent as an object of
     * <code>DATE</code> type to the database. The accepted format is <code>YYYY-MM-DD</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DECIMAL</code> - The corresponding <code>String</code> parameter value is sent as an object of
     * <code>DECIMAL</code> type to the database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JSON</code> - The corresponding <code>String</code> parameter value is sent as an object of
     * <code>JSON</code> type to the database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TIME</code> - The corresponding <code>String</code> parameter value is sent as an object of
     * <code>TIME</code> type to the database. The accepted format is <code>HH:MM:SS[.FFF]</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TIMESTAMP</code> - The corresponding <code>String</code> parameter value is sent as an object of
     * <code>TIMESTAMP</code> type to the database. The accepted format is <code>YYYY-MM-DD HH:MM:SS[.FFF]</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UUID</code> - The corresponding <code>String</code> parameter value is sent as an object of
     * <code>UUID</code> type to the database.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #typeHint} will
     * return {@link TypeHint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeHintAsString}.
     * </p>
     * 
     * @return A hint that specifies the correct object type for data type mapping. Possible values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DATE</code> - The corresponding <code>String</code> parameter value is sent as an object of
     *         <code>DATE</code> type to the database. The accepted format is <code>YYYY-MM-DD</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DECIMAL</code> - The corresponding <code>String</code> parameter value is sent as an object of
     *         <code>DECIMAL</code> type to the database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JSON</code> - The corresponding <code>String</code> parameter value is sent as an object of
     *         <code>JSON</code> type to the database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TIME</code> - The corresponding <code>String</code> parameter value is sent as an object of
     *         <code>TIME</code> type to the database. The accepted format is <code>HH:MM:SS[.FFF]</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TIMESTAMP</code> - The corresponding <code>String</code> parameter value is sent as an object of
     *         <code>TIMESTAMP</code> type to the database. The accepted format is
     *         <code>YYYY-MM-DD HH:MM:SS[.FFF]</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UUID</code> - The corresponding <code>String</code> parameter value is sent as an object of
     *         <code>UUID</code> type to the database.
     *         </p>
     *         </li>
     * @see TypeHint
     */
    public final TypeHint typeHint() {
        return TypeHint.fromValue(typeHint);
    }

    /**
     * <p>
     * A hint that specifies the correct object type for data type mapping. Possible values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DATE</code> - The corresponding <code>String</code> parameter value is sent as an object of
     * <code>DATE</code> type to the database. The accepted format is <code>YYYY-MM-DD</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DECIMAL</code> - The corresponding <code>String</code> parameter value is sent as an object of
     * <code>DECIMAL</code> type to the database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JSON</code> - The corresponding <code>String</code> parameter value is sent as an object of
     * <code>JSON</code> type to the database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TIME</code> - The corresponding <code>String</code> parameter value is sent as an object of
     * <code>TIME</code> type to the database. The accepted format is <code>HH:MM:SS[.FFF]</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TIMESTAMP</code> - The corresponding <code>String</code> parameter value is sent as an object of
     * <code>TIMESTAMP</code> type to the database. The accepted format is <code>YYYY-MM-DD HH:MM:SS[.FFF]</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UUID</code> - The corresponding <code>String</code> parameter value is sent as an object of
     * <code>UUID</code> type to the database.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #typeHint} will
     * return {@link TypeHint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeHintAsString}.
     * </p>
     * 
     * @return A hint that specifies the correct object type for data type mapping. Possible values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DATE</code> - The corresponding <code>String</code> parameter value is sent as an object of
     *         <code>DATE</code> type to the database. The accepted format is <code>YYYY-MM-DD</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DECIMAL</code> - The corresponding <code>String</code> parameter value is sent as an object of
     *         <code>DECIMAL</code> type to the database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JSON</code> - The corresponding <code>String</code> parameter value is sent as an object of
     *         <code>JSON</code> type to the database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TIME</code> - The corresponding <code>String</code> parameter value is sent as an object of
     *         <code>TIME</code> type to the database. The accepted format is <code>HH:MM:SS[.FFF]</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TIMESTAMP</code> - The corresponding <code>String</code> parameter value is sent as an object of
     *         <code>TIMESTAMP</code> type to the database. The accepted format is
     *         <code>YYYY-MM-DD HH:MM:SS[.FFF]</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UUID</code> - The corresponding <code>String</code> parameter value is sent as an object of
     *         <code>UUID</code> type to the database.
     *         </p>
     *         </li>
     * @see TypeHint
     */
    public final String typeHintAsString() {
        return typeHint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(typeHintAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlParameter)) {
            return false;
        }
        SqlParameter other = (SqlParameter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value())
                && Objects.equals(typeHintAsString(), other.typeHintAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SqlParameter").add("Name", name()).add("Value", value()).add("TypeHint", typeHintAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "typeHint":
            return Optional.ofNullable(clazz.cast(typeHintAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlParameter, T> g) {
        return obj -> g.apply((SqlParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SqlParameter> {
        /**
         * <p>
         * The name of the parameter.
         * </p>
         * 
         * @param name
         *        The name of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value of the parameter.
         * </p>
         * 
         * @param value
         *        The value of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Field value);

        /**
         * <p>
         * The value of the parameter.
         * </p>
         * This is a convenience method that creates an instance of the {@link Field.Builder} avoiding the need to
         * create one manually via {@link Field#builder()}.
         *
         * When the {@link Consumer} completes, {@link Field.Builder#build()} is called immediately and its result is
         * passed to {@link #value(Field)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link Field.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(Field)
         */
        default Builder value(Consumer<Field.Builder> value) {
            return value(Field.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * A hint that specifies the correct object type for data type mapping. Possible values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DATE</code> - The corresponding <code>String</code> parameter value is sent as an object of
         * <code>DATE</code> type to the database. The accepted format is <code>YYYY-MM-DD</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DECIMAL</code> - The corresponding <code>String</code> parameter value is sent as an object of
         * <code>DECIMAL</code> type to the database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JSON</code> - The corresponding <code>String</code> parameter value is sent as an object of
         * <code>JSON</code> type to the database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TIME</code> - The corresponding <code>String</code> parameter value is sent as an object of
         * <code>TIME</code> type to the database. The accepted format is <code>HH:MM:SS[.FFF]</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TIMESTAMP</code> - The corresponding <code>String</code> parameter value is sent as an object of
         * <code>TIMESTAMP</code> type to the database. The accepted format is <code>YYYY-MM-DD HH:MM:SS[.FFF]</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UUID</code> - The corresponding <code>String</code> parameter value is sent as an object of
         * <code>UUID</code> type to the database.
         * </p>
         * </li>
         * </ul>
         * 
         * @param typeHint
         *        A hint that specifies the correct object type for data type mapping. Possible values are as
         *        follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DATE</code> - The corresponding <code>String</code> parameter value is sent as an object of
         *        <code>DATE</code> type to the database. The accepted format is <code>YYYY-MM-DD</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DECIMAL</code> - The corresponding <code>String</code> parameter value is sent as an object of
         *        <code>DECIMAL</code> type to the database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JSON</code> - The corresponding <code>String</code> parameter value is sent as an object of
         *        <code>JSON</code> type to the database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TIME</code> - The corresponding <code>String</code> parameter value is sent as an object of
         *        <code>TIME</code> type to the database. The accepted format is <code>HH:MM:SS[.FFF]</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TIMESTAMP</code> - The corresponding <code>String</code> parameter value is sent as an object of
         *        <code>TIMESTAMP</code> type to the database. The accepted format is
         *        <code>YYYY-MM-DD HH:MM:SS[.FFF]</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UUID</code> - The corresponding <code>String</code> parameter value is sent as an object of
         *        <code>UUID</code> type to the database.
         *        </p>
         *        </li>
         * @see TypeHint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TypeHint
         */
        Builder typeHint(String typeHint);

        /**
         * <p>
         * A hint that specifies the correct object type for data type mapping. Possible values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DATE</code> - The corresponding <code>String</code> parameter value is sent as an object of
         * <code>DATE</code> type to the database. The accepted format is <code>YYYY-MM-DD</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DECIMAL</code> - The corresponding <code>String</code> parameter value is sent as an object of
         * <code>DECIMAL</code> type to the database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JSON</code> - The corresponding <code>String</code> parameter value is sent as an object of
         * <code>JSON</code> type to the database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TIME</code> - The corresponding <code>String</code> parameter value is sent as an object of
         * <code>TIME</code> type to the database. The accepted format is <code>HH:MM:SS[.FFF]</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TIMESTAMP</code> - The corresponding <code>String</code> parameter value is sent as an object of
         * <code>TIMESTAMP</code> type to the database. The accepted format is <code>YYYY-MM-DD HH:MM:SS[.FFF]</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UUID</code> - The corresponding <code>String</code> parameter value is sent as an object of
         * <code>UUID</code> type to the database.
         * </p>
         * </li>
         * </ul>
         * 
         * @param typeHint
         *        A hint that specifies the correct object type for data type mapping. Possible values are as
         *        follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DATE</code> - The corresponding <code>String</code> parameter value is sent as an object of
         *        <code>DATE</code> type to the database. The accepted format is <code>YYYY-MM-DD</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DECIMAL</code> - The corresponding <code>String</code> parameter value is sent as an object of
         *        <code>DECIMAL</code> type to the database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JSON</code> - The corresponding <code>String</code> parameter value is sent as an object of
         *        <code>JSON</code> type to the database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TIME</code> - The corresponding <code>String</code> parameter value is sent as an object of
         *        <code>TIME</code> type to the database. The accepted format is <code>HH:MM:SS[.FFF]</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TIMESTAMP</code> - The corresponding <code>String</code> parameter value is sent as an object of
         *        <code>TIMESTAMP</code> type to the database. The accepted format is
         *        <code>YYYY-MM-DD HH:MM:SS[.FFF]</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UUID</code> - The corresponding <code>String</code> parameter value is sent as an object of
         *        <code>UUID</code> type to the database.
         *        </p>
         *        </li>
         * @see TypeHint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TypeHint
         */
        Builder typeHint(TypeHint typeHint);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Field value;

        private String typeHint;

        private BuilderImpl() {
        }

        private BuilderImpl(SqlParameter model) {
            name(model.name);
            value(model.value);
            typeHint(model.typeHint);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Field.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(Field.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(Field value) {
            this.value = value;
            return this;
        }

        public final String getTypeHint() {
            return typeHint;
        }

        public final void setTypeHint(String typeHint) {
            this.typeHint = typeHint;
        }

        @Override
        public final Builder typeHint(String typeHint) {
            this.typeHint = typeHint;
            return this;
        }

        @Override
        public final Builder typeHint(TypeHint typeHint) {
            this.typeHint(typeHint == null ? null : typeHint.toString());
            return this;
        }

        @Override
        public SqlParameter build() {
            return new SqlParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
