/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rdsdata.model.RdsDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteSqlRequest
extends RdsDataRequest
implements ToCopyableBuilder<Builder, ExecuteSqlRequest> {
    private static final SdkField<String> DB_CLUSTER_OR_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbClusterOrInstanceArn").getter(ExecuteSqlRequest.getter(ExecuteSqlRequest::dbClusterOrInstanceArn)).setter(ExecuteSqlRequest.setter(Builder::dbClusterOrInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbClusterOrInstanceArn").build()}).build();
    private static final SdkField<String> AWS_SECRET_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsSecretStoreArn").getter(ExecuteSqlRequest.getter(ExecuteSqlRequest::awsSecretStoreArn)).setter(ExecuteSqlRequest.setter(Builder::awsSecretStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsSecretStoreArn").build()}).build();
    private static final SdkField<String> SQL_STATEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sqlStatements").getter(ExecuteSqlRequest.getter(ExecuteSqlRequest::sqlStatements)).setter(ExecuteSqlRequest.setter(Builder::sqlStatements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlStatements").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("database").getter(ExecuteSqlRequest.getter(ExecuteSqlRequest::database)).setter(ExecuteSqlRequest.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("database").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schema").getter(ExecuteSqlRequest.getter(ExecuteSqlRequest::schema)).setter(ExecuteSqlRequest.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_OR_INSTANCE_ARN_FIELD, AWS_SECRET_STORE_ARN_FIELD, SQL_STATEMENTS_FIELD, DATABASE_FIELD, SCHEMA_FIELD));
    private final String dbClusterOrInstanceArn;
    private final String awsSecretStoreArn;
    private final String sqlStatements;
    private final String database;
    private final String schema;

    private ExecuteSqlRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterOrInstanceArn = builder.dbClusterOrInstanceArn;
        this.awsSecretStoreArn = builder.awsSecretStoreArn;
        this.sqlStatements = builder.sqlStatements;
        this.database = builder.database;
        this.schema = builder.schema;
    }

    public final String dbClusterOrInstanceArn() {
        return this.dbClusterOrInstanceArn;
    }

    public final String awsSecretStoreArn() {
        return this.awsSecretStoreArn;
    }

    public final String sqlStatements() {
        return this.sqlStatements;
    }

    public final String database() {
        return this.database;
    }

    public final String schema() {
        return this.schema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterOrInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsSecretStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlStatements());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteSqlRequest)) {
            return false;
        }
        ExecuteSqlRequest other = (ExecuteSqlRequest)((Object)obj);
        return Objects.equals(this.dbClusterOrInstanceArn(), other.dbClusterOrInstanceArn()) && Objects.equals(this.awsSecretStoreArn(), other.awsSecretStoreArn()) && Objects.equals(this.sqlStatements(), other.sqlStatements()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.schema(), other.schema());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteSqlRequest").add("DbClusterOrInstanceArn", (Object)this.dbClusterOrInstanceArn()).add("AwsSecretStoreArn", (Object)this.awsSecretStoreArn()).add("SqlStatements", (Object)this.sqlStatements()).add("Database", (Object)this.database()).add("Schema", (Object)this.schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dbClusterOrInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.dbClusterOrInstanceArn()));
            }
            case "awsSecretStoreArn": {
                return Optional.ofNullable(clazz.cast(this.awsSecretStoreArn()));
            }
            case "sqlStatements": {
                return Optional.ofNullable(clazz.cast(this.sqlStatements()));
            }
            case "database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteSqlRequest, T> g) {
        return obj -> g.apply((ExecuteSqlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsDataRequest.BuilderImpl
    implements Builder {
        private String dbClusterOrInstanceArn;
        private String awsSecretStoreArn;
        private String sqlStatements;
        private String database;
        private String schema;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteSqlRequest model) {
            super(model);
            this.dbClusterOrInstanceArn(model.dbClusterOrInstanceArn);
            this.awsSecretStoreArn(model.awsSecretStoreArn);
            this.sqlStatements(model.sqlStatements);
            this.database(model.database);
            this.schema(model.schema);
        }

        public final String getDbClusterOrInstanceArn() {
            return this.dbClusterOrInstanceArn;
        }

        public final void setDbClusterOrInstanceArn(String dbClusterOrInstanceArn) {
            this.dbClusterOrInstanceArn = dbClusterOrInstanceArn;
        }

        @Override
        public final Builder dbClusterOrInstanceArn(String dbClusterOrInstanceArn) {
            this.dbClusterOrInstanceArn = dbClusterOrInstanceArn;
            return this;
        }

        public final String getAwsSecretStoreArn() {
            return this.awsSecretStoreArn;
        }

        public final void setAwsSecretStoreArn(String awsSecretStoreArn) {
            this.awsSecretStoreArn = awsSecretStoreArn;
        }

        @Override
        public final Builder awsSecretStoreArn(String awsSecretStoreArn) {
            this.awsSecretStoreArn = awsSecretStoreArn;
            return this;
        }

        public final String getSqlStatements() {
            return this.sqlStatements;
        }

        public final void setSqlStatements(String sqlStatements) {
            this.sqlStatements = sqlStatements;
        }

        @Override
        public final Builder sqlStatements(String sqlStatements) {
            this.sqlStatements = sqlStatements;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteSqlRequest build() {
            return new ExecuteSqlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteSqlRequest> {
        public Builder dbClusterOrInstanceArn(String var1);

        public Builder awsSecretStoreArn(String var1);

        public Builder sqlStatements(String var1);

        public Builder database(String var1);

        public Builder schema(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

