/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.rdsdata.model.AccessDeniedException;
import software.amazon.awssdk.services.rdsdata.model.BadRequestException;
import software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementRequest;
import software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.rdsdata.model.BeginTransactionRequest;
import software.amazon.awssdk.services.rdsdata.model.BeginTransactionResponse;
import software.amazon.awssdk.services.rdsdata.model.CommitTransactionRequest;
import software.amazon.awssdk.services.rdsdata.model.CommitTransactionResponse;
import software.amazon.awssdk.services.rdsdata.model.ExecuteSqlRequest;
import software.amazon.awssdk.services.rdsdata.model.ExecuteSqlResponse;
import software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.rdsdata.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.rdsdata.model.ForbiddenException;
import software.amazon.awssdk.services.rdsdata.model.InternalServerErrorException;
import software.amazon.awssdk.services.rdsdata.model.NotFoundException;
import software.amazon.awssdk.services.rdsdata.model.RdsDataException;
import software.amazon.awssdk.services.rdsdata.model.RollbackTransactionRequest;
import software.amazon.awssdk.services.rdsdata.model.RollbackTransactionResponse;
import software.amazon.awssdk.services.rdsdata.model.ServiceUnavailableErrorException;
import software.amazon.awssdk.services.rdsdata.model.StatementTimeoutException;

/**
 * Service client for accessing AWS RDS DataService. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * <fullname>Amazon RDS Data Service</fullname>
 * <p>
 * Amazon RDS provides an HTTP endpoint to run SQL statements on an Amazon Aurora Serverless v1 DB cluster. To run these
 * statements, you work with the Data Service API.
 * </p>
 * <note>
 * <p>
 * The Data Service API isn't supported on Amazon Aurora Serverless v2 DB clusters.
 * </p>
 * </note>
 * <p>
 * For more information about the Data Service API, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API</a> in the
 * <i>Amazon Aurora User Guide</i>.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface RdsDataClient extends AwsClient {
    String SERVICE_NAME = "rds-data";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "rds-data";

    /**
     * <p>
     * Runs a batch SQL statement over an array of data.
     * </p>
     * <p>
     * You can run bulk update and insert operations for multiple records using a DML statement with different parameter
     * sets. Bulk operations can provide a significant performance improvement over individual insert and update
     * operations.
     * </p>
     * <note>
     * <p>
     * If a call isn't part of a transaction because it doesn't include the <code>transactionID</code> parameter,
     * changes that result from the call are committed automatically.
     * </p>
     * <p>
     * There isn't a fixed upper limit on the number of parameter sets. However, the maximum size of the HTTP request
     * submitted through the Data API is 4 MiB. If the request exceeds this limit, the Data API returns an error and
     * doesn't process the request. This 4-MiB limit includes the size of the HTTP headers and the JSON notation in the
     * request. Thus, the number of parameter sets that you can include depends on a combination of factors, such as the
     * size of the SQL statement and the size of each parameter set.
     * </p>
     * <p>
     * The response size limit is 1 MiB. If the call returns more than 1 MiB of response data, the call is terminated.
     * </p>
     * </note>
     *
     * @param batchExecuteStatementRequest
     *        The request parameters represent the input of a SQL statement over an array of data.
     * @return Result of the BatchExecuteStatement operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws BadRequestException
     *         There is an error in the call or in a SQL statement.
     * @throws StatementTimeoutException
     *         The execution of the SQL statement timed out.
     * @throws InternalServerErrorException
     *         An internal error occurred.
     * @throws ForbiddenException
     *         There are insufficient privileges to make the call.
     * @throws ServiceUnavailableErrorException
     *         The service specified by the <code>resourceArn</code> parameter is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsDataClient.BatchExecuteStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/BatchExecuteStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchExecuteStatementResponse batchExecuteStatement(BatchExecuteStatementRequest batchExecuteStatementRequest)
            throws AccessDeniedException, BadRequestException, StatementTimeoutException, InternalServerErrorException,
            ForbiddenException, ServiceUnavailableErrorException, AwsServiceException, SdkClientException, RdsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs a batch SQL statement over an array of data.
     * </p>
     * <p>
     * You can run bulk update and insert operations for multiple records using a DML statement with different parameter
     * sets. Bulk operations can provide a significant performance improvement over individual insert and update
     * operations.
     * </p>
     * <note>
     * <p>
     * If a call isn't part of a transaction because it doesn't include the <code>transactionID</code> parameter,
     * changes that result from the call are committed automatically.
     * </p>
     * <p>
     * There isn't a fixed upper limit on the number of parameter sets. However, the maximum size of the HTTP request
     * submitted through the Data API is 4 MiB. If the request exceeds this limit, the Data API returns an error and
     * doesn't process the request. This 4-MiB limit includes the size of the HTTP headers and the JSON notation in the
     * request. Thus, the number of parameter sets that you can include depends on a combination of factors, such as the
     * size of the SQL statement and the size of each parameter set.
     * </p>
     * <p>
     * The response size limit is 1 MiB. If the call returns more than 1 MiB of response data, the call is terminated.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchExecuteStatementRequest.Builder} avoiding the
     * need to create one manually via {@link BatchExecuteStatementRequest#builder()}
     * </p>
     *
     * @param batchExecuteStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementRequest.Builder} to create a
     *        request. The request parameters represent the input of a SQL statement over an array of data.
     * @return Result of the BatchExecuteStatement operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws BadRequestException
     *         There is an error in the call or in a SQL statement.
     * @throws StatementTimeoutException
     *         The execution of the SQL statement timed out.
     * @throws InternalServerErrorException
     *         An internal error occurred.
     * @throws ForbiddenException
     *         There are insufficient privileges to make the call.
     * @throws ServiceUnavailableErrorException
     *         The service specified by the <code>resourceArn</code> parameter is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsDataClient.BatchExecuteStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/BatchExecuteStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchExecuteStatementResponse batchExecuteStatement(
            Consumer<BatchExecuteStatementRequest.Builder> batchExecuteStatementRequest) throws AccessDeniedException,
            BadRequestException, StatementTimeoutException, InternalServerErrorException, ForbiddenException,
            ServiceUnavailableErrorException, AwsServiceException, SdkClientException, RdsDataException {
        return batchExecuteStatement(BatchExecuteStatementRequest.builder().applyMutation(batchExecuteStatementRequest).build());
    }

    /**
     * <p>
     * Starts a SQL transaction.
     * </p>
     * <note>
     * <p>
     * A transaction can run for a maximum of 24 hours. A transaction is terminated and rolled back automatically after
     * 24 hours.
     * </p>
     * <p>
     * A transaction times out if no calls use its transaction ID in three minutes. If a transaction times out before
     * it's committed, it's rolled back automatically.
     * </p>
     * <p>
     * DDL statements inside a transaction cause an implicit commit. We recommend that you run each DDL statement in a
     * separate <code>ExecuteStatement</code> call with <code>continueAfterTimeout</code> enabled.
     * </p>
     * </note>
     *
     * @param beginTransactionRequest
     *        The request parameters represent the input of a request to start a SQL transaction.
     * @return Result of the BeginTransaction operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws BadRequestException
     *         There is an error in the call or in a SQL statement.
     * @throws StatementTimeoutException
     *         The execution of the SQL statement timed out.
     * @throws InternalServerErrorException
     *         An internal error occurred.
     * @throws ForbiddenException
     *         There are insufficient privileges to make the call.
     * @throws ServiceUnavailableErrorException
     *         The service specified by the <code>resourceArn</code> parameter is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsDataClient.BeginTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/BeginTransaction" target="_top">AWS API
     *      Documentation</a>
     */
    default BeginTransactionResponse beginTransaction(BeginTransactionRequest beginTransactionRequest)
            throws AccessDeniedException, BadRequestException, StatementTimeoutException, InternalServerErrorException,
            ForbiddenException, ServiceUnavailableErrorException, AwsServiceException, SdkClientException, RdsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a SQL transaction.
     * </p>
     * <note>
     * <p>
     * A transaction can run for a maximum of 24 hours. A transaction is terminated and rolled back automatically after
     * 24 hours.
     * </p>
     * <p>
     * A transaction times out if no calls use its transaction ID in three minutes. If a transaction times out before
     * it's committed, it's rolled back automatically.
     * </p>
     * <p>
     * DDL statements inside a transaction cause an implicit commit. We recommend that you run each DDL statement in a
     * separate <code>ExecuteStatement</code> call with <code>continueAfterTimeout</code> enabled.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BeginTransactionRequest.Builder} avoiding the need
     * to create one manually via {@link BeginTransactionRequest#builder()}
     * </p>
     *
     * @param beginTransactionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rdsdata.model.BeginTransactionRequest.Builder} to create a request.
     *        The request parameters represent the input of a request to start a SQL transaction.
     * @return Result of the BeginTransaction operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws BadRequestException
     *         There is an error in the call or in a SQL statement.
     * @throws StatementTimeoutException
     *         The execution of the SQL statement timed out.
     * @throws InternalServerErrorException
     *         An internal error occurred.
     * @throws ForbiddenException
     *         There are insufficient privileges to make the call.
     * @throws ServiceUnavailableErrorException
     *         The service specified by the <code>resourceArn</code> parameter is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsDataClient.BeginTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/BeginTransaction" target="_top">AWS API
     *      Documentation</a>
     */
    default BeginTransactionResponse beginTransaction(Consumer<BeginTransactionRequest.Builder> beginTransactionRequest)
            throws AccessDeniedException, BadRequestException, StatementTimeoutException, InternalServerErrorException,
            ForbiddenException, ServiceUnavailableErrorException, AwsServiceException, SdkClientException, RdsDataException {
        return beginTransaction(BeginTransactionRequest.builder().applyMutation(beginTransactionRequest).build());
    }

    /**
     * <p>
     * Ends a SQL transaction started with the <code>BeginTransaction</code> operation and commits the changes.
     * </p>
     *
     * @param commitTransactionRequest
     *        The request parameters represent the input of a commit transaction request.
     * @return Result of the CommitTransaction operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws BadRequestException
     *         There is an error in the call or in a SQL statement.
     * @throws StatementTimeoutException
     *         The execution of the SQL statement timed out.
     * @throws InternalServerErrorException
     *         An internal error occurred.
     * @throws ForbiddenException
     *         There are insufficient privileges to make the call.
     * @throws ServiceUnavailableErrorException
     *         The service specified by the <code>resourceArn</code> parameter is not available.
     * @throws NotFoundException
     *         The <code>resourceArn</code>, <code>secretArn</code>, or <code>transactionId</code> value can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsDataClient.CommitTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/CommitTransaction" target="_top">AWS
     *      API Documentation</a>
     */
    default CommitTransactionResponse commitTransaction(CommitTransactionRequest commitTransactionRequest)
            throws AccessDeniedException, BadRequestException, StatementTimeoutException, InternalServerErrorException,
            ForbiddenException, ServiceUnavailableErrorException, NotFoundException, AwsServiceException, SdkClientException,
            RdsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Ends a SQL transaction started with the <code>BeginTransaction</code> operation and commits the changes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CommitTransactionRequest.Builder} avoiding the need
     * to create one manually via {@link CommitTransactionRequest#builder()}
     * </p>
     *
     * @param commitTransactionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rdsdata.model.CommitTransactionRequest.Builder} to create a
     *        request. The request parameters represent the input of a commit transaction request.
     * @return Result of the CommitTransaction operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws BadRequestException
     *         There is an error in the call or in a SQL statement.
     * @throws StatementTimeoutException
     *         The execution of the SQL statement timed out.
     * @throws InternalServerErrorException
     *         An internal error occurred.
     * @throws ForbiddenException
     *         There are insufficient privileges to make the call.
     * @throws ServiceUnavailableErrorException
     *         The service specified by the <code>resourceArn</code> parameter is not available.
     * @throws NotFoundException
     *         The <code>resourceArn</code>, <code>secretArn</code>, or <code>transactionId</code> value can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsDataClient.CommitTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/CommitTransaction" target="_top">AWS
     *      API Documentation</a>
     */
    default CommitTransactionResponse commitTransaction(Consumer<CommitTransactionRequest.Builder> commitTransactionRequest)
            throws AccessDeniedException, BadRequestException, StatementTimeoutException, InternalServerErrorException,
            ForbiddenException, ServiceUnavailableErrorException, NotFoundException, AwsServiceException, SdkClientException,
            RdsDataException {
        return commitTransaction(CommitTransactionRequest.builder().applyMutation(commitTransactionRequest).build());
    }

    /**
     * <p>
     * Runs one or more SQL statements.
     * </p>
     * <note>
     * <p>
     * This operation is deprecated. Use the <code>BatchExecuteStatement</code> or <code>ExecuteStatement</code>
     * operation.
     * </p>
     * </note>
     *
     * @param executeSqlRequest
     *        The request parameters represent the input of a request to run one or more SQL statements.
     * @return Result of the ExecuteSql operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws BadRequestException
     *         There is an error in the call or in a SQL statement.
     * @throws InternalServerErrorException
     *         An internal error occurred.
     * @throws ForbiddenException
     *         There are insufficient privileges to make the call.
     * @throws ServiceUnavailableErrorException
     *         The service specified by the <code>resourceArn</code> parameter is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsDataClient.ExecuteSql
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/ExecuteSql" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated The ExecuteSql API is deprecated, please use the ExecuteStatement API.
     */
    @Deprecated
    default ExecuteSqlResponse executeSql(ExecuteSqlRequest executeSqlRequest) throws AccessDeniedException, BadRequestException,
            InternalServerErrorException, ForbiddenException, ServiceUnavailableErrorException, AwsServiceException,
            SdkClientException, RdsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs one or more SQL statements.
     * </p>
     * <note>
     * <p>
     * This operation is deprecated. Use the <code>BatchExecuteStatement</code> or <code>ExecuteStatement</code>
     * operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteSqlRequest.Builder} avoiding the need to
     * create one manually via {@link ExecuteSqlRequest#builder()}
     * </p>
     *
     * @param executeSqlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rdsdata.model.ExecuteSqlRequest.Builder} to create a request. The
     *        request parameters represent the input of a request to run one or more SQL statements.
     * @return Result of the ExecuteSql operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws BadRequestException
     *         There is an error in the call or in a SQL statement.
     * @throws InternalServerErrorException
     *         An internal error occurred.
     * @throws ForbiddenException
     *         There are insufficient privileges to make the call.
     * @throws ServiceUnavailableErrorException
     *         The service specified by the <code>resourceArn</code> parameter is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsDataClient.ExecuteSql
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/ExecuteSql" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated The ExecuteSql API is deprecated, please use the ExecuteStatement API.
     */
    @Deprecated
    default ExecuteSqlResponse executeSql(Consumer<ExecuteSqlRequest.Builder> executeSqlRequest) throws AccessDeniedException,
            BadRequestException, InternalServerErrorException, ForbiddenException, ServiceUnavailableErrorException,
            AwsServiceException, SdkClientException, RdsDataException {
        return executeSql(ExecuteSqlRequest.builder().applyMutation(executeSqlRequest).build());
    }

    /**
     * <p>
     * Runs a SQL statement against a database.
     * </p>
     * <note>
     * <p>
     * If a call isn't part of a transaction because it doesn't include the <code>transactionID</code> parameter,
     * changes that result from the call are committed automatically.
     * </p>
     * <p>
     * If the binary response data from the database is more than 1 MB, the call is terminated.
     * </p>
     * </note>
     *
     * @param executeStatementRequest
     *        The request parameters represent the input of a request to run a SQL statement against a database.
     * @return Result of the ExecuteStatement operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws BadRequestException
     *         There is an error in the call or in a SQL statement.
     * @throws StatementTimeoutException
     *         The execution of the SQL statement timed out.
     * @throws InternalServerErrorException
     *         An internal error occurred.
     * @throws ForbiddenException
     *         There are insufficient privileges to make the call.
     * @throws ServiceUnavailableErrorException
     *         The service specified by the <code>resourceArn</code> parameter is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsDataClient.ExecuteStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/ExecuteStatement" target="_top">AWS API
     *      Documentation</a>
     */
    default ExecuteStatementResponse executeStatement(ExecuteStatementRequest executeStatementRequest)
            throws AccessDeniedException, BadRequestException, StatementTimeoutException, InternalServerErrorException,
            ForbiddenException, ServiceUnavailableErrorException, AwsServiceException, SdkClientException, RdsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs a SQL statement against a database.
     * </p>
     * <note>
     * <p>
     * If a call isn't part of a transaction because it doesn't include the <code>transactionID</code> parameter,
     * changes that result from the call are committed automatically.
     * </p>
     * <p>
     * If the binary response data from the database is more than 1 MB, the call is terminated.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteStatementRequest.Builder} avoiding the need
     * to create one manually via {@link ExecuteStatementRequest#builder()}
     * </p>
     *
     * @param executeStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest.Builder} to create a request.
     *        The request parameters represent the input of a request to run a SQL statement against a database.
     * @return Result of the ExecuteStatement operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws BadRequestException
     *         There is an error in the call or in a SQL statement.
     * @throws StatementTimeoutException
     *         The execution of the SQL statement timed out.
     * @throws InternalServerErrorException
     *         An internal error occurred.
     * @throws ForbiddenException
     *         There are insufficient privileges to make the call.
     * @throws ServiceUnavailableErrorException
     *         The service specified by the <code>resourceArn</code> parameter is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsDataClient.ExecuteStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/ExecuteStatement" target="_top">AWS API
     *      Documentation</a>
     */
    default ExecuteStatementResponse executeStatement(Consumer<ExecuteStatementRequest.Builder> executeStatementRequest)
            throws AccessDeniedException, BadRequestException, StatementTimeoutException, InternalServerErrorException,
            ForbiddenException, ServiceUnavailableErrorException, AwsServiceException, SdkClientException, RdsDataException {
        return executeStatement(ExecuteStatementRequest.builder().applyMutation(executeStatementRequest).build());
    }

    /**
     * <p>
     * Performs a rollback of a transaction. Rolling back a transaction cancels its changes.
     * </p>
     *
     * @param rollbackTransactionRequest
     *        The request parameters represent the input of a request to perform a rollback of a transaction.
     * @return Result of the RollbackTransaction operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws BadRequestException
     *         There is an error in the call or in a SQL statement.
     * @throws StatementTimeoutException
     *         The execution of the SQL statement timed out.
     * @throws InternalServerErrorException
     *         An internal error occurred.
     * @throws ForbiddenException
     *         There are insufficient privileges to make the call.
     * @throws ServiceUnavailableErrorException
     *         The service specified by the <code>resourceArn</code> parameter is not available.
     * @throws NotFoundException
     *         The <code>resourceArn</code>, <code>secretArn</code>, or <code>transactionId</code> value can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsDataClient.RollbackTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/RollbackTransaction" target="_top">AWS
     *      API Documentation</a>
     */
    default RollbackTransactionResponse rollbackTransaction(RollbackTransactionRequest rollbackTransactionRequest)
            throws AccessDeniedException, BadRequestException, StatementTimeoutException, InternalServerErrorException,
            ForbiddenException, ServiceUnavailableErrorException, NotFoundException, AwsServiceException, SdkClientException,
            RdsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Performs a rollback of a transaction. Rolling back a transaction cancels its changes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RollbackTransactionRequest.Builder} avoiding the
     * need to create one manually via {@link RollbackTransactionRequest#builder()}
     * </p>
     *
     * @param rollbackTransactionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rdsdata.model.RollbackTransactionRequest.Builder} to create a
     *        request. The request parameters represent the input of a request to perform a rollback of a transaction.
     * @return Result of the RollbackTransaction operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws BadRequestException
     *         There is an error in the call or in a SQL statement.
     * @throws StatementTimeoutException
     *         The execution of the SQL statement timed out.
     * @throws InternalServerErrorException
     *         An internal error occurred.
     * @throws ForbiddenException
     *         There are insufficient privileges to make the call.
     * @throws ServiceUnavailableErrorException
     *         The service specified by the <code>resourceArn</code> parameter is not available.
     * @throws NotFoundException
     *         The <code>resourceArn</code>, <code>secretArn</code>, or <code>transactionId</code> value can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsDataClient.RollbackTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/RollbackTransaction" target="_top">AWS
     *      API Documentation</a>
     */
    default RollbackTransactionResponse rollbackTransaction(
            Consumer<RollbackTransactionRequest.Builder> rollbackTransactionRequest) throws AccessDeniedException,
            BadRequestException, StatementTimeoutException, InternalServerErrorException, ForbiddenException,
            ServiceUnavailableErrorException, NotFoundException, AwsServiceException, SdkClientException, RdsDataException {
        return rollbackTransaction(RollbackTransactionRequest.builder().applyMutation(rollbackTransactionRequest).build());
    }

    /**
     * Create a {@link RdsDataClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RdsDataClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RdsDataClient}.
     */
    static RdsDataClientBuilder builder() {
        return new DefaultRdsDataClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default RdsDataServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
