/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a SQL statement.
 * </p>
 * <note>
 * <p>
 * This data structure is only used with the deprecated <code>ExecuteSql</code> operation. Use the
 * <code>BatchExecuteStatement</code> or <code>ExecuteStatement</code> operation instead.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SqlStatementResult implements SdkPojo, Serializable,
        ToCopyableBuilder<SqlStatementResult.Builder, SqlStatementResult> {
    private static final SdkField<ResultFrame> RESULT_FRAME_FIELD = SdkField.<ResultFrame> builder(MarshallingType.SDK_POJO)
            .memberName("resultFrame").getter(getter(SqlStatementResult::resultFrame)).setter(setter(Builder::resultFrame))
            .constructor(ResultFrame::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultFrame").build()).build();

    private static final SdkField<Long> NUMBER_OF_RECORDS_UPDATED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numberOfRecordsUpdated").getter(getter(SqlStatementResult::numberOfRecordsUpdated))
            .setter(setter(Builder::numberOfRecordsUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecordsUpdated").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FRAME_FIELD,
            NUMBER_OF_RECORDS_UPDATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResultFrame resultFrame;

    private final Long numberOfRecordsUpdated;

    private SqlStatementResult(BuilderImpl builder) {
        this.resultFrame = builder.resultFrame;
        this.numberOfRecordsUpdated = builder.numberOfRecordsUpdated;
    }

    /**
     * <p>
     * The result set of the SQL statement.
     * </p>
     * 
     * @return The result set of the SQL statement.
     */
    public final ResultFrame resultFrame() {
        return resultFrame;
    }

    /**
     * <p>
     * The number of records updated by a SQL statement.
     * </p>
     * 
     * @return The number of records updated by a SQL statement.
     */
    public final Long numberOfRecordsUpdated() {
        return numberOfRecordsUpdated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resultFrame());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRecordsUpdated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlStatementResult)) {
            return false;
        }
        SqlStatementResult other = (SqlStatementResult) obj;
        return Objects.equals(resultFrame(), other.resultFrame())
                && Objects.equals(numberOfRecordsUpdated(), other.numberOfRecordsUpdated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SqlStatementResult").add("ResultFrame", resultFrame())
                .add("NumberOfRecordsUpdated", numberOfRecordsUpdated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resultFrame":
            return Optional.ofNullable(clazz.cast(resultFrame()));
        case "numberOfRecordsUpdated":
            return Optional.ofNullable(clazz.cast(numberOfRecordsUpdated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlStatementResult, T> g) {
        return obj -> g.apply((SqlStatementResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SqlStatementResult> {
        /**
         * <p>
         * The result set of the SQL statement.
         * </p>
         * 
         * @param resultFrame
         *        The result set of the SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultFrame(ResultFrame resultFrame);

        /**
         * <p>
         * The result set of the SQL statement.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResultFrame.Builder} avoiding the need to
         * create one manually via {@link ResultFrame#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResultFrame.Builder#build()} is called immediately and its result
         * is passed to {@link #resultFrame(ResultFrame)}.
         * 
         * @param resultFrame
         *        a consumer that will call methods on {@link ResultFrame.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultFrame(ResultFrame)
         */
        default Builder resultFrame(Consumer<ResultFrame.Builder> resultFrame) {
            return resultFrame(ResultFrame.builder().applyMutation(resultFrame).build());
        }

        /**
         * <p>
         * The number of records updated by a SQL statement.
         * </p>
         * 
         * @param numberOfRecordsUpdated
         *        The number of records updated by a SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRecordsUpdated(Long numberOfRecordsUpdated);
    }

    static final class BuilderImpl implements Builder {
        private ResultFrame resultFrame;

        private Long numberOfRecordsUpdated;

        private BuilderImpl() {
        }

        private BuilderImpl(SqlStatementResult model) {
            resultFrame(model.resultFrame);
            numberOfRecordsUpdated(model.numberOfRecordsUpdated);
        }

        public final ResultFrame.Builder getResultFrame() {
            return resultFrame != null ? resultFrame.toBuilder() : null;
        }

        public final void setResultFrame(ResultFrame.BuilderImpl resultFrame) {
            this.resultFrame = resultFrame != null ? resultFrame.build() : null;
        }

        @Override
        public final Builder resultFrame(ResultFrame resultFrame) {
            this.resultFrame = resultFrame;
            return this;
        }

        public final Long getNumberOfRecordsUpdated() {
            return numberOfRecordsUpdated;
        }

        public final void setNumberOfRecordsUpdated(Long numberOfRecordsUpdated) {
            this.numberOfRecordsUpdated = numberOfRecordsUpdated;
        }

        @Override
        public final Builder numberOfRecordsUpdated(Long numberOfRecordsUpdated) {
            this.numberOfRecordsUpdated = numberOfRecordsUpdated;
            return this;
        }

        @Override
        public SqlStatementResult build() {
            return new SqlStatementResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
