/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the value of a column.
 * </p>
 * <note>
 * <p>
 * This data structure is only used with the deprecated <code>ExecuteSql</code> operation. Use the
 * <code>BatchExecuteStatement</code> or <code>ExecuteStatement</code> operation instead.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Value implements SdkPojo, Serializable, ToCopyableBuilder<Value.Builder, Value> {
    private static final SdkField<Boolean> IS_NULL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isNull").getter(getter(Value::isNull)).setter(setter(Builder::isNull))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isNull").build()).build();

    private static final SdkField<Boolean> BIT_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("bitValue").getter(getter(Value::bitValue)).setter(setter(Builder::bitValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitValue").build()).build();

    private static final SdkField<Long> BIG_INT_VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("bigIntValue").getter(getter(Value::bigIntValue)).setter(setter(Builder::bigIntValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bigIntValue").build()).build();

    private static final SdkField<Integer> INT_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("intValue").getter(getter(Value::intValue)).setter(setter(Builder::intValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intValue").build()).build();

    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("doubleValue").getter(getter(Value::doubleValue)).setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()).build();

    private static final SdkField<Float> REAL_VALUE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("realValue").getter(getter(Value::realValue)).setter(setter(Builder::realValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("realValue").build()).build();

    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stringValue").getter(getter(Value::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final SdkField<SdkBytes> BLOB_VALUE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("blobValue").getter(getter(Value::blobValue)).setter(setter(Builder::blobValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobValue").build()).build();

    private static final SdkField<List<Value>> ARRAY_VALUES_FIELD = SdkField
            .<List<Value>> builder(MarshallingType.LIST)
            .memberName("arrayValues")
            .getter(getter(Value::arrayValues))
            .setter(setter(Builder::arrayValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Value> builder(MarshallingType.SDK_POJO)
                                            .constructor(Value::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StructValue> STRUCT_VALUE_FIELD = SdkField.<StructValue> builder(MarshallingType.SDK_POJO)
            .memberName("structValue").getter(getter(Value::structValue)).setter(setter(Builder::structValue))
            .constructor(StructValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("structValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_NULL_FIELD,
            BIT_VALUE_FIELD, BIG_INT_VALUE_FIELD, INT_VALUE_FIELD, DOUBLE_VALUE_FIELD, REAL_VALUE_FIELD, STRING_VALUE_FIELD,
            BLOB_VALUE_FIELD, ARRAY_VALUES_FIELD, STRUCT_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isNull;

    private final Boolean bitValue;

    private final Long bigIntValue;

    private final Integer intValue;

    private final Double doubleValue;

    private final Float realValue;

    private final String stringValue;

    private final SdkBytes blobValue;

    private final List<Value> arrayValues;

    private final StructValue structValue;

    private final Type type;

    private Value(BuilderImpl builder) {
        this.isNull = builder.isNull;
        this.bitValue = builder.bitValue;
        this.bigIntValue = builder.bigIntValue;
        this.intValue = builder.intValue;
        this.doubleValue = builder.doubleValue;
        this.realValue = builder.realValue;
        this.stringValue = builder.stringValue;
        this.blobValue = builder.blobValue;
        this.arrayValues = builder.arrayValues;
        this.structValue = builder.structValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * A NULL value.
     * </p>
     * 
     * @return A NULL value.
     */
    public final Boolean isNull() {
        return isNull;
    }

    /**
     * <p>
     * A value for a column of BIT data type.
     * </p>
     * 
     * @return A value for a column of BIT data type.
     */
    public final Boolean bitValue() {
        return bitValue;
    }

    /**
     * <p>
     * A value for a column of big integer data type.
     * </p>
     * 
     * @return A value for a column of big integer data type.
     */
    public final Long bigIntValue() {
        return bigIntValue;
    }

    /**
     * <p>
     * A value for a column of integer data type.
     * </p>
     * 
     * @return A value for a column of integer data type.
     */
    public final Integer intValue() {
        return intValue;
    }

    /**
     * <p>
     * A value for a column of double data type.
     * </p>
     * 
     * @return A value for a column of double data type.
     */
    public final Double doubleValue() {
        return doubleValue;
    }

    /**
     * <p>
     * A value for a column of real data type.
     * </p>
     * 
     * @return A value for a column of real data type.
     */
    public final Float realValue() {
        return realValue;
    }

    /**
     * <p>
     * A value for a column of string data type.
     * </p>
     * 
     * @return A value for a column of string data type.
     */
    public final String stringValue() {
        return stringValue;
    }

    /**
     * <p>
     * A value for a column of BLOB data type.
     * </p>
     * 
     * @return A value for a column of BLOB data type.
     */
    public final SdkBytes blobValue() {
        return blobValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the ArrayValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasArrayValues() {
        return arrayValues != null && !(arrayValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of column values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArrayValues} method.
     * </p>
     * 
     * @return An array of column values.
     */
    public final List<Value> arrayValues() {
        return arrayValues;
    }

    /**
     * <p>
     * A value for a column of STRUCT data type.
     * </p>
     * 
     * @return A value for a column of STRUCT data type.
     */
    public final StructValue structValue() {
        return structValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isNull());
        hashCode = 31 * hashCode + Objects.hashCode(bitValue());
        hashCode = 31 * hashCode + Objects.hashCode(bigIntValue());
        hashCode = 31 * hashCode + Objects.hashCode(intValue());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(realValue());
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(blobValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasArrayValues() ? arrayValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(structValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Value)) {
            return false;
        }
        Value other = (Value) obj;
        return Objects.equals(isNull(), other.isNull()) && Objects.equals(bitValue(), other.bitValue())
                && Objects.equals(bigIntValue(), other.bigIntValue()) && Objects.equals(intValue(), other.intValue())
                && Objects.equals(doubleValue(), other.doubleValue()) && Objects.equals(realValue(), other.realValue())
                && Objects.equals(stringValue(), other.stringValue()) && Objects.equals(blobValue(), other.blobValue())
                && hasArrayValues() == other.hasArrayValues() && Objects.equals(arrayValues(), other.arrayValues())
                && Objects.equals(structValue(), other.structValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Value").add("IsNull", isNull()).add("BitValue", bitValue()).add("BigIntValue", bigIntValue())
                .add("IntValue", intValue()).add("DoubleValue", doubleValue()).add("RealValue", realValue())
                .add("StringValue", stringValue()).add("BlobValue", blobValue())
                .add("ArrayValues", hasArrayValues() ? arrayValues() : null).add("StructValue", structValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isNull":
            return Optional.ofNullable(clazz.cast(isNull()));
        case "bitValue":
            return Optional.ofNullable(clazz.cast(bitValue()));
        case "bigIntValue":
            return Optional.ofNullable(clazz.cast(bigIntValue()));
        case "intValue":
            return Optional.ofNullable(clazz.cast(intValue()));
        case "doubleValue":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "realValue":
            return Optional.ofNullable(clazz.cast(realValue()));
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "blobValue":
            return Optional.ofNullable(clazz.cast(blobValue()));
        case "arrayValues":
            return Optional.ofNullable(clazz.cast(arrayValues()));
        case "structValue":
            return Optional.ofNullable(clazz.cast(structValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #isNull()} initialized to the given value.
     *
     * <p>
     * A NULL value.
     * </p>
     * 
     * @param isNull
     *        A NULL value.
     */
    public static Value fromIsNull(Boolean isNull) {
        return builder().isNull(isNull).build();
    }

    /**
     * Create an instance of this class with {@link #bitValue()} initialized to the given value.
     *
     * <p>
     * A value for a column of BIT data type.
     * </p>
     * 
     * @param bitValue
     *        A value for a column of BIT data type.
     */
    public static Value fromBitValue(Boolean bitValue) {
        return builder().bitValue(bitValue).build();
    }

    /**
     * Create an instance of this class with {@link #bigIntValue()} initialized to the given value.
     *
     * <p>
     * A value for a column of big integer data type.
     * </p>
     * 
     * @param bigIntValue
     *        A value for a column of big integer data type.
     */
    public static Value fromBigIntValue(Long bigIntValue) {
        return builder().bigIntValue(bigIntValue).build();
    }

    /**
     * Create an instance of this class with {@link #intValue()} initialized to the given value.
     *
     * <p>
     * A value for a column of integer data type.
     * </p>
     * 
     * @param intValue
     *        A value for a column of integer data type.
     */
    public static Value fromIntValue(Integer intValue) {
        return builder().intValue(intValue).build();
    }

    /**
     * Create an instance of this class with {@link #doubleValue()} initialized to the given value.
     *
     * <p>
     * A value for a column of double data type.
     * </p>
     * 
     * @param doubleValue
     *        A value for a column of double data type.
     */
    public static Value fromDoubleValue(Double doubleValue) {
        return builder().doubleValue(doubleValue).build();
    }

    /**
     * Create an instance of this class with {@link #realValue()} initialized to the given value.
     *
     * <p>
     * A value for a column of real data type.
     * </p>
     * 
     * @param realValue
     *        A value for a column of real data type.
     */
    public static Value fromRealValue(Float realValue) {
        return builder().realValue(realValue).build();
    }

    /**
     * Create an instance of this class with {@link #stringValue()} initialized to the given value.
     *
     * <p>
     * A value for a column of string data type.
     * </p>
     * 
     * @param stringValue
     *        A value for a column of string data type.
     */
    public static Value fromStringValue(String stringValue) {
        return builder().stringValue(stringValue).build();
    }

    /**
     * Create an instance of this class with {@link #blobValue()} initialized to the given value.
     *
     * <p>
     * A value for a column of BLOB data type.
     * </p>
     * 
     * @param blobValue
     *        A value for a column of BLOB data type.
     */
    public static Value fromBlobValue(SdkBytes blobValue) {
        return builder().blobValue(blobValue).build();
    }

    /**
     * Create an instance of this class with {@link #arrayValues()} initialized to the given value.
     *
     * <p>
     * An array of column values.
     * </p>
     * 
     * @param arrayValues
     *        An array of column values.
     */
    public static Value fromArrayValues(List<Value> arrayValues) {
        return builder().arrayValues(arrayValues).build();
    }

    /**
     * Create an instance of this class with {@link #structValue()} initialized to the given value.
     *
     * <p>
     * A value for a column of STRUCT data type.
     * </p>
     * 
     * @param structValue
     *        A value for a column of STRUCT data type.
     */
    public static Value fromStructValue(StructValue structValue) {
        return builder().structValue(structValue).build();
    }

    /**
     * Create an instance of this class with {@link #structValue()} initialized to the given value.
     *
     * <p>
     * A value for a column of STRUCT data type.
     * </p>
     * 
     * @param structValue
     *        A value for a column of STRUCT data type.
     */
    public static Value fromStructValue(Consumer<StructValue.Builder> structValue) {
        StructValue.Builder builder = StructValue.builder();
        structValue.accept(builder);
        return fromStructValue(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Value, T> g) {
        return obj -> g.apply((Value) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Value> {
        /**
         * <p>
         * A NULL value.
         * </p>
         * 
         * @param isNull
         *        A NULL value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNull(Boolean isNull);

        /**
         * <p>
         * A value for a column of BIT data type.
         * </p>
         * 
         * @param bitValue
         *        A value for a column of BIT data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitValue(Boolean bitValue);

        /**
         * <p>
         * A value for a column of big integer data type.
         * </p>
         * 
         * @param bigIntValue
         *        A value for a column of big integer data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bigIntValue(Long bigIntValue);

        /**
         * <p>
         * A value for a column of integer data type.
         * </p>
         * 
         * @param intValue
         *        A value for a column of integer data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intValue(Integer intValue);

        /**
         * <p>
         * A value for a column of double data type.
         * </p>
         * 
         * @param doubleValue
         *        A value for a column of double data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(Double doubleValue);

        /**
         * <p>
         * A value for a column of real data type.
         * </p>
         * 
         * @param realValue
         *        A value for a column of real data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realValue(Float realValue);

        /**
         * <p>
         * A value for a column of string data type.
         * </p>
         * 
         * @param stringValue
         *        A value for a column of string data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * A value for a column of BLOB data type.
         * </p>
         * 
         * @param blobValue
         *        A value for a column of BLOB data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blobValue(SdkBytes blobValue);

        /**
         * <p>
         * An array of column values.
         * </p>
         * 
         * @param arrayValues
         *        An array of column values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayValues(Collection<Value> arrayValues);

        /**
         * <p>
         * An array of column values.
         * </p>
         * 
         * @param arrayValues
         *        An array of column values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayValues(Value... arrayValues);

        /**
         * <p>
         * An array of column values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rdsdata.model.Value.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.rdsdata.model.Value#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rdsdata.model.Value.Builder#build()} is called immediately and its
         * result is passed to {@link #arrayValues(List<Value>)}.
         * 
         * @param arrayValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rdsdata.model.Value.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arrayValues(java.util.Collection<Value>)
         */
        Builder arrayValues(Consumer<Builder>... arrayValues);

        /**
         * <p>
         * A value for a column of STRUCT data type.
         * </p>
         * 
         * @param structValue
         *        A value for a column of STRUCT data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder structValue(StructValue structValue);

        /**
         * <p>
         * A value for a column of STRUCT data type.
         * </p>
         * This is a convenience method that creates an instance of the {@link StructValue.Builder} avoiding the need to
         * create one manually via {@link StructValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StructValue.Builder#build()} is called immediately and its result
         * is passed to {@link #structValue(StructValue)}.
         * 
         * @param structValue
         *        a consumer that will call methods on {@link StructValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #structValue(StructValue)
         */
        default Builder structValue(Consumer<StructValue.Builder> structValue) {
            return structValue(StructValue.builder().applyMutation(structValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean isNull;

        private Boolean bitValue;

        private Long bigIntValue;

        private Integer intValue;

        private Double doubleValue;

        private Float realValue;

        private String stringValue;

        private SdkBytes blobValue;

        private List<Value> arrayValues = DefaultSdkAutoConstructList.getInstance();

        private StructValue structValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Value model) {
            isNull(model.isNull);
            bitValue(model.bitValue);
            bigIntValue(model.bigIntValue);
            intValue(model.intValue);
            doubleValue(model.doubleValue);
            realValue(model.realValue);
            stringValue(model.stringValue);
            blobValue(model.blobValue);
            arrayValues(model.arrayValues);
            structValue(model.structValue);
        }

        public final Boolean getIsNull() {
            return isNull;
        }

        public final void setIsNull(Boolean isNull) {
            Object oldValue = this.isNull;
            this.isNull = isNull;
            handleUnionValueChange(Type.IS_NULL, oldValue, this.isNull);
        }

        @Override
        public final Builder isNull(Boolean isNull) {
            Object oldValue = this.isNull;
            this.isNull = isNull;
            handleUnionValueChange(Type.IS_NULL, oldValue, this.isNull);
            return this;
        }

        public final Boolean getBitValue() {
            return bitValue;
        }

        public final void setBitValue(Boolean bitValue) {
            Object oldValue = this.bitValue;
            this.bitValue = bitValue;
            handleUnionValueChange(Type.BIT_VALUE, oldValue, this.bitValue);
        }

        @Override
        public final Builder bitValue(Boolean bitValue) {
            Object oldValue = this.bitValue;
            this.bitValue = bitValue;
            handleUnionValueChange(Type.BIT_VALUE, oldValue, this.bitValue);
            return this;
        }

        public final Long getBigIntValue() {
            return bigIntValue;
        }

        public final void setBigIntValue(Long bigIntValue) {
            Object oldValue = this.bigIntValue;
            this.bigIntValue = bigIntValue;
            handleUnionValueChange(Type.BIG_INT_VALUE, oldValue, this.bigIntValue);
        }

        @Override
        public final Builder bigIntValue(Long bigIntValue) {
            Object oldValue = this.bigIntValue;
            this.bigIntValue = bigIntValue;
            handleUnionValueChange(Type.BIG_INT_VALUE, oldValue, this.bigIntValue);
            return this;
        }

        public final Integer getIntValue() {
            return intValue;
        }

        public final void setIntValue(Integer intValue) {
            Object oldValue = this.intValue;
            this.intValue = intValue;
            handleUnionValueChange(Type.INT_VALUE, oldValue, this.intValue);
        }

        @Override
        public final Builder intValue(Integer intValue) {
            Object oldValue = this.intValue;
            this.intValue = intValue;
            handleUnionValueChange(Type.INT_VALUE, oldValue, this.intValue);
            return this;
        }

        public final Double getDoubleValue() {
            return doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            Object oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            Object oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
            return this;
        }

        public final Float getRealValue() {
            return realValue;
        }

        public final void setRealValue(Float realValue) {
            Object oldValue = this.realValue;
            this.realValue = realValue;
            handleUnionValueChange(Type.REAL_VALUE, oldValue, this.realValue);
        }

        @Override
        public final Builder realValue(Float realValue) {
            Object oldValue = this.realValue;
            this.realValue = realValue;
            handleUnionValueChange(Type.REAL_VALUE, oldValue, this.realValue);
            return this;
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final ByteBuffer getBlobValue() {
            return blobValue == null ? null : blobValue.asByteBuffer();
        }

        public final void setBlobValue(ByteBuffer blobValue) {
            blobValue(blobValue == null ? null : SdkBytes.fromByteBuffer(blobValue));
        }

        @Override
        public final Builder blobValue(SdkBytes blobValue) {
            Object oldValue = this.blobValue;
            this.blobValue = blobValue;
            handleUnionValueChange(Type.BLOB_VALUE, oldValue, this.blobValue);
            return this;
        }

        public final List<Builder> getArrayValues() {
            List<Builder> result = ArrayValueListCopier.copyToBuilder(this.arrayValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArrayValues(Collection<BuilderImpl> arrayValues) {
            Object oldValue = this.arrayValues;
            this.arrayValues = ArrayValueListCopier.copyFromBuilder(arrayValues);
            handleUnionValueChange(Type.ARRAY_VALUES, oldValue, this.arrayValues);
        }

        @Override
        public final Builder arrayValues(Collection<Value> arrayValues) {
            Object oldValue = this.arrayValues;
            this.arrayValues = ArrayValueListCopier.copy(arrayValues);
            handleUnionValueChange(Type.ARRAY_VALUES, oldValue, this.arrayValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValues(Value... arrayValues) {
            arrayValues(Arrays.asList(arrayValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValues(Consumer<Builder>... arrayValues) {
            arrayValues(Stream.of(arrayValues).map(c -> Value.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final StructValue.Builder getStructValue() {
            return structValue != null ? structValue.toBuilder() : null;
        }

        public final void setStructValue(StructValue.BuilderImpl structValue) {
            Object oldValue = this.structValue;
            this.structValue = structValue != null ? structValue.build() : null;
            handleUnionValueChange(Type.STRUCT_VALUE, oldValue, this.structValue);
        }

        @Override
        public final Builder structValue(StructValue structValue) {
            Object oldValue = this.structValue;
            this.structValue = structValue;
            handleUnionValueChange(Type.STRUCT_VALUE, oldValue, this.structValue);
            return this;
        }

        @Override
        public Value build() {
            return new Value(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Value#type()
     */
    public enum Type {
        IS_NULL,

        BIT_VALUE,

        BIG_INT_VALUE,

        INT_VALUE,

        DOUBLE_VALUE,

        REAL_VALUE,

        STRING_VALUE,

        BLOB_VALUE,

        ARRAY_VALUES,

        STRUCT_VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
