/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response elements represent the output of a request to run one or more SQL statements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteSqlResponse extends RdsDataResponse implements
        ToCopyableBuilder<ExecuteSqlResponse.Builder, ExecuteSqlResponse> {
    private static final SdkField<List<SqlStatementResult>> SQL_STATEMENT_RESULTS_FIELD = SdkField
            .<List<SqlStatementResult>> builder(MarshallingType.LIST)
            .memberName("sqlStatementResults")
            .getter(getter(ExecuteSqlResponse::sqlStatementResults))
            .setter(setter(Builder::sqlStatementResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlStatementResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SqlStatementResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(SqlStatementResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SQL_STATEMENT_RESULTS_FIELD));

    private final List<SqlStatementResult> sqlStatementResults;

    private ExecuteSqlResponse(BuilderImpl builder) {
        super(builder);
        this.sqlStatementResults = builder.sqlStatementResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the SqlStatementResults property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSqlStatementResults() {
        return sqlStatementResults != null && !(sqlStatementResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results of the SQL statement or statements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSqlStatementResults} method.
     * </p>
     * 
     * @return The results of the SQL statement or statements.
     */
    public final List<SqlStatementResult> sqlStatementResults() {
        return sqlStatementResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSqlStatementResults() ? sqlStatementResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteSqlResponse)) {
            return false;
        }
        ExecuteSqlResponse other = (ExecuteSqlResponse) obj;
        return hasSqlStatementResults() == other.hasSqlStatementResults()
                && Objects.equals(sqlStatementResults(), other.sqlStatementResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteSqlResponse")
                .add("SqlStatementResults", hasSqlStatementResults() ? sqlStatementResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sqlStatementResults":
            return Optional.ofNullable(clazz.cast(sqlStatementResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteSqlResponse, T> g) {
        return obj -> g.apply((ExecuteSqlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteSqlResponse> {
        /**
         * <p>
         * The results of the SQL statement or statements.
         * </p>
         * 
         * @param sqlStatementResults
         *        The results of the SQL statement or statements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlStatementResults(Collection<SqlStatementResult> sqlStatementResults);

        /**
         * <p>
         * The results of the SQL statement or statements.
         * </p>
         * 
         * @param sqlStatementResults
         *        The results of the SQL statement or statements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlStatementResults(SqlStatementResult... sqlStatementResults);

        /**
         * <p>
         * The results of the SQL statement or statements.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rdsdata.model.SqlStatementResult.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rdsdata.model.SqlStatementResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rdsdata.model.SqlStatementResult.Builder#build()} is called
         * immediately and its result is passed to {@link #sqlStatementResults(List<SqlStatementResult>)}.
         * 
         * @param sqlStatementResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rdsdata.model.SqlStatementResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlStatementResults(java.util.Collection<SqlStatementResult>)
         */
        Builder sqlStatementResults(Consumer<SqlStatementResult.Builder>... sqlStatementResults);
    }

    static final class BuilderImpl extends RdsDataResponse.BuilderImpl implements Builder {
        private List<SqlStatementResult> sqlStatementResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteSqlResponse model) {
            super(model);
            sqlStatementResults(model.sqlStatementResults);
        }

        public final List<SqlStatementResult.Builder> getSqlStatementResults() {
            List<SqlStatementResult.Builder> result = SqlStatementResultsCopier.copyToBuilder(this.sqlStatementResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSqlStatementResults(Collection<SqlStatementResult.BuilderImpl> sqlStatementResults) {
            this.sqlStatementResults = SqlStatementResultsCopier.copyFromBuilder(sqlStatementResults);
        }

        @Override
        public final Builder sqlStatementResults(Collection<SqlStatementResult> sqlStatementResults) {
            this.sqlStatementResults = SqlStatementResultsCopier.copy(sqlStatementResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlStatementResults(SqlStatementResult... sqlStatementResults) {
            sqlStatementResults(Arrays.asList(sqlStatementResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlStatementResults(Consumer<SqlStatementResult.Builder>... sqlStatementResults) {
            sqlStatementResults(Stream.of(sqlStatementResults).map(c -> SqlStatementResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExecuteSqlResponse build() {
            return new ExecuteSqlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
