/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Column Metadata
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnMetadata implements SdkPojo, Serializable, ToCopyableBuilder<ColumnMetadata.Builder, ColumnMetadata> {
    private static final SdkField<Integer> ARRAY_BASE_COLUMN_TYPE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ColumnMetadata::arrayBaseColumnType)).setter(setter(Builder::arrayBaseColumnType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayBaseColumnType").build())
            .build();

    private static final SdkField<Boolean> IS_AUTO_INCREMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ColumnMetadata::isAutoIncrement)).setter(setter(Builder::isAutoIncrement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAutoIncrement").build()).build();

    private static final SdkField<Boolean> IS_CASE_SENSITIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ColumnMetadata::isCaseSensitive)).setter(setter(Builder::isCaseSensitive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isCaseSensitive").build()).build();

    private static final SdkField<Boolean> IS_CURRENCY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ColumnMetadata::isCurrency)).setter(setter(Builder::isCurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isCurrency").build()).build();

    private static final SdkField<Boolean> IS_SIGNED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ColumnMetadata::isSigned)).setter(setter(Builder::isSigned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSigned").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ColumnMetadata::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("label").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ColumnMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> NULLABLE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ColumnMetadata::nullable)).setter(setter(Builder::nullable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nullable").build()).build();

    private static final SdkField<Integer> PRECISION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ColumnMetadata::precision)).setter(setter(Builder::precision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("precision").build()).build();

    private static final SdkField<Integer> SCALE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ColumnMetadata::scale)).setter(setter(Builder::scale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scale").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ColumnMetadata::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ColumnMetadata::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()).build();

    private static final SdkField<Integer> TYPE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ColumnMetadata::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ColumnMetadata::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARRAY_BASE_COLUMN_TYPE_FIELD,
            IS_AUTO_INCREMENT_FIELD, IS_CASE_SENSITIVE_FIELD, IS_CURRENCY_FIELD, IS_SIGNED_FIELD, LABEL_FIELD, NAME_FIELD,
            NULLABLE_FIELD, PRECISION_FIELD, SCALE_FIELD, SCHEMA_NAME_FIELD, TABLE_NAME_FIELD, TYPE_FIELD, TYPE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer arrayBaseColumnType;

    private final Boolean isAutoIncrement;

    private final Boolean isCaseSensitive;

    private final Boolean isCurrency;

    private final Boolean isSigned;

    private final String label;

    private final String name;

    private final Integer nullable;

    private final Integer precision;

    private final Integer scale;

    private final String schemaName;

    private final String tableName;

    private final Integer type;

    private final String typeName;

    private ColumnMetadata(BuilderImpl builder) {
        this.arrayBaseColumnType = builder.arrayBaseColumnType;
        this.isAutoIncrement = builder.isAutoIncrement;
        this.isCaseSensitive = builder.isCaseSensitive;
        this.isCurrency = builder.isCurrency;
        this.isSigned = builder.isSigned;
        this.label = builder.label;
        this.name = builder.name;
        this.nullable = builder.nullable;
        this.precision = builder.precision;
        this.scale = builder.scale;
        this.schemaName = builder.schemaName;
        this.tableName = builder.tableName;
        this.type = builder.type;
        this.typeName = builder.typeName;
    }

    /**
     * Homogenous array base SQL type from java.sql.Types.
     * 
     * @return Homogenous array base SQL type from java.sql.Types.
     */
    public Integer arrayBaseColumnType() {
        return arrayBaseColumnType;
    }

    /**
     * Whether the designated column is automatically numbered
     * 
     * @return Whether the designated column is automatically numbered
     */
    public Boolean isAutoIncrement() {
        return isAutoIncrement;
    }

    /**
     * Whether values in the designated column's case matters
     * 
     * @return Whether values in the designated column's case matters
     */
    public Boolean isCaseSensitive() {
        return isCaseSensitive;
    }

    /**
     * Whether values in the designated column is a cash value
     * 
     * @return Whether values in the designated column is a cash value
     */
    public Boolean isCurrency() {
        return isCurrency;
    }

    /**
     * Whether values in the designated column are signed numbers
     * 
     * @return Whether values in the designated column are signed numbers
     */
    public Boolean isSigned() {
        return isSigned;
    }

    /**
     * Usually specified by the SQL AS. If not specified, return column name.
     * 
     * @return Usually specified by the SQL AS. If not specified, return column name.
     */
    public String label() {
        return label;
    }

    /**
     * Name of the column.
     * 
     * @return Name of the column.
     */
    public String name() {
        return name;
    }

    /**
     * Indicates the nullability of values in the designated column. One of columnNoNulls (0), columnNullable (1),
     * columnNullableUnknown (2)
     * 
     * @return Indicates the nullability of values in the designated column. One of columnNoNulls (0), columnNullable
     *         (1), columnNullableUnknown (2)
     */
    public Integer nullable() {
        return nullable;
    }

    /**
     * Get the designated column's specified column size.For numeric data, this is the maximum precision. For character
     * data, this is the length in characters. For datetime datatypes, this is the length in characters of the String
     * representation (assuming the maximum allowed precision of the fractional seconds component). For binary data,
     * this is the length in bytes. For the ROWID datatype, this is the length in bytes. 0 is returned for data types
     * where the column size is not applicable.
     * 
     * @return Get the designated column's specified column size.For numeric data, this is the maximum precision. For
     *         character data, this is the length in characters. For datetime datatypes, this is the length in
     *         characters of the String representation (assuming the maximum allowed precision of the fractional seconds
     *         component). For binary data, this is the length in bytes. For the ROWID datatype, this is the length in
     *         bytes. 0 is returned for data types where the column size is not applicable.
     */
    public Integer precision() {
        return precision;
    }

    /**
     * Designated column's number of digits to right of the decimal point. 0 is returned for data types where the scale
     * is not applicable.
     * 
     * @return Designated column's number of digits to right of the decimal point. 0 is returned for data types where
     *         the scale is not applicable.
     */
    public Integer scale() {
        return scale;
    }

    /**
     * Designated column's table's schema
     * 
     * @return Designated column's table's schema
     */
    public String schemaName() {
        return schemaName;
    }

    /**
     * Designated column's table name
     * 
     * @return Designated column's table name
     */
    public String tableName() {
        return tableName;
    }

    /**
     * SQL type from java.sql.Types.
     * 
     * @return SQL type from java.sql.Types.
     */
    public Integer type() {
        return type;
    }

    /**
     * Database-specific type name.
     * 
     * @return Database-specific type name.
     */
    public String typeName() {
        return typeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arrayBaseColumnType());
        hashCode = 31 * hashCode + Objects.hashCode(isAutoIncrement());
        hashCode = 31 * hashCode + Objects.hashCode(isCaseSensitive());
        hashCode = 31 * hashCode + Objects.hashCode(isCurrency());
        hashCode = 31 * hashCode + Objects.hashCode(isSigned());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(nullable());
        hashCode = 31 * hashCode + Objects.hashCode(precision());
        hashCode = 31 * hashCode + Objects.hashCode(scale());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnMetadata)) {
            return false;
        }
        ColumnMetadata other = (ColumnMetadata) obj;
        return Objects.equals(arrayBaseColumnType(), other.arrayBaseColumnType())
                && Objects.equals(isAutoIncrement(), other.isAutoIncrement())
                && Objects.equals(isCaseSensitive(), other.isCaseSensitive()) && Objects.equals(isCurrency(), other.isCurrency())
                && Objects.equals(isSigned(), other.isSigned()) && Objects.equals(label(), other.label())
                && Objects.equals(name(), other.name()) && Objects.equals(nullable(), other.nullable())
                && Objects.equals(precision(), other.precision()) && Objects.equals(scale(), other.scale())
                && Objects.equals(schemaName(), other.schemaName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(type(), other.type()) && Objects.equals(typeName(), other.typeName());
    }

    @Override
    public String toString() {
        return ToString.builder("ColumnMetadata").add("ArrayBaseColumnType", arrayBaseColumnType())
                .add("IsAutoIncrement", isAutoIncrement()).add("IsCaseSensitive", isCaseSensitive())
                .add("IsCurrency", isCurrency()).add("IsSigned", isSigned()).add("Label", label()).add("Name", name())
                .add("Nullable", nullable()).add("Precision", precision()).add("Scale", scale()).add("SchemaName", schemaName())
                .add("TableName", tableName()).add("Type", type()).add("TypeName", typeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arrayBaseColumnType":
            return Optional.ofNullable(clazz.cast(arrayBaseColumnType()));
        case "isAutoIncrement":
            return Optional.ofNullable(clazz.cast(isAutoIncrement()));
        case "isCaseSensitive":
            return Optional.ofNullable(clazz.cast(isCaseSensitive()));
        case "isCurrency":
            return Optional.ofNullable(clazz.cast(isCurrency()));
        case "isSigned":
            return Optional.ofNullable(clazz.cast(isSigned()));
        case "label":
            return Optional.ofNullable(clazz.cast(label()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "nullable":
            return Optional.ofNullable(clazz.cast(nullable()));
        case "precision":
            return Optional.ofNullable(clazz.cast(precision()));
        case "scale":
            return Optional.ofNullable(clazz.cast(scale()));
        case "schemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "tableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "typeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnMetadata, T> g) {
        return obj -> g.apply((ColumnMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnMetadata> {
        /**
         * Homogenous array base SQL type from java.sql.Types.
         * 
         * @param arrayBaseColumnType
         *        Homogenous array base SQL type from java.sql.Types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayBaseColumnType(Integer arrayBaseColumnType);

        /**
         * Whether the designated column is automatically numbered
         * 
         * @param isAutoIncrement
         *        Whether the designated column is automatically numbered
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAutoIncrement(Boolean isAutoIncrement);

        /**
         * Whether values in the designated column's case matters
         * 
         * @param isCaseSensitive
         *        Whether values in the designated column's case matters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isCaseSensitive(Boolean isCaseSensitive);

        /**
         * Whether values in the designated column is a cash value
         * 
         * @param isCurrency
         *        Whether values in the designated column is a cash value
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isCurrency(Boolean isCurrency);

        /**
         * Whether values in the designated column are signed numbers
         * 
         * @param isSigned
         *        Whether values in the designated column are signed numbers
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSigned(Boolean isSigned);

        /**
         * Usually specified by the SQL AS. If not specified, return column name.
         * 
         * @param label
         *        Usually specified by the SQL AS. If not specified, return column name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * Name of the column.
         * 
         * @param name
         *        Name of the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Indicates the nullability of values in the designated column. One of columnNoNulls (0), columnNullable (1),
         * columnNullableUnknown (2)
         * 
         * @param nullable
         *        Indicates the nullability of values in the designated column. One of columnNoNulls (0), columnNullable
         *        (1), columnNullableUnknown (2)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nullable(Integer nullable);

        /**
         * Get the designated column's specified column size.For numeric data, this is the maximum precision. For
         * character data, this is the length in characters. For datetime datatypes, this is the length in characters of
         * the String representation (assuming the maximum allowed precision of the fractional seconds component). For
         * binary data, this is the length in bytes. For the ROWID datatype, this is the length in bytes. 0 is returned
         * for data types where the column size is not applicable.
         * 
         * @param precision
         *        Get the designated column's specified column size.For numeric data, this is the maximum precision. For
         *        character data, this is the length in characters. For datetime datatypes, this is the length in
         *        characters of the String representation (assuming the maximum allowed precision of the fractional
         *        seconds component). For binary data, this is the length in bytes. For the ROWID datatype, this is the
         *        length in bytes. 0 is returned for data types where the column size is not applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precision(Integer precision);

        /**
         * Designated column's number of digits to right of the decimal point. 0 is returned for data types where the
         * scale is not applicable.
         * 
         * @param scale
         *        Designated column's number of digits to right of the decimal point. 0 is returned for data types where
         *        the scale is not applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scale(Integer scale);

        /**
         * Designated column's table's schema
         * 
         * @param schemaName
         *        Designated column's table's schema
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * Designated column's table name
         * 
         * @param tableName
         *        Designated column's table name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * SQL type from java.sql.Types.
         * 
         * @param type
         *        SQL type from java.sql.Types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(Integer type);

        /**
         * Database-specific type name.
         * 
         * @param typeName
         *        Database-specific type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);
    }

    static final class BuilderImpl implements Builder {
        private Integer arrayBaseColumnType;

        private Boolean isAutoIncrement;

        private Boolean isCaseSensitive;

        private Boolean isCurrency;

        private Boolean isSigned;

        private String label;

        private String name;

        private Integer nullable;

        private Integer precision;

        private Integer scale;

        private String schemaName;

        private String tableName;

        private Integer type;

        private String typeName;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnMetadata model) {
            arrayBaseColumnType(model.arrayBaseColumnType);
            isAutoIncrement(model.isAutoIncrement);
            isCaseSensitive(model.isCaseSensitive);
            isCurrency(model.isCurrency);
            isSigned(model.isSigned);
            label(model.label);
            name(model.name);
            nullable(model.nullable);
            precision(model.precision);
            scale(model.scale);
            schemaName(model.schemaName);
            tableName(model.tableName);
            type(model.type);
            typeName(model.typeName);
        }

        public final Integer getArrayBaseColumnType() {
            return arrayBaseColumnType;
        }

        @Override
        public final Builder arrayBaseColumnType(Integer arrayBaseColumnType) {
            this.arrayBaseColumnType = arrayBaseColumnType;
            return this;
        }

        public final void setArrayBaseColumnType(Integer arrayBaseColumnType) {
            this.arrayBaseColumnType = arrayBaseColumnType;
        }

        public final Boolean getIsAutoIncrement() {
            return isAutoIncrement;
        }

        @Override
        public final Builder isAutoIncrement(Boolean isAutoIncrement) {
            this.isAutoIncrement = isAutoIncrement;
            return this;
        }

        public final void setIsAutoIncrement(Boolean isAutoIncrement) {
            this.isAutoIncrement = isAutoIncrement;
        }

        public final Boolean getIsCaseSensitive() {
            return isCaseSensitive;
        }

        @Override
        public final Builder isCaseSensitive(Boolean isCaseSensitive) {
            this.isCaseSensitive = isCaseSensitive;
            return this;
        }

        public final void setIsCaseSensitive(Boolean isCaseSensitive) {
            this.isCaseSensitive = isCaseSensitive;
        }

        public final Boolean getIsCurrency() {
            return isCurrency;
        }

        @Override
        public final Builder isCurrency(Boolean isCurrency) {
            this.isCurrency = isCurrency;
            return this;
        }

        public final void setIsCurrency(Boolean isCurrency) {
            this.isCurrency = isCurrency;
        }

        public final Boolean getIsSigned() {
            return isSigned;
        }

        @Override
        public final Builder isSigned(Boolean isSigned) {
            this.isSigned = isSigned;
            return this;
        }

        public final void setIsSigned(Boolean isSigned) {
            this.isSigned = isSigned;
        }

        public final String getLabel() {
            return label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getNullable() {
            return nullable;
        }

        @Override
        public final Builder nullable(Integer nullable) {
            this.nullable = nullable;
            return this;
        }

        public final void setNullable(Integer nullable) {
            this.nullable = nullable;
        }

        public final Integer getPrecision() {
            return precision;
        }

        @Override
        public final Builder precision(Integer precision) {
            this.precision = precision;
            return this;
        }

        public final void setPrecision(Integer precision) {
            this.precision = precision;
        }

        public final Integer getScale() {
            return scale;
        }

        @Override
        public final Builder scale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public final void setScale(Integer scale) {
            this.scale = scale;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Integer getType() {
            return type;
        }

        @Override
        public final Builder type(Integer type) {
            this.type = type;
            return this;
        }

        public final void setType(Integer type) {
            this.type = type;
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public ColumnMetadata build() {
            return new ColumnMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
