/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rdsdata.model.ArrayValueListCopier;
import software.amazon.awssdk.services.rdsdata.model.StructValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Value
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Value> {
    private static final SdkField<Boolean> IS_NULL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isNull").getter(Value.getter(Value::isNull)).setter(Value.setter(Builder::isNull)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isNull").build()}).build();
    private static final SdkField<Boolean> BIT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("bitValue").getter(Value.getter(Value::bitValue)).setter(Value.setter(Builder::bitValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitValue").build()}).build();
    private static final SdkField<Long> BIG_INT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("bigIntValue").getter(Value.getter(Value::bigIntValue)).setter(Value.setter(Builder::bigIntValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bigIntValue").build()}).build();
    private static final SdkField<Integer> INT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("intValue").getter(Value.getter(Value::intValue)).setter(Value.setter(Builder::intValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intValue").build()}).build();
    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("doubleValue").getter(Value.getter(Value::doubleValue)).setter(Value.setter(Builder::doubleValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()}).build();
    private static final SdkField<Float> REAL_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("realValue").getter(Value.getter(Value::realValue)).setter(Value.setter(Builder::realValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("realValue").build()}).build();
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stringValue").getter(Value.getter(Value::stringValue)).setter(Value.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final SdkField<SdkBytes> BLOB_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("blobValue").getter(Value.getter(Value::blobValue)).setter(Value.setter(Builder::blobValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobValue").build()}).build();
    private static final SdkField<List<Value>> ARRAY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("arrayValues").getter(Value.getter(Value::arrayValues)).setter(Value.setter(Builder::arrayValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Value::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StructValue> STRUCT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("structValue").getter(Value.getter(Value::structValue)).setter(Value.setter(Builder::structValue)).constructor(StructValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("structValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_NULL_FIELD, BIT_VALUE_FIELD, BIG_INT_VALUE_FIELD, INT_VALUE_FIELD, DOUBLE_VALUE_FIELD, REAL_VALUE_FIELD, STRING_VALUE_FIELD, BLOB_VALUE_FIELD, ARRAY_VALUES_FIELD, STRUCT_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Value.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean isNull;
    private final Boolean bitValue;
    private final Long bigIntValue;
    private final Integer intValue;
    private final Double doubleValue;
    private final Float realValue;
    private final String stringValue;
    private final SdkBytes blobValue;
    private final List<Value> arrayValues;
    private final StructValue structValue;
    private final Type type;

    private Value(BuilderImpl builder) {
        this.isNull = builder.isNull;
        this.bitValue = builder.bitValue;
        this.bigIntValue = builder.bigIntValue;
        this.intValue = builder.intValue;
        this.doubleValue = builder.doubleValue;
        this.realValue = builder.realValue;
        this.stringValue = builder.stringValue;
        this.blobValue = builder.blobValue;
        this.arrayValues = builder.arrayValues;
        this.structValue = builder.structValue;
        this.type = builder.type;
    }

    public final Boolean isNull() {
        return this.isNull;
    }

    public final Boolean bitValue() {
        return this.bitValue;
    }

    public final Long bigIntValue() {
        return this.bigIntValue;
    }

    public final Integer intValue() {
        return this.intValue;
    }

    public final Double doubleValue() {
        return this.doubleValue;
    }

    public final Float realValue() {
        return this.realValue;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final SdkBytes blobValue() {
        return this.blobValue;
    }

    public final boolean hasArrayValues() {
        return this.arrayValues != null && !(this.arrayValues instanceof SdkAutoConstructList);
    }

    public final List<Value> arrayValues() {
        return this.arrayValues;
    }

    public final StructValue structValue() {
        return this.structValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isNull());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.bigIntValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.intValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.realValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.blobValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArrayValues() ? this.arrayValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.structValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Value)) {
            return false;
        }
        Value other = (Value)obj;
        return Objects.equals(this.isNull(), other.isNull()) && Objects.equals(this.bitValue(), other.bitValue()) && Objects.equals(this.bigIntValue(), other.bigIntValue()) && Objects.equals(this.intValue(), other.intValue()) && Objects.equals(this.doubleValue(), other.doubleValue()) && Objects.equals(this.realValue(), other.realValue()) && Objects.equals(this.stringValue(), other.stringValue()) && Objects.equals(this.blobValue(), other.blobValue()) && this.hasArrayValues() == other.hasArrayValues() && Objects.equals(this.arrayValues(), other.arrayValues()) && Objects.equals(this.structValue(), other.structValue());
    }

    public final String toString() {
        return ToString.builder((String)"Value").add("IsNull", (Object)this.isNull()).add("BitValue", (Object)this.bitValue()).add("BigIntValue", (Object)this.bigIntValue()).add("IntValue", (Object)this.intValue()).add("DoubleValue", (Object)this.doubleValue()).add("RealValue", (Object)this.realValue()).add("StringValue", (Object)this.stringValue()).add("BlobValue", (Object)this.blobValue()).add("ArrayValues", this.hasArrayValues() ? this.arrayValues() : null).add("StructValue", (Object)this.structValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isNull": {
                return Optional.ofNullable(clazz.cast(this.isNull()));
            }
            case "bitValue": {
                return Optional.ofNullable(clazz.cast(this.bitValue()));
            }
            case "bigIntValue": {
                return Optional.ofNullable(clazz.cast(this.bigIntValue()));
            }
            case "intValue": {
                return Optional.ofNullable(clazz.cast(this.intValue()));
            }
            case "doubleValue": {
                return Optional.ofNullable(clazz.cast(this.doubleValue()));
            }
            case "realValue": {
                return Optional.ofNullable(clazz.cast(this.realValue()));
            }
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "blobValue": {
                return Optional.ofNullable(clazz.cast(this.blobValue()));
            }
            case "arrayValues": {
                return Optional.ofNullable(clazz.cast(this.arrayValues()));
            }
            case "structValue": {
                return Optional.ofNullable(clazz.cast(this.structValue()));
            }
        }
        return Optional.empty();
    }

    public static Value fromIsNull(Boolean isNull) {
        return (Value)Value.builder().isNull(isNull).build();
    }

    public static Value fromBitValue(Boolean bitValue) {
        return (Value)Value.builder().bitValue(bitValue).build();
    }

    public static Value fromBigIntValue(Long bigIntValue) {
        return (Value)Value.builder().bigIntValue(bigIntValue).build();
    }

    public static Value fromIntValue(Integer intValue) {
        return (Value)Value.builder().intValue(intValue).build();
    }

    public static Value fromDoubleValue(Double doubleValue) {
        return (Value)Value.builder().doubleValue(doubleValue).build();
    }

    public static Value fromRealValue(Float realValue) {
        return (Value)Value.builder().realValue(realValue).build();
    }

    public static Value fromStringValue(String stringValue) {
        return (Value)Value.builder().stringValue(stringValue).build();
    }

    public static Value fromBlobValue(SdkBytes blobValue) {
        return (Value)Value.builder().blobValue(blobValue).build();
    }

    public static Value fromArrayValues(List<Value> arrayValues) {
        return (Value)Value.builder().arrayValues(arrayValues).build();
    }

    public static Value fromStructValue(StructValue structValue) {
        return (Value)Value.builder().structValue(structValue).build();
    }

    public static Value fromStructValue(Consumer<StructValue.Builder> structValue) {
        StructValue.Builder builder = StructValue.builder();
        structValue.accept(builder);
        return Value.fromStructValue((StructValue)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isNull", IS_NULL_FIELD);
        map.put("bitValue", BIT_VALUE_FIELD);
        map.put("bigIntValue", BIG_INT_VALUE_FIELD);
        map.put("intValue", INT_VALUE_FIELD);
        map.put("doubleValue", DOUBLE_VALUE_FIELD);
        map.put("realValue", REAL_VALUE_FIELD);
        map.put("stringValue", STRING_VALUE_FIELD);
        map.put("blobValue", BLOB_VALUE_FIELD);
        map.put("arrayValues", ARRAY_VALUES_FIELD);
        map.put("structValue", STRUCT_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Value, T> g) {
        return obj -> g.apply((Value)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        IS_NULL,
        BIT_VALUE,
        BIG_INT_VALUE,
        INT_VALUE,
        DOUBLE_VALUE,
        REAL_VALUE,
        STRING_VALUE,
        BLOB_VALUE,
        ARRAY_VALUES,
        STRUCT_VALUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isNull;
        private Boolean bitValue;
        private Long bigIntValue;
        private Integer intValue;
        private Double doubleValue;
        private Float realValue;
        private String stringValue;
        private SdkBytes blobValue;
        private List<Value> arrayValues = DefaultSdkAutoConstructList.getInstance();
        private StructValue structValue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Value model) {
            this.isNull(model.isNull);
            this.bitValue(model.bitValue);
            this.bigIntValue(model.bigIntValue);
            this.intValue(model.intValue);
            this.doubleValue(model.doubleValue);
            this.realValue(model.realValue);
            this.stringValue(model.stringValue);
            this.blobValue(model.blobValue);
            this.arrayValues(model.arrayValues);
            this.structValue(model.structValue);
        }

        public final Boolean getIsNull() {
            return this.isNull;
        }

        public final void setIsNull(Boolean isNull) {
            Boolean oldValue = this.isNull;
            this.isNull = isNull;
            this.handleUnionValueChange(Type.IS_NULL, oldValue, this.isNull);
        }

        @Override
        public final Builder isNull(Boolean isNull) {
            Boolean oldValue = this.isNull;
            this.isNull = isNull;
            this.handleUnionValueChange(Type.IS_NULL, oldValue, this.isNull);
            return this;
        }

        public final Boolean getBitValue() {
            return this.bitValue;
        }

        public final void setBitValue(Boolean bitValue) {
            Boolean oldValue = this.bitValue;
            this.bitValue = bitValue;
            this.handleUnionValueChange(Type.BIT_VALUE, oldValue, this.bitValue);
        }

        @Override
        public final Builder bitValue(Boolean bitValue) {
            Boolean oldValue = this.bitValue;
            this.bitValue = bitValue;
            this.handleUnionValueChange(Type.BIT_VALUE, oldValue, this.bitValue);
            return this;
        }

        public final Long getBigIntValue() {
            return this.bigIntValue;
        }

        public final void setBigIntValue(Long bigIntValue) {
            Long oldValue = this.bigIntValue;
            this.bigIntValue = bigIntValue;
            this.handleUnionValueChange(Type.BIG_INT_VALUE, oldValue, this.bigIntValue);
        }

        @Override
        public final Builder bigIntValue(Long bigIntValue) {
            Long oldValue = this.bigIntValue;
            this.bigIntValue = bigIntValue;
            this.handleUnionValueChange(Type.BIG_INT_VALUE, oldValue, this.bigIntValue);
            return this;
        }

        public final Integer getIntValue() {
            return this.intValue;
        }

        public final void setIntValue(Integer intValue) {
            Integer oldValue = this.intValue;
            this.intValue = intValue;
            this.handleUnionValueChange(Type.INT_VALUE, oldValue, this.intValue);
        }

        @Override
        public final Builder intValue(Integer intValue) {
            Integer oldValue = this.intValue;
            this.intValue = intValue;
            this.handleUnionValueChange(Type.INT_VALUE, oldValue, this.intValue);
            return this;
        }

        public final Double getDoubleValue() {
            return this.doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            Double oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            Double oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
            return this;
        }

        public final Float getRealValue() {
            return this.realValue;
        }

        public final void setRealValue(Float realValue) {
            Float oldValue = this.realValue;
            this.realValue = realValue;
            this.handleUnionValueChange(Type.REAL_VALUE, oldValue, this.realValue);
        }

        @Override
        public final Builder realValue(Float realValue) {
            Float oldValue = this.realValue;
            this.realValue = realValue;
            this.handleUnionValueChange(Type.REAL_VALUE, oldValue, this.realValue);
            return this;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final ByteBuffer getBlobValue() {
            return this.blobValue == null ? null : this.blobValue.asByteBuffer();
        }

        public final void setBlobValue(ByteBuffer blobValue) {
            this.blobValue(blobValue == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)blobValue));
        }

        @Override
        public final Builder blobValue(SdkBytes blobValue) {
            SdkBytes oldValue = this.blobValue;
            this.blobValue = blobValue;
            this.handleUnionValueChange(Type.BLOB_VALUE, oldValue, this.blobValue);
            return this;
        }

        public final List<Builder> getArrayValues() {
            List<Builder> result = ArrayValueListCopier.copyToBuilder(this.arrayValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArrayValues(Collection<BuilderImpl> arrayValues) {
            List<Value> oldValue = this.arrayValues;
            this.arrayValues = ArrayValueListCopier.copyFromBuilder(arrayValues);
            this.handleUnionValueChange(Type.ARRAY_VALUES, oldValue, this.arrayValues);
        }

        @Override
        public final Builder arrayValues(Collection<Value> arrayValues) {
            List<Value> oldValue = this.arrayValues;
            this.arrayValues = ArrayValueListCopier.copy(arrayValues);
            this.handleUnionValueChange(Type.ARRAY_VALUES, oldValue, this.arrayValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValues(Value ... arrayValues) {
            this.arrayValues(Arrays.asList(arrayValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValues(Consumer<Builder> ... arrayValues) {
            this.arrayValues(Stream.of(arrayValues).map(c -> (Value)((Builder)Value.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final StructValue.Builder getStructValue() {
            return this.structValue != null ? this.structValue.toBuilder() : null;
        }

        public final void setStructValue(StructValue.BuilderImpl structValue) {
            StructValue oldValue = this.structValue;
            this.structValue = structValue != null ? structValue.build() : null;
            this.handleUnionValueChange(Type.STRUCT_VALUE, oldValue, this.structValue);
        }

        @Override
        public final Builder structValue(StructValue structValue) {
            StructValue oldValue = this.structValue;
            this.structValue = structValue;
            this.handleUnionValueChange(Type.STRUCT_VALUE, oldValue, this.structValue);
            return this;
        }

        public Value build() {
            return new Value(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Value> {
        public Builder isNull(Boolean var1);

        public Builder bitValue(Boolean var1);

        public Builder bigIntValue(Long var1);

        public Builder intValue(Integer var1);

        public Builder doubleValue(Double var1);

        public Builder realValue(Float var1);

        public Builder stringValue(String var1);

        public Builder blobValue(SdkBytes var1);

        public Builder arrayValues(Collection<Value> var1);

        public Builder arrayValues(Value ... var1);

        public Builder arrayValues(Consumer<Builder> ... var1);

        public Builder structValue(StructValue var1);

        default public Builder structValue(Consumer<StructValue.Builder> structValue) {
            return this.structValue((StructValue)((StructValue.Builder)StructValue.builder().applyMutation(structValue)).build());
        }
    }
}

