/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request parameters represent the input of a request to run one or more SQL statements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteSqlRequest extends RdsDataRequest implements
        ToCopyableBuilder<ExecuteSqlRequest.Builder, ExecuteSqlRequest> {
    private static final SdkField<String> DB_CLUSTER_OR_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbClusterOrInstanceArn").getter(getter(ExecuteSqlRequest::dbClusterOrInstanceArn))
            .setter(setter(Builder::dbClusterOrInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbClusterOrInstanceArn").build())
            .build();

    private static final SdkField<String> AWS_SECRET_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsSecretStoreArn").getter(getter(ExecuteSqlRequest::awsSecretStoreArn))
            .setter(setter(Builder::awsSecretStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsSecretStoreArn").build()).build();

    private static final SdkField<String> SQL_STATEMENTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sqlStatements").getter(getter(ExecuteSqlRequest::sqlStatements)).setter(setter(Builder::sqlStatements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlStatements").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("database").getter(getter(ExecuteSqlRequest::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("database").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("schema")
            .getter(getter(ExecuteSqlRequest::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DB_CLUSTER_OR_INSTANCE_ARN_FIELD, AWS_SECRET_STORE_ARN_FIELD, SQL_STATEMENTS_FIELD, DATABASE_FIELD, SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbClusterOrInstanceArn;

    private final String awsSecretStoreArn;

    private final String sqlStatements;

    private final String database;

    private final String schema;

    private ExecuteSqlRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterOrInstanceArn = builder.dbClusterOrInstanceArn;
        this.awsSecretStoreArn = builder.awsSecretStoreArn;
        this.sqlStatements = builder.sqlStatements;
        this.database = builder.database;
        this.schema = builder.schema;
    }

    /**
     * <p>
     * The ARN of the Aurora Serverless DB cluster.
     * </p>
     * 
     * @return The ARN of the Aurora Serverless DB cluster.
     */
    public final String dbClusterOrInstanceArn() {
        return dbClusterOrInstanceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster. Enter the database user name
     * and password for the credentials in the secret.
     * </p>
     * <p>
     * For information about creating the secret, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/create_database_secret.html">Create a database
     * secret</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster. Enter the database
     *         user name and password for the credentials in the secret.</p>
     *         <p>
     *         For information about creating the secret, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/create_database_secret.html">Create a
     *         database secret</a>.
     */
    public final String awsSecretStoreArn() {
        return awsSecretStoreArn;
    }

    /**
     * <p>
     * One or more SQL statements to run on the DB cluster.
     * </p>
     * <p>
     * You can separate SQL statements from each other with a semicolon (;). Any valid SQL statement is permitted,
     * including data definition, data manipulation, and commit statements.
     * </p>
     * 
     * @return One or more SQL statements to run on the DB cluster.</p>
     *         <p>
     *         You can separate SQL statements from each other with a semicolon (;). Any valid SQL statement is
     *         permitted, including data definition, data manipulation, and commit statements.
     */
    public final String sqlStatements() {
        return sqlStatements;
    }

    /**
     * <p>
     * The name of the database.
     * </p>
     * 
     * @return The name of the database.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The name of the database schema.
     * </p>
     * 
     * @return The name of the database schema.
     */
    public final String schema() {
        return schema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterOrInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(awsSecretStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(sqlStatements());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteSqlRequest)) {
            return false;
        }
        ExecuteSqlRequest other = (ExecuteSqlRequest) obj;
        return Objects.equals(dbClusterOrInstanceArn(), other.dbClusterOrInstanceArn())
                && Objects.equals(awsSecretStoreArn(), other.awsSecretStoreArn())
                && Objects.equals(sqlStatements(), other.sqlStatements()) && Objects.equals(database(), other.database())
                && Objects.equals(schema(), other.schema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteSqlRequest").add("DbClusterOrInstanceArn", dbClusterOrInstanceArn())
                .add("AwsSecretStoreArn", awsSecretStoreArn()).add("SqlStatements", sqlStatements()).add("Database", database())
                .add("Schema", schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dbClusterOrInstanceArn":
            return Optional.ofNullable(clazz.cast(dbClusterOrInstanceArn()));
        case "awsSecretStoreArn":
            return Optional.ofNullable(clazz.cast(awsSecretStoreArn()));
        case "sqlStatements":
            return Optional.ofNullable(clazz.cast(sqlStatements()));
        case "database":
            return Optional.ofNullable(clazz.cast(database()));
        case "schema":
            return Optional.ofNullable(clazz.cast(schema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dbClusterOrInstanceArn", DB_CLUSTER_OR_INSTANCE_ARN_FIELD);
        map.put("awsSecretStoreArn", AWS_SECRET_STORE_ARN_FIELD);
        map.put("sqlStatements", SQL_STATEMENTS_FIELD);
        map.put("database", DATABASE_FIELD);
        map.put("schema", SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteSqlRequest, T> g) {
        return obj -> g.apply((ExecuteSqlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteSqlRequest> {
        /**
         * <p>
         * The ARN of the Aurora Serverless DB cluster.
         * </p>
         * 
         * @param dbClusterOrInstanceArn
         *        The ARN of the Aurora Serverless DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterOrInstanceArn(String dbClusterOrInstanceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster. Enter the database user
         * name and password for the credentials in the secret.
         * </p>
         * <p>
         * For information about creating the secret, see <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/create_database_secret.html">Create a
         * database secret</a>.
         * </p>
         * 
         * @param awsSecretStoreArn
         *        The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster. Enter the database
         *        user name and password for the credentials in the secret.</p>
         *        <p>
         *        For information about creating the secret, see <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/create_database_secret.html">Create
         *        a database secret</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSecretStoreArn(String awsSecretStoreArn);

        /**
         * <p>
         * One or more SQL statements to run on the DB cluster.
         * </p>
         * <p>
         * You can separate SQL statements from each other with a semicolon (;). Any valid SQL statement is permitted,
         * including data definition, data manipulation, and commit statements.
         * </p>
         * 
         * @param sqlStatements
         *        One or more SQL statements to run on the DB cluster.</p>
         *        <p>
         *        You can separate SQL statements from each other with a semicolon (;). Any valid SQL statement is
         *        permitted, including data definition, data manipulation, and commit statements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlStatements(String sqlStatements);

        /**
         * <p>
         * The name of the database.
         * </p>
         * 
         * @param database
         *        The name of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The name of the database schema.
         * </p>
         * 
         * @param schema
         *        The name of the database schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsDataRequest.BuilderImpl implements Builder {
        private String dbClusterOrInstanceArn;

        private String awsSecretStoreArn;

        private String sqlStatements;

        private String database;

        private String schema;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteSqlRequest model) {
            super(model);
            dbClusterOrInstanceArn(model.dbClusterOrInstanceArn);
            awsSecretStoreArn(model.awsSecretStoreArn);
            sqlStatements(model.sqlStatements);
            database(model.database);
            schema(model.schema);
        }

        public final String getDbClusterOrInstanceArn() {
            return dbClusterOrInstanceArn;
        }

        public final void setDbClusterOrInstanceArn(String dbClusterOrInstanceArn) {
            this.dbClusterOrInstanceArn = dbClusterOrInstanceArn;
        }

        @Override
        public final Builder dbClusterOrInstanceArn(String dbClusterOrInstanceArn) {
            this.dbClusterOrInstanceArn = dbClusterOrInstanceArn;
            return this;
        }

        public final String getAwsSecretStoreArn() {
            return awsSecretStoreArn;
        }

        public final void setAwsSecretStoreArn(String awsSecretStoreArn) {
            this.awsSecretStoreArn = awsSecretStoreArn;
        }

        @Override
        public final Builder awsSecretStoreArn(String awsSecretStoreArn) {
            this.awsSecretStoreArn = awsSecretStoreArn;
            return this;
        }

        public final String getSqlStatements() {
            return sqlStatements;
        }

        public final void setSqlStatements(String sqlStatements) {
            this.sqlStatements = sqlStatements;
        }

        @Override
        public final Builder sqlStatements(String sqlStatements) {
            this.sqlStatements = sqlStatements;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getSchema() {
            return schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteSqlRequest build() {
            return new ExecuteSqlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
