/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response elements represent the output of a request to run a SQL statement against a database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteStatementResponse extends RdsDataResponse implements
        ToCopyableBuilder<ExecuteStatementResponse.Builder, ExecuteStatementResponse> {
    private static final SdkField<List<List<Field>>> RECORDS_FIELD = SdkField
            .<List<List<Field>>> builder(MarshallingType.LIST)
            .memberName("records")
            .getter(getter(ExecuteStatementResponse::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<Field>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(Field::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<ColumnMetadata>> COLUMN_METADATA_FIELD = SdkField
            .<List<ColumnMetadata>> builder(MarshallingType.LIST)
            .memberName("columnMetadata")
            .getter(getter(ExecuteStatementResponse::columnMetadata))
            .setter(setter(Builder::columnMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> NUMBER_OF_RECORDS_UPDATED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numberOfRecordsUpdated").getter(getter(ExecuteStatementResponse::numberOfRecordsUpdated))
            .setter(setter(Builder::numberOfRecordsUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecordsUpdated").build())
            .build();

    private static final SdkField<List<Field>> GENERATED_FIELDS_FIELD = SdkField
            .<List<Field>> builder(MarshallingType.LIST)
            .memberName("generatedFields")
            .getter(getter(ExecuteStatementResponse::generatedFields))
            .setter(setter(Builder::generatedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                            .constructor(Field::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FORMATTED_RECORDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("formattedRecords").getter(getter(ExecuteStatementResponse::formattedRecords))
            .setter(setter(Builder::formattedRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formattedRecords").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD,
            COLUMN_METADATA_FIELD, NUMBER_OF_RECORDS_UPDATED_FIELD, GENERATED_FIELDS_FIELD, FORMATTED_RECORDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<List<Field>> records;

    private final List<ColumnMetadata> columnMetadata;

    private final Long numberOfRecordsUpdated;

    private final List<Field> generatedFields;

    private final String formattedRecords;

    private ExecuteStatementResponse(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.columnMetadata = builder.columnMetadata;
        this.numberOfRecordsUpdated = builder.numberOfRecordsUpdated;
        this.generatedFields = builder.generatedFields;
        this.formattedRecords = builder.formattedRecords;
    }

    /**
     * For responses, this returns true if the service returned a value for the Records property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The records returned by the SQL statement. This field is blank if the <code>formatRecordsAs</code> parameter is
     * set to <code>JSON</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecords} method.
     * </p>
     * 
     * @return The records returned by the SQL statement. This field is blank if the <code>formatRecordsAs</code>
     *         parameter is set to <code>JSON</code>.
     */
    public final List<List<Field>> records() {
        return records;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnMetadata property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnMetadata() {
        return columnMetadata != null && !(columnMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata for the columns included in the results. This field is blank if the <code>formatRecordsAs</code>
     * parameter is set to <code>JSON</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnMetadata} method.
     * </p>
     * 
     * @return Metadata for the columns included in the results. This field is blank if the <code>formatRecordsAs</code>
     *         parameter is set to <code>JSON</code>.
     */
    public final List<ColumnMetadata> columnMetadata() {
        return columnMetadata;
    }

    /**
     * <p>
     * The number of records updated by the request.
     * </p>
     * 
     * @return The number of records updated by the request.
     */
    public final Long numberOfRecordsUpdated() {
        return numberOfRecordsUpdated;
    }

    /**
     * For responses, this returns true if the service returned a value for the GeneratedFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGeneratedFields() {
        return generatedFields != null && !(generatedFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Values for fields generated during a DML request.
     * </p>
     * <note>
     * <p>
     * The <code>generatedFields</code> data isn't supported by Aurora PostgreSQL. To get the values of generated
     * fields, use the <code>RETURNING</code> clause. For more information, see <a
     * href="https://www.postgresql.org/docs/10/dml-returning.html">Returning Data From Modified Rows</a> in the
     * PostgreSQL documentation.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGeneratedFields} method.
     * </p>
     * 
     * @return Values for fields generated during a DML request.</p> <note>
     *         <p>
     *         The <code>generatedFields</code> data isn't supported by Aurora PostgreSQL. To get the values of
     *         generated fields, use the <code>RETURNING</code> clause. For more information, see <a
     *         href="https://www.postgresql.org/docs/10/dml-returning.html">Returning Data From Modified Rows</a> in the
     *         PostgreSQL documentation.
     *         </p>
     */
    public final List<Field> generatedFields() {
        return generatedFields;
    }

    /**
     * <p>
     * A string value that represents the result set of a <code>SELECT</code> statement in JSON format. This value is
     * only present when the <code>formatRecordsAs</code> parameter is set to <code>JSON</code>.
     * </p>
     * <p>
     * The size limit for this field is currently 10 MB. If the JSON-formatted string representing the result set
     * requires more than 10 MB, the call returns an error.
     * </p>
     * 
     * @return A string value that represents the result set of a <code>SELECT</code> statement in JSON format. This
     *         value is only present when the <code>formatRecordsAs</code> parameter is set to <code>JSON</code>.</p>
     *         <p>
     *         The size limit for this field is currently 10 MB. If the JSON-formatted string representing the result
     *         set requires more than 10 MB, the call returns an error.
     */
    public final String formattedRecords() {
        return formattedRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRecords() ? records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnMetadata() ? columnMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRecordsUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(hasGeneratedFields() ? generatedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(formattedRecords());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementResponse)) {
            return false;
        }
        ExecuteStatementResponse other = (ExecuteStatementResponse) obj;
        return hasRecords() == other.hasRecords() && Objects.equals(records(), other.records())
                && hasColumnMetadata() == other.hasColumnMetadata() && Objects.equals(columnMetadata(), other.columnMetadata())
                && Objects.equals(numberOfRecordsUpdated(), other.numberOfRecordsUpdated())
                && hasGeneratedFields() == other.hasGeneratedFields()
                && Objects.equals(generatedFields(), other.generatedFields())
                && Objects.equals(formattedRecords(), other.formattedRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteStatementResponse").add("Records", hasRecords() ? records() : null)
                .add("ColumnMetadata", hasColumnMetadata() ? columnMetadata() : null)
                .add("NumberOfRecordsUpdated", numberOfRecordsUpdated())
                .add("GeneratedFields", hasGeneratedFields() ? generatedFields() : null)
                .add("FormattedRecords", formattedRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "records":
            return Optional.ofNullable(clazz.cast(records()));
        case "columnMetadata":
            return Optional.ofNullable(clazz.cast(columnMetadata()));
        case "numberOfRecordsUpdated":
            return Optional.ofNullable(clazz.cast(numberOfRecordsUpdated()));
        case "generatedFields":
            return Optional.ofNullable(clazz.cast(generatedFields()));
        case "formattedRecords":
            return Optional.ofNullable(clazz.cast(formattedRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("records", RECORDS_FIELD);
        map.put("columnMetadata", COLUMN_METADATA_FIELD);
        map.put("numberOfRecordsUpdated", NUMBER_OF_RECORDS_UPDATED_FIELD);
        map.put("generatedFields", GENERATED_FIELDS_FIELD);
        map.put("formattedRecords", FORMATTED_RECORDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteStatementResponse, T> g) {
        return obj -> g.apply((ExecuteStatementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteStatementResponse> {
        /**
         * <p>
         * The records returned by the SQL statement. This field is blank if the <code>formatRecordsAs</code> parameter
         * is set to <code>JSON</code>.
         * </p>
         * 
         * @param records
         *        The records returned by the SQL statement. This field is blank if the <code>formatRecordsAs</code>
         *        parameter is set to <code>JSON</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<? extends Collection<Field>> records);

        /**
         * <p>
         * The records returned by the SQL statement. This field is blank if the <code>formatRecordsAs</code> parameter
         * is set to <code>JSON</code>.
         * </p>
         * 
         * @param records
         *        The records returned by the SQL statement. This field is blank if the <code>formatRecordsAs</code>
         *        parameter is set to <code>JSON</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<Field>... records);

        /**
         * <p>
         * Metadata for the columns included in the results. This field is blank if the <code>formatRecordsAs</code>
         * parameter is set to <code>JSON</code>.
         * </p>
         * 
         * @param columnMetadata
         *        Metadata for the columns included in the results. This field is blank if the
         *        <code>formatRecordsAs</code> parameter is set to <code>JSON</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnMetadata(Collection<ColumnMetadata> columnMetadata);

        /**
         * <p>
         * Metadata for the columns included in the results. This field is blank if the <code>formatRecordsAs</code>
         * parameter is set to <code>JSON</code>.
         * </p>
         * 
         * @param columnMetadata
         *        Metadata for the columns included in the results. This field is blank if the
         *        <code>formatRecordsAs</code> parameter is set to <code>JSON</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnMetadata(ColumnMetadata... columnMetadata);

        /**
         * <p>
         * Metadata for the columns included in the results. This field is blank if the <code>formatRecordsAs</code>
         * parameter is set to <code>JSON</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rdsdata.model.ColumnMetadata.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rdsdata.model.ColumnMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rdsdata.model.ColumnMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #columnMetadata(List<ColumnMetadata>)}.
         * 
         * @param columnMetadata
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rdsdata.model.ColumnMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnMetadata(java.util.Collection<ColumnMetadata>)
         */
        Builder columnMetadata(Consumer<ColumnMetadata.Builder>... columnMetadata);

        /**
         * <p>
         * The number of records updated by the request.
         * </p>
         * 
         * @param numberOfRecordsUpdated
         *        The number of records updated by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRecordsUpdated(Long numberOfRecordsUpdated);

        /**
         * <p>
         * Values for fields generated during a DML request.
         * </p>
         * <note>
         * <p>
         * The <code>generatedFields</code> data isn't supported by Aurora PostgreSQL. To get the values of generated
         * fields, use the <code>RETURNING</code> clause. For more information, see <a
         * href="https://www.postgresql.org/docs/10/dml-returning.html">Returning Data From Modified Rows</a> in the
         * PostgreSQL documentation.
         * </p>
         * </note>
         * 
         * @param generatedFields
         *        Values for fields generated during a DML request.</p> <note>
         *        <p>
         *        The <code>generatedFields</code> data isn't supported by Aurora PostgreSQL. To get the values of
         *        generated fields, use the <code>RETURNING</code> clause. For more information, see <a
         *        href="https://www.postgresql.org/docs/10/dml-returning.html">Returning Data From Modified Rows</a> in
         *        the PostgreSQL documentation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedFields(Collection<Field> generatedFields);

        /**
         * <p>
         * Values for fields generated during a DML request.
         * </p>
         * <note>
         * <p>
         * The <code>generatedFields</code> data isn't supported by Aurora PostgreSQL. To get the values of generated
         * fields, use the <code>RETURNING</code> clause. For more information, see <a
         * href="https://www.postgresql.org/docs/10/dml-returning.html">Returning Data From Modified Rows</a> in the
         * PostgreSQL documentation.
         * </p>
         * </note>
         * 
         * @param generatedFields
         *        Values for fields generated during a DML request.</p> <note>
         *        <p>
         *        The <code>generatedFields</code> data isn't supported by Aurora PostgreSQL. To get the values of
         *        generated fields, use the <code>RETURNING</code> clause. For more information, see <a
         *        href="https://www.postgresql.org/docs/10/dml-returning.html">Returning Data From Modified Rows</a> in
         *        the PostgreSQL documentation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedFields(Field... generatedFields);

        /**
         * <p>
         * Values for fields generated during a DML request.
         * </p>
         * <note>
         * <p>
         * The <code>generatedFields</code> data isn't supported by Aurora PostgreSQL. To get the values of generated
         * fields, use the <code>RETURNING</code> clause. For more information, see <a
         * href="https://www.postgresql.org/docs/10/dml-returning.html">Returning Data From Modified Rows</a> in the
         * PostgreSQL documentation.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rdsdata.model.Field.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.rdsdata.model.Field#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rdsdata.model.Field.Builder#build()} is called immediately and its
         * result is passed to {@link #generatedFields(List<Field>)}.
         * 
         * @param generatedFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rdsdata.model.Field.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generatedFields(java.util.Collection<Field>)
         */
        Builder generatedFields(Consumer<Field.Builder>... generatedFields);

        /**
         * <p>
         * A string value that represents the result set of a <code>SELECT</code> statement in JSON format. This value
         * is only present when the <code>formatRecordsAs</code> parameter is set to <code>JSON</code>.
         * </p>
         * <p>
         * The size limit for this field is currently 10 MB. If the JSON-formatted string representing the result set
         * requires more than 10 MB, the call returns an error.
         * </p>
         * 
         * @param formattedRecords
         *        A string value that represents the result set of a <code>SELECT</code> statement in JSON format. This
         *        value is only present when the <code>formatRecordsAs</code> parameter is set to <code>JSON</code>.</p>
         *        <p>
         *        The size limit for this field is currently 10 MB. If the JSON-formatted string representing the result
         *        set requires more than 10 MB, the call returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formattedRecords(String formattedRecords);
    }

    static final class BuilderImpl extends RdsDataResponse.BuilderImpl implements Builder {
        private List<List<Field>> records = DefaultSdkAutoConstructList.getInstance();

        private List<ColumnMetadata> columnMetadata = DefaultSdkAutoConstructList.getInstance();

        private Long numberOfRecordsUpdated;

        private List<Field> generatedFields = DefaultSdkAutoConstructList.getInstance();

        private String formattedRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteStatementResponse model) {
            super(model);
            records(model.records);
            columnMetadata(model.columnMetadata);
            numberOfRecordsUpdated(model.numberOfRecordsUpdated);
            generatedFields(model.generatedFields);
            formattedRecords(model.formattedRecords);
        }

        public final List<List<Field.Builder>> getRecords() {
            List<List<Field.Builder>> result = SqlRecordsCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<? extends Collection<Field.BuilderImpl>> records) {
            this.records = SqlRecordsCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<? extends Collection<Field>> records) {
            this.records = SqlRecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Collection<Field>... records) {
            records(Arrays.asList(records));
            return this;
        }

        public final List<ColumnMetadata.Builder> getColumnMetadata() {
            List<ColumnMetadata.Builder> result = MetadataCopier.copyToBuilder(this.columnMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnMetadata(Collection<ColumnMetadata.BuilderImpl> columnMetadata) {
            this.columnMetadata = MetadataCopier.copyFromBuilder(columnMetadata);
        }

        @Override
        public final Builder columnMetadata(Collection<ColumnMetadata> columnMetadata) {
            this.columnMetadata = MetadataCopier.copy(columnMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(ColumnMetadata... columnMetadata) {
            columnMetadata(Arrays.asList(columnMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(Consumer<ColumnMetadata.Builder>... columnMetadata) {
            columnMetadata(Stream.of(columnMetadata).map(c -> ColumnMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Long getNumberOfRecordsUpdated() {
            return numberOfRecordsUpdated;
        }

        public final void setNumberOfRecordsUpdated(Long numberOfRecordsUpdated) {
            this.numberOfRecordsUpdated = numberOfRecordsUpdated;
        }

        @Override
        public final Builder numberOfRecordsUpdated(Long numberOfRecordsUpdated) {
            this.numberOfRecordsUpdated = numberOfRecordsUpdated;
            return this;
        }

        public final List<Field.Builder> getGeneratedFields() {
            List<Field.Builder> result = FieldListCopier.copyToBuilder(this.generatedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeneratedFields(Collection<Field.BuilderImpl> generatedFields) {
            this.generatedFields = FieldListCopier.copyFromBuilder(generatedFields);
        }

        @Override
        public final Builder generatedFields(Collection<Field> generatedFields) {
            this.generatedFields = FieldListCopier.copy(generatedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedFields(Field... generatedFields) {
            generatedFields(Arrays.asList(generatedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedFields(Consumer<Field.Builder>... generatedFields) {
            generatedFields(Stream.of(generatedFields).map(c -> Field.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFormattedRecords() {
            return formattedRecords;
        }

        public final void setFormattedRecords(String formattedRecords) {
            this.formattedRecords = formattedRecords;
        }

        @Override
        public final Builder formattedRecords(String formattedRecords) {
            this.formattedRecords = formattedRecords;
            return this;
        }

        @Override
        public ExecuteStatementResponse build() {
            return new ExecuteStatementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
