/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * List of columns and their types.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultSetMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ResultSetMetadata.Builder, ResultSetMetadata> {
    private static final SdkField<Long> COLUMN_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ResultSetMetadata::columnCount)).setter(setter(Builder::columnCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnCount").build()).build();

    private static final SdkField<List<ColumnMetadata>> COLUMN_METADATA_FIELD = SdkField
            .<List<ColumnMetadata>> builder(MarshallingType.LIST)
            .getter(getter(ResultSetMetadata::columnMetadata))
            .setter(setter(Builder::columnMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_COUNT_FIELD,
            COLUMN_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long columnCount;

    private final List<ColumnMetadata> columnMetadata;

    private ResultSetMetadata(BuilderImpl builder) {
        this.columnCount = builder.columnCount;
        this.columnMetadata = builder.columnMetadata;
    }

    /**
     * Number of columns
     * 
     * @return Number of columns
     */
    public Long columnCount() {
        return columnCount;
    }

    /**
     * List of columns and their types
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of columns and their types
     */
    public List<ColumnMetadata> columnMetadata() {
        return columnMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnCount());
        hashCode = 31 * hashCode + Objects.hashCode(columnMetadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSetMetadata)) {
            return false;
        }
        ResultSetMetadata other = (ResultSetMetadata) obj;
        return Objects.equals(columnCount(), other.columnCount()) && Objects.equals(columnMetadata(), other.columnMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResultSetMetadata").add("ColumnCount", columnCount()).add("ColumnMetadata", columnMetadata())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columnCount":
            return Optional.ofNullable(clazz.cast(columnCount()));
        case "columnMetadata":
            return Optional.ofNullable(clazz.cast(columnMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultSetMetadata, T> g) {
        return obj -> g.apply((ResultSetMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultSetMetadata> {
        /**
         * Number of columns
         * 
         * @param columnCount
         *        Number of columns
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnCount(Long columnCount);

        /**
         * List of columns and their types
         * 
         * @param columnMetadata
         *        List of columns and their types
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnMetadata(Collection<ColumnMetadata> columnMetadata);

        /**
         * List of columns and their types
         * 
         * @param columnMetadata
         *        List of columns and their types
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnMetadata(ColumnMetadata... columnMetadata);

        /**
         * List of columns and their types This is a convenience that creates an instance of the {@link List
         * <ColumnMetadata>.Builder} avoiding the need to create one manually via {@link List<ColumnMetadata>#builder()}
         * .
         *
         * When the {@link Consumer} completes, {@link List<ColumnMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #columnMetadata(List<ColumnMetadata>)}.
         * 
         * @param columnMetadata
         *        a consumer that will call methods on {@link List<ColumnMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnMetadata(List<ColumnMetadata>)
         */
        Builder columnMetadata(Consumer<ColumnMetadata.Builder>... columnMetadata);
    }

    static final class BuilderImpl implements Builder {
        private Long columnCount;

        private List<ColumnMetadata> columnMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResultSetMetadata model) {
            columnCount(model.columnCount);
            columnMetadata(model.columnMetadata);
        }

        public final Long getColumnCount() {
            return columnCount;
        }

        @Override
        public final Builder columnCount(Long columnCount) {
            this.columnCount = columnCount;
            return this;
        }

        public final void setColumnCount(Long columnCount) {
            this.columnCount = columnCount;
        }

        public final Collection<ColumnMetadata.Builder> getColumnMetadata() {
            return columnMetadata != null ? columnMetadata.stream().map(ColumnMetadata::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder columnMetadata(Collection<ColumnMetadata> columnMetadata) {
            this.columnMetadata = ColumnMetadataListCopier.copy(columnMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(ColumnMetadata... columnMetadata) {
            columnMetadata(Arrays.asList(columnMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(Consumer<ColumnMetadata.Builder>... columnMetadata) {
            columnMetadata(Stream.of(columnMetadata).map(c -> ColumnMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setColumnMetadata(Collection<ColumnMetadata.BuilderImpl> columnMetadata) {
            this.columnMetadata = ColumnMetadataListCopier.copyFromBuilder(columnMetadata);
        }

        @Override
        public ResultSetMetadata build() {
            return new ResultSetMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
