/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Column value
 */
@Generated("software.amazon.awssdk:codegen")
public final class Value implements SdkPojo, Serializable, ToCopyableBuilder<Value.Builder, Value> {
    private static final SdkField<List<Value>> ARRAY_VALUES_FIELD = SdkField
            .<List<Value>> builder(MarshallingType.LIST)
            .getter(getter(Value::arrayValues))
            .setter(setter(Builder::arrayValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Value> builder(MarshallingType.SDK_POJO)
                                            .constructor(Value::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> BIG_INT_VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Value::bigIntValue)).setter(setter(Builder::bigIntValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bigIntValue").build()).build();

    private static final SdkField<Boolean> BIT_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Value::bitValue)).setter(setter(Builder::bitValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitValue").build()).build();

    private static final SdkField<SdkBytes> BLOB_VALUE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(Value::blobValue)).setter(setter(Builder::blobValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobValue").build()).build();

    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Value::doubleValue)).setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()).build();

    private static final SdkField<Integer> INT_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Value::intValue)).setter(setter(Builder::intValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intValue").build()).build();

    private static final SdkField<Boolean> IS_NULL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Value::isNull)).setter(setter(Builder::isNull))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isNull").build()).build();

    private static final SdkField<Float> REAL_VALUE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(Value::realValue)).setter(setter(Builder::realValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("realValue").build()).build();

    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Value::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final SdkField<StructValue> STRUCT_VALUE_FIELD = SdkField.<StructValue> builder(MarshallingType.SDK_POJO)
            .getter(getter(Value::structValue)).setter(setter(Builder::structValue)).constructor(StructValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("structValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARRAY_VALUES_FIELD,
            BIG_INT_VALUE_FIELD, BIT_VALUE_FIELD, BLOB_VALUE_FIELD, DOUBLE_VALUE_FIELD, INT_VALUE_FIELD, IS_NULL_FIELD,
            REAL_VALUE_FIELD, STRING_VALUE_FIELD, STRUCT_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Value> arrayValues;

    private final Long bigIntValue;

    private final Boolean bitValue;

    private final SdkBytes blobValue;

    private final Double doubleValue;

    private final Integer intValue;

    private final Boolean isNull;

    private final Float realValue;

    private final String stringValue;

    private final StructValue structValue;

    private Value(BuilderImpl builder) {
        this.arrayValues = builder.arrayValues;
        this.bigIntValue = builder.bigIntValue;
        this.bitValue = builder.bitValue;
        this.blobValue = builder.blobValue;
        this.doubleValue = builder.doubleValue;
        this.intValue = builder.intValue;
        this.isNull = builder.isNull;
        this.realValue = builder.realValue;
        this.stringValue = builder.stringValue;
        this.structValue = builder.structValue;
    }

    /**
     * Arbitrarily nested arrays
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Arbitrarily nested arrays
     */
    public List<Value> arrayValues() {
        return arrayValues;
    }

    /**
     * Long value
     * 
     * @return Long value
     */
    public Long bigIntValue() {
        return bigIntValue;
    }

    /**
     * Bit value
     * 
     * @return Bit value
     */
    public Boolean bitValue() {
        return bitValue;
    }

    /**
     * Blob value
     * 
     * @return Blob value
     */
    public SdkBytes blobValue() {
        return blobValue;
    }

    /**
     * Double value
     * 
     * @return Double value
     */
    public Double doubleValue() {
        return doubleValue;
    }

    /**
     * Integer value
     * 
     * @return Integer value
     */
    public Integer intValue() {
        return intValue;
    }

    /**
     * Is column null
     * 
     * @return Is column null
     */
    public Boolean isNull() {
        return isNull;
    }

    /**
     * Float value
     * 
     * @return Float value
     */
    public Float realValue() {
        return realValue;
    }

    /**
     * String value
     * 
     * @return String value
     */
    public String stringValue() {
        return stringValue;
    }

    /**
     * Struct or UDT
     * 
     * @return Struct or UDT
     */
    public StructValue structValue() {
        return structValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arrayValues());
        hashCode = 31 * hashCode + Objects.hashCode(bigIntValue());
        hashCode = 31 * hashCode + Objects.hashCode(bitValue());
        hashCode = 31 * hashCode + Objects.hashCode(blobValue());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(intValue());
        hashCode = 31 * hashCode + Objects.hashCode(isNull());
        hashCode = 31 * hashCode + Objects.hashCode(realValue());
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(structValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Value)) {
            return false;
        }
        Value other = (Value) obj;
        return Objects.equals(arrayValues(), other.arrayValues()) && Objects.equals(bigIntValue(), other.bigIntValue())
                && Objects.equals(bitValue(), other.bitValue()) && Objects.equals(blobValue(), other.blobValue())
                && Objects.equals(doubleValue(), other.doubleValue()) && Objects.equals(intValue(), other.intValue())
                && Objects.equals(isNull(), other.isNull()) && Objects.equals(realValue(), other.realValue())
                && Objects.equals(stringValue(), other.stringValue()) && Objects.equals(structValue(), other.structValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Value").add("ArrayValues", arrayValues()).add("BigIntValue", bigIntValue())
                .add("BitValue", bitValue()).add("BlobValue", blobValue()).add("DoubleValue", doubleValue())
                .add("IntValue", intValue()).add("IsNull", isNull()).add("RealValue", realValue())
                .add("StringValue", stringValue()).add("StructValue", structValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arrayValues":
            return Optional.ofNullable(clazz.cast(arrayValues()));
        case "bigIntValue":
            return Optional.ofNullable(clazz.cast(bigIntValue()));
        case "bitValue":
            return Optional.ofNullable(clazz.cast(bitValue()));
        case "blobValue":
            return Optional.ofNullable(clazz.cast(blobValue()));
        case "doubleValue":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "intValue":
            return Optional.ofNullable(clazz.cast(intValue()));
        case "isNull":
            return Optional.ofNullable(clazz.cast(isNull()));
        case "realValue":
            return Optional.ofNullable(clazz.cast(realValue()));
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "structValue":
            return Optional.ofNullable(clazz.cast(structValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Value, T> g) {
        return obj -> g.apply((Value) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Value> {
        /**
         * Arbitrarily nested arrays
         * 
         * @param arrayValues
         *        Arbitrarily nested arrays
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayValues(Collection<Value> arrayValues);

        /**
         * Arbitrarily nested arrays
         * 
         * @param arrayValues
         *        Arbitrarily nested arrays
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayValues(Value... arrayValues);

        /**
         * Arbitrarily nested arrays This is a convenience that creates an instance of the {@link List<Value>.Builder}
         * avoiding the need to create one manually via {@link List<Value>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Value>.Builder#build()} is called immediately and its result
         * is passed to {@link #arrayValues(List<Value>)}.
         * 
         * @param arrayValues
         *        a consumer that will call methods on {@link List<Value>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arrayValues(List<Value>)
         */
        Builder arrayValues(Consumer<Builder>... arrayValues);

        /**
         * Long value
         * 
         * @param bigIntValue
         *        Long value
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bigIntValue(Long bigIntValue);

        /**
         * Bit value
         * 
         * @param bitValue
         *        Bit value
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitValue(Boolean bitValue);

        /**
         * Blob value
         * 
         * @param blobValue
         *        Blob value
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blobValue(SdkBytes blobValue);

        /**
         * Double value
         * 
         * @param doubleValue
         *        Double value
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(Double doubleValue);

        /**
         * Integer value
         * 
         * @param intValue
         *        Integer value
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intValue(Integer intValue);

        /**
         * Is column null
         * 
         * @param isNull
         *        Is column null
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNull(Boolean isNull);

        /**
         * Float value
         * 
         * @param realValue
         *        Float value
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realValue(Float realValue);

        /**
         * String value
         * 
         * @param stringValue
         *        String value
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * Struct or UDT
         * 
         * @param structValue
         *        Struct or UDT
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder structValue(StructValue structValue);

        /**
         * Struct or UDT This is a convenience that creates an instance of the {@link StructValue.Builder} avoiding the
         * need to create one manually via {@link StructValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link StructValue.Builder#build()} is called immediately and its result
         * is passed to {@link #structValue(StructValue)}.
         * 
         * @param structValue
         *        a consumer that will call methods on {@link StructValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #structValue(StructValue)
         */
        default Builder structValue(Consumer<StructValue.Builder> structValue) {
            return structValue(StructValue.builder().applyMutation(structValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<Value> arrayValues = DefaultSdkAutoConstructList.getInstance();

        private Long bigIntValue;

        private Boolean bitValue;

        private SdkBytes blobValue;

        private Double doubleValue;

        private Integer intValue;

        private Boolean isNull;

        private Float realValue;

        private String stringValue;

        private StructValue structValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Value model) {
            arrayValues(model.arrayValues);
            bigIntValue(model.bigIntValue);
            bitValue(model.bitValue);
            blobValue(model.blobValue);
            doubleValue(model.doubleValue);
            intValue(model.intValue);
            isNull(model.isNull);
            realValue(model.realValue);
            stringValue(model.stringValue);
            structValue(model.structValue);
        }

        public final Collection<Builder> getArrayValues() {
            return arrayValues != null ? arrayValues.stream().map(Value::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder arrayValues(Collection<Value> arrayValues) {
            this.arrayValues = ArrayValuesCopier.copy(arrayValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValues(Value... arrayValues) {
            arrayValues(Arrays.asList(arrayValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValues(Consumer<Builder>... arrayValues) {
            arrayValues(Stream.of(arrayValues).map(c -> Value.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setArrayValues(Collection<BuilderImpl> arrayValues) {
            this.arrayValues = ArrayValuesCopier.copyFromBuilder(arrayValues);
        }

        public final Long getBigIntValue() {
            return bigIntValue;
        }

        @Override
        public final Builder bigIntValue(Long bigIntValue) {
            this.bigIntValue = bigIntValue;
            return this;
        }

        public final void setBigIntValue(Long bigIntValue) {
            this.bigIntValue = bigIntValue;
        }

        public final Boolean getBitValue() {
            return bitValue;
        }

        @Override
        public final Builder bitValue(Boolean bitValue) {
            this.bitValue = bitValue;
            return this;
        }

        public final void setBitValue(Boolean bitValue) {
            this.bitValue = bitValue;
        }

        public final ByteBuffer getBlobValue() {
            return blobValue == null ? null : blobValue.asByteBuffer();
        }

        @Override
        public final Builder blobValue(SdkBytes blobValue) {
            this.blobValue = StandardMemberCopier.copy(blobValue);
            return this;
        }

        public final void setBlobValue(ByteBuffer blobValue) {
            blobValue(blobValue == null ? null : SdkBytes.fromByteBuffer(blobValue));
        }

        public final Double getDoubleValue() {
            return doubleValue;
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
            return this;
        }

        public final void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        public final Integer getIntValue() {
            return intValue;
        }

        @Override
        public final Builder intValue(Integer intValue) {
            this.intValue = intValue;
            return this;
        }

        public final void setIntValue(Integer intValue) {
            this.intValue = intValue;
        }

        public final Boolean getIsNull() {
            return isNull;
        }

        @Override
        public final Builder isNull(Boolean isNull) {
            this.isNull = isNull;
            return this;
        }

        public final void setIsNull(Boolean isNull) {
            this.isNull = isNull;
        }

        public final Float getRealValue() {
            return realValue;
        }

        @Override
        public final Builder realValue(Float realValue) {
            this.realValue = realValue;
            return this;
        }

        public final void setRealValue(Float realValue) {
            this.realValue = realValue;
        }

        public final String getStringValue() {
            return stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public final StructValue.Builder getStructValue() {
            return structValue != null ? structValue.toBuilder() : null;
        }

        @Override
        public final Builder structValue(StructValue structValue) {
            this.structValue = structValue;
            return this;
        }

        public final void setStructValue(StructValue.BuilderImpl structValue) {
            this.structValue = structValue != null ? structValue.build() : null;
        }

        @Override
        public Value build() {
            return new Value(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
