/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.rdsdata.model.ExecuteSqlRequest;
import software.amazon.awssdk.services.rdsdata.model.ExecuteSqlResponse;

/**
 * Service client for accessing AWS RDS DataService asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * AWS RDS DataService provides Http Endpoint to query RDS databases.
 */
@Generated("software.amazon.awssdk:codegen")
public interface RdsDataAsyncClient extends SdkClient {
    String SERVICE_NAME = "rds-data";

    /**
     * Create a {@link RdsDataAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RdsDataAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RdsDataAsyncClient}.
     */
    static RdsDataAsyncClientBuilder builder() {
        return new DefaultRdsDataAsyncClientBuilder();
    }

    /**
     * Executes any SQL statement on the target database synchronously
     *
     * @param executeSqlRequest
     *        Execute SQL Request
     * @return A Java Future containing the result of the ExecuteSql operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Invalid Request exception</li>
     *         <li>ForbiddenException Access denied exception</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ServiceUnavailableErrorException Internal service unavailable error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RdsDataAsyncClient.ExecuteSql
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/ExecuteSql" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExecuteSqlResponse> executeSql(ExecuteSqlRequest executeSqlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Executes any SQL statement on the target database synchronously<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteSqlRequest.Builder} avoiding the need to
     * create one manually via {@link ExecuteSqlRequest#builder()}
     * </p>
     *
     * @param executeSqlRequest
     *        A {@link Consumer} that will call methods on {@link ExecuteSqlRequest.Builder} to create a request.
     *        Execute SQL Request
     * @return A Java Future containing the result of the ExecuteSql operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Invalid Request exception</li>
     *         <li>ForbiddenException Access denied exception</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ServiceUnavailableErrorException Internal service unavailable error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RdsDataAsyncClient.ExecuteSql
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/ExecuteSql" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExecuteSqlResponse> executeSql(Consumer<ExecuteSqlRequest.Builder> executeSqlRequest) {
        return executeSql(ExecuteSqlRequest.builder().applyMutation(executeSqlRequest).build());
    }
}
