/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Field implements SdkPojo, Serializable, ToCopyableBuilder<Field.Builder, Field> {
    private static final SdkField<SdkBytes> BLOB_VALUE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(Field::blobValue)).setter(setter(Builder::blobValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobValue").build()).build();

    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Field::booleanValue)).setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()).build();

    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Field::doubleValue)).setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()).build();

    private static final SdkField<Boolean> IS_NULL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Field::isNull)).setter(setter(Builder::isNull))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isNull").build()).build();

    private static final SdkField<Long> LONG_VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Field::longValue)).setter(setter(Builder::longValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longValue").build()).build();

    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Field::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOB_VALUE_FIELD,
            BOOLEAN_VALUE_FIELD, DOUBLE_VALUE_FIELD, IS_NULL_FIELD, LONG_VALUE_FIELD, STRING_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes blobValue;

    private final Boolean booleanValue;

    private final Double doubleValue;

    private final Boolean isNull;

    private final Long longValue;

    private final String stringValue;

    private Field(BuilderImpl builder) {
        this.blobValue = builder.blobValue;
        this.booleanValue = builder.booleanValue;
        this.doubleValue = builder.doubleValue;
        this.isNull = builder.isNull;
        this.longValue = builder.longValue;
        this.stringValue = builder.stringValue;
    }

    /**
     * <p>
     * A value of BLOB data type.
     * </p>
     * 
     * @return A value of BLOB data type.
     */
    public SdkBytes blobValue() {
        return blobValue;
    }

    /**
     * <p>
     * A value of Boolean data type.
     * </p>
     * 
     * @return A value of Boolean data type.
     */
    public Boolean booleanValue() {
        return booleanValue;
    }

    /**
     * <p>
     * A value of double data type.
     * </p>
     * 
     * @return A value of double data type.
     */
    public Double doubleValue() {
        return doubleValue;
    }

    /**
     * <p>
     * A NULL value.
     * </p>
     * 
     * @return A NULL value.
     */
    public Boolean isNull() {
        return isNull;
    }

    /**
     * <p>
     * A value of long data type.
     * </p>
     * 
     * @return A value of long data type.
     */
    public Long longValue() {
        return longValue;
    }

    /**
     * <p>
     * A value of string data type.
     * </p>
     * 
     * @return A value of string data type.
     */
    public String stringValue() {
        return stringValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blobValue());
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(isNull());
        hashCode = 31 * hashCode + Objects.hashCode(longValue());
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Field)) {
            return false;
        }
        Field other = (Field) obj;
        return Objects.equals(blobValue(), other.blobValue()) && Objects.equals(booleanValue(), other.booleanValue())
                && Objects.equals(doubleValue(), other.doubleValue()) && Objects.equals(isNull(), other.isNull())
                && Objects.equals(longValue(), other.longValue()) && Objects.equals(stringValue(), other.stringValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Field").add("BlobValue", blobValue()).add("BooleanValue", booleanValue())
                .add("DoubleValue", doubleValue()).add("IsNull", isNull()).add("LongValue", longValue())
                .add("StringValue", stringValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blobValue":
            return Optional.ofNullable(clazz.cast(blobValue()));
        case "booleanValue":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        case "doubleValue":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "isNull":
            return Optional.ofNullable(clazz.cast(isNull()));
        case "longValue":
            return Optional.ofNullable(clazz.cast(longValue()));
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Field, T> g) {
        return obj -> g.apply((Field) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Field> {
        /**
         * <p>
         * A value of BLOB data type.
         * </p>
         * 
         * @param blobValue
         *        A value of BLOB data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blobValue(SdkBytes blobValue);

        /**
         * <p>
         * A value of Boolean data type.
         * </p>
         * 
         * @param booleanValue
         *        A value of Boolean data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(Boolean booleanValue);

        /**
         * <p>
         * A value of double data type.
         * </p>
         * 
         * @param doubleValue
         *        A value of double data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(Double doubleValue);

        /**
         * <p>
         * A NULL value.
         * </p>
         * 
         * @param isNull
         *        A NULL value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNull(Boolean isNull);

        /**
         * <p>
         * A value of long data type.
         * </p>
         * 
         * @param longValue
         *        A value of long data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longValue(Long longValue);

        /**
         * <p>
         * A value of string data type.
         * </p>
         * 
         * @param stringValue
         *        A value of string data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes blobValue;

        private Boolean booleanValue;

        private Double doubleValue;

        private Boolean isNull;

        private Long longValue;

        private String stringValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Field model) {
            blobValue(model.blobValue);
            booleanValue(model.booleanValue);
            doubleValue(model.doubleValue);
            isNull(model.isNull);
            longValue(model.longValue);
            stringValue(model.stringValue);
        }

        public final ByteBuffer getBlobValue() {
            return blobValue == null ? null : blobValue.asByteBuffer();
        }

        @Override
        public final Builder blobValue(SdkBytes blobValue) {
            this.blobValue = StandardMemberCopier.copy(blobValue);
            return this;
        }

        public final void setBlobValue(ByteBuffer blobValue) {
            blobValue(blobValue == null ? null : SdkBytes.fromByteBuffer(blobValue));
        }

        public final Boolean getBooleanValue() {
            return booleanValue;
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        public final Double getDoubleValue() {
            return doubleValue;
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
            return this;
        }

        public final void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        public final Boolean getIsNull() {
            return isNull;
        }

        @Override
        public final Builder isNull(Boolean isNull) {
            this.isNull = isNull;
            return this;
        }

        public final void setIsNull(Boolean isNull) {
            this.isNull = isNull;
        }

        public final Long getLongValue() {
            return longValue;
        }

        @Override
        public final Builder longValue(Long longValue) {
            this.longValue = longValue;
            return this;
        }

        public final void setLongValue(Long longValue) {
            this.longValue = longValue;
        }

        public final String getStringValue() {
            return stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        @Override
        public Field build() {
            return new Field(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
