/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rdsdata.model.ColumnMetadata;
import software.amazon.awssdk.services.rdsdata.model.MetadataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResultSetMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResultSetMetadata> {
    private static final SdkField<Long> COLUMN_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ResultSetMetadata.getter(ResultSetMetadata::columnCount)).setter(ResultSetMetadata.setter(Builder::columnCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnCount").build()}).build();
    private static final SdkField<List<ColumnMetadata>> COLUMN_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ResultSetMetadata.getter(ResultSetMetadata::columnMetadata)).setter(ResultSetMetadata.setter(Builder::columnMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_COUNT_FIELD, COLUMN_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long columnCount;
    private final List<ColumnMetadata> columnMetadata;

    private ResultSetMetadata(BuilderImpl builder) {
        this.columnCount = builder.columnCount;
        this.columnMetadata = builder.columnMetadata;
    }

    public Long columnCount() {
        return this.columnCount;
    }

    public List<ColumnMetadata> columnMetadata() {
        return this.columnMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSetMetadata)) {
            return false;
        }
        ResultSetMetadata other = (ResultSetMetadata)obj;
        return Objects.equals(this.columnCount(), other.columnCount()) && Objects.equals(this.columnMetadata(), other.columnMetadata());
    }

    public String toString() {
        return ToString.builder((String)"ResultSetMetadata").add("ColumnCount", (Object)this.columnCount()).add("ColumnMetadata", this.columnMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "columnCount": {
                return Optional.ofNullable(clazz.cast(this.columnCount()));
            }
            case "columnMetadata": {
                return Optional.ofNullable(clazz.cast(this.columnMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultSetMetadata, T> g) {
        return obj -> g.apply((ResultSetMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long columnCount;
        private List<ColumnMetadata> columnMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResultSetMetadata model) {
            this.columnCount(model.columnCount);
            this.columnMetadata(model.columnMetadata);
        }

        public final Long getColumnCount() {
            return this.columnCount;
        }

        @Override
        public final Builder columnCount(Long columnCount) {
            this.columnCount = columnCount;
            return this;
        }

        public final void setColumnCount(Long columnCount) {
            this.columnCount = columnCount;
        }

        public final Collection<ColumnMetadata.Builder> getColumnMetadata() {
            return this.columnMetadata != null ? (Collection)this.columnMetadata.stream().map(ColumnMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder columnMetadata(Collection<ColumnMetadata> columnMetadata) {
            this.columnMetadata = MetadataCopier.copy(columnMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(ColumnMetadata ... columnMetadata) {
            this.columnMetadata(Arrays.asList(columnMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(Consumer<ColumnMetadata.Builder> ... columnMetadata) {
            this.columnMetadata(Stream.of(columnMetadata).map(c -> (ColumnMetadata)((ColumnMetadata.Builder)ColumnMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setColumnMetadata(Collection<ColumnMetadata.BuilderImpl> columnMetadata) {
            this.columnMetadata = MetadataCopier.copyFromBuilder(columnMetadata);
        }

        public ResultSetMetadata build() {
            return new ResultSetMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResultSetMetadata> {
        public Builder columnCount(Long var1);

        public Builder columnMetadata(Collection<ColumnMetadata> var1);

        public Builder columnMetadata(ColumnMetadata ... var1);

        public Builder columnMetadata(Consumer<ColumnMetadata.Builder> ... var1);
    }
}

