/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response elements represent the output of a request to run a SQL statement against a database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteStatementResponse extends RdsDataResponse implements
        ToCopyableBuilder<ExecuteStatementResponse.Builder, ExecuteStatementResponse> {
    private static final SdkField<List<ColumnMetadata>> COLUMN_METADATA_FIELD = SdkField
            .<List<ColumnMetadata>> builder(MarshallingType.LIST)
            .getter(getter(ExecuteStatementResponse::columnMetadata))
            .setter(setter(Builder::columnMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Field>> GENERATED_FIELDS_FIELD = SdkField
            .<List<Field>> builder(MarshallingType.LIST)
            .getter(getter(ExecuteStatementResponse::generatedFields))
            .setter(setter(Builder::generatedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                            .constructor(Field::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> NUMBER_OF_RECORDS_UPDATED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ExecuteStatementResponse::numberOfRecordsUpdated)).setter(setter(Builder::numberOfRecordsUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecordsUpdated").build())
            .build();

    private static final SdkField<List<List<Field>>> RECORDS_FIELD = SdkField
            .<List<List<Field>>> builder(MarshallingType.LIST)
            .getter(getter(ExecuteStatementResponse::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<Field>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(Field::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_METADATA_FIELD,
            GENERATED_FIELDS_FIELD, NUMBER_OF_RECORDS_UPDATED_FIELD, RECORDS_FIELD));

    private final List<ColumnMetadata> columnMetadata;

    private final List<Field> generatedFields;

    private final Long numberOfRecordsUpdated;

    private final List<List<Field>> records;

    private ExecuteStatementResponse(BuilderImpl builder) {
        super(builder);
        this.columnMetadata = builder.columnMetadata;
        this.generatedFields = builder.generatedFields;
        this.numberOfRecordsUpdated = builder.numberOfRecordsUpdated;
        this.records = builder.records;
    }

    /**
     * <p>
     * Metadata for the columns included in the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Metadata for the columns included in the results.
     */
    public List<ColumnMetadata> columnMetadata() {
        return columnMetadata;
    }

    /**
     * <p>
     * Values for fields generated during the request.
     * </p>
     * 
     * <pre>
     * <code> &lt;note&gt; &lt;p&gt;The &lt;code&gt;generatedFields&lt;/code&gt; data isn't supported by Aurora PostgreSQL. To get the values of generated fields, use the &lt;code&gt;RETURNING&lt;/code&gt; clause. For more information, see &lt;a href=&quot;https://www.postgresql.org/docs/10/dml-returning.html&quot;&gt;Returning Data From Modified Rows&lt;/a&gt; in the PostgreSQL documentation.&lt;/p&gt; &lt;/note&gt; </code>
     * </pre>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Values for fields generated during the request.</p>
     * 
     * <pre><code> &lt;note&gt; &lt;p&gt;The &lt;code&gt;generatedFields&lt;/code&gt; data isn't supported by Aurora PostgreSQL. To get the values of generated fields, use the &lt;code&gt;RETURNING&lt;/code&gt; clause. For more information, see &lt;a href=&quot;https://www.postgresql.org/docs/10/dml-returning.html&quot;&gt;Returning Data From Modified Rows&lt;/a&gt; in the PostgreSQL documentation.&lt;/p&gt; &lt;/note&gt; </code>
     */
    public List<Field> generatedFields() {
        return generatedFields;
    }

    /**
     * <p>
     * The number of records updated by the request.
     * </p>
     * 
     * @return The number of records updated by the request.
     */
    public Long numberOfRecordsUpdated() {
        return numberOfRecordsUpdated;
    }

    /**
     * <p>
     * The records returned by the SQL statement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The records returned by the SQL statement.
     */
    public List<List<Field>> records() {
        return records;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(columnMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(generatedFields());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRecordsUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(records());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementResponse)) {
            return false;
        }
        ExecuteStatementResponse other = (ExecuteStatementResponse) obj;
        return Objects.equals(columnMetadata(), other.columnMetadata())
                && Objects.equals(generatedFields(), other.generatedFields())
                && Objects.equals(numberOfRecordsUpdated(), other.numberOfRecordsUpdated())
                && Objects.equals(records(), other.records());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExecuteStatementResponse").add("ColumnMetadata", columnMetadata())
                .add("GeneratedFields", generatedFields()).add("NumberOfRecordsUpdated", numberOfRecordsUpdated())
                .add("Records", records()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columnMetadata":
            return Optional.ofNullable(clazz.cast(columnMetadata()));
        case "generatedFields":
            return Optional.ofNullable(clazz.cast(generatedFields()));
        case "numberOfRecordsUpdated":
            return Optional.ofNullable(clazz.cast(numberOfRecordsUpdated()));
        case "records":
            return Optional.ofNullable(clazz.cast(records()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteStatementResponse, T> g) {
        return obj -> g.apply((ExecuteStatementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteStatementResponse> {
        /**
         * <p>
         * Metadata for the columns included in the results.
         * </p>
         * 
         * @param columnMetadata
         *        Metadata for the columns included in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnMetadata(Collection<ColumnMetadata> columnMetadata);

        /**
         * <p>
         * Metadata for the columns included in the results.
         * </p>
         * 
         * @param columnMetadata
         *        Metadata for the columns included in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnMetadata(ColumnMetadata... columnMetadata);

        /**
         * <p>
         * Metadata for the columns included in the results.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ColumnMetadata>.Builder} avoiding the need
         * to create one manually via {@link List<ColumnMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ColumnMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #columnMetadata(List<ColumnMetadata>)}.
         * 
         * @param columnMetadata
         *        a consumer that will call methods on {@link List<ColumnMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnMetadata(List<ColumnMetadata>)
         */
        Builder columnMetadata(Consumer<ColumnMetadata.Builder>... columnMetadata);

        /**
         * <p>
         * Values for fields generated during the request.
         * </p>
         * 
         * <pre>
         * <code> &lt;note&gt; &lt;p&gt;The &lt;code&gt;generatedFields&lt;/code&gt; data isn't supported by Aurora PostgreSQL. To get the values of generated fields, use the &lt;code&gt;RETURNING&lt;/code&gt; clause. For more information, see &lt;a href=&quot;https://www.postgresql.org/docs/10/dml-returning.html&quot;&gt;Returning Data From Modified Rows&lt;/a&gt; in the PostgreSQL documentation.&lt;/p&gt; &lt;/note&gt; </code>
         * </pre>
         * 
         * @param generatedFields
         *        Values for fields generated during the request.</p>
         * 
         *        <pre>
         * <code> &lt;note&gt; &lt;p&gt;The &lt;code&gt;generatedFields&lt;/code&gt; data isn't supported by Aurora PostgreSQL. To get the values of generated fields, use the &lt;code&gt;RETURNING&lt;/code&gt; clause. For more information, see &lt;a href=&quot;https://www.postgresql.org/docs/10/dml-returning.html&quot;&gt;Returning Data From Modified Rows&lt;/a&gt; in the PostgreSQL documentation.&lt;/p&gt; &lt;/note&gt; </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedFields(Collection<Field> generatedFields);

        /**
         * <p>
         * Values for fields generated during the request.
         * </p>
         * 
         * <pre>
         * <code> &lt;note&gt; &lt;p&gt;The &lt;code&gt;generatedFields&lt;/code&gt; data isn't supported by Aurora PostgreSQL. To get the values of generated fields, use the &lt;code&gt;RETURNING&lt;/code&gt; clause. For more information, see &lt;a href=&quot;https://www.postgresql.org/docs/10/dml-returning.html&quot;&gt;Returning Data From Modified Rows&lt;/a&gt; in the PostgreSQL documentation.&lt;/p&gt; &lt;/note&gt; </code>
         * </pre>
         * 
         * @param generatedFields
         *        Values for fields generated during the request.</p>
         * 
         *        <pre>
         * <code> &lt;note&gt; &lt;p&gt;The &lt;code&gt;generatedFields&lt;/code&gt; data isn't supported by Aurora PostgreSQL. To get the values of generated fields, use the &lt;code&gt;RETURNING&lt;/code&gt; clause. For more information, see &lt;a href=&quot;https://www.postgresql.org/docs/10/dml-returning.html&quot;&gt;Returning Data From Modified Rows&lt;/a&gt; in the PostgreSQL documentation.&lt;/p&gt; &lt;/note&gt; </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedFields(Field... generatedFields);

        /**
         * <p>
         * Values for fields generated during the request.
         * </p>
         * 
         * <pre>
         * <code> &lt;note&gt; &lt;p&gt;The &lt;code&gt;generatedFields&lt;/code&gt; data isn't supported by Aurora PostgreSQL. To get the values of generated fields, use the &lt;code&gt;RETURNING&lt;/code&gt; clause. For more information, see &lt;a href=&quot;https://www.postgresql.org/docs/10/dml-returning.html&quot;&gt;Returning Data From Modified Rows&lt;/a&gt; in the PostgreSQL documentation.&lt;/p&gt; &lt;/note&gt; </code>
         * </pre>
         * 
         * This is a convenience that creates an instance of the {@link List<Field>.Builder} avoiding the need to create
         * one manually via {@link List<Field>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Field>.Builder#build()} is called immediately and its result
         * is passed to {@link #generatedFields(List<Field>)}.
         * 
         * @param generatedFields
         *        a consumer that will call methods on {@link List<Field>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generatedFields(List<Field>)
         */
        Builder generatedFields(Consumer<Field.Builder>... generatedFields);

        /**
         * <p>
         * The number of records updated by the request.
         * </p>
         * 
         * @param numberOfRecordsUpdated
         *        The number of records updated by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRecordsUpdated(Long numberOfRecordsUpdated);

        /**
         * <p>
         * The records returned by the SQL statement.
         * </p>
         * 
         * @param records
         *        The records returned by the SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<? extends Collection<Field>> records);

        /**
         * <p>
         * The records returned by the SQL statement.
         * </p>
         * 
         * @param records
         *        The records returned by the SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<Field>... records);
    }

    static final class BuilderImpl extends RdsDataResponse.BuilderImpl implements Builder {
        private List<ColumnMetadata> columnMetadata = DefaultSdkAutoConstructList.getInstance();

        private List<Field> generatedFields = DefaultSdkAutoConstructList.getInstance();

        private Long numberOfRecordsUpdated;

        private List<List<Field>> records = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteStatementResponse model) {
            super(model);
            columnMetadata(model.columnMetadata);
            generatedFields(model.generatedFields);
            numberOfRecordsUpdated(model.numberOfRecordsUpdated);
            records(model.records);
        }

        public final Collection<ColumnMetadata.Builder> getColumnMetadata() {
            return columnMetadata != null ? columnMetadata.stream().map(ColumnMetadata::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder columnMetadata(Collection<ColumnMetadata> columnMetadata) {
            this.columnMetadata = MetadataCopier.copy(columnMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(ColumnMetadata... columnMetadata) {
            columnMetadata(Arrays.asList(columnMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(Consumer<ColumnMetadata.Builder>... columnMetadata) {
            columnMetadata(Stream.of(columnMetadata).map(c -> ColumnMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setColumnMetadata(Collection<ColumnMetadata.BuilderImpl> columnMetadata) {
            this.columnMetadata = MetadataCopier.copyFromBuilder(columnMetadata);
        }

        public final Collection<Field.Builder> getGeneratedFields() {
            return generatedFields != null ? generatedFields.stream().map(Field::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder generatedFields(Collection<Field> generatedFields) {
            this.generatedFields = FieldListCopier.copy(generatedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedFields(Field... generatedFields) {
            generatedFields(Arrays.asList(generatedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedFields(Consumer<Field.Builder>... generatedFields) {
            generatedFields(Stream.of(generatedFields).map(c -> Field.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGeneratedFields(Collection<Field.BuilderImpl> generatedFields) {
            this.generatedFields = FieldListCopier.copyFromBuilder(generatedFields);
        }

        public final Long getNumberOfRecordsUpdated() {
            return numberOfRecordsUpdated;
        }

        @Override
        public final Builder numberOfRecordsUpdated(Long numberOfRecordsUpdated) {
            this.numberOfRecordsUpdated = numberOfRecordsUpdated;
            return this;
        }

        public final void setNumberOfRecordsUpdated(Long numberOfRecordsUpdated) {
            this.numberOfRecordsUpdated = numberOfRecordsUpdated;
        }

        public final Collection<? extends Collection<Field>> getRecords() {
            return records;
        }

        @Override
        public final Builder records(Collection<? extends Collection<Field>> records) {
            this.records = SqlRecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Collection<Field>... records) {
            records(Arrays.asList(records));
            return this;
        }

        public final void setRecords(Collection<? extends Collection<Field>> records) {
            this.records = SqlRecordsCopier.copy(records);
        }

        @Override
        public ExecuteStatementResponse build() {
            return new ExecuteStatementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
