/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStatementResultResponse extends RedshiftDataResponse implements
        ToCopyableBuilder<GetStatementResultResponse.Builder, GetStatementResultResponse> {
    private static final SdkField<List<ColumnMetadata>> COLUMN_METADATA_FIELD = SdkField
            .<List<ColumnMetadata>> builder(MarshallingType.LIST)
            .getter(getter(GetStatementResultResponse::columnMetadata))
            .setter(setter(Builder::columnMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetStatementResultResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<List<Field>>> RECORDS_FIELD = SdkField
            .<List<List<Field>>> builder(MarshallingType.LIST)
            .getter(getter(GetStatementResultResponse::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<Field>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(Field::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Long> TOTAL_NUM_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GetStatementResultResponse::totalNumRows)).setter(setter(Builder::totalNumRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumRows").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_METADATA_FIELD,
            NEXT_TOKEN_FIELD, RECORDS_FIELD, TOTAL_NUM_ROWS_FIELD));

    private final List<ColumnMetadata> columnMetadata;

    private final String nextToken;

    private final List<List<Field>> records;

    private final Long totalNumRows;

    private GetStatementResultResponse(BuilderImpl builder) {
        super(builder);
        this.columnMetadata = builder.columnMetadata;
        this.nextToken = builder.nextToken;
        this.records = builder.records;
        this.totalNumRows = builder.totalNumRows;
    }

    /**
     * Returns true if the ColumnMetadata property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasColumnMetadata() {
        return columnMetadata != null && !(columnMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties (metadata) of a column.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasColumnMetadata()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The properties (metadata) of a column.
     */
    public List<ColumnMetadata> columnMetadata() {
        return columnMetadata;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned NextToken
     * value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response
     * records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is
     *         empty, all response records have been retrieved for the request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Records property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results of the SQL statement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The results of the SQL statement.
     */
    public List<List<Field>> records() {
        return records;
    }

    /**
     * <p>
     * The total number of rows in the result set returned from a query. You can use this number to estimate the number
     * of calls to the <code>GetStatementResult</code> operation needed to page through the results.
     * </p>
     * 
     * @return The total number of rows in the result set returned from a query. You can use this number to estimate the
     *         number of calls to the <code>GetStatementResult</code> operation needed to page through the results.
     */
    public Long totalNumRows() {
        return totalNumRows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(columnMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(records());
        hashCode = 31 * hashCode + Objects.hashCode(totalNumRows());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStatementResultResponse)) {
            return false;
        }
        GetStatementResultResponse other = (GetStatementResultResponse) obj;
        return Objects.equals(columnMetadata(), other.columnMetadata()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(records(), other.records()) && Objects.equals(totalNumRows(), other.totalNumRows());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetStatementResultResponse").add("ColumnMetadata", columnMetadata())
                .add("NextToken", nextToken()).add("Records", records()).add("TotalNumRows", totalNumRows()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnMetadata":
            return Optional.ofNullable(clazz.cast(columnMetadata()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Records":
            return Optional.ofNullable(clazz.cast(records()));
        case "TotalNumRows":
            return Optional.ofNullable(clazz.cast(totalNumRows()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStatementResultResponse, T> g) {
        return obj -> g.apply((GetStatementResultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStatementResultResponse> {
        /**
         * <p>
         * The properties (metadata) of a column.
         * </p>
         * 
         * @param columnMetadata
         *        The properties (metadata) of a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnMetadata(Collection<ColumnMetadata> columnMetadata);

        /**
         * <p>
         * The properties (metadata) of a column.
         * </p>
         * 
         * @param columnMetadata
         *        The properties (metadata) of a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnMetadata(ColumnMetadata... columnMetadata);

        /**
         * <p>
         * The properties (metadata) of a column.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ColumnMetadata>.Builder} avoiding the need
         * to create one manually via {@link List<ColumnMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ColumnMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #columnMetadata(List<ColumnMetadata>)}.
         * 
         * @param columnMetadata
         *        a consumer that will call methods on {@link List<ColumnMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnMetadata(List<ColumnMetadata>)
         */
        Builder columnMetadata(Consumer<ColumnMetadata.Builder>... columnMetadata);

        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned
         * NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty,
         * all response records have been retrieved for the request.
         * </p>
         * 
         * @param nextToken
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned NextToken value in the next NextToken parameter and retrying the command. If the
         *        NextToken field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The results of the SQL statement.
         * </p>
         * 
         * @param records
         *        The results of the SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<? extends Collection<Field>> records);

        /**
         * <p>
         * The results of the SQL statement.
         * </p>
         * 
         * @param records
         *        The results of the SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<Field>... records);

        /**
         * <p>
         * The total number of rows in the result set returned from a query. You can use this number to estimate the
         * number of calls to the <code>GetStatementResult</code> operation needed to page through the results.
         * </p>
         * 
         * @param totalNumRows
         *        The total number of rows in the result set returned from a query. You can use this number to estimate
         *        the number of calls to the <code>GetStatementResult</code> operation needed to page through the
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumRows(Long totalNumRows);
    }

    static final class BuilderImpl extends RedshiftDataResponse.BuilderImpl implements Builder {
        private List<ColumnMetadata> columnMetadata = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private List<List<Field>> records = DefaultSdkAutoConstructList.getInstance();

        private Long totalNumRows;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStatementResultResponse model) {
            super(model);
            columnMetadata(model.columnMetadata);
            nextToken(model.nextToken);
            records(model.records);
            totalNumRows(model.totalNumRows);
        }

        public final Collection<ColumnMetadata.Builder> getColumnMetadata() {
            return columnMetadata != null ? columnMetadata.stream().map(ColumnMetadata::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder columnMetadata(Collection<ColumnMetadata> columnMetadata) {
            this.columnMetadata = ColumnMetadataListCopier.copy(columnMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(ColumnMetadata... columnMetadata) {
            columnMetadata(Arrays.asList(columnMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(Consumer<ColumnMetadata.Builder>... columnMetadata) {
            columnMetadata(Stream.of(columnMetadata).map(c -> ColumnMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setColumnMetadata(Collection<ColumnMetadata.BuilderImpl> columnMetadata) {
            this.columnMetadata = ColumnMetadataListCopier.copyFromBuilder(columnMetadata);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<? extends Collection<Field>> getRecords() {
            return records;
        }

        @Override
        public final Builder records(Collection<? extends Collection<Field>> records) {
            this.records = SqlRecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Collection<Field>... records) {
            records(Arrays.asList(records));
            return this;
        }

        public final void setRecords(Collection<? extends Collection<Field>> records) {
            this.records = SqlRecordsCopier.copy(records);
        }

        public final Long getTotalNumRows() {
            return totalNumRows;
        }

        @Override
        public final Builder totalNumRows(Long totalNumRows) {
            this.totalNumRows = totalNumRows;
            return this;
        }

        public final void setTotalNumRows(Long totalNumRows) {
            this.totalNumRows = totalNumRows;
        }

        @Override
        public GetStatementResultResponse build() {
            return new GetStatementResultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
