/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStatementResponse extends RedshiftDataResponse implements
        ToCopyableBuilder<DescribeStatementResponse.Builder, DescribeStatementResponse> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStatementResponse::clusterIdentifier)).setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeStatementResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStatementResponse::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> DB_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStatementResponse::dbUser)).setter(setter(Builder::dbUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()).build();

    private static final SdkField<Long> DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeStatementResponse::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStatementResponse::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStatementResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStatementResponse::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<Long> REDSHIFT_PID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeStatementResponse::redshiftPid)).setter(setter(Builder::redshiftPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftPid").build()).build();

    private static final SdkField<Long> REDSHIFT_QUERY_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeStatementResponse::redshiftQueryId)).setter(setter(Builder::redshiftQueryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftQueryId").build()).build();

    private static final SdkField<Long> RESULT_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeStatementResponse::resultRows)).setter(setter(Builder::resultRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultRows").build()).build();

    private static final SdkField<Long> RESULT_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeStatementResponse::resultSize)).setter(setter(Builder::resultSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultSize").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStatementResponse::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStatementResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeStatementResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            CREATED_AT_FIELD, DATABASE_FIELD, DB_USER_FIELD, DURATION_FIELD, ERROR_FIELD, ID_FIELD, QUERY_STRING_FIELD,
            REDSHIFT_PID_FIELD, REDSHIFT_QUERY_ID_FIELD, RESULT_ROWS_FIELD, RESULT_SIZE_FIELD, SECRET_ARN_FIELD, STATUS_FIELD,
            UPDATED_AT_FIELD));

    private final String clusterIdentifier;

    private final Instant createdAt;

    private final String database;

    private final String dbUser;

    private final Long duration;

    private final String error;

    private final String id;

    private final String queryString;

    private final Long redshiftPid;

    private final Long redshiftQueryId;

    private final Long resultRows;

    private final Long resultSize;

    private final String secretArn;

    private final String status;

    private final Instant updatedAt;

    private DescribeStatementResponse(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.createdAt = builder.createdAt;
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.duration = builder.duration;
        this.error = builder.error;
        this.id = builder.id;
        this.queryString = builder.queryString;
        this.redshiftPid = builder.redshiftPid;
        this.redshiftQueryId = builder.redshiftQueryId;
        this.resultRows = builder.resultRows;
        this.resultSize = builder.resultSize;
        this.secretArn = builder.secretArn;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The cluster identifier.
     * </p>
     * 
     * @return The cluster identifier.
     */
    public String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The date and time (UTC) when the SQL statement was submitted to run.
     * </p>
     * 
     * @return The date and time (UTC) when the SQL statement was submitted to run.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The name of the database.
     * </p>
     * 
     * @return The name of the database.
     */
    public String database() {
        return database;
    }

    /**
     * <p>
     * The database user name.
     * </p>
     * 
     * @return The database user name.
     */
    public String dbUser() {
        return dbUser;
    }

    /**
     * <p>
     * The amount of time in nanoseconds that the statement ran.
     * </p>
     * 
     * @return The amount of time in nanoseconds that the statement ran.
     */
    public Long duration() {
        return duration;
    }

    /**
     * <p>
     * The error message from the cluster if the SQL statement encountered an error while running.
     * </p>
     * 
     * @return The error message from the cluster if the SQL statement encountered an error while running.
     */
    public String error() {
        return error;
    }

    /**
     * <p>
     * The identifier of the SQL statement described. This value is a universally unique identifier (UUID) generated by
     * Amazon Redshift Data API.
     * </p>
     * 
     * @return The identifier of the SQL statement described. This value is a universally unique identifier (UUID)
     *         generated by Amazon Redshift Data API.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The SQL statement text.
     * </p>
     * 
     * @return The SQL statement text.
     */
    public String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The process identifier from Amazon Redshift.
     * </p>
     * 
     * @return The process identifier from Amazon Redshift.
     */
    public Long redshiftPid() {
        return redshiftPid;
    }

    /**
     * <p>
     * The identifier of the query generated by Amazon Redshift. These identifiers are also available in the
     * <code>query</code> column of the <code>STL_QUERY</code> system view.
     * </p>
     * 
     * @return The identifier of the query generated by Amazon Redshift. These identifiers are also available in the
     *         <code>query</code> column of the <code>STL_QUERY</code> system view.
     */
    public Long redshiftQueryId() {
        return redshiftQueryId;
    }

    /**
     * <p>
     * Either the number of rows returned from the SQL statement or the number of rows affected. If result size is
     * greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE,
     * DELETE, COPY, and others.
     * </p>
     * 
     * @return Either the number of rows returned from the SQL statement or the number of rows affected. If result size
     *         is greater than zero, the result rows can be the number of rows affected by SQL statements such as
     *         INSERT, UPDATE, DELETE, COPY, and others.
     */
    public Long resultRows() {
        return resultRows;
    }

    /**
     * <p>
     * The size in bytes of the returned results.
     * </p>
     * 
     * @return The size in bytes of the returned results.
     */
    public Long resultSize() {
        return resultSize;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     */
    public String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The status of the SQL statement being described. Status values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ABORTED - The query run was stopped by the user.
     * </p>
     * </li>
     * <li>
     * <p>
     * ALL - A status value that includes all query statuses. This value can be used to filter results.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The query run failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * FINISHED - The query has finished running.
     * </p>
     * </li>
     * <li>
     * <p>
     * PICKED - The query has been chosen to be run.
     * </p>
     * </li>
     * <li>
     * <p>
     * STARTED - The query run has started.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUBMITTED - The query was submitted, but not yet processed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the SQL statement being described. Status values are defined as follows: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ABORTED - The query run was stopped by the user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ALL - A status value that includes all query statuses. This value can be used to filter results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED - The query run failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FINISHED - The query has finished running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PICKED - The query has been chosen to be run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STARTED - The query run has started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SUBMITTED - The query was submitted, but not yet processed.
     *         </p>
     *         </li>
     * @see StatusString
     */
    public StatusString status() {
        return StatusString.fromValue(status);
    }

    /**
     * <p>
     * The status of the SQL statement being described. Status values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ABORTED - The query run was stopped by the user.
     * </p>
     * </li>
     * <li>
     * <p>
     * ALL - A status value that includes all query statuses. This value can be used to filter results.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The query run failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * FINISHED - The query has finished running.
     * </p>
     * </li>
     * <li>
     * <p>
     * PICKED - The query has been chosen to be run.
     * </p>
     * </li>
     * <li>
     * <p>
     * STARTED - The query run has started.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUBMITTED - The query was submitted, but not yet processed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the SQL statement being described. Status values are defined as follows: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ABORTED - The query run was stopped by the user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ALL - A status value that includes all query statuses. This value can be used to filter results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED - The query run failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FINISHED - The query has finished running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PICKED - The query has been chosen to be run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STARTED - The query run has started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SUBMITTED - The query was submitted, but not yet processed.
     *         </p>
     *         </li>
     * @see StatusString
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time (UTC) that the metadata for the SQL statement was last updated. An example is the time the
     * status last changed.
     * </p>
     * 
     * @return The date and time (UTC) that the metadata for the SQL statement was last updated. An example is the time
     *         the status last changed.
     */
    public Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftPid());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftQueryId());
        hashCode = 31 * hashCode + Objects.hashCode(resultRows());
        hashCode = 31 * hashCode + Objects.hashCode(resultSize());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStatementResponse)) {
            return false;
        }
        DescribeStatementResponse other = (DescribeStatementResponse) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(database(), other.database()) && Objects.equals(dbUser(), other.dbUser())
                && Objects.equals(duration(), other.duration()) && Objects.equals(error(), other.error())
                && Objects.equals(id(), other.id()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(redshiftPid(), other.redshiftPid())
                && Objects.equals(redshiftQueryId(), other.redshiftQueryId()) && Objects.equals(resultRows(), other.resultRows())
                && Objects.equals(resultSize(), other.resultSize()) && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeStatementResponse").add("ClusterIdentifier", clusterIdentifier())
                .add("CreatedAt", createdAt()).add("Database", database()).add("DbUser", dbUser()).add("Duration", duration())
                .add("Error", error()).add("Id", id()).add("QueryString", queryString()).add("RedshiftPid", redshiftPid())
                .add("RedshiftQueryId", redshiftQueryId()).add("ResultRows", resultRows()).add("ResultSize", resultSize())
                .add("SecretArn", secretArn()).add("Status", statusAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "DbUser":
            return Optional.ofNullable(clazz.cast(dbUser()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "RedshiftPid":
            return Optional.ofNullable(clazz.cast(redshiftPid()));
        case "RedshiftQueryId":
            return Optional.ofNullable(clazz.cast(redshiftQueryId()));
        case "ResultRows":
            return Optional.ofNullable(clazz.cast(resultRows()));
        case "ResultSize":
            return Optional.ofNullable(clazz.cast(resultSize()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStatementResponse, T> g) {
        return obj -> g.apply((DescribeStatementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStatementResponse> {
        /**
         * <p>
         * The cluster identifier.
         * </p>
         * 
         * @param clusterIdentifier
         *        The cluster identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The date and time (UTC) when the SQL statement was submitted to run.
         * </p>
         * 
         * @param createdAt
         *        The date and time (UTC) when the SQL statement was submitted to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The name of the database.
         * </p>
         * 
         * @param database
         *        The name of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The database user name.
         * </p>
         * 
         * @param dbUser
         *        The database user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * The amount of time in nanoseconds that the statement ran.
         * </p>
         * 
         * @param duration
         *        The amount of time in nanoseconds that the statement ran.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * The error message from the cluster if the SQL statement encountered an error while running.
         * </p>
         * 
         * @param error
         *        The error message from the cluster if the SQL statement encountered an error while running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * The identifier of the SQL statement described. This value is a universally unique identifier (UUID) generated
         * by Amazon Redshift Data API.
         * </p>
         * 
         * @param id
         *        The identifier of the SQL statement described. This value is a universally unique identifier (UUID)
         *        generated by Amazon Redshift Data API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The SQL statement text.
         * </p>
         * 
         * @param queryString
         *        The SQL statement text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The process identifier from Amazon Redshift.
         * </p>
         * 
         * @param redshiftPid
         *        The process identifier from Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftPid(Long redshiftPid);

        /**
         * <p>
         * The identifier of the query generated by Amazon Redshift. These identifiers are also available in the
         * <code>query</code> column of the <code>STL_QUERY</code> system view.
         * </p>
         * 
         * @param redshiftQueryId
         *        The identifier of the query generated by Amazon Redshift. These identifiers are also available in the
         *        <code>query</code> column of the <code>STL_QUERY</code> system view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftQueryId(Long redshiftQueryId);

        /**
         * <p>
         * Either the number of rows returned from the SQL statement or the number of rows affected. If result size is
         * greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT,
         * UPDATE, DELETE, COPY, and others.
         * </p>
         * 
         * @param resultRows
         *        Either the number of rows returned from the SQL statement or the number of rows affected. If result
         *        size is greater than zero, the result rows can be the number of rows affected by SQL statements such
         *        as INSERT, UPDATE, DELETE, COPY, and others.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultRows(Long resultRows);

        /**
         * <p>
         * The size in bytes of the returned results.
         * </p>
         * 
         * @param resultSize
         *        The size in bytes of the returned results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultSize(Long resultSize);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
         * </p>
         * 
         * @param secretArn
         *        The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The status of the SQL statement being described. Status values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ABORTED - The query run was stopped by the user.
         * </p>
         * </li>
         * <li>
         * <p>
         * ALL - A status value that includes all query statuses. This value can be used to filter results.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED - The query run failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * FINISHED - The query has finished running.
         * </p>
         * </li>
         * <li>
         * <p>
         * PICKED - The query has been chosen to be run.
         * </p>
         * </li>
         * <li>
         * <p>
         * STARTED - The query run has started.
         * </p>
         * </li>
         * <li>
         * <p>
         * SUBMITTED - The query was submitted, but not yet processed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the SQL statement being described. Status values are defined as follows: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ABORTED - The query run was stopped by the user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ALL - A status value that includes all query statuses. This value can be used to filter results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED - The query run failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FINISHED - The query has finished running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PICKED - The query has been chosen to be run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STARTED - The query run has started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SUBMITTED - The query was submitted, but not yet processed.
         *        </p>
         *        </li>
         * @see StatusString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusString
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the SQL statement being described. Status values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ABORTED - The query run was stopped by the user.
         * </p>
         * </li>
         * <li>
         * <p>
         * ALL - A status value that includes all query statuses. This value can be used to filter results.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED - The query run failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * FINISHED - The query has finished running.
         * </p>
         * </li>
         * <li>
         * <p>
         * PICKED - The query has been chosen to be run.
         * </p>
         * </li>
         * <li>
         * <p>
         * STARTED - The query run has started.
         * </p>
         * </li>
         * <li>
         * <p>
         * SUBMITTED - The query was submitted, but not yet processed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the SQL statement being described. Status values are defined as follows: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ABORTED - The query run was stopped by the user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ALL - A status value that includes all query statuses. This value can be used to filter results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED - The query run failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FINISHED - The query has finished running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PICKED - The query has been chosen to be run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STARTED - The query run has started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SUBMITTED - The query was submitted, but not yet processed.
         *        </p>
         *        </li>
         * @see StatusString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusString
         */
        Builder status(StatusString status);

        /**
         * <p>
         * The date and time (UTC) that the metadata for the SQL statement was last updated. An example is the time the
         * status last changed.
         * </p>
         * 
         * @param updatedAt
         *        The date and time (UTC) that the metadata for the SQL statement was last updated. An example is the
         *        time the status last changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends RedshiftDataResponse.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private Instant createdAt;

        private String database;

        private String dbUser;

        private Long duration;

        private String error;

        private String id;

        private String queryString;

        private Long redshiftPid;

        private Long redshiftQueryId;

        private Long resultRows;

        private Long resultSize;

        private String secretArn;

        private String status;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStatementResponse model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            createdAt(model.createdAt);
            database(model.database);
            dbUser(model.dbUser);
            duration(model.duration);
            error(model.error);
            id(model.id);
            queryString(model.queryString);
            redshiftPid(model.redshiftPid);
            redshiftQueryId(model.redshiftQueryId);
            resultRows(model.resultRows);
            resultSize(model.resultSize);
            secretArn(model.secretArn);
            status(model.status);
            updatedAt(model.updatedAt);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDatabase() {
            return database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public final String getDbUser() {
            return dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final Long getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        public final String getError() {
            return error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final void setError(String error) {
            this.error = error;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getQueryString() {
            return queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final Long getRedshiftPid() {
            return redshiftPid;
        }

        @Override
        public final Builder redshiftPid(Long redshiftPid) {
            this.redshiftPid = redshiftPid;
            return this;
        }

        public final void setRedshiftPid(Long redshiftPid) {
            this.redshiftPid = redshiftPid;
        }

        public final Long getRedshiftQueryId() {
            return redshiftQueryId;
        }

        @Override
        public final Builder redshiftQueryId(Long redshiftQueryId) {
            this.redshiftQueryId = redshiftQueryId;
            return this;
        }

        public final void setRedshiftQueryId(Long redshiftQueryId) {
            this.redshiftQueryId = redshiftQueryId;
        }

        public final Long getResultRows() {
            return resultRows;
        }

        @Override
        public final Builder resultRows(Long resultRows) {
            this.resultRows = resultRows;
            return this;
        }

        public final void setResultRows(Long resultRows) {
            this.resultRows = resultRows;
        }

        public final Long getResultSize() {
            return resultSize;
        }

        @Override
        public final Builder resultSize(Long resultSize) {
            this.resultSize = resultSize;
            return this;
        }

        public final void setResultSize(Long resultSize) {
            this.resultSize = resultSize;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusString status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public DescribeStatementResponse build() {
            return new DescribeStatementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
