/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStatementsResponse extends RedshiftDataResponse implements
        ToCopyableBuilder<ListStatementsResponse.Builder, ListStatementsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListStatementsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<StatementData>> STATEMENTS_FIELD = SdkField
            .<List<StatementData>> builder(MarshallingType.LIST)
            .getter(getter(ListStatementsResponse::statements))
            .setter(setter(Builder::statements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatementData> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatementData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            STATEMENTS_FIELD));

    private final String nextToken;

    private final List<StatementData> statements;

    private ListStatementsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.statements = builder.statements;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned NextToken
     * value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response
     * records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is
     *         empty, all response records have been retrieved for the request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Statements property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStatements() {
        return statements != null && !(statements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The SQL statements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatements()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The SQL statements.
     */
    public List<StatementData> statements() {
        return statements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(statements());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStatementsResponse)) {
            return false;
        }
        ListStatementsResponse other = (ListStatementsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(statements(), other.statements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListStatementsResponse").add("NextToken", nextToken()).add("Statements", statements()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Statements":
            return Optional.ofNullable(clazz.cast(statements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStatementsResponse, T> g) {
        return obj -> g.apply((ListStatementsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStatementsResponse> {
        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned
         * NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty,
         * all response records have been retrieved for the request.
         * </p>
         * 
         * @param nextToken
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned NextToken value in the next NextToken parameter and retrying the command. If the
         *        NextToken field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The SQL statements.
         * </p>
         * 
         * @param statements
         *        The SQL statements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statements(Collection<StatementData> statements);

        /**
         * <p>
         * The SQL statements.
         * </p>
         * 
         * @param statements
         *        The SQL statements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statements(StatementData... statements);

        /**
         * <p>
         * The SQL statements.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StatementData>.Builder} avoiding the need
         * to create one manually via {@link List<StatementData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StatementData>.Builder#build()} is called immediately and
         * its result is passed to {@link #statements(List<StatementData>)}.
         * 
         * @param statements
         *        a consumer that will call methods on {@link List<StatementData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statements(List<StatementData>)
         */
        Builder statements(Consumer<StatementData.Builder>... statements);
    }

    static final class BuilderImpl extends RedshiftDataResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<StatementData> statements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStatementsResponse model) {
            super(model);
            nextToken(model.nextToken);
            statements(model.statements);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<StatementData.Builder> getStatements() {
            return statements != null ? statements.stream().map(StatementData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statements(Collection<StatementData> statements) {
            this.statements = StatementListCopier.copy(statements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(StatementData... statements) {
            statements(Arrays.asList(statements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Consumer<StatementData.Builder>... statements) {
            statements(Stream.of(statements).map(c -> StatementData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStatements(Collection<StatementData.BuilderImpl> statements) {
            this.statements = StatementListCopier.copyFromBuilder(statements);
        }

        @Override
        public ListStatementsResponse build() {
            return new ListStatementsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
